/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.OptionChecker;
import javax.tools.StandardJavaFileManager;
import javax.tools.Tool;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.ForkedToolSources;

class ForkedTool
implements Tool,
OptionChecker {
    private final Path basedir;
    private final String executable;
    private final Path debugFilePath;

    ForkedTool(AbstractCompilerMojo mojo) {
        this.basedir = mojo.basedir;
        this.executable = Objects.requireNonNull(mojo.executable);
        this.debugFilePath = mojo.getDebugFilePath();
    }

    @Override
    public String name() {
        return this.executable;
    }

    @Override
    public int isSupportedOption(String option) {
        return -1;
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return Set.of(SourceVersion.latestSupported());
    }

    public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset encoding) {
        return new ForkedToolSources(encoding);
    }

    private ProcessBuilder builder() {
        ProcessBuilder builder = new ProcessBuilder(this.executable);
        if (this.basedir != null) {
            builder.directory(this.basedir.toFile());
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean run(Writer out, ForkedToolSources fileManager, Iterable<String> options, Iterable<? extends JavaFileObject> compilationUnits) throws IOException {
        ProcessBuilder builder = this.builder();
        List<String> command = builder.command();
        for (String string : options) {
            command.add(string);
        }
        fileManager.addAllLocations(command);
        for (JavaFileObject javaFileObject : compilationUnits) {
            Path path = fileManager.asPath(javaFileObject);
            if (this.basedir != null) {
                try {
                    path = this.basedir.relativize(path);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            command.add(path.toString());
        }
        File output = File.createTempFile("javac", null);
        try {
            ProcessBuilder.Redirect redirect = ProcessBuilder.Redirect.appendTo(output);
            builder.redirectError(redirect);
            builder.redirectOutput(redirect);
            boolean bl = this.start(builder, out) == 0;
            return bl;
        }
        finally {
            out.append(Files.readString(output.toPath()));
            output.delete();
        }
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        ProcessBuilder builder = this.builder();
        builder.command().addAll(Arrays.asList(arguments));
        try {
            return this.start(builder, System.err);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private int start(ProcessBuilder builder, Appendable out) throws IOException {
        if (this.debugFilePath != null) {
            boolean windows = File.separatorChar == '\\';
            Object filename = this.debugFilePath.getFileName().toString();
            filename = ((String)filename).substring(0, ((String)filename).lastIndexOf(46) + 1);
            filename = (String)filename + (windows ? "bat" : "sh");
            boolean more = false;
            try (BufferedWriter debugFile = Files.newBufferedWriter(this.debugFilePath.resolveSibling((String)filename), new OpenOption[0]);){
                if (this.basedir != null) {
                    debugFile.write(windows ? "chdir " : "cd ");
                    debugFile.write(this.basedir.toString());
                    debugFile.newLine();
                }
                for (String cmd : builder.command()) {
                    if (more) {
                        debugFile.append(' ');
                    }
                    debugFile.append(cmd);
                    more = true;
                }
                debugFile.newLine();
            }
        }
        Process process = builder.start();
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            out.append("Compilation has been interrupted by " + String.valueOf(e)).append(System.lineSeparator());
            process.destroy();
            return 1;
        }
    }
}

