/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.maven.api.PathType;

final class SourcePathType
implements PathType {
    private static final SourcePathType SOURCE_PATH = new SourcePathType(null);
    private final String moduleName;

    private SourcePathType(String moduleName) {
        this.moduleName = moduleName;
    }

    static SourcePathType valueOf(String moduleName) {
        return moduleName == null || moduleName.isBlank() ? SOURCE_PATH : new SourcePathType(moduleName);
    }

    public String id() {
        Object id = this.name();
        if (this.moduleName != null) {
            id = (String)id + ":" + this.moduleName;
        }
        return id;
    }

    public String name() {
        return this.moduleName == null ? "SOURCE_PATH" : "MODULE_SOURCE_PATH";
    }

    public Optional<String> option() {
        return Optional.of(this.moduleName == null ? "--source-path" : "--module-source-path");
    }

    public String[] option(Iterable<? extends Path> paths) {
        StringJoiner joiner = new StringJoiner(File.pathSeparator, (CharSequence)(this.moduleName != null ? this.moduleName + "=" : ""), "");
        paths.forEach(path -> joiner.add(path.toString()));
        return new String[]{this.option().get(), joiner.toString()};
    }

    public int hashCode() {
        return Objects.hashCode(this.moduleName) + 17;
    }

    public boolean equals(Object obj) {
        return obj instanceof SourcePathType && Objects.equals(this.moduleName, ((SourcePathType)obj).moduleName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.id() + "]";
    }
}

