/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.resolvers;

import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.AbstractResolveMojo;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.codehaus.plexus.util.IOUtil;

public class ResolvePluginsMojo
extends AbstractResolveMojo {
    private List remotePluginRepositories;
    private boolean excludeTransitive;

    public void execute() throws MojoExecutionException {
        FileWriter outputWriter = null;
        try {
            Set plugins = this.resolvePluginArtifacts();
            if (this.outputFile != null) {
                this.outputFile.getParentFile().mkdirs();
                outputWriter = new FileWriter(this.outputFile);
            }
            for (Artifact plugin : plugins) {
                String logStr = "Plugin Resolved: " + DependencyUtil.getFormattedFileName(plugin, false);
                if (!this.silent) {
                    this.getLog().info((CharSequence)logStr);
                }
                if (outputWriter != null) {
                    outputWriter.write(logStr);
                    outputWriter.write("\n");
                }
                if (this.excludeTransitive) continue;
                Set transitiveDependencies = this.resolveArtifactDependencies(plugin);
                Iterator transIter = transitiveDependencies.iterator();
                while (transIter.hasNext()) {
                    logStr = "    Plugin Dependency Resolved: " + DependencyUtil.getFormattedFileName((Artifact)transIter.next(), false);
                    if (!this.silent) {
                        this.getLog().info((CharSequence)logStr);
                    }
                    if (outputWriter == null) continue;
                    outputWriter.write(logStr);
                    outputWriter.write("\n");
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Nested:", (Exception)e);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Nested:", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Nested:", (Exception)((Object)e));
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Nested:", (Exception)((Object)e));
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException("Nested:", (Exception)((Object)e));
        }
        finally {
            IOUtil.close(outputWriter);
        }
    }

    protected Set resolvePluginArtifacts() throws ArtifactResolutionException, ArtifactNotFoundException {
        Set plugins = this.project.getPluginArtifacts();
        Set reports = this.project.getReportArtifacts();
        HashSet artifacts = new HashSet();
        artifacts.addAll(reports);
        artifacts.addAll(plugins);
        for (Artifact artifact : artifacts) {
            this.resolver.resolve(artifact, this.remotePluginRepositories, this.getLocal());
        }
        return artifacts;
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return null;
    }
}

