/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="analyze-duplicate", aggregator=false, threadSafe=true)
public class AnalyzeDuplicateMojo
extends AbstractMojo {
    @Parameter(property="mdep.analyze.skip", defaultValue="false")
    private boolean skip;
    @Component
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        Model model = null;
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)this.project.getFile());
            model = pomReader.read((Reader)reader);
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("IOException: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        Set<Object> duplicateDependencies = new HashSet();
        if (model.getDependencies() != null) {
            duplicateDependencies = this.findDuplicateDependencies(model.getDependencies());
        }
        Set<Object> duplicateDependenciesManagement = new HashSet();
        if (model.getDependencyManagement() != null && model.getDependencyManagement().getDependencies() != null) {
            duplicateDependenciesManagement = this.findDuplicateDependencies(model.getDependencyManagement().getDependencies());
        }
        if (this.getLog().isInfoEnabled()) {
            String dup;
            Iterator<Object> it;
            StringBuilder sb = new StringBuilder();
            if (!duplicateDependencies.isEmpty()) {
                sb.append("List of duplicate dependencies defined in <dependencies/> in your pom.xml:\n");
                it = duplicateDependencies.iterator();
                while (it.hasNext()) {
                    dup = (String)it.next();
                    sb.append("\to " + dup);
                    if (!it.hasNext()) continue;
                    sb.append("\n");
                }
            }
            if (!duplicateDependenciesManagement.isEmpty()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append("List of duplicate dependencies defined in <dependencyManagement/> in your pom.xml:\n");
                it = duplicateDependenciesManagement.iterator();
                while (it.hasNext()) {
                    dup = (String)it.next();
                    sb.append("\to " + dup);
                    if (!it.hasNext()) continue;
                    sb.append("\n");
                }
            }
            if (sb.length() > 0) {
                this.getLog().info((CharSequence)sb.toString());
            } else {
                this.getLog().info((CharSequence)"No duplicate dependencies found in <dependencies/> or in <dependencyManagement/>");
            }
        }
    }

    private Set<String> findDuplicateDependencies(List<Dependency> modelDependencies) {
        ArrayList<String> modelDependencies2 = new ArrayList<String>();
        for (Dependency dep : modelDependencies) {
            modelDependencies2.add(dep.getManagementKey());
        }
        return new HashSet<String>(CollectionUtils.disjunction(modelDependencies2, new HashSet(modelDependencies2)));
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

