/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.utils.markers;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.dependency.utils.markers.MarkerHandler;

public class DefaultFileMarkerHandler
implements MarkerHandler {
    protected Artifact artifact;
    protected File markerFilesDirectory;

    public DefaultFileMarkerHandler(File theMarkerFilesDirectory) {
        this.markerFilesDirectory = theMarkerFilesDirectory;
    }

    public DefaultFileMarkerHandler(Artifact theArtifact, File theMarkerFilesDirectory) {
        this.artifact = theArtifact;
        this.markerFilesDirectory = theMarkerFilesDirectory;
    }

    protected File getMarkerFile() {
        return new File(this.markerFilesDirectory, this.artifact.getId().replace(':', '-') + ".marker");
    }

    @Override
    public boolean isMarkerSet() throws MojoExecutionException {
        File marker = this.getMarkerFile();
        return marker.exists();
    }

    @Override
    public boolean isMarkerOlder(Artifact artifact1) throws MojoExecutionException {
        File marker = this.getMarkerFile();
        if (marker.exists()) {
            return artifact1.getFile().lastModified() > marker.lastModified();
        }
        return true;
    }

    @Override
    public void setMarker() throws MojoExecutionException {
        File marker = this.getMarkerFile();
        try {
            marker.getParentFile().mkdirs();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            marker.createNewFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create Marker: " + marker.getAbsolutePath(), (Exception)e);
        }
        try {
            long ts = this.artifact != null && this.artifact.getFile() != null ? this.artifact.getFile().lastModified() : System.currentTimeMillis();
            if (!marker.setLastModified(ts)) {
                throw new MojoExecutionException("Unable to update last modified timestamp on marker file " + marker.getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to update Marker timestamp: " + marker.getAbsolutePath(), e);
        }
    }

    @Override
    public boolean clearMarker() throws MojoExecutionException {
        File marker = this.getMarkerFile();
        return marker.delete();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    @Override
    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public File getMarkerFilesDirectory() {
        return this.markerFilesDirectory;
    }

    public void setMarkerFilesDirectory(File markerFilesDirectory) {
        this.markerFilesDirectory = markerFilesDirectory;
    }
}

