/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.tree;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.dependency.tree.AbstractSerializingVisitor;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class TGFDependencyNodeVisitor
extends AbstractSerializingVisitor
implements DependencyNodeVisitor {
    private final List<EdgeAppender> edges = new ArrayList<EdgeAppender>();

    public TGFDependencyNodeVisitor(Writer writer) {
        super(writer);
    }

    public boolean endVisit(DependencyNode node) {
        try {
            if (node.getParent() == null || node.getParent() == node) {
                this.writer.write("#" + System.lineSeparator());
                for (EdgeAppender edge : this.edges) {
                    this.writer.write(edge.toString() + System.lineSeparator());
                }
                this.writer.flush();
            } else {
                DependencyNode parent = node.getParent();
                this.edges.add(new EdgeAppender(parent, node, node.getArtifact().getScope()));
            }
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write TGF format output", e);
        }
    }

    public boolean visit(DependencyNode node) {
        try {
            this.writer.write(TGFDependencyNodeVisitor.generateId(node));
            this.writer.write(" ");
            this.writer.write(node.toNodeString());
            this.writer.write(System.lineSeparator());
            this.writer.flush();
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write TGF format output", e);
        }
    }

    private static String generateId(DependencyNode node) {
        return String.valueOf(node.hashCode());
    }

    static final class EdgeAppender {
        private final DependencyNode from;
        private final DependencyNode to;
        private final String label;

        EdgeAppender(DependencyNode from, DependencyNode to, String label) {
            this.from = from;
            this.to = to;
            this.label = label;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(TGFDependencyNodeVisitor.generateId(this.from));
            result.append(' ').append(TGFDependencyNodeVisitor.generateId(this.to));
            if (this.label != null) {
                result.append(' ').append(this.label);
            }
            return result.toString();
        }
    }
}

