/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.deploy;

import java.io.File;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class AbstractDeployMojo
extends AbstractMojo {
    private ArtifactDeployer deployer;
    protected ArtifactFactory artifactFactory;
    ArtifactRepositoryFactory repositoryFactory;
    private Map repositoryLayouts;
    private ArtifactRepository localRepository;
    private boolean offline;
    protected boolean updateReleaseInfo;
    private int retryFailedDeploymentCount;

    public ArtifactDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(ArtifactDeployer deployer) {
        this.deployer = deployer;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    void failIfOffline() throws MojoFailureException {
        if (this.offline) {
            throw new MojoFailureException("Cannot deploy artifacts when Maven is in offline mode");
        }
    }

    ArtifactRepositoryLayout getLayout(String id) throws MojoExecutionException {
        ArtifactRepositoryLayout layout = (ArtifactRepositoryLayout)this.repositoryLayouts.get(id);
        if (layout == null) {
            throw new MojoExecutionException("Invalid repository layout: " + id);
        }
        return layout;
    }

    protected void deploy(File source, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        int retryFailedDeploymentCount = Math.max(1, Math.min(10, this.retryFailedDeploymentCount));
        ArtifactDeploymentException exception = null;
        for (int count = 0; count < retryFailedDeploymentCount; ++count) {
            try {
                if (count > 0) {
                    this.getLog().info((CharSequence)("Retrying deployment attempt " + (count + 1) + " of " + retryFailedDeploymentCount));
                }
                this.getDeployer().deploy(source, artifact, deploymentRepository, localRepository);
                exception = null;
                break;
            }
            catch (ArtifactDeploymentException e) {
                if (count + 1 < retryFailedDeploymentCount) {
                    this.getLog().warn((CharSequence)("Encountered issue during deployment: " + e.getLocalizedMessage()));
                    this.getLog().debug((Throwable)e);
                }
                if (exception != null) continue;
                exception = e;
                continue;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

