/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.deploy;

import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.Version;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.plugin.Mojo;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Parameter;

public abstract class AbstractDeployMojo
implements Mojo {
    private static final String AFFECTED_MAVEN_PACKAGING = "maven-plugin";
    private static final String FIXED_MAVEN_VERSION = "3.9.0";
    @Inject
    protected Log logger;
    @Inject
    protected Session session;
    @Parameter(defaultValue="${settings.offline}", readonly=true)
    private boolean offline;
    @Parameter(property="retryFailedDeploymentCount", defaultValue="1")
    private int retryFailedDeploymentCount;

    void failIfOffline() throws MojoException {
        if (this.offline) {
            throw new MojoException("Cannot deploy artifacts when Maven is in offline mode");
        }
    }

    public int getRetryFailedDeploymentCount() {
        return this.retryFailedDeploymentCount;
    }

    protected void warnIfAffectedPackagingAndMaven(String packaging) {
        Version currentMavenVersion;
        Version fixedMavenVersion;
        if (AFFECTED_MAVEN_PACKAGING.equals(packaging) && (fixedMavenVersion = this.session.parseVersion(FIXED_MAVEN_VERSION)).compareTo((Object)(currentMavenVersion = this.session.getMavenVersion())) > 0) {
            this.getLog().warn((CharSequence)"");
            this.getLog().warn((CharSequence)("You are about to deploy a maven-plugin using Maven " + String.valueOf(currentMavenVersion) + "."));
            this.getLog().warn((CharSequence)"This plugin should be used ONLY with Maven 3.9.0 and newer, as MNG-7055");
            this.getLog().warn((CharSequence)"is fixed in those versions of Maven only!");
            this.getLog().warn((CharSequence)"");
        }
    }

    protected RemoteRepository createDeploymentArtifactRepository(String id, String url) {
        return this.getSession().createRemoteRepository(id, url);
    }

    protected Session getSession() {
        return this.session;
    }

    protected Log getLog() {
        return this.logger;
    }
}

