/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.deploy;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Mojo;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.api.services.ArtifactDeployer;
import org.apache.maven.api.services.ArtifactDeployerException;
import org.apache.maven.api.services.ArtifactDeployerRequest;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.xml.ModelXmlFactory;
import org.apache.maven.api.services.xml.XmlReaderException;
import org.apache.maven.plugins.deploy.AbstractDeployMojo;

@Mojo(name="deploy-file", projectRequired=false)
public class DeployFileMojo
extends AbstractDeployMojo {
    private static final String TAR = "tar.";
    private static final String ILLEGAL_VERSION_CHARS = "\\/:\"<>|?*[](){},";
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="packaging")
    private String packaging;
    @Parameter(property="generatePom.description")
    private String description;
    @Parameter(property="file", required=true)
    Path file;
    @Parameter(property="javadoc")
    private Path javadoc;
    @Parameter(property="sources")
    private Path sources;
    @Parameter(property="repositoryId", defaultValue="remote-repository", required=true)
    private String repositoryId;
    @Parameter(property="url", required=true)
    private String url;
    @Parameter(property="pomFile")
    private Path pomFile;
    @Parameter(property="generatePom", defaultValue="true")
    private boolean generatePom;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="types")
    private String types;
    @Parameter(property="classifiers")
    private String classifiers;
    @Parameter(property="files")
    private String files;
    @Parameter(property="maven.deploy.file.skip", defaultValue="false")
    private String skip = Boolean.FALSE.toString();

    void initProperties() throws MojoException {
        if (this.pomFile != null) {
            Path deployedPom = this.pomFile;
            this.processModel(this.readModel(deployedPom));
        } else {
            Path deployedPom = this.readingPomFromJarFile();
            if (deployedPom != null) {
                this.pomFile = deployedPom;
            }
        }
        if (this.packaging == null && this.file != null) {
            this.packaging = this.getExtension(this.file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path readingPomFromJarFile() {
        Pattern pomEntry = Pattern.compile("META-INF/maven/.*/pom\\.xml");
        try (JarFile jarFile = new JarFile(this.file.toFile());){
            JarEntry entry = jarFile.stream().filter(e -> pomEntry.matcher(e.getName()).matches()).findFirst().orElse(null);
            if (entry != null) {
                this.getLog().debug((CharSequence)("Using " + entry.getName() + " as pomFile"));
                try (InputStream pomInputStream = jarFile.getInputStream(entry);){
                    String base = this.file.getFileName().toString();
                    if (base.indexOf(46) > 0) {
                        base = base.substring(0, base.lastIndexOf(46));
                    }
                    Path pomFile = File.createTempFile(base, ".pom").toPath();
                    Files.copy(pomInputStream, pomFile, StandardCopyOption.REPLACE_EXISTING);
                    this.processModel(this.readModel(pomFile));
                    Path path = pomFile;
                    return path;
                }
            }
            this.getLog().info((CharSequence)("pom.xml not found in " + String.valueOf(this.file.getFileName())));
            return null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void execute() throws MojoException {
        Path deployedPom;
        if (Boolean.parseBoolean(this.skip) || "releases".equals(this.skip) && !this.session.isVersionSnapshot(this.version) || "snapshots".equals(this.skip) && this.session.isVersionSnapshot(this.version)) {
            this.getLog().info((CharSequence)"Skipping artifact deployment");
            return;
        }
        if (!Files.exists(this.file, new LinkOption[0])) {
            String message = "The specified file '" + String.valueOf(this.file) + "' does not exist";
            this.getLog().error((CharSequence)message);
            throw new MojoException(message);
        }
        this.initProperties();
        RemoteRepository deploymentRepository = this.createDeploymentArtifactRepository(this.repositoryId, this.url.replace(File.separator, "/"));
        if (deploymentRepository.getProtocol().isEmpty()) {
            throw new MojoException("No transfer protocol found.");
        }
        if (this.pomFile != null) {
            deployedPom = this.pomFile;
            this.processModel(this.readModel(deployedPom));
        } else {
            deployedPom = this.readingPomFromJarFile();
        }
        if (this.groupId == null || this.artifactId == null || this.version == null || this.packaging == null) {
            throw new MojoException("The artifact information is incomplete: 'groupId', 'artifactId', 'version' and 'packaging' are required.");
        }
        if (!(this.isValidId(this.groupId) && this.isValidId(this.artifactId) && this.isValidVersion(this.version))) {
            throw new MojoException("The artifact information is not valid: uses invalid characters.");
        }
        this.failIfOffline();
        this.warnIfAffectedPackagingAndMaven(this.packaging);
        ArrayList<Artifact> deployables = new ArrayList<Artifact>();
        boolean isFilePom = this.classifier == null && "pom".equals(this.packaging);
        Artifact artifact = this.session.createArtifact(this.groupId, this.artifactId, this.version, this.classifier, isFilePom ? "pom" : this.getExtension(this.file), this.packaging);
        if (this.file.equals(this.getLocalRepositoryFile(artifact))) {
            throw new MojoException("Cannot deploy artifact from the local repository: " + String.valueOf(this.file));
        }
        ArtifactManager artifactManager = (ArtifactManager)this.session.getService(ArtifactManager.class);
        artifactManager.setPath(artifact, this.file);
        deployables.add(artifact);
        if (!isFilePom) {
            Artifact pomArtifact = this.session.createArtifact(this.groupId, this.artifactId, this.version, "", "pom", null);
            if (deployedPom != null) {
                artifactManager.setPath(pomArtifact, deployedPom);
                deployables.add(pomArtifact);
            } else {
                deployedPom = this.generatePomFile();
                artifactManager.setPath(pomArtifact, deployedPom);
                if (this.generatePom) {
                    this.getLog().debug((CharSequence)"Deploying generated POM");
                    deployables.add(pomArtifact);
                } else {
                    this.getLog().debug((CharSequence)"Skipping deploying POM");
                }
            }
        }
        if (this.sources != null) {
            Artifact sourcesArtifact = this.session.createArtifact(this.groupId, this.artifactId, this.version, "sources", "jar", null);
            artifactManager.setPath(sourcesArtifact, this.sources);
            deployables.add(sourcesArtifact);
        }
        if (this.javadoc != null) {
            Artifact javadocArtifact = this.session.createArtifact(this.groupId, this.artifactId, this.version, "javadoc", "jar", null);
            artifactManager.setPath(javadocArtifact, this.javadoc);
            deployables.add(javadocArtifact);
        }
        if (this.files != null) {
            if (this.types == null) {
                throw new MojoException("You must specify 'types' if you specify 'files'");
            }
            if (this.classifiers == null) {
                throw new MojoException("You must specify 'classifiers' if you specify 'files'");
            }
            int filesLength = DeployFileMojo.countCommas(this.files);
            int typesLength = DeployFileMojo.countCommas(this.types);
            int classifiersLength = DeployFileMojo.countCommas(this.classifiers);
            if (typesLength != filesLength) {
                throw new MojoException("You must specify the same number of entries in 'files' and 'types' (respectively " + filesLength + " and " + typesLength + " entries )");
            }
            if (classifiersLength != filesLength) {
                throw new MojoException("You must specify the same number of entries in 'files' and 'classifiers' (respectively " + filesLength + " and " + classifiersLength + " entries )");
            }
            int fi = 0;
            int ti = 0;
            int ci = 0;
            for (int i = 0; i <= filesLength; ++i) {
                Path file;
                int nci;
                int nti;
                int nfi = this.files.indexOf(44, fi);
                if (nfi == -1) {
                    nfi = this.files.length();
                }
                if ((nti = this.types.indexOf(44, ti)) == -1) {
                    nti = this.types.length();
                }
                if ((nci = this.classifiers.indexOf(44, ci)) == -1) {
                    nci = this.classifiers.length();
                }
                if (!Files.isRegularFile(file = Paths.get(this.files.substring(fi, nfi).replace("/", File.separator), new String[0]), new LinkOption[0])) {
                    file = Paths.get(this.files.substring(fi, nfi), new String[0]);
                }
                if (!Files.isRegularFile(file, new LinkOption[0])) {
                    throw new MojoException("Specified side artifact " + String.valueOf(file) + " does not exist");
                }
                String extension = this.getExtension(file);
                String type = this.types.substring(ti, nti).trim();
                Artifact deployable = this.session.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion().asString(), this.classifiers.substring(ci, nci).trim(), extension, type);
                artifactManager.setPath(deployable, file);
                deployables.add(deployable);
                fi = nfi + 1;
                ti = nti + 1;
                ci = nci + 1;
            }
        } else {
            if (this.types != null) {
                throw new MojoException("You must specify 'files' if you specify 'types'");
            }
            if (this.classifiers != null) {
                throw new MojoException("You must specify 'files' if you specify 'classifiers'");
            }
        }
        try {
            ArtifactDeployerRequest deployRequest = ArtifactDeployerRequest.builder().session(this.session).repository(deploymentRepository).artifacts(deployables).retryFailedDeploymentCount(Math.max(1, Math.min(10, this.getRetryFailedDeploymentCount()))).build();
            this.getLog().info((CharSequence)("Deploying artifacts " + String.valueOf(deployables) + " to repository " + String.valueOf(deploymentRepository)));
            ArtifactDeployer artifactDeployer = (ArtifactDeployer)this.session.getService(ArtifactDeployer.class);
            artifactDeployer.deploy(deployRequest);
        }
        catch (ArtifactDeployerException e) {
            throw new MojoException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.pomFile == null && deployedPom != null) {
                try {
                    Files.deleteIfExists(deployedPom);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Path getLocalRepositoryFile(Artifact artifact) {
        return this.session.getPathForLocalArtifact(artifact);
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            this.groupId = model.getGroupId();
            if (this.groupId == null && parent != null) {
                this.groupId = parent.getGroupId();
            }
        }
        if (this.artifactId == null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null) {
            this.version = model.getVersion();
            if (this.version == null && parent != null) {
                this.version = parent.getVersion();
            }
        }
        if (this.packaging == null) {
            this.packaging = model.getPackaging();
        }
    }

    Model readModel(Path pomFile) throws MojoException {
        Model model;
        block10: {
            InputStream is = Files.newInputStream(pomFile, new OpenOption[0]);
            try {
                ModelXmlFactory modelXmlFactory = (ModelXmlFactory)this.session.getService(ModelXmlFactory.class);
                model = (Model)modelXmlFactory.read(is);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new MojoException("POM not found " + String.valueOf(pomFile), (Throwable)e);
                }
                catch (IOException e) {
                    throw new MojoException("Error reading POM " + String.valueOf(pomFile), (Throwable)e);
                }
                catch (XmlReaderException e) {
                    throw new MojoException("Error parsing POM " + String.valueOf(pomFile), (Throwable)e);
                }
            }
            is.close();
        }
        return model;
    }

    private Path generatePomFile() throws MojoException {
        Model model = this.generateModel();
        try {
            Path pomFile = File.createTempFile("mvndeploy", ".pom").toPath();
            try (BufferedWriter writer = Files.newBufferedWriter(pomFile, new OpenOption[0]);){
                ModelXmlFactory modelXmlFactory = (ModelXmlFactory)this.session.getService(ModelXmlFactory.class);
                modelXmlFactory.write((Object)model, (Writer)writer);
            }
            return pomFile;
        }
        catch (IOException e) {
            throw new MojoException("Error writing temporary POM file: " + e.getMessage(), (Throwable)e);
        }
    }

    private Model generateModel() {
        return Model.newBuilder().modelVersion("4.0.0").groupId(this.groupId).artifactId(this.artifactId).version(this.version).packaging(this.packaging).description(this.description).build();
    }

    void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    void setVersion(String version) {
        this.version = version;
    }

    void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    void setPomFile(Path pomFile) {
        this.pomFile = pomFile;
    }

    String getGroupId() {
        return this.groupId;
    }

    String getArtifactId() {
        return this.artifactId;
    }

    String getVersion() {
        return this.version;
    }

    String getPackaging() {
        return this.packaging;
    }

    Path getFile() {
        return this.file;
    }

    String getClassifier() {
        return this.classifier;
    }

    void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    private static int countCommas(String str) {
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(44, idx)) != -1) {
            ++count;
            ++idx;
        }
        return count;
    }

    private String getExtension(Path file) {
        String filename = file.getFileName().toString();
        int lastDot = filename.lastIndexOf(46);
        if (lastDot > 0 && lastDot < filename.length() - 1) {
            String ext = filename.substring(lastDot + 1);
            return filename.regionMatches(lastDot + 1 - TAR.length(), TAR, 0, TAR.length()) ? TAR + ext : ext;
        }
        return "";
    }

    private boolean isValidId(String id) {
        if (id == null) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.') continue;
            return false;
        }
        return true;
    }

    private boolean isValidVersion(String version) {
        if (version == null) {
            return false;
        }
        for (int i = version.length() - 1; i >= 0; --i) {
            if (ILLEGAL_VERSION_CHARS.indexOf(version.charAt(i)) < 0) continue;
            return false;
        }
        return true;
    }
}

