/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.doap;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.doap.DoapUtil;
import org.apache.maven.plugin.doap.options.ASFExtOptions;
import org.apache.maven.plugin.doap.options.ASFExtOptionsUtil;
import org.apache.maven.plugin.doap.options.DoapArtifact;
import org.apache.maven.plugin.doap.options.DoapOptions;
import org.apache.maven.plugin.doap.options.ExtOptions;
import org.apache.maven.plugin.doap.options.Standard;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="generate")
public class DoapMojo
extends AbstractMojo {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final DateFormat REPOSITORY_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss", Locale.ENGLISH);
    private static final DateFormat DOAP_DATE_FORMAT;
    @Component
    private ScmManager scmManager;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private RepositoryMetadataManager repositoryMetadataManager;
    @Component
    private I18N i18n;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="doapFile", defaultValue="doap_${project.artifactId}.rdf", required=true)
    private String doapFile;
    @Parameter(defaultValue="${project.reporting.outputDirectory}", required=true)
    private String outputDirectory;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Component
    private ArtifactFactory factory;
    @Component
    private MavenProjectBuilder mavenProjectBuilder;
    @Component
    private ArtifactResolver resolver;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings settings;
    @Parameter(property="category")
    private String category;
    @Parameter(property="language")
    private String language;
    @Parameter(property="doapOptions")
    private DoapOptions doapOptions;
    @Parameter(property="asfExtOptions")
    private ASFExtOptions asfExtOptions;
    @Parameter(property="lang", defaultValue="en", required=true)
    private String lang;
    @Parameter(property="about", defaultValue="${project.url}")
    private String about;
    @Parameter(defaultValue="true")
    private boolean validate;
    @Parameter
    private DoapArtifact artifact;
    @Parameter(property="maven.doap.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="extOptions")
    private ExtOptions[] extOptions;
    private UserMessages messages = new UserMessages();

    public void execute() throws MojoExecutionException {
        MavenProject givenProject;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping DOAP generation");
            return;
        }
        if (this.artifact != null && (givenProject = this.getMavenProject(this.artifact)) != null) {
            File outDir = new File(this.outputDirectory);
            if (!outDir.isAbsolute()) {
                outDir = new File(this.project.getBasedir(), this.outputDirectory);
            }
            File outFile = new File(outDir, this.artifact.getDoapFileName());
            this.writeDoapFile(givenProject, outFile);
            return;
        }
        File outFile = new File(this.doapFile);
        if (!outFile.isAbsolute()) {
            outFile = new File(this.project.getBasedir(), this.doapFile);
        }
        if (!this.doapFile.replaceAll("\\\\", "/").contains("/")) {
            File outDir = new File(this.outputDirectory);
            if (!outDir.isAbsolute()) {
                outDir = new File(this.project.getBasedir(), this.outputDirectory);
            }
            outFile = new File(outDir, this.doapFile);
        }
        this.writeDoapFile(this.project, outFile);
    }

    private MavenProject getMavenProject(DoapArtifact artifact) {
        if (artifact == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)artifact.getGroupId()) || StringUtils.isEmpty((String)artifact.getArtifactId()) || StringUtils.isEmpty((String)artifact.getVersion())) {
            this.getLog().warn((CharSequence)"Missing groupId or artifactId or version in <artifact/> parameter, ignored it.");
            return null;
        }
        this.getLog().info((CharSequence)("Using artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion()));
        try {
            Artifact art = this.factory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "compile");
            if (art.getFile() == null) {
                MavenProject proj = this.mavenProjectBuilder.buildFromRepository(art, this.remoteRepositories, this.localRepository);
                art = proj.getArtifact();
                this.resolver.resolve(art, this.remoteRepositories, this.localRepository);
                return proj;
            }
        }
        catch (ArtifactResolutionException e) {
            this.getLog().error((CharSequence)("ArtifactResolutionException: " + e.getMessage() + "\nIgnored <artifact/> parameter."));
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().error((CharSequence)("ArtifactNotFoundException: " + e.getMessage() + "\nIgnored <artifact/> parameter."));
        }
        catch (ProjectBuildingException e) {
            this.getLog().error((CharSequence)("ProjectBuildingException: " + e.getMessage() + "\nIgnored <artifact/> parameter."));
        }
        return null;
    }

    private void writeDoapFile(MavenProject project, File outputFile) throws MojoExecutionException {
        List<String> errors;
        XmlStreamWriter w;
        if (!this.asfExtOptions.isIncluded() && ASFExtOptionsUtil.isASFProject(project)) {
            this.getLog().info((CharSequence)"This project is an ASF project, ASF Extensions to DOAP will be added.");
            this.asfExtOptions.setIncluded(true);
        }
        try {
            if (!outputFile.getParentFile().exists()) {
                FileUtils.mkdir((String)outputFile.getParentFile().getAbsolutePath());
            }
            w = WriterFactory.newXmlWriter((File)outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating DOAP file " + outputFile.getAbsolutePath(), (Exception)e);
        }
        if (this.asfExtOptions.isIncluded()) {
            this.getLog().info((CharSequence)("Generating an ASF DOAP file " + outputFile.getAbsolutePath()));
        } else {
            this.getLog().info((CharSequence)("Generating a pure DOAP file " + outputFile.getAbsolutePath()));
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, project.getModel().getModelEncoding(), null);
        DoapUtil.writeHeader((XMLWriter)writer);
        DoapUtil.writeStartElement((XMLWriter)writer, "rdf", "RDF");
        if (Arrays.binarySearch(Locale.getISOLanguages(), this.lang) < 0) {
            this.messages.addMessage(new String[]{"doapOptions", "lang"}, this.lang, 32);
            throw new MojoExecutionException(this.messages.getErrorMessages().get(0));
        }
        writer.addAttribute("xml:lang", this.lang);
        if (StringUtils.isEmpty((String)this.doapOptions.getXmlnsNamespaceURI())) {
            this.messages.addMessage(new String[]{"doapOptions", "xmlnsNamespaceURI"}, null, 10);
            throw new MojoExecutionException(this.messages.getErrorMessages().get(0));
        }
        writer.addAttribute("xmlns" + (StringUtils.isEmpty((String)this.doapOptions.getXmlnsPrefix()) ? "" : ":" + this.doapOptions.getXmlnsPrefix()), this.doapOptions.getXmlnsNamespaceURI());
        writer.addAttribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        writer.addAttribute("xmlns:foaf", "http://xmlns.com/foaf/0.1/");
        if (this.asfExtOptions.isIncluded()) {
            if (StringUtils.isEmpty((String)this.asfExtOptions.getXmlnsPrefix())) {
                this.messages.addMessage(new String[]{"doapOptions", "xmlnsPrefix"}, null, 10);
                throw new MojoExecutionException(this.messages.getErrorMessages().get(0));
            }
            if (StringUtils.isEmpty((String)this.asfExtOptions.getXmlnsNamespaceURI())) {
                this.messages.addMessage(new String[]{"doapOptions", "xmlnsNamespaceURI"}, null, 10);
            }
            writer.addAttribute("xmlns" + (StringUtils.isEmpty((String)this.asfExtOptions.getXmlnsPrefix()) ? "" : ":" + this.asfExtOptions.getXmlnsPrefix()), this.asfExtOptions.getXmlnsNamespaceURI());
        }
        if (this.extOptions != null && this.extOptions.length > 0 && !this.extOptions[0].getExtensions().isEmpty()) {
            for (ExtOptions extOption : this.extOptions) {
                if (StringUtils.isEmpty((String)extOption.getXmlnsPrefix())) {
                    this.messages.addMessage(new String[]{"extOptions", "extOption", "xmlnsPrefix"}, null, 10);
                    throw new MojoExecutionException(this.messages.getErrorMessages().get(0));
                }
                if (StringUtils.isEmpty((String)extOption.getXmlnsNamespaceURI())) {
                    this.messages.addMessage(new String[]{"extOptions", "extOption", "xmlnsNamespaceURI"}, null, 10);
                    throw new MojoExecutionException(this.messages.getErrorMessages().get(0));
                }
                writer.addAttribute("xmlns" + (StringUtils.isEmpty((String)extOption.getXmlnsPrefix()) ? "" : ":" + extOption.getXmlnsPrefix()), extOption.getXmlnsNamespaceURI());
            }
        }
        DoapUtil.writeStartElement((XMLWriter)writer, this.doapOptions.getXmlnsPrefix(), "Project");
        boolean added = false;
        if (this.artifact != null) {
            String about = project.getUrl();
            if (StringUtils.isNotEmpty((String)about)) {
                try {
                    new URL(about);
                    writer.addAttribute("rdf:about", about);
                    added = true;
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (!added) {
                this.messages.getWarnMessages().add("The project's url defined from " + this.artifact.toConfiguration() + " is empty or not a valid URL, using <about/> parameter.");
            }
        }
        if (!added && StringUtils.isNotEmpty((String)this.about)) {
            try {
                new URL(this.about);
                writer.addAttribute("rdf:about", this.about);
            }
            catch (MalformedURLException e) {
                this.messages.addMessage(new String[]{"about"}, this.about, 30);
            }
            added = true;
        }
        if (!added) {
            this.messages.addMessage(new String[]{"about"}, null, 20);
        }
        this.writeName((XMLWriter)writer, project);
        this.writeDescription((XMLWriter)writer, project);
        this.writeImplements((XMLWriter)writer);
        this.writeAudience((XMLWriter)writer);
        this.writeVendor((XMLWriter)writer, project);
        this.writeCreated((XMLWriter)writer, project);
        this.writeHomepage((XMLWriter)writer, project);
        this.writeBlog((XMLWriter)writer);
        this.writeLicenses((XMLWriter)writer, project);
        this.writeProgrammingLanguage((XMLWriter)writer, project);
        this.writeCategory((XMLWriter)writer, project);
        this.writeOS((XMLWriter)writer, project);
        this.writePlateform((XMLWriter)writer);
        this.writeLanguage((XMLWriter)writer);
        this.writeSourceRepositories((XMLWriter)writer, project);
        this.writeBugDatabase((XMLWriter)writer, project);
        this.writeMailingList((XMLWriter)writer, project);
        this.writeDownloadPage((XMLWriter)writer, project);
        this.writeScreenshots((XMLWriter)writer, project);
        this.writeServiceEndpoint((XMLWriter)writer);
        this.writeWiki((XMLWriter)writer, project);
        this.writeReleases((XMLWriter)writer, project);
        List developers = project.getDevelopers();
        this.writeContributors((XMLWriter)writer, developers);
        List contributors = project.getContributors();
        this.writeContributors((XMLWriter)writer, contributors);
        Map<Object, String> map = this.doapOptions.getExtra();
        this.writeExtra((XMLWriter)writer, project, "Extra DOAP vocabulary.", map, this.doapOptions.getXmlnsPrefix());
        this.writeASFext((XMLWriter)writer, project);
        this.writeExtensions((XMLWriter)writer);
        writer.endElement();
        this.writeOrganizations((XMLWriter)writer);
        writer.endElement();
        try {
            w.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error when closing the writer.", (Exception)e);
        }
        if (!this.messages.getWarnMessages().isEmpty()) {
            for (String warn : this.messages.getWarnMessages()) {
                this.getLog().warn((CharSequence)warn);
            }
        }
        if (!this.messages.getErrorMessages().isEmpty()) {
            this.getLog().error((CharSequence)"");
            for (String error : this.messages.getErrorMessages()) {
                this.getLog().error((CharSequence)error);
            }
            this.getLog().error((CharSequence)"");
            if (ASFExtOptionsUtil.isASFProject(project)) {
                this.getLog().error((CharSequence)"For more information about the errors and possible solutions, please read the plugin documentation:");
                this.getLog().error((CharSequence)"http://maven.apache.org/plugins/maven-doap-plugin/usage.html#DOAP_ASF_Configuration");
                throw new MojoExecutionException("The generated DOAP doesn't respect ASF rules, see above.");
            }
        }
        if (this.validate && !(errors = DoapUtil.validate(outputFile)).isEmpty()) {
            this.getLog().error((CharSequence)"");
            for (String error : errors) {
                this.getLog().error((CharSequence)error);
            }
            this.getLog().error((CharSequence)"");
            throw new MojoExecutionException("Error parsing the generated DOAP file, see above.");
        }
    }

    private void writeName(XMLWriter writer, MavenProject project) {
        String name = DoapUtil.interpolate(this.doapOptions.getName(), project, this.settings);
        if (StringUtils.isEmpty((String)name)) {
            this.messages.addMessage(new String[]{"doapOptions", "name"}, null, 11);
            return;
        }
        DoapUtil.writeComment(writer, "A name of something.");
        if (ASFExtOptionsUtil.isASFProject(project) && !name.toLowerCase(Locale.ENGLISH).startsWith("apache")) {
            name = "Apache " + name;
        }
        DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "name", name);
    }

    private void writeDescription(XMLWriter writer, MavenProject project) {
        boolean addComment = false;
        String description = DoapUtil.interpolate(this.doapOptions.getDescription(), project, this.settings);
        if (StringUtils.isEmpty((String)description)) {
            this.messages.addMessage(new String[]{"doapOptions", "description"}, null, 11);
        } else {
            DoapUtil.writeComment(writer, "Plain text description of a project, of 2-4 sentences in length.");
            addComment = true;
            DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "description", description, this.lang);
        }
        String comment = "Short plain text description of a project.";
        String shortdesc = DoapUtil.interpolate(this.doapOptions.getShortdesc(), project, this.settings);
        if (StringUtils.isEmpty((String)shortdesc)) {
            this.messages.addMessage(new String[]{"doapOptions", "shortdesc"}, null, 11);
            return;
        }
        if (description.equals(shortdesc)) {
            String sentence = StringUtils.split((String)shortdesc, (String)".")[0];
            if (StringUtils.split((String)sentence, (String)" ").length > 10) {
                this.messages.addMessage(new String[]{"doapOptions", "shortdesc"}, null, 34);
                return;
            }
            if (!addComment) {
                DoapUtil.writeComment(writer, comment);
            }
            DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "shortdesc", sentence, this.lang);
            return;
        }
        if (!addComment) {
            DoapUtil.writeComment(writer, comment);
        }
        DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "shortdesc", shortdesc, this.lang);
    }

    private void writeCreated(XMLWriter writer, MavenProject project) {
        String created = DoapUtil.interpolate(this.doapOptions.getCreated(), project, this.settings);
        if (StringUtils.isEmpty((String)created)) {
            this.messages.addMessage(new String[]{"doapOptions", "created"}, null, 11);
            return;
        }
        try {
            DOAP_DATE_FORMAT.parse(created);
        }
        catch (ParseException e) {
            this.messages.addMessage(new String[]{"doapOptions", "created"}, null, 31);
            return;
        }
        DoapUtil.writeComment(writer, "Date when something was created, in YYYY-MM-DD form. e.g. 2004-04-05");
        DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "created", created);
    }

    private void writeHomepage(XMLWriter writer, MavenProject project) {
        String homepage = DoapUtil.interpolate(this.doapOptions.getHomepage(), project, this.settings);
        if (StringUtils.isEmpty((String)homepage)) {
            this.messages.addMessage(new String[]{"doapOptions", "homepage"}, null, 11);
        } else {
            try {
                new URL(homepage);
                DoapUtil.writeComment(writer, "URL of a project's homepage, associated with exactly one project.");
                DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "homepage", homepage);
            }
            catch (MalformedURLException e) {
                this.messages.addMessage(new String[]{"doapOptions", "homepage"}, homepage, 30);
            }
        }
        if (StringUtils.isNotEmpty((String)this.doapOptions.getOldHomepage())) {
            String oldHomepage = DoapUtil.interpolate(this.doapOptions.getOldHomepage(), project, this.settings);
            if (StringUtils.isEmpty((String)oldHomepage)) {
                return;
            }
            try {
                new URL(oldHomepage);
                DoapUtil.writeComment(writer, "URL of a project's past homepage, associated with exactly one project.");
                DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "old-homepage", oldHomepage);
            }
            catch (MalformedURLException e) {
                this.messages.addMessage(new String[]{"doapOptions", "oldHomepage"}, oldHomepage, 30);
            }
        }
    }

    private void writeProgrammingLanguage(XMLWriter writer, MavenProject project) {
        if (StringUtils.isEmpty((String)this.doapOptions.getProgrammingLanguage()) && StringUtils.isEmpty((String)this.language)) {
            this.messages.addMessage(new String[]{"doapOptions", "programmingLanguage"}, null, 11);
            return;
        }
        boolean addComment = false;
        String comment = "Programming language.";
        if (StringUtils.isNotEmpty((String)this.language)) {
            this.getLog().warn((CharSequence)("The <language/> parameter is deprecated, please use " + this.messages.toConfiguration(new String[]{"doapOptions", "programmingLanguage"}, null) + " parameter instead of."));
            this.language = this.language.trim();
            if (this.asfExtOptions.isIncluded()) {
                String asfLanguage = ASFExtOptionsUtil.getProgrammingLanguageSupportedByASF(this.language);
                if (asfLanguage == null) {
                    this.messages.getErrorMessages().add("The deprecated " + this.messages.toConfiguration(new String[]{"language"}, this.language) + " parameter is not supported by ASF. Should be one of " + Arrays.toString(ASFExtOptionsUtil.PROGRAMMING_LANGUAGES));
                } else {
                    DoapUtil.writeComment(writer, comment);
                    addComment = true;
                    DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "programming-language", asfLanguage.trim());
                }
            } else {
                DoapUtil.writeComment(writer, comment);
                addComment = true;
                DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "programming-language", this.language.trim());
            }
        }
        if (StringUtils.isNotEmpty((String)this.doapOptions.getProgrammingLanguage())) {
            String[] languages;
            for (String language : languages = StringUtils.split((String)this.doapOptions.getProgrammingLanguage(), (String)",")) {
                language = language.trim();
                if (this.asfExtOptions.isIncluded()) {
                    String asfLanguage = ASFExtOptionsUtil.getProgrammingLanguageSupportedByASF(language);
                    if (asfLanguage == null) {
                        this.messages.getErrorMessages().add("The " + this.messages.toConfiguration(new String[]{"doapOptions", "programmingLanguage"}, language) + " parameter is not supported by ASF. " + "Should be one of " + Arrays.toString(ASFExtOptionsUtil.PROGRAMMING_LANGUAGES));
                        continue;
                    }
                    if (!addComment) {
                        DoapUtil.writeComment(writer, comment);
                        addComment = true;
                    }
                    DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "programming-language", asfLanguage);
                    continue;
                }
                if (!addComment) {
                    DoapUtil.writeComment(writer, comment);
                    addComment = true;
                }
                DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "programming-language", language);
            }
        }
    }

    private void writeCategory(XMLWriter writer, MavenProject project) {
        if (StringUtils.isEmpty((String)this.doapOptions.getCategory()) && StringUtils.isEmpty((String)this.category)) {
            this.messages.addMessage(new String[]{"doapOptions", "category"}, null, 11);
            return;
        }
        boolean addComment = false;
        String comment = "A category of project.";
        if (StringUtils.isNotEmpty((String)this.category)) {
            this.getLog().warn((CharSequence)("The <category/> parameter is deprecated, please use " + this.messages.toConfiguration(new String[]{"doapOptions", "category"}, null) + " parameter instead of."));
            this.category = this.category.trim();
            if (this.asfExtOptions.isIncluded()) {
                String asfCategory = ASFExtOptionsUtil.getCategorySupportedByASF(this.category);
                if (asfCategory == null) {
                    this.messages.getErrorMessages().add("The deprecated " + this.messages.toConfiguration(new String[]{"category"}, this.category) + " parameter is not supported by ASF. Should be one of " + Arrays.toString(ASFExtOptionsUtil.CATEGORIES));
                } else {
                    DoapUtil.writeComment(writer, comment);
                    addComment = true;
                    DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "category", "http://projects.apache.org/category/" + asfCategory);
                }
            } else {
                DoapUtil.writeComment(writer, comment);
                addComment = true;
                DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "category", this.category);
            }
        }
        if (StringUtils.isNotEmpty((String)this.doapOptions.getCategory())) {
            String[] categories;
            for (String category : categories = StringUtils.split((String)this.doapOptions.getCategory(), (String)",")) {
                category = category.trim();
                if (this.asfExtOptions.isIncluded()) {
                    String asfCategory = ASFExtOptionsUtil.getCategorySupportedByASF(category);
                    if (asfCategory == null) {
                        this.messages.getErrorMessages().add("The " + this.messages.toConfiguration(new String[]{"doapOptions", "category"}, category) + " parameter is not supported by ASF. Should be one of " + Arrays.toString(ASFExtOptionsUtil.CATEGORIES));
                        continue;
                    }
                    if (!addComment) {
                        DoapUtil.writeComment(writer, comment);
                        addComment = true;
                    }
                    DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "category", "http://projects.apache.org/category/" + asfCategory);
                    continue;
                }
                if (!addComment) {
                    DoapUtil.writeComment(writer, comment);
                    addComment = true;
                }
                DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "category", category);
            }
        }
    }

    private void writeDownloadPage(XMLWriter writer, MavenProject project) {
        String downloadPage = DoapUtil.interpolate(this.doapOptions.getDownloadPage(), project, this.settings);
        if (StringUtils.isEmpty((String)downloadPage)) {
            this.messages.addMessage(new String[]{"doapOptions", "downloadPage"}, null, 11);
            return;
        }
        try {
            new URL(downloadPage);
            DoapUtil.writeComment(writer, "Download page.");
            DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "download-page", downloadPage);
        }
        catch (MalformedURLException e) {
            this.messages.addMessage(new String[]{"doapOptions", "downloadPage"}, downloadPage, 30);
        }
        if (StringUtils.isNotEmpty((String)this.doapOptions.getDownloadMirror())) {
            String[] downloadMirrors;
            boolean addComment = false;
            for (String downloadMirror : downloadMirrors = StringUtils.split((String)this.doapOptions.getDownloadMirror(), (String)",")) {
                downloadMirror = downloadMirror.trim();
                try {
                    new URL(downloadMirror);
                    if (!addComment) {
                        DoapUtil.writeComment(writer, "Mirror of software download web page.");
                        addComment = true;
                    }
                    DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "download-mirror", downloadMirror);
                }
                catch (MalformedURLException e) {
                    this.messages.addMessage(new String[]{"doapOptions", "downloadMirror"}, downloadMirror, 30);
                }
            }
        }
    }

    private void writeOS(XMLWriter writer, MavenProject project) {
        String[] oses;
        String osList = DoapUtil.interpolate(this.doapOptions.getOs(), project, this.settings);
        if (StringUtils.isEmpty((String)osList)) {
            return;
        }
        DoapUtil.writeComment(writer, "Operating system that a project is limited to.");
        for (String os : oses = StringUtils.split((String)osList, (String)",")) {
            DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "os", os.trim());
        }
    }

    private void writeScreenshots(XMLWriter writer, MavenProject project) {
        String screenshots = DoapUtil.interpolate(this.doapOptions.getScreenshots(), project, this.settings);
        if (StringUtils.isEmpty((String)screenshots)) {
            return;
        }
        screenshots = screenshots.trim();
        try {
            new URL(screenshots);
        }
        catch (MalformedURLException e) {
            this.messages.addMessage(new String[]{"doapOptions", "screenshots"}, screenshots, 30);
            return;
        }
        DoapUtil.writeComment(writer, "Web page with screenshots of project.");
        DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "screenshots", screenshots);
    }

    private void writeWiki(XMLWriter writer, MavenProject project) {
        String wiki = DoapUtil.interpolate(this.doapOptions.getWiki(), project, this.settings);
        if (StringUtils.isEmpty((String)wiki)) {
            return;
        }
        wiki = wiki.trim();
        try {
            new URL(wiki);
        }
        catch (MalformedURLException e) {
            this.messages.addMessage(new String[]{"doapOptions", "wiki"}, wiki, 30);
            return;
        }
        DoapUtil.writeComment(writer, "URL of Wiki for collaborative discussion of project.");
        DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "wiki", wiki);
    }

    private void writeLicenses(XMLWriter writer, MavenProject project) {
        String license = DoapUtil.interpolate(this.doapOptions.getLicense(), project, this.settings);
        if (StringUtils.isEmpty((String)license)) {
            boolean added = false;
            List licenses = project.getLicenses();
            if (licenses.size() > 1) {
                for (int i = 1; i < licenses.size(); ++i) {
                    if (StringUtils.isEmpty((String)((License)licenses.get(i)).getUrl())) continue;
                    String licenseUrl = ((License)licenses.get(i)).getUrl().trim();
                    try {
                        new URL(licenseUrl);
                        DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "license", licenseUrl);
                        added = true;
                        continue;
                    }
                    catch (MalformedURLException e) {
                        this.messages.addMessage(new String[]{"project", "licenses", "license", "url"}, licenseUrl, 30);
                    }
                }
            }
            if (!added) {
                this.messages.addMessage(new String[]{"doapOptions", "license"}, null, 11);
            }
            return;
        }
        try {
            new URL(license);
            DoapUtil.writeComment(writer, "The URI of the license the software is distributed under.");
            DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "license", license);
        }
        catch (MalformedURLException e) {
            this.messages.addMessage(new String[]{"doapOptions", "license"}, license, 30);
        }
    }

    private void writeBugDatabase(XMLWriter writer, MavenProject project) {
        String bugDatabase = DoapUtil.interpolate(this.doapOptions.getBugDatabase(), project, this.settings);
        if (StringUtils.isEmpty((String)bugDatabase)) {
            this.messages.addMessage(new String[]{"doapOptions", "bugDatabase"}, null, 11);
            return;
        }
        try {
            new URL(bugDatabase);
            DoapUtil.writeComment(writer, "Bug database.");
            DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "bug-database", bugDatabase);
        }
        catch (MalformedURLException e) {
            this.messages.addMessage(new String[]{"doapOptions", "bugDatabase"}, bugDatabase, 30);
        }
    }

    private void writeMailingList(XMLWriter writer, MavenProject project) {
        String ml = DoapUtil.interpolate(this.doapOptions.getMailingList(), project, this.settings);
        if (StringUtils.isEmpty((String)ml)) {
            this.messages.addMessage(new String[]{"doapOptions", "mailingList"}, null, 11);
            return;
        }
        try {
            new URL(ml);
            DoapUtil.writeComment(writer, "Mailing lists.");
            DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "mailing-list", ml);
        }
        catch (MalformedURLException e) {
            this.messages.addMessage(new String[]{"doapOptions", "mailingList"}, ml, 30);
        }
    }

    private void writeReleases(XMLWriter writer, MavenProject project) throws MojoExecutionException {
        Artifact artifact = this.artifactFactory.createArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, project.getPackaging());
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(artifact);
        for (ArtifactRepository repo : this.remoteRepositories) {
            if (repo.isBlacklisted() || repo.getSnapshots().isEnabled() || !repo.getReleases().isEnabled()) continue;
            try {
                this.repositoryMetadataManager.resolveAlways((RepositoryMetadata)metadata, this.localRepository, repo);
                break;
            }
            catch (RepositoryMetadataResolutionException e) {
                throw new MojoExecutionException(metadata.extendedToString() + " could not be retrieved from repositories due to an error: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        if (metadata.getMetadata().getVersioning() == null) {
            this.messages.getWarnMessages().add("No versioning was found for " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ". Ignored DOAP <release/> tag.");
            return;
        }
        List versions = metadata.getMetadata().getVersioning().getVersions();
        Collections.reverse(versions);
        boolean addComment = false;
        int i = 0;
        for (String version : versions) {
            if (!addComment) {
                DoapUtil.writeComment(writer, "Project releases.");
                addComment = true;
            }
            DoapUtil.writeStartElement(writer, this.doapOptions.getXmlnsPrefix(), "release");
            DoapUtil.writeStartElement(writer, this.doapOptions.getXmlnsPrefix(), "Version");
            DoapUtil.writeStartElement(writer, this.doapOptions.getXmlnsPrefix(), "name");
            if (version.equals(metadata.getMetadata().getVersioning().getRelease())) {
                writer.writeText("Latest stable release");
            } else {
                writer.writeText(project.getName() + " - " + version);
            }
            writer.endElement();
            DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "revision", version);
            for (ArtifactRepository repo : this.remoteRepositories) {
                Artifact artifactRelease = this.artifactFactory.createArtifact(project.getGroupId(), project.getArtifactId(), version, null, project.getPackaging());
                if (artifactRelease == null) continue;
                String fileRelease = repo.getUrl() + "/" + repo.pathOf(artifactRelease);
                try {
                    DoapUtil.fetchURL(this.settings, new URL(fileRelease));
                }
                catch (IOException e) {
                    this.getLog().debug((CharSequence)("IOException :" + e.getMessage()));
                    continue;
                }
                DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "file-release", fileRelease);
                Date releaseDate = null;
                try {
                    releaseDate = REPOSITORY_DATE_FORMAT.parse(metadata.getMetadata().getVersioning().getLastUpdated());
                }
                catch (ParseException e) {
                    this.getLog().error((CharSequence)("Unable to parse date '" + metadata.getMetadata().getVersioning().getLastUpdated() + "'"));
                    continue;
                }
                if (i != 0) continue;
                DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "created", DOAP_DATE_FORMAT.format(releaseDate));
            }
            writer.endElement();
            writer.endElement();
            ++i;
        }
    }

    private void writeSourceRepositories(XMLWriter writer, MavenProject project) {
        String anonymousConnection = DoapUtil.interpolate(this.doapOptions.getScmAnonymous(), project, this.settings);
        if (StringUtils.isEmpty((String)anonymousConnection)) {
            this.messages.addMessage(new String[]{"doapOptions", "scmAnonymousConnection"}, null, 11);
        } else {
            DoapUtil.writeComment(writer, "Anonymous Source Repository.");
            try {
                new URL(anonymousConnection);
                DoapUtil.writeStartElement(writer, this.doapOptions.getXmlnsPrefix(), "repository");
                DoapUtil.writeStartElement(writer, this.doapOptions.getXmlnsPrefix(), "Repository");
                DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "location", anonymousConnection);
                writer.endElement();
                writer.endElement();
            }
            catch (MalformedURLException e) {
                this.writeSourceRepository(writer, project, anonymousConnection);
            }
        }
        String devConnection = DoapUtil.interpolate(this.doapOptions.getScmDeveloper(), project, this.settings);
        if (StringUtils.isEmpty((String)devConnection)) {
            this.messages.addMessage(new String[]{"doapOptions", "scmDeveloperConnection"}, null, 11);
        } else {
            DoapUtil.writeComment(writer, "Developer Source Repository.");
            try {
                new URL(devConnection);
                DoapUtil.writeStartElement(writer, this.doapOptions.getXmlnsPrefix(), "repository");
                DoapUtil.writeStartElement(writer, this.doapOptions.getXmlnsPrefix(), "Repository");
                DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "location", devConnection);
                writer.endElement();
                writer.endElement();
            }
            catch (MalformedURLException e) {
                this.writeSourceRepository(writer, project, devConnection);
            }
        }
    }

    private void writeSourceRepository(XMLWriter writer, MavenProject project, String connection) {
        ScmRepository repository = this.getScmRepository(connection);
        DoapUtil.writeStartElement(writer, this.doapOptions.getXmlnsPrefix(), "repository");
        if (DoapMojo.isScmSystem(repository, "cvs")) {
            DoapUtil.writeStartElement(writer, this.doapOptions.getXmlnsPrefix(), "CVSRepository");
            CvsScmProviderRepository cvsRepo = (CvsScmProviderRepository)repository.getProviderRepository();
            DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "anon-root", cvsRepo.getCvsRoot());
            DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "module", cvsRepo.getModule());
        } else if (DoapMojo.isScmSystem(repository, "svn")) {
            DoapUtil.writeStartElement(writer, this.doapOptions.getXmlnsPrefix(), "SVNRepository");
            SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
            DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "location", svnRepo.getUrl());
        } else {
            DoapUtil.writeStartElement(writer, this.doapOptions.getXmlnsPrefix(), "Repository");
            if (connection.length() < 4) {
                throw new IllegalArgumentException("The source repository connection is too short.");
            }
            DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "location", connection.substring(4));
        }
        DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "browse", project.getScm().getUrl());
        writer.endElement();
        writer.endElement();
    }

    private void writeContributors(XMLWriter writer, List<Contributor> contributors) {
        if (contributors == null || contributors.isEmpty()) {
            return;
        }
        boolean isDeveloper = Developer.class.isAssignableFrom(contributors.get(0).getClass());
        if (isDeveloper) {
            DoapUtil.writeComment(writer, "Main committers.");
        } else {
            DoapUtil.writeComment(writer, "Contributed persons.");
        }
        List<Contributor> maintainers = DoapUtil.getContributorsWithMaintainerRole(this.i18n, contributors);
        List<Contributor> developers = DoapUtil.getContributorsWithDeveloperRole(this.i18n, contributors);
        List<Contributor> documenters = DoapUtil.getContributorsWithDocumenterRole(this.i18n, contributors);
        List<Contributor> translators = DoapUtil.getContributorsWithTranslatorRole(this.i18n, contributors);
        List<Contributor> testers = DoapUtil.getContributorsWithTesterRole(this.i18n, contributors);
        List<Contributor> helpers = DoapUtil.getContributorsWithHelperRole(this.i18n, contributors);
        List<Contributor> unknowns = DoapUtil.getContributorsWithUnknownRole(this.i18n, contributors);
        if (isDeveloper) {
            maintainers.addAll(unknowns);
        } else {
            helpers.addAll(unknowns);
        }
        if (developers.size() != 0) {
            this.writeContributor(writer, developers, "developer");
        }
        if (documenters.size() != 0) {
            this.writeContributor(writer, documenters, "documenter");
        }
        if (helpers.size() != 0) {
            this.writeContributor(writer, helpers, "helper");
        }
        if (maintainers.size() != 0) {
            this.writeContributor(writer, maintainers, "maintainer");
        }
        if (testers.size() != 0) {
            this.writeContributor(writer, testers, "tester");
        }
        if (translators.size() != 0) {
            this.writeContributor(writer, translators, "translator");
        }
    }

    private void writeContributor(XMLWriter writer, List<Contributor> developersOrContributors, String doapType) {
        if (developersOrContributors == null || developersOrContributors.isEmpty()) {
            return;
        }
        DoapMojo.sortContributors(developersOrContributors);
        for (Contributor developersOrContributor : developersOrContributors) {
            this.writeContributor(writer, developersOrContributor, this.doapOptions.getXmlnsPrefix(), doapType);
        }
    }

    private void writeContributor(XMLWriter writer, Contributor developerOrContributor, String xmlsPrefix, String doapType) {
        if (developerOrContributor == null) {
            return;
        }
        if (StringUtils.isEmpty((String)doapType)) {
            throw new IllegalArgumentException("doapType is required.");
        }
        String name = developerOrContributor.getName();
        String email = developerOrContributor.getEmail();
        String organization = developerOrContributor.getOrganization();
        String organizationUrl = developerOrContributor.getOrganizationUrl();
        String homepage = developerOrContributor.getUrl();
        String nodeId = null;
        if (StringUtils.isEmpty((String)name)) {
            this.messages.addMessage(new String[]{"project", "developers|contributors", "developer|contributor", "name"}, null, 10);
            return;
        }
        if (!StringUtils.isEmpty((String)organization) || !StringUtils.isEmpty((String)organizationUrl)) {
            DoapUtil.Organization doapOrganization = DoapUtil.addOrganization(organization, organizationUrl);
            nodeId = DoapUtil.getNodeId();
            doapOrganization.addMember(nodeId);
        }
        DoapUtil.writeStartElement(writer, xmlsPrefix, doapType);
        DoapUtil.writeStartElement(writer, "foaf", "Person");
        if (StringUtils.isNotEmpty((String)nodeId)) {
            writer.addAttribute("rdf:nodeID", nodeId);
        }
        DoapUtil.writeStartElement(writer, "foaf", "name");
        writer.writeText(name);
        writer.endElement();
        if (StringUtils.isNotEmpty((String)email)) {
            if (DoapUtil.isValidEmail(email)) {
                DoapUtil.writeRdfResourceElement(writer, "foaf", "mbox", "mailto:" + email);
            } else {
                this.messages.addMessage(new String[]{"project", "developers|contributors", "developer|contributor", "email"}, null, 33);
            }
        }
        if (StringUtils.isNotEmpty((String)organization) && StringUtils.isNotEmpty((String)organizationUrl)) {
            try {
                new URL(organizationUrl);
                DoapUtil.addOrganization(organization, organizationUrl);
            }
            catch (MalformedURLException e) {
                this.messages.addMessage(new String[]{"project", "developers|contributors", "developer|contributor", "organizationUrl"}, organizationUrl, 30);
            }
        }
        if (StringUtils.isNotEmpty((String)homepage)) {
            try {
                new URL(homepage);
                DoapUtil.writeRdfResourceElement(writer, "foaf", "homepage", homepage);
            }
            catch (MalformedURLException e) {
                this.messages.addMessage(new String[]{"project", "developers|contributors", "developer|contributor", "homepage"}, homepage, 30);
            }
        }
        writer.endElement();
        writer.endElement();
    }

    private ScmRepository getScmRepository(String scmUrl) {
        ScmRepository repo;
        block5: {
            repo = null;
            if (!StringUtils.isEmpty((String)scmUrl)) {
                try {
                    repo = this.scmManager.makeScmRepository(scmUrl);
                }
                catch (NoSuchScmProviderException e) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
                    }
                }
                catch (ScmRepositoryException e) {
                    if (!this.getLog().isDebugEnabled()) break block5;
                    this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
        }
        return repo;
    }

    private void writeASFext(XMLWriter writer, MavenProject project) {
        if (!this.asfExtOptions.isIncluded()) {
            return;
        }
        DoapUtil.writeComment(writer, "ASF extension.");
        String pmc = DoapUtil.interpolate(this.asfExtOptions.getPmc(), project, this.settings);
        if (StringUtils.isNotEmpty((String)pmc)) {
            DoapUtil.writeRdfResourceElement(writer, this.asfExtOptions.getXmlnsPrefix(), "pmc", pmc);
        } else {
            this.messages.addMessage(new String[]{"asfExtOptions", "pmc"}, null, 12);
        }
        String name = DoapUtil.interpolate(this.asfExtOptions.getName(), project, this.settings);
        if (StringUtils.isNotEmpty((String)name)) {
            if (!name.toLowerCase(Locale.ENGLISH).trim().startsWith("apache")) {
                name = "Apache " + name;
            }
            DoapUtil.writeElement(writer, this.asfExtOptions.getXmlnsPrefix(), "name", name);
        } else {
            this.messages.addMessage(new String[]{"asfExtOptions", "name"}, null, 12);
        }
        String homepage = DoapUtil.interpolate(this.doapOptions.getHomepage(), project, this.settings);
        if (StringUtils.isNotEmpty((String)homepage)) {
            try {
                new URL(homepage);
                DoapUtil.writeRdfResourceElement(writer, "foaf", "homepage", homepage);
            }
            catch (MalformedURLException e) {
                this.messages.addMessage(new String[]{"doapOptions", "homepage"}, homepage, 30);
            }
        }
        if (StringUtils.isEmpty((String)this.asfExtOptions.getCharter())) {
            this.messages.addMessage(new String[]{"asfExtOptions", "charter"}, null, 12);
        } else {
            DoapUtil.writeElement(writer, this.asfExtOptions.getXmlnsPrefix(), "charter", this.asfExtOptions.getCharter());
        }
        ArrayList<Developer> developers = new ArrayList<Developer>(project.getDevelopers());
        DoapMojo.sortContributors(developers);
        if (StringUtils.isNotEmpty((String)this.asfExtOptions.getChair())) {
            DoapUtil.writeStartElement(writer, this.asfExtOptions.getXmlnsPrefix(), "chair");
            DoapUtil.writeStartElement(writer, "foaf", "Person");
            DoapUtil.writeStartElement(writer, "foaf", "name");
            writer.writeText(this.asfExtOptions.getChair());
            writer.endElement();
            writer.endElement();
            writer.endElement();
        } else {
            Developer chair = ASFExtOptionsUtil.findChair(developers);
            if (chair != null) {
                this.writeContributor(writer, (Contributor)chair, this.asfExtOptions.getXmlnsPrefix(), "chair");
                developers.remove(chair);
            } else {
                this.messages.addMessage(new String[]{"asfExtOptions", "chair"}, null, 12);
            }
        }
        if (developers != null && developers.size() > 0) {
            List<Developer> pmcMembers = ASFExtOptionsUtil.findPMCMembers(developers);
            for (Developer pmcMember : pmcMembers) {
                this.writeContributor(writer, (Contributor)pmcMember, this.asfExtOptions.getXmlnsPrefix(), "member");
            }
        }
        this.writeASFImplements(writer);
        Map<Object, String> map = this.asfExtOptions.getExtra();
        this.writeExtra(writer, project, "Extra ASFExt vocabulary.", map, this.asfExtOptions.getXmlnsPrefix());
    }

    private void writeASFImplements(XMLWriter writer) {
        if (this.asfExtOptions.getStandards() == null || this.asfExtOptions.getStandards().isEmpty()) {
            return;
        }
        for (Standard standard : this.asfExtOptions.getStandards()) {
            DoapUtil.writeStartElement(writer, this.asfExtOptions.getXmlnsPrefix(), "implements");
            DoapUtil.writeStartElement(writer, this.asfExtOptions.getXmlnsPrefix(), "Standard");
            if (StringUtils.isEmpty((String)standard.getTitle())) {
                this.messages.addMessage(new String[]{"asfExtOptions", "standards", "title"}, null, 12);
            } else {
                DoapUtil.writeElement(writer, this.asfExtOptions.getXmlnsPrefix(), "title", standard.getTitle().trim());
            }
            if (StringUtils.isEmpty((String)standard.getBody())) {
                this.messages.addMessage(new String[]{"asfExtOptions", "standards", "body"}, null, 12);
            } else {
                DoapUtil.writeElement(writer, this.asfExtOptions.getXmlnsPrefix(), "body", standard.getBody().trim());
            }
            if (StringUtils.isEmpty((String)standard.getId())) {
                this.messages.addMessage(new String[]{"asfExtOptions", "standards", "id"}, null, 12);
            } else {
                DoapUtil.writeElement(writer, this.asfExtOptions.getXmlnsPrefix(), "id", standard.getId().trim());
            }
            if (StringUtils.isNotEmpty((String)standard.getUrl())) {
                String standardUrl = standard.getUrl().trim();
                try {
                    new URL(standardUrl);
                    DoapUtil.writeElement(writer, this.asfExtOptions.getXmlnsPrefix(), "url", standardUrl);
                }
                catch (MalformedURLException e) {
                    this.messages.addMessage(new String[]{"asfExtOptions", "standards", "url"}, standardUrl, 30);
                }
            }
            writer.endElement();
            writer.endElement();
        }
    }

    private void writeOrganizations(XMLWriter writer) {
        Set<Map.Entry<String, DoapUtil.Organization>> organizations = DoapUtil.getOrganizations();
        for (Map.Entry<String, DoapUtil.Organization> organizationEntry : organizations) {
            DoapUtil.Organization organization = organizationEntry.getValue();
            DoapUtil.writeStartElement(writer, "foaf", "Organization");
            if (!StringUtils.isEmpty((String)organization.getName())) {
                DoapUtil.writeElement(writer, "foaf", "name", organization.getName());
            }
            if (!StringUtils.isEmpty((String)organization.getUrl())) {
                try {
                    new URL(organization.getUrl());
                    DoapUtil.writeRdfResourceElement(writer, "foaf", "homepage", organization.getUrl());
                }
                catch (MalformedURLException e) {
                    this.messages.errorMessages.add("The organization URL " + organization.getUrl() + " is not a valid URL.");
                }
            }
            List<String> members = organization.getMembers();
            for (String member : members) {
                DoapUtil.writeRdfNodeIdElement(writer, "foaf", "member", member);
            }
            writer.endElement();
        }
    }

    private void writeAudience(XMLWriter writer) {
        String audience = DoapUtil.interpolate(this.doapOptions.getAudience(), this.project, this.settings);
        if (StringUtils.isEmpty((String)audience)) {
            return;
        }
        DoapUtil.writeComment(writer, "Audience.");
        DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "audience", audience);
    }

    private void writeBlog(XMLWriter writer) {
        String blog = DoapUtil.interpolate(this.doapOptions.getBlog(), this.project, this.settings);
        if (StringUtils.isEmpty((String)this.doapOptions.getBlog())) {
            return;
        }
        blog = blog.trim();
        try {
            new URL(blog);
        }
        catch (MalformedURLException e) {
            this.messages.addMessage(new String[]{"doapOptions", "blog"}, blog, 30);
            return;
        }
        DoapUtil.writeComment(writer, "Blog page.");
        DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "blog", blog);
    }

    private void writePlateform(XMLWriter writer) {
        String[] platforms;
        if (StringUtils.isEmpty((String)this.doapOptions.getPlatform())) {
            return;
        }
        DoapUtil.writeComment(writer, "Platform.");
        for (String platform : platforms = StringUtils.split((String)this.doapOptions.getPlatform(), (String)",")) {
            DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "platform", platform.trim());
        }
    }

    private void writeVendor(XMLWriter writer, MavenProject project) {
        String vendor = DoapUtil.interpolate(this.doapOptions.getVendor(), project, this.settings);
        if (StringUtils.isEmpty((String)vendor)) {
            return;
        }
        DoapUtil.writeComment(writer, "Vendor.");
        DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "vendor", vendor);
    }

    private void writeLanguage(XMLWriter writer) {
        String[] languages;
        if (StringUtils.isEmpty((String)this.doapOptions.getLanguage())) {
            return;
        }
        boolean addComment = false;
        for (String language : languages = StringUtils.split((String)this.doapOptions.getLanguage(), (String)",")) {
            language = language.trim();
            if (Arrays.binarySearch(Locale.getISOLanguages(), language) < 0) {
                this.messages.addMessage(new String[]{"doapOptions", "languages"}, language, 32);
                continue;
            }
            if (!addComment) {
                DoapUtil.writeComment(writer, "Language.");
                addComment = true;
            }
            DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "language", language);
        }
    }

    private void writeServiceEndpoint(XMLWriter writer) {
        String serviceEndpoint = DoapUtil.interpolate(this.doapOptions.getServiceEndpoint(), this.project, this.settings);
        if (StringUtils.isEmpty((String)serviceEndpoint)) {
            return;
        }
        serviceEndpoint = serviceEndpoint.trim();
        try {
            new URL(serviceEndpoint);
        }
        catch (MalformedURLException e) {
            this.messages.addMessage(new String[]{"doapOptions", "serviceEndpoint"}, serviceEndpoint, 30);
            return;
        }
        DoapUtil.writeComment(writer, "Service endpoint.");
        DoapUtil.writeRdfResourceElement(writer, this.doapOptions.getXmlnsPrefix(), "service-endpoint", serviceEndpoint);
    }

    private void writeImplements(XMLWriter writer) {
        String[] implementations;
        if (StringUtils.isEmpty((String)this.doapOptions.getImplementations())) {
            return;
        }
        DoapUtil.writeComment(writer, "Implements.");
        for (String implementation : implementations = StringUtils.split((String)this.doapOptions.getImplementations(), (String)",")) {
            DoapUtil.writeElement(writer, this.doapOptions.getXmlnsPrefix(), "implements", implementation.trim());
        }
    }

    private void writeExtra(XMLWriter writer, MavenProject project, String comment, Map<Object, String> map, String xmlnsPrefix) {
        if (map == null || map.isEmpty()) {
            return;
        }
        boolean addComment = false;
        for (Map.Entry<Object, String> entry : map.entrySet()) {
            String interpolatedValue;
            String key = (String)entry.getKey();
            String value = entry.getValue();
            if (value == null || (interpolatedValue = DoapUtil.interpolate(value, project, this.settings)) == null) continue;
            if (!addComment) {
                DoapUtil.writeComment(writer, comment);
                addComment = true;
            }
            try {
                new URL(interpolatedValue);
                DoapUtil.writeRdfResourceElement(writer, xmlnsPrefix, key, interpolatedValue);
            }
            catch (MalformedURLException e) {
                DoapUtil.writeElement(writer, xmlnsPrefix, key, interpolatedValue);
            }
        }
    }

    private void writeExtensions(XMLWriter writer) {
        if (this.extOptions == null || this.extOptions.length <= 0 || this.extOptions[0].getExtensions().isEmpty()) {
            return;
        }
        for (ExtOptions extOption : this.extOptions) {
            Map<Object, String> map = extOption.getExtensions();
            this.writeExtra(writer, this.project, "Other extension vocabulary.", map, extOption.getXmlnsPrefix());
        }
    }

    private static boolean isScmSystem(ScmRepository scmRepository, String scmProvider) {
        if (StringUtils.isEmpty((String)scmProvider)) {
            return false;
        }
        return scmRepository != null && scmProvider.equalsIgnoreCase(scmRepository.getProvider());
    }

    private static void sortContributors(List contributors) {
        Collections.sort(contributors, new Comparator<Contributor>(){

            @Override
            public int compare(Contributor contributor1, Contributor contributor2) {
                if (contributor1 == contributor2) {
                    return 0;
                }
                if (contributor1 == null && contributor2 != null) {
                    return -1;
                }
                if (contributor1 != null && contributor2 == null) {
                    return 1;
                }
                if (Developer.class.isAssignableFrom(contributor1.getClass()) && Developer.class.isAssignableFrom(contributor2.getClass())) {
                    Developer developer1 = (Developer)contributor1;
                    Developer developer2 = (Developer)contributor2;
                    if (developer1.getId() == null && developer2.getId() != null) {
                        return -1;
                    }
                    if (developer1.getId() != null && developer2.getId() == null) {
                        return 1;
                    }
                    return developer1.getId().compareTo(developer2.getId());
                }
                if (contributor1.getName() == null && contributor2.getName() != null) {
                    return -1;
                }
                if (contributor1.getName() != null && contributor2.getName() == null) {
                    return 1;
                }
                return contributor1.getName().compareTo(contributor2.getName());
            }
        });
    }

    static {
        REPOSITORY_DATE_FORMAT.setTimeZone(UTC_TIME_ZONE);
        DOAP_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        DOAP_DATE_FORMAT.setTimeZone(UTC_TIME_ZONE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UserMessages {
        public static final int REQUIRED = 10;
        public static final int REQUIRED_BY_ASF_OR_RECOMMENDED = 11;
        public static final int REQUIRED_BY_ASF = 12;
        public static final int RECOMMENDED = 20;
        public static final int INVALID_URL = 30;
        public static final int INVALID_DATE = 31;
        public static final int INVALID_ISO_DATE = 32;
        public static final int INVALID_EMAIL = 33;
        public static final int SHORT_DESC_TOO_LONG = 34;
        private List<String> errorMessages = new ArrayList<String>();
        private List<String> warnMessages = new ArrayList<String>();

        private UserMessages() {
        }

        public List<String> getErrorMessages() {
            return this.errorMessages;
        }

        public List<String> getWarnMessages() {
            return this.warnMessages;
        }

        protected void addMessage(String[] tags, String value, int errorId) {
            if (tags == null) {
                throw new IllegalArgumentException("tags is required");
            }
            boolean isPom = false;
            if (tags[0].equalsIgnoreCase("project")) {
                isPom = true;
            }
            switch (errorId) {
                case 10: {
                    this.errorMessages.add("A " + this.toConfiguration(tags, null) + "  parameter is required.");
                    break;
                }
                case 11: {
                    if (isPom) {
                        if (DoapMojo.this.asfExtOptions.isIncluded()) {
                            this.errorMessages.add("A POM " + this.toConfiguration(tags, null) + " value is required by ASF.");
                            break;
                        }
                        this.warnMessages.add("No POM " + this.toConfiguration(tags, null) + " value is defined, it is highly recommended to have one.");
                        break;
                    }
                    if (DoapMojo.this.asfExtOptions.isIncluded()) {
                        this.errorMessages.add("A " + this.toConfiguration(tags, null) + " parameter is required by ASF.");
                        break;
                    }
                    this.warnMessages.add("No " + this.toConfiguration(tags, null) + " parameter defined, it is highly recommended to have one.");
                    break;
                }
                case 12: {
                    if (isPom) {
                        this.errorMessages.add("A POM " + this.toConfiguration(tags, null) + " value is required by ASF.");
                        break;
                    }
                    this.errorMessages.add("A " + this.toConfiguration(tags, null) + " parameter is required by ASF.");
                    break;
                }
                case 20: {
                    this.warnMessages.add("No " + this.toConfiguration(tags, null) + " parameter defined, it is highly recommended to have one.");
                    break;
                }
                case 30: {
                    if (isPom) {
                        this.errorMessages.add("The POM " + this.toConfiguration(tags, value) + " value is not a valid URL.");
                        break;
                    }
                    this.errorMessages.add("The " + this.toConfiguration(tags, value) + " parameter is not a valid URL.");
                    break;
                }
                case 31: {
                    this.errorMessages.add("The " + this.toConfiguration(tags, value) + " parameter should be in YYYY-MM-DD.");
                    break;
                }
                case 33: {
                    this.errorMessages.add("The POM " + this.toConfiguration(tags, value) + " value is not a valid email.");
                    break;
                }
                case 32: {
                    this.errorMessages.add("The " + this.toConfiguration(tags, value) + " parameter is not a valid ISO language.");
                    break;
                }
                case 34: {
                    this.errorMessages.add("The " + this.toConfiguration(tags, value) + " first sentence is too long maximum words number is 10.");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown errorId=" + errorId);
                }
            }
        }

        protected String toConfiguration(String[] tags, String value) {
            int i;
            if (tags == null) {
                throw new IllegalArgumentException("tags is required");
            }
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < tags.length; ++i) {
                if (i == tags.length - 1 && StringUtils.isEmpty((String)value)) {
                    sb.append("<").append(tags[i]).append("/>");
                    continue;
                }
                sb.append("<").append(tags[i]).append(">");
            }
            if (StringUtils.isNotEmpty((String)value)) {
                sb.append(value);
            }
            for (i = tags.length - 1; i >= 0; --i) {
                if (i == tags.length - 1 && StringUtils.isEmpty((String)value)) continue;
                sb.append("</").append(tags[i]).append(">");
            }
            return sb.toString();
        }
    }
}

