/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.ear;

import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;

public class ResourceRef {
    static final String RESOURCE_REF = "resource-ref";
    static final String RESOURCE_REF_NAME = "res-ref-name";
    static final String RESOURCE_TYPE = "res-type";
    static final String RESOURCE_AUTH = "res-auth";
    static final String LOOKUP_NAME = "lookup-name";
    private String name;
    private String type;
    private String auth;
    private String lookupName;

    public ResourceRef(String name, String type, String auth, String lookupName) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("res-ref-name in res-ref-name element cannot be null.");
        }
        if (StringUtils.isEmpty((String)type) && StringUtils.isEmpty((String)auth)) {
            throw new IllegalArgumentException("res-type in res-ref-name element cannot be null ");
        }
        this.name = name;
        this.type = type;
        this.auth = auth;
        this.lookupName = lookupName;
    }

    public void appendResourceRefEntry(XMLWriter writer) {
        writer.startElement(RESOURCE_REF);
        this.doWriteElement(writer, RESOURCE_REF_NAME, this.getName());
        if (this.getType() != null) {
            this.doWriteElement(writer, RESOURCE_TYPE, this.getType());
        }
        if (this.getAuth() != null) {
            this.doWriteElement(writer, RESOURCE_AUTH, this.getAuth());
        }
        if (this.getLookupName() != null) {
            this.doWriteElement(writer, LOOKUP_NAME, this.getLookupName());
        }
        writer.endElement();
    }

    private void doWriteElement(XMLWriter writer, String element, String text) {
        writer.startElement(element);
        writer.writeText(text);
        writer.endElement();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAuth() {
        return this.auth;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public String getLookupName() {
        return this.lookupName;
    }

    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }
}

