/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.eclipse.reader.ReadWorkspaceLocations;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="resolve-workspace-dependencies", aggregator=true, requiresProject=false)
public class WorkspaceDependencyResolveMojo
extends AbstractMojo {
    @Parameter(property="eclipse.workspace")
    private File workspace;
    @Component(role=ArtifactFactory.class)
    private ArtifactFactory artifactFactory;
    @Component(role=ArtifactResolver.class)
    private ArtifactResolver artifactResolver;
    @Parameter(property="project.remoteArtifactRepositories", required=true, readonly=true)
    private List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(property="localRepository", required=true, readonly=true)
    private ArtifactRepository localRepository;

    private List<File> findProjectLocations(File workspaceLocation) {
        return new ReadWorkspaceLocations().readProjectLocations(workspaceLocation, this.getLog());
    }

    private void validateWorkspaceLocation() throws MojoExecutionException {
        if (this.workspace != null && !this.isWorkspaceDirectory(this.workspace)) {
            throw new MojoExecutionException("Not a workspace directory: there is no subdirectory .metadata at " + this.workspace);
        }
        if (this.workspace == null) {
            for (File currentWorkingDirectory = new File(".").getAbsoluteFile(); currentWorkingDirectory != null; currentWorkingDirectory = currentWorkingDirectory.getParentFile()) {
                if (!this.isWorkspaceDirectory(currentWorkingDirectory)) continue;
                this.getLog().debug((CharSequence)("Detected workspace at " + currentWorkingDirectory));
                this.workspace = currentWorkingDirectory;
                return;
            }
        }
        throw new MojoExecutionException("No workspace location configured and none can be detected in the parent directories.");
    }

    private boolean isWorkspaceDirectory(File currentWorkingDirectory) {
        return new File(currentWorkingDirectory, ".metadata").isDirectory();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateWorkspaceLocation();
        for (File location : this.findProjectLocations(this.workspace)) {
            File classpathFile = new File(location, ".classpath");
            if (!classpathFile.exists()) continue;
            this.getLog().info((CharSequence)("Resolving M2_REPO dependencies in " + classpathFile));
            try {
                Xpp3Dom classpath = Xpp3DomBuilder.build((Reader)new FileReader(classpathFile));
                for (Xpp3Dom entry : classpath.getChildren()) {
                    if (!"var".equals(entry.getAttribute("kind"))) continue;
                    this.resolveIfNecessary(entry.getAttribute("path"));
                    this.resolveIfNecessary(entry.getAttribute("sourcepath"));
                }
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Error parsing " + classpathFile), (Throwable)e);
            }
        }
    }

    private void resolveIfNecessary(String path) throws ArtifactResolutionException {
        if (null != path && path.startsWith("M2_REPO")) {
            try {
                Artifact artifact = this.createArtifactFromPath(path);
                if (artifact != null) {
                    this.artifactResolver.resolve(artifact, this.remoteArtifactRepositories, this.localRepository);
                }
            }
            catch (ArtifactNotFoundException e) {
                this.getLog().info((Throwable)e);
            }
        }
    }

    private Artifact createArtifactFromPath(String path) {
        String[] elements = path.split("/");
        if (elements.length < 4) {
            this.getLog().error((CharSequence)("Unexpected repository path structure: " + path));
            return null;
        }
        ArrayList<String> groupParts = new ArrayList<String>();
        for (int i = 1; i < elements.length - 3; ++i) {
            groupParts.add(elements[i]);
        }
        String group = StringUtils.join(groupParts.iterator(), (String)".");
        String artifactId = elements[elements.length - 3];
        String version = elements[elements.length - 2];
        String classifier = null;
        String fileName = elements[elements.length - 1];
        String type = fileName.substring(fileName.lastIndexOf(46) + 1);
        String possibleClassifier = fileName.substring(artifactId.length() + version.length() + 1, fileName.length() - type.length() - 1);
        if (possibleClassifier.length() > 1) {
            classifier = possibleClassifier.substring(1);
        }
        return this.artifactFactory.createArtifactWithClassifier(group, artifactId, version, type, classifier);
    }
}

