/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseResourceWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;

public abstract class AbstractWtpResourceWriter
extends AbstractEclipseResourceWriter {
    private static final String ELT_DEPENDENCY_TYPE = "dependency-type";
    private static final String ATTR_HANDLE = "handle";
    private static final String ELT_DEPENDENT_MODULE = "dependent-module";
    protected static final String ATTR_VALUE = "value";
    protected static final String ATTR_NAME = "name";
    protected static final String ELT_PROPERTY = "property";
    protected static final String ELT_VERSION = "version";
    protected static final String ATTR_MODULE_TYPE_ID = "module-type-id";
    protected static final String ATTR_SOURCE_PATH = "source-path";
    protected static final String ATTR_DEPLOY_PATH = "deploy-path";
    protected static final String ELT_WB_RESOURCE = "wb-resource";
    protected static final String ELT_MODULE_TYPE = "module-type";
    protected static final String ATTR_DEPLOY_NAME = "deploy-name";
    protected static final String ELT_WB_MODULE = "wb-module";
    protected static final String ATTR_MODULE_ID = "id";
    protected static final String ELT_PROJECT_MODULES = "project-modules";
    protected static final String ARTIFACT_MAVEN_WAR_PLUGIN = "maven-war-plugin";

    public AbstractWtpResourceWriter(Log log, File eclipseProjectDir, MavenProject project, IdeDependency[] deps) {
        super(log, eclipseProjectDir, project, deps);
    }

    protected IdeDependency[] getDependencies() {
        return this.deps;
    }

    public abstract void write(EclipseSourceDir[] var1, ArtifactRepository var2, File var3) throws MojoExecutionException;

    protected void writeModuleTypeAccordingToPackaging(MavenProject project, XMLWriter writer, String packaging, File buildOutputDirectory) throws MojoExecutionException {
        if ("war".equals(packaging)) {
            writer.addAttribute(ATTR_MODULE_TYPE_ID, "jst.web");
            writer.startElement(ELT_VERSION);
            writer.writeText(this.resolveServletVersion());
            writer.endElement();
            String contextRoot = project.getArtifactId();
            String finalName = project.getBuild().getFinalName();
            if (!finalName.equals(project.getArtifactId() + "-" + project.getVersion())) {
                contextRoot = finalName;
            }
            writer.startElement(ELT_PROPERTY);
            writer.addAttribute(ATTR_NAME, "context-root");
            writer.addAttribute(ATTR_VALUE, contextRoot);
            writer.endElement();
        } else if ("ejb".equals(packaging)) {
            writer.addAttribute(ATTR_MODULE_TYPE_ID, "jst.ejb");
            writer.startElement(ELT_VERSION);
            writer.writeText(this.resolveEjbVersion());
            writer.endElement();
            writer.startElement(ELT_PROPERTY);
            writer.addAttribute(ATTR_NAME, "java-output-path");
            writer.addAttribute(ATTR_VALUE, "/" + IdeUtils.toRelativeAndFixSeparator(this.getProject().getBasedir(), buildOutputDirectory, false));
            writer.endElement();
        } else if ("ear".equals(packaging)) {
            writer.addAttribute(ATTR_MODULE_TYPE_ID, "jst.ear");
            writer.startElement(ELT_VERSION);
            writer.writeText(this.resolveJ2eeVersion());
            writer.endElement();
        } else {
            writer.addAttribute(ATTR_MODULE_TYPE_ID, "jst.utility");
            writer.startElement(ELT_PROPERTY);
            writer.addAttribute(ATTR_NAME, "java-output-path");
            writer.addAttribute(ATTR_VALUE, "/" + IdeUtils.toRelativeAndFixSeparator(this.getProject().getBasedir(), buildOutputDirectory, false));
            writer.endElement();
        }
    }

    protected void addDependency(XMLWriter writer, IdeDependency dep, ArtifactRepository localRepository, File basedir) throws MojoExecutionException {
        String handle;
        if (dep.isReferencedProject()) {
            handle = "module:/resource/" + dep.getArtifactId() + "/" + dep.getArtifactId();
        } else {
            File artifactPath = dep.getFile();
            if (artifactPath == null) {
                this.getLog().error((CharSequence)Messages.getString("EclipsePlugin.artifactpathisnull", dep.getId()));
                return;
            }
            String fullPath = artifactPath.getPath();
            File repoFile = new File(fullPath);
            if (dep.isSystemScoped()) {
                handle = "module:/classpath/lib/" + IdeUtils.toRelativeAndFixSeparator(this.getEclipseProjectDirectory(), repoFile, false);
            } else {
                File localRepositoryFile = new File(localRepository.getBasedir());
                handle = "module:/classpath/var/M2_REPO/" + IdeUtils.toRelativeAndFixSeparator(localRepositoryFile, repoFile, false);
            }
        }
        writer.startElement(ELT_DEPENDENT_MODULE);
        writer.addAttribute(ATTR_DEPLOY_PATH, "/WEB-INF/lib");
        writer.addAttribute(ATTR_HANDLE, handle);
        writer.startElement(ELT_DEPENDENCY_TYPE);
        writer.writeText("uses");
        writer.endElement();
        writer.endElement();
    }

    protected void writeWarOrEarResources(XMLWriter writer, MavenProject project, ArtifactRepository localRepository) throws MojoExecutionException {
        for (int j = 0; j < this.deps.length; ++j) {
            IdeDependency dep = this.deps[j];
            String type = dep.getType();
            if (dep.isTestDependency() || dep.isProvided() || !"jar".equals(type) && !"ejb".equals(type) && !"ejb-client".equals(type) && !"war".equals(type)) continue;
            this.addDependency(writer, dep, localRepository, this.getProject().getBasedir());
        }
    }

    protected String resolveServletVersion() {
        String[] artifactNames = new String[]{"servlet-api", "servletapi", "geronimo-spec-servlet"};
        String version = IdeUtils.getDependencyVersion(artifactNames, this.getProject().getArtifacts(), 3);
        if (version == null && (version = IdeUtils.getDependencyVersion(artifactNames = new String[]{"geronimo-spec-j2ee"}, this.getProject().getArtifacts(), 3)) != null) {
            String j2eeMinorVersion = StringUtils.substring((String)version, (int)2, (int)3);
            version = "2." + j2eeMinorVersion;
        }
        return version == null ? "2.4" : version;
    }

    protected String resolveEjbVersion() {
        Object version = null;
        return version == null ? "2.1" : version;
    }

    protected String resolveJ2eeVersion() {
        Object version = null;
        return version == null ? "1.3" : version;
    }

    protected String resolveJavaVersion() {
        String version = IdeUtils.getPluginSetting(this.getProject(), "maven-compiler-plugin", "target", null);
        if (version == null) {
            IdeUtils.getPluginSetting(this.getProject(), "maven-compiler-plugin", "source", null);
        }
        if ("1.5".equals(version) || "5".equals(version)) {
            version = "5.0";
        }
        return version == null ? "1.4" : version;
    }
}

