/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseResourceWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EclipseClasspathWriter
extends AbstractEclipseResourceWriter {
    private static final String M2_REPO = "M2_REPO";
    private File eclipseProjectDir;
    private static final String ATTR_SOURCEPATH = "sourcepath";
    private MavenProject project;
    private static final String ATTR_OUTPUT = "output";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_KIND = "kind";
    private static final String ELT_CLASSPATHENTRY = "classpathentry";
    private static final String ELT_CLASSPATH = "classpath";
    private static final String FILE_DOT_CLASSPATH = ".classpath";

    public EclipseClasspathWriter(Log log, File eclipseProjectDir, MavenProject project, IdeDependency[] deps) {
        super(log, eclipseProjectDir, project, deps);
    }

    public void write(File projectBaseDir, EclipseSourceDir[] sourceDirs, List classpathContainers, ArtifactRepository localRepository, File buildOutputDirectory) throws MojoExecutionException {
        FileWriter w;
        try {
            w = new FileWriter(new File(this.getEclipseProjectDirectory(), FILE_DOT_CLASSPATH));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        writer.startElement(ELT_CLASSPATH);
        String defaultOutput = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, buildOutputDirectory, false);
        for (int j = 0; j < sourceDirs.length; ++j) {
            EclipseSourceDir dir = sourceDirs[j];
            writer.startElement(ELT_CLASSPATHENTRY);
            writer.addAttribute(ATTR_KIND, "src");
            writer.addAttribute(ATTR_PATH, dir.getPath());
            if (dir.getOutput() != null && !defaultOutput.equals(dir.getOutput())) {
                writer.addAttribute(ATTR_OUTPUT, dir.getOutput());
            }
            writer.endElement();
        }
        writer.startElement(ELT_CLASSPATHENTRY);
        writer.addAttribute(ATTR_KIND, ATTR_OUTPUT);
        writer.addAttribute(ATTR_PATH, defaultOutput);
        writer.endElement();
        Iterator it = classpathContainers.iterator();
        while (it.hasNext()) {
            writer.startElement(ELT_CLASSPATHENTRY);
            writer.addAttribute(ATTR_KIND, "con");
            writer.addAttribute(ATTR_PATH, (String)it.next());
            writer.endElement();
        }
        for (int j = 0; j < this.deps.length; ++j) {
            IdeDependency dep = this.deps[j];
            if (!dep.isAddedToClasspath()) continue;
            this.addDependency((XMLWriter)writer, dep, localRepository);
        }
        writer.endElement();
        IOUtil.close((Writer)w);
    }

    private void addDependency(XMLWriter writer, IdeDependency dep, ArtifactRepository localRepository) throws MojoExecutionException {
        String kind;
        String path;
        String sourcepath = null;
        String javadocpath = null;
        if (dep.isReferencedProject()) {
            path = "/" + dep.getArtifactId();
            kind = "src";
        } else {
            File artifactPath = dep.getFile();
            if (artifactPath == null) {
                this.getLog().error((CharSequence)Messages.getString("EclipsePlugin.artifactpathisnull", dep.getId()));
                return;
            }
            if (dep.isSystemScoped()) {
                path = IdeUtils.toRelativeAndFixSeparator(this.getEclipseProjectDirectory(), artifactPath, false);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)Messages.getString("EclipsePlugin.artifactissystemscoped", new Object[]{dep.getArtifactId(), path}));
                }
                kind = "lib";
            } else {
                File localRepositoryFile = new File(localRepository.getBasedir());
                String fullPath = artifactPath.getPath();
                path = "M2_REPO/" + IdeUtils.toRelativeAndFixSeparator(localRepositoryFile, new File(fullPath), false);
                if (dep.getSourceAttachment() != null) {
                    sourcepath = "M2_REPO/" + IdeUtils.toRelativeAndFixSeparator(localRepositoryFile, dep.getSourceAttachment(), false);
                }
                if (dep.getJavadocAttachment() != null) {
                    javadocpath = StringUtils.replace((String)IdeUtils.getCanonicalPath(dep.getJavadocAttachment()), (String)"\\", (String)"/");
                }
                kind = "var";
            }
        }
        writer.startElement(ELT_CLASSPATHENTRY);
        writer.addAttribute(ATTR_KIND, kind);
        writer.addAttribute(ATTR_PATH, path);
        if (sourcepath != null) {
            writer.addAttribute(ATTR_SOURCEPATH, sourcepath);
        } else if (javadocpath != null) {
            writer.startElement("attributes");
            writer.startElement("attribute");
            writer.addAttribute("value", "jar:file:/" + javadocpath + "!/");
            writer.addAttribute("name", "javadoc_location");
            writer.endElement();
            writer.endElement();
        }
        writer.endElement();
    }
}

