/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.version;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.version.strategy.ExternalVersionException;
import org.apache.maven.version.strategy.ExternalVersionStrategy;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.expression.DefaultExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="external-version")
public class ExternalVersionExtension
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private Logger logger;
    @Requirement
    private PlexusContainer container;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        this.logger.info("About to change project version in reactor.");
        HashMap<String, String> gavVersionMap = new HashMap<String, String>();
        for (MavenProject mavenProject : session.getAllProjects()) {
            Plugin plugin = mavenProject.getPlugin("org.apache.maven.plugins:maven-external-version-plugin");
            Xpp3Dom configDom = (Xpp3Dom)plugin.getConfiguration();
            ExternalVersionStrategy strategy = this.getStrategy(configDom, mavenProject.getFile());
            String oldVersion = mavenProject.getVersion();
            try {
                String newVersion = this.getNewVersion(strategy, mavenProject);
                mavenProject.setVersion(newVersion);
                mavenProject.getArtifact().setVersion(newVersion);
                mavenProject.getArtifact().setVersionRange(VersionRange.createFromVersion((String)newVersion));
                String oldFinalName = mavenProject.getBuild().getFinalName();
                String newFinalName = oldFinalName.replaceFirst(Pattern.quote(oldVersion), newVersion);
                this.logger.info("Updating project.build.finalName: " + newFinalName);
                mavenProject.getBuild().setFinalName(newFinalName);
                gavVersionMap.put(this.buildGavKey(mavenProject.getGroupId(), mavenProject.getArtifactId(), oldVersion), newVersion);
                this.logger.info("new version added to map: " + this.buildGavKey(mavenProject.getGroupId(), mavenProject.getArtifactId(), oldVersion) + ": " + newVersion);
                if (mavenProject.getParent() == null) continue;
                this.logger.info("My parent is: " + this.buildGavKey(mavenProject.getParent()));
            }
            catch (ExternalVersionException e) {
                throw new MavenExecutionException(e.getMessage(), (Throwable)e);
            }
        }
        for (MavenProject mavenProject : session.getAllProjects()) {
            try {
                if (mavenProject.getParent() != null) {
                    this.logger.info("looking for parent in map");
                    if (gavVersionMap.containsKey(this.buildGavKey(mavenProject.getParent()))) {
                        this.logger.info("WE NEED TO ACT NOW!");
                    }
                }
                this.createNewVersionPom(mavenProject, gavVersionMap);
            }
            catch (XmlPullParserException e) {
                throw new MavenExecutionException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new MavenExecutionException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String buildGavKey(MavenProject mavenProject) {
        return this.buildGavKey(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
    }

    private String buildGavKey(MavenProject mavenProject, String oldVersion) {
        return this.buildGavKey(mavenProject.getGroupId(), mavenProject.getArtifactId(), oldVersion);
    }

    private String buildGavKey(String groupId, String artifactId, String oldVersion) {
        return groupId + ":" + artifactId + ":" + oldVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewVersionPom(MavenProject mavenProject, Map<String, String> gavVersionMap) throws IOException, XmlPullParserException {
        FileReader fileReader = null;
        FileWriter fileWriter = null;
        try {
            String key;
            String newVersionForParent;
            fileReader = new FileReader(mavenProject.getFile());
            Model model = new MavenXpp3Reader().read((Reader)fileReader);
            model.setVersion(mavenProject.getVersion());
            if (model.getParent() != null && (newVersionForParent = gavVersionMap.get(key = this.buildGavKey(model.getParent().getGroupId(), model.getParent().getArtifactId(), model.getParent().getVersion()))) != null) {
                model.getParent().setVersion(newVersionForParent);
            }
            Plugin plugin = mavenProject.getPlugin("org.apache.maven.plugins:maven-external-version-plugin");
            Xpp3Dom pluginConfiguration = (Xpp3Dom)plugin.getConfiguration();
            File newPom = this.createFileFromConfiguration(mavenProject, pluginConfiguration);
            this.logger.debug(ExternalVersionExtension.class.getSimpleName() + ": using new pom file => " + newPom);
            fileWriter = new FileWriter(newPom);
            new MavenXpp3Writer().write((Writer)fileWriter, model);
            mavenProject.setFile(newPom);
        }
        catch (Throwable throwable) {
            IOUtil.close(fileReader);
            IOUtil.close(fileWriter);
            throw throwable;
        }
        IOUtil.close((Reader)fileReader);
        IOUtil.close((Writer)fileWriter);
    }

    private File createFileFromConfiguration(MavenProject mavenProject, Xpp3Dom pluginConfig) throws IOException {
        boolean deleteTemporaryFile = this.shouldDeleteTemporaryFile(pluginConfig);
        boolean generateTemporaryFile = this.shouldGenerateTemporaryFile(pluginConfig);
        File f = new File(mavenProject.getBasedir(), "pom.xml.new-version");
        if (generateTemporaryFile) {
            f = File.createTempFile("pom", ".maven-external-version");
        }
        if (deleteTemporaryFile) {
            f.deleteOnExit();
        }
        return f;
    }

    private boolean shouldGenerateTemporaryFile(Xpp3Dom pluginConfiguration) {
        return this.evaluateBooleanNodeInConfiguration(pluginConfiguration, "generateTemporaryFile");
    }

    private boolean shouldDeleteTemporaryFile(Xpp3Dom pluginConfiguration) {
        return this.evaluateBooleanNodeInConfiguration(pluginConfiguration, "deleteTemporaryFile");
    }

    private boolean evaluateBooleanNodeInConfiguration(Xpp3Dom pluginConfiguration, String nodeName) {
        Xpp3Dom n = pluginConfiguration.getChild(nodeName);
        return n != null && Boolean.parseBoolean(n.getValue());
    }

    private String getNewVersion(ExternalVersionStrategy strategy, MavenProject mavenProject) throws ExternalVersionException {
        boolean isSnapshot = ArtifactUtils.isSnapshot((String)mavenProject.getVersion());
        String newVersion = strategy.getVersion(mavenProject);
        if (newVersion != null) {
            newVersion = newVersion.trim();
        }
        boolean isNewSnapshot = ArtifactUtils.isSnapshot((String)newVersion);
        if (isSnapshot && !isNewSnapshot) {
            newVersion = newVersion + "-SNAPSHOT";
        }
        return newVersion;
    }

    private ExternalVersionStrategy getStrategy(Xpp3Dom configDom, File pomFile) throws MavenExecutionException {
        Xpp3Dom strategyNode = configDom.getChild("strategy");
        if (strategyNode == null) {
            throw new MavenExecutionException("Missing configuration, 'strategy' is required. ", pomFile);
        }
        String hint = strategyNode.getAttribute("hint");
        if (hint == null) {
            throw new MavenExecutionException("Missing configuration, '<strategy hint=\"HINT\">' is required. ", pomFile);
        }
        try {
            ExternalVersionStrategy strategy = (ExternalVersionStrategy)this.container.lookup(ExternalVersionStrategy.class, hint);
            this.logger.info("component: " + strategy);
            ComponentConfigurator configurator = (ComponentConfigurator)this.container.lookup(ComponentConfigurator.class, "basic");
            configurator.configureComponent((Object)strategy, (PlexusConfiguration)new XmlPlexusConfiguration(strategyNode), (ExpressionEvaluator)new DefaultExpressionEvaluator(), null, null);
            return strategy;
        }
        catch (ComponentLookupException e) {
            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (ComponentConfigurationException e) {
            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
    }
}

