/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.failsafe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.surefire.shade.org.apache.commons.io.IOUtils;
import org.apache.maven.surefire.shade.org.apache.commons.lang3.StringEscapeUtils;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.util.internal.StringUtils;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class FailsafeSummaryXmlUtils {
    private static final String FAILSAFE_SUMMARY_XML_SCHEMA_LOCATION = "https://maven.apache.org/surefire/maven-surefire-plugin/xsd/failsafe-summary.xsd";
    private static final String FAILSAFE_SUMMARY_XML_NIL_ATTR = " xsi:nil=\"true\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
    private static final String FAILSAFE_SUMMARY_XML_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<failsafe-summary xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"https://maven.apache.org/surefire/maven-surefire-plugin/xsd/failsafe-summary.xsd\" result=\"%s\" timeout=\"%s\">\n    <completed>%d</completed>\n    <errors>%d</errors>\n    <failures>%d</failures>\n    <skipped>%d</skipped>\n    <failureMessage%s>%s</failureMessage>\n</failsafe-summary>";

    private FailsafeSummaryXmlUtils() {
        throw new IllegalStateException("No instantiable constructor.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RunResult toRunResult(File failsafeSummaryXml) throws Exception {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        FileInputStream is = new FileInputStream(failsafeSummaryXml);
        try {
            Node root = (Node)xpath.evaluate("/", new InputSource(is), XPathConstants.NODE);
            String completed = xpath.evaluate("/failsafe-summary/completed", root);
            String errors = xpath.evaluate("/failsafe-summary/errors", root);
            String failures = xpath.evaluate("/failsafe-summary/failures", root);
            String skipped = xpath.evaluate("/failsafe-summary/skipped", root);
            String failureMessage = xpath.evaluate("/failsafe-summary/failureMessage", root);
            String timeout = xpath.evaluate("/failsafe-summary/@timeout", root);
            RunResult runResult = new RunResult(Integer.parseInt(completed), Integer.parseInt(errors), Integer.parseInt(failures), Integer.parseInt(skipped), StringUtils.isBlank((String)failureMessage) ? null : StringEscapeUtils.unescapeXml(failureMessage), Boolean.parseBoolean(timeout));
            return runResult;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fromRunResultToFile(RunResult fromRunResult, File toFailsafeSummaryXml) throws IOException {
        String failure = fromRunResult.getFailure();
        String xml = String.format(Locale.ROOT, FAILSAFE_SUMMARY_XML_TEMPLATE, fromRunResult.getFailsafeCode(), String.valueOf(fromRunResult.isTimeout()), fromRunResult.getCompletedCount(), fromRunResult.getErrors(), fromRunResult.getFailures(), fromRunResult.getSkipped(), StringUtils.isBlank((String)failure) ? FAILSAFE_SUMMARY_XML_NIL_ATTR : "", StringUtils.isBlank((String)failure) ? "" : StringEscapeUtils.escapeXml10(failure));
        FileOutputStream os = new FileOutputStream(toFailsafeSummaryXml);
        try {
            IOUtils.write(xml, (OutputStream)os, StringUtils.UTF_8);
        }
        finally {
            os.close();
        }
    }

    public static void writeSummary(RunResult mergedSummary, File mergedSummaryFile, boolean inProgress) throws Exception {
        if (!mergedSummaryFile.getParentFile().isDirectory()) {
            mergedSummaryFile.getParentFile().mkdirs();
        }
        if (mergedSummaryFile.exists() && inProgress) {
            RunResult runResult = FailsafeSummaryXmlUtils.toRunResult(mergedSummaryFile);
            mergedSummary = mergedSummary.aggregate(runResult);
        }
        FailsafeSummaryXmlUtils.fromRunResultToFile(mergedSummary, mergedSummaryFile);
    }
}

