/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.gpg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.gpg.AbstractGpgMojo;
import org.apache.maven.plugin.gpg.AscArtifactMetadata;
import org.apache.maven.plugin.gpg.GpgSigner;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class SignAndDeployFileMojo
extends AbstractGpgMojo {
    private File ascDirectory;
    private boolean offline;
    private String groupId;
    private String artifactId;
    private String version;
    private String packaging;
    private String classifier;
    private String description;
    private File file;
    private File pomFile;
    private boolean generatePom;
    private boolean uniqueVersion;
    private String url;
    private String repositoryId;
    private String repositoryLayout;
    private ArtifactDeployer deployer;
    private ArtifactRepository localRepository;
    private Map repositoryLayouts;
    private ArtifactFactory artifactFactory;
    private ArtifactRepositoryFactory repositoryFactory;
    private ModelValidator modelValidator;

    private void initProperties() throws MojoExecutionException {
        if (this.pomFile != null) {
            this.generatePom = false;
            Model model = this.readModel(this.pomFile);
            this.processModel(model);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        GpgSigner signer = this.newSigner(null);
        signer.setOutputDirectory(this.ascDirectory);
        signer.setBaseDirectory(new File("").getAbsoluteFile());
        if (this.offline) {
            throw new MojoFailureException("Cannot deploy artifacts when Maven is in offline mode");
        }
        this.initProperties();
        this.validateArtifactInformation();
        if (!this.file.exists()) {
            throw new MojoFailureException(this.file.getPath() + " not found.");
        }
        ArtifactRepositoryLayout layout = (ArtifactRepositoryLayout)this.repositoryLayouts.get(this.repositoryLayout);
        if (layout == null) {
            throw new MojoFailureException("Invalid repository layout: " + this.repositoryLayout);
        }
        ArtifactRepository deploymentRepository = this.repositoryFactory.createDeploymentArtifactRepository(this.repositoryId, this.url, layout, this.uniqueVersion);
        if (StringUtils.isEmpty((String)deploymentRepository.getProtocol())) {
            throw new MojoFailureException("No transfer protocol found.");
        }
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
        if (this.file.equals(this.getLocalRepoFile(artifact))) {
            throw new MojoFailureException("Cannot deploy artifact from the local repository: " + this.file);
        }
        File fileSig = signer.generateSignatureForArtifact(this.file);
        AscArtifactMetadata metadata = new AscArtifactMetadata(artifact, fileSig, false);
        artifact.addMetadata((ArtifactMetadata)metadata);
        if (!"pom".equals(this.packaging)) {
            if (this.pomFile == null && this.generatePom) {
                this.pomFile = this.generatePomFile();
            }
            if (this.pomFile != null) {
                metadata = new ProjectArtifactMetadata(artifact, this.pomFile);
                artifact.addMetadata((ArtifactMetadata)metadata);
                fileSig = signer.generateSignatureForArtifact(this.pomFile);
                metadata = new AscArtifactMetadata(artifact, fileSig, true);
                artifact.addMetadata((ArtifactMetadata)metadata);
            }
        }
        try {
            this.deployer.deploy(this.file, artifact, deploymentRepository, this.localRepository);
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private File getLocalRepoFile(Artifact artifact) {
        String path = this.localRepository.pathOf(artifact);
        return new File(this.localRepository.getBasedir(), path);
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            this.groupId = model.getGroupId();
            if (this.groupId == null && parent != null) {
                this.groupId = parent.getGroupId();
            }
        }
        if (this.artifactId == null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null) {
            this.version = model.getVersion();
            if (this.version == null && parent != null) {
                this.version = parent.getVersion();
            }
        }
        if (this.packaging == null) {
            this.packaging = model.getPackaging();
        }
    }

    private Model readModel(File pomFile) throws MojoExecutionException {
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pomFile);
            Model model = new MavenXpp3Reader().read((Reader)reader);
            return model;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("POM not found " + pomFile, (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading POM " + pomFile, (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing POM " + pomFile, (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private File generatePomFile() throws MojoExecutionException {
        File file;
        Model model = this.generateModel();
        XmlStreamWriter fw = null;
        try {
            File tempFile = File.createTempFile("mvndeploy", ".pom");
            tempFile.deleteOnExit();
            fw = WriterFactory.newXmlWriter((File)tempFile);
            new MavenXpp3Writer().write((Writer)fw, model);
            file = tempFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fw);
        return file;
    }

    private Model generateModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setPackaging(this.packaging);
        model.setDescription(this.description);
        return model;
    }

    private void validateArtifactInformation() throws MojoFailureException {
        Model model = this.generateModel();
        ModelValidationResult result = this.modelValidator.validate(model);
        if (result.getMessageCount() > 0) {
            throw new MojoFailureException("The artifact information is incomplete or not valid:\n" + result.render("  "));
        }
    }
}

