/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.help.AbstractHelpMojo;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;

@Mojo(name="system", requiresProject=false)
public class SystemMojo
extends AbstractHelpMojo {
    private static final int REPEAT = 25;

    public void execute() throws MojoExecutionException {
        StringBuilder message;
        block10: {
            message = new StringBuilder();
            message.append('\n');
            message.append(StringUtils.repeat((String)"=", (int)79)).append('\n');
            message.append(StringUtils.repeat((String)"=", (int)25));
            message.append(" Platform Properties Details ");
            message.append(StringUtils.repeat((String)"=", (int)25)).append('\n');
            message.append(StringUtils.repeat((String)"=", (int)79)).append('\n');
            message.append('\n');
            message.append(StringUtils.repeat((String)"=", (int)79)).append('\n');
            message.append("System Properties").append('\n');
            message.append(StringUtils.repeat((String)"=", (int)79)).append('\n');
            Properties systemProperties = System.getProperties();
            Iterator<Object> it = systemProperties.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                message.append("\n");
                message.append(key).append("=").append(systemProperties.get(key));
            }
            message.append('\n').append('\n');
            message.append(StringUtils.repeat((String)"=", (int)79)).append('\n');
            message.append("Environment Variables").append('\n');
            message.append(StringUtils.repeat((String)"=", (int)79)).append('\n');
            try {
                Properties envVars = CommandLineUtils.getSystemEnvVars();
                Iterator<Object> it2 = envVars.keySet().iterator();
                while (it2.hasNext()) {
                    String key = it2.next().toString();
                    message.append("\n");
                    message.append(key).append("=").append(envVars.get(key));
                }
            }
            catch (IOException e) {
                if (!this.getLog().isWarnEnabled()) break block10;
                this.getLog().warn((CharSequence)("IOException: " + e.getMessage()));
            }
        }
        message.append("\n");
        if (this.output != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Created by: " + ((Object)((Object)this)).getClass().getName()).append("\n");
            sb.append("Created on: " + new Date()).append("\n").append("\n");
            sb.append(message.toString());
            try {
                SystemMojo.writeFile(this.output, sb);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write system report to output: " + this.output, (Exception)e);
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("System report written to: " + this.output));
            }
        } else if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)message);
        }
    }
}

