/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.idea;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-idea-plugin:2.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven IDEA Plugin 2.2", 0);
        this.append(sb, "Maven Plugins", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 6 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "clean".equals(this.goal)) {
            this.append(sb, "idea:clean", 0);
            this.append(sb, "Removes all existing IDEA files for the project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "idea:help", 0);
            this.append(sb, "Display help information on maven-idea-plugin. Call\n\u00a0\u00a0mvn\u00a0idea:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "idea".equals(this.goal)) {
            this.append(sb, "idea:idea", 0);
            this.append(sb, "Goal for generating IDEA files from a POM. This plug-in provides the ability to generate project files (.ipr, .iml and .iws files) for IDEA.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "dependenciesAsLibraries (Default: false)", 2);
                this.append(sb, "Causes the module libraries to use a short name for all dependencies. This is very convenient but has been reported to cause problems with IDEA.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorFile", 2);
                this.append(sb, "Specify the location of the deployment descriptor file, if one is provided.", 3);
                this.append(sb, "", 0);
                this.append(sb, "downloadJavadocs (Default: false)", 2);
                this.append(sb, "Enables/disables the downloading of javadoc attachments.", 3);
                this.append(sb, "", 0);
                this.append(sb, "downloadSources (Default: false)", 2);
                this.append(sb, "Enables/disables the downloading of source attachments.", 3);
                this.append(sb, "", 0);
                this.append(sb, "exclude", 2);
                this.append(sb, "A comma-separated list of directories that should be excluded. These directories are in addition to those already excluded, such as target/classes. A common use of this is to exclude the entire target directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ideaPlugin (Default: false)", 2);
                this.append(sb, "Tell IntelliJ IDEA that this module is an IntelliJ IDEA Plugin.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ideaVersion (Default: 5.x)", 2);
                this.append(sb, "Specify the version of IDEA to target. This is needed to identify the default formatting of project-jdk-name used by IDEA. Currently supports 4.x and 5.x.\n>This will only be used when parameter jdkName is not set.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "javadocClassifier (Default: javadoc)", 2);
                this.append(sb, "Sets the classifier string attached to an artifact javadoc archive name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdkLevel", 2);
                this.append(sb, "Specify the version of the JDK to use for the project for the purpose of enabled assertions and Java 5.0 language features. The default value is the specification version of the executing JVM.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdkName", 2);
                this.append(sb, "Specify the name of the registered IDEA JDK to use for the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "libraries", 2);
                this.append(sb, "An optional set of Library objects that allow you to specify a comma separated list of source dirs, class dirs, or to indicate that the library should be excluded from the module. For example:\n>\n\n<libraries>\n<library>\n<name>webwork</name>\n<sources>file://$webwork$/src/java</sources>\n<!--\n<classes>...</classes>\n<exclude>true</exclude>\n-->\n</library>\n</libraries>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkModules (Default: true)", 2);
                this.append(sb, "Whether to link the reactor projects as dependency modules or as libraries.", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Whether to update the existing project files or overwrite them.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceClassifier (Default: sources)", 2);
                this.append(sb, "Sets the classifier string attached to an artifact source archive name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useFullNames (Default: false)", 2);
                this.append(sb, "Whether to use full artifact names when referencing libraries.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wildcardResourcePatterns (Default: !?*.java)", 2);
                this.append(sb, "Specify the resource pattern in wildcard format, for example '?*.xml;?*.properties'. Currently supports 4.x and 5.x. Because IDEA doesn't distinguish between source and resources directories, this is needed. The default value corresponds to any file without a java extension. Please note that the default value includes package.html files as it's not possible to exclude those.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "module".equals(this.goal)) {
            this.append(sb, "idea:module", 0);
            this.append(sb, "Creates the module files (*.iml) for IntelliJ IDEA.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "dependenciesAsLibraries (Default: false)", 2);
                this.append(sb, "Causes the module libraries to use a short name for all dependencies. This is very convenient but has been reported to cause problems with IDEA.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorFile", 2);
                this.append(sb, "Specify the location of the deployment descriptor file, if one is provided.", 3);
                this.append(sb, "", 0);
                this.append(sb, "downloadJavadocs (Default: false)", 2);
                this.append(sb, "Enables/disables the downloading of javadoc attachments.", 3);
                this.append(sb, "", 0);
                this.append(sb, "downloadSources (Default: false)", 2);
                this.append(sb, "Enables/disables the downloading of source attachments.", 3);
                this.append(sb, "", 0);
                this.append(sb, "exclude", 2);
                this.append(sb, "A comma-separated list of directories that should be excluded. These directories are in addition to those already excluded, such as target.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ideaPlugin (Default: false)", 2);
                this.append(sb, "Tell IntelliJ IDEA that this module is an IntelliJ IDEA Plugin.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ideaVersion (Default: 5.x)", 2);
                this.append(sb, "Specify the version of IDEA to target. This is needed to identify the default formatting of project-jdk-name used by IDEA. Currently supports 4.x and 5.x.\n>This will only be used when parameter jdkName is not set.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "javadocClassifier (Default: javadoc)", 2);
                this.append(sb, "Sets the classifier string attached to an artifact javadoc archive name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "libraries", 2);
                this.append(sb, "An optional set of Library objects that allow you to specify a comma separated list of source dirs, class dirs, or to indicate that the library should be excluded from the module. For example:\n>\n\n<libraries>\n<library>\n<name>webwork</name>\n<sources>file://$webwork$/src/java</sources>\n<!--\n<classes>...</classes>\n<exclude>true</exclude>\n-->\n</library>\n</libraries>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkModules (Default: true)", 2);
                this.append(sb, "Whether to link the reactor projects as dependency modules or as libraries.", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Whether to update the existing project files or overwrite them.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceClassifier (Default: sources)", 2);
                this.append(sb, "Sets the classifier string attached to an artifact source archive name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useFullNames (Default: false)", 2);
                this.append(sb, "Whether to use full artifact names when referencing libraries.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "project".equals(this.goal)) {
            this.append(sb, "idea:project", 0);
            this.append(sb, "Creates the project file (*.ipr) for IntelliJ IDEA.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "ideaVersion (Default: 5.x)", 2);
                this.append(sb, "Specify the version of IDEA to target. This is needed to identify the default formatting of project-jdk-name used by IDEA. Currently supports 4.x and 5.x.\n>This will only be used when parameter jdkName is not set.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdkLevel", 2);
                this.append(sb, "Specify the version of the JDK to use for the project for the purpose of enabled assertions and Java 5.0 language features. The default value is the specification version of the executing JVM.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdkName", 2);
                this.append(sb, "Specify the name of the registered IDEA JDK to use for the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Whether to update the existing project files or overwrite them.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wildcardResourcePatterns (Default: !?*.java)", 2);
                this.append(sb, "Specify the resource pattern in wildcard format, for example '?*.xml;?*.properties'. Currently supports 4.x and 5.x. Because IDEA doesn't distinguish between source and resources directories, this is needed. The default value corresponds to any file without a java extension. Please note that the default value includes package.html files as it's not possible to exclude those.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "workspace".equals(this.goal)) {
            this.append(sb, "idea:workspace", 0);
            this.append(sb, "Creates the workspace file (*.iws) for IntelliJ IDEA.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Whether to update the existing project files or overwrite them.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

