/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.invoker.InvokerSession;
import org.apache.maven.plugin.invoker.ReportUtils;
import org.apache.maven.plugin.invoker.model.io.xpp3.BuildJobXpp3Reader;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class VerifyMojo
extends AbstractMojo {
    @Parameter(property="invoker.skip", defaultValue="false")
    private boolean skipInvocation;
    @Parameter(property="invoker.reportsDirectory", defaultValue="${project.build.directory}/invoker-reports")
    private File reportsDirectory;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean ignoreFailures;
    @Parameter(defaultValue="false")
    private boolean suppressSummaries;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipInvocation) {
            this.getLog().info((CharSequence)"Skipping invocation per configuration. If this is incorrect, ensure the skipInvocation parameter is not set to true.");
            return;
        }
        File[] reportFiles = ReportUtils.getReportFiles(this.reportsDirectory);
        if (reportFiles.length <= 0) {
            this.getLog().info((CharSequence)"No invoker report files found, nothing to check.");
            return;
        }
        InvokerSession invokerSession = new InvokerSession();
        for (File reportFile : reportFiles) {
            try {
                BuildJobXpp3Reader reader = new BuildJobXpp3Reader();
                invokerSession.addJob(reader.read((Reader)ReaderFactory.newXmlReader((File)reportFile)));
            }
            catch (XmlPullParserException e) {
                throw new MojoExecutionException("Failed to parse report file: " + reportFile, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read report file: " + reportFile, (Exception)e);
            }
        }
        if (!this.suppressSummaries) {
            invokerSession.logSummary(this.getLog(), this.ignoreFailures);
        }
        invokerSession.handleFailures(this.getLog(), this.ignoreFailures);
    }
}

