/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.invoker.MetadataUtils;
import org.apache.maven.plugin.invoker.PomUtils;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="install", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class InstallMojo
extends AbstractMojo {
    @Component
    private ArtifactInstaller installer;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactRepositoryFactory repositoryFactory;
    @Parameter(property="localRepository", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(property="invoker.localRepositoryPath")
    private File localRepositoryPath;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private Collection<MavenProject> reactorProjects;
    @Parameter(property="invoker.skip", defaultValue="false")
    private boolean skipInstallation;
    private Collection<String> installedArtifacts;
    private Collection<String> copiedArtifacts;
    @Parameter
    private String[] extraArtifacts;
    @Component
    private ArtifactResolver resolver;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    private List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(defaultValue="${project.pluginArtifactRepositories}", readonly=true)
    private List<ArtifactRepository> remotePluginRepositories;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;

    public void execute() throws MojoExecutionException {
        if (this.skipInstallation) {
            this.getLog().info((CharSequence)"Skipping artifact installation per configuration.");
            return;
        }
        ArtifactRepository testRepository = this.createTestRepository();
        this.installedArtifacts = new HashSet<String>();
        this.copiedArtifacts = new HashSet<String>();
        this.installProjectDependencies(this.project, this.reactorProjects, testRepository);
        this.installProjectParents(this.project, testRepository);
        this.installProjectArtifacts(this.project, testRepository);
        this.installExtraArtifacts(testRepository, this.extraArtifacts);
    }

    private ArtifactRepository createTestRepository() throws MojoExecutionException {
        ArtifactRepository testRepository = this.localRepository;
        if (this.localRepositoryPath != null) {
            try {
                if (!this.localRepositoryPath.exists() && !this.localRepositoryPath.mkdirs()) {
                    throw new IOException("Failed to create directory: " + this.localRepositoryPath);
                }
                testRepository = this.repositoryFactory.createArtifactRepository(this.localRepository.getId(), this.localRepositoryPath.toURL().toExternalForm(), this.localRepository.getLayout(), this.localRepository.getSnapshots(), this.localRepository.getReleases());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to create local repository: " + this.localRepositoryPath, e);
            }
        }
        return testRepository;
    }

    private void installArtifact(File file, Artifact artifact, ArtifactRepository testRepository) throws MojoExecutionException {
        try {
            if (file == null) {
                throw new IllegalStateException("Artifact has no associated file: " + artifact.getId());
            }
            if (!file.isFile()) {
                throw new IllegalStateException("Artifact is not fully assembled: " + file);
            }
            if (this.installedArtifacts.add(artifact.getId())) {
                this.installer.install(file, artifact, testRepository);
            } else {
                this.getLog().debug((CharSequence)("Not re-installing " + artifact + ", " + file));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install artifact: " + artifact, e);
        }
    }

    private void copyArtifact(File file, Artifact artifact, ArtifactRepository testRepository) throws MojoExecutionException {
        try {
            if (file == null) {
                throw new IllegalStateException("Artifact has no associated file: " + artifact.getId());
            }
            if (!file.isFile()) {
                throw new IllegalStateException("Artifact is not fully assembled: " + file);
            }
            if (this.copiedArtifacts.add(artifact.getId())) {
                File destination = new File(testRepository.getBasedir(), testRepository.pathOf(artifact));
                this.getLog().debug((CharSequence)("Installing " + file + " to " + destination));
                this.copyFileIfDifferent(file, destination);
                MetadataUtils.createMetadata(destination, artifact);
            } else {
                this.getLog().debug((CharSequence)("Not re-installing " + artifact + ", " + file));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to stage artifact: " + artifact, e);
        }
    }

    private void copyFileIfDifferent(File src, File dst) throws IOException {
        if (src.lastModified() != dst.lastModified() || src.length() != dst.length()) {
            FileUtils.copyFile((File)src, (File)dst);
            dst.setLastModified(src.lastModified());
        }
    }

    private void installProjectArtifacts(MavenProject mvnProject, ArtifactRepository testRepository) throws MojoExecutionException {
        try {
            this.installProjectPom(mvnProject, testRepository);
            Artifact mainArtifact = mvnProject.getArtifact();
            if (mainArtifact.getFile() != null) {
                this.installArtifact(mainArtifact.getFile(), mainArtifact, testRepository);
            }
            List attachedArtifacts = mvnProject.getAttachedArtifacts();
            for (Artifact attachedArtifact : attachedArtifacts) {
                this.installArtifact(attachedArtifact.getFile(), attachedArtifact, testRepository);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install project artifacts: " + mvnProject, e);
        }
    }

    private void installProjectParents(MavenProject mvnProject, ArtifactRepository testRepository) throws MojoExecutionException {
        try {
            for (MavenProject parent = mvnProject.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.getFile() == null) {
                    this.copyParentPoms(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), testRepository);
                    break;
                }
                this.installProjectPom(parent, testRepository);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install project parents: " + mvnProject, e);
        }
    }

    private void installProjectPom(MavenProject mvnProject, ArtifactRepository testRepository) throws MojoExecutionException {
        try {
            Artifact pomArtifact = null;
            if ("pom".equals(mvnProject.getPackaging())) {
                pomArtifact = mvnProject.getArtifact();
            }
            if (pomArtifact == null) {
                pomArtifact = this.artifactFactory.createProjectArtifact(mvnProject.getGroupId(), mvnProject.getArtifactId(), mvnProject.getVersion());
            }
            this.installArtifact(mvnProject.getFile(), pomArtifact, testRepository);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install POM: " + mvnProject, e);
        }
    }

    private void installProjectDependencies(MavenProject mvnProject, Collection<MavenProject> reactorProjects, ArtifactRepository testRepository) throws MojoExecutionException {
        boolean foundCurrent = false;
        LinkedHashSet<String> dependencyProjects = new LinkedHashSet<String>();
        HashMap<String, MavenProject> projects = new HashMap<String, MavenProject>();
        for (MavenProject reactorProject : reactorProjects) {
            String projectId = reactorProject.getGroupId() + ':' + reactorProject.getArtifactId() + ':' + reactorProject.getVersion();
            projects.put(projectId, reactorProject);
            if (foundCurrent |= mvnProject.equals((Object)reactorProject)) continue;
            dependencyProjects.add(projectId);
        }
        Set artifacts = mvnProject.getArtifacts();
        LinkedHashSet<Artifact> dependencyArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            artifact.isSnapshot();
            String projectId = artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getBaseVersion();
            if (projects.containsKey(projectId)) continue;
            dependencyArtifacts.add(artifact);
        }
        try {
            for (Artifact artifact : dependencyArtifacts) {
                this.copyArtifact(artifact, testRepository);
            }
            for (String projectId : dependencyProjects) {
                MavenProject dependencyProject = (MavenProject)projects.get(projectId);
                this.installProjectArtifacts(dependencyProject, testRepository);
                this.installProjectParents(dependencyProject, testRepository);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install project dependencies: " + mvnProject, e);
        }
    }

    private void copyArtifact(Artifact artifact, ArtifactRepository testRepository) throws MojoExecutionException {
        this.copyPoms(artifact, testRepository);
        Artifact depArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getType(), artifact.getClassifier());
        File artifactFile = artifact.getFile();
        this.copyArtifact(artifactFile, depArtifact, testRepository);
    }

    private void copyPoms(Artifact artifact, ArtifactRepository testRepository) throws MojoExecutionException {
        Artifact pomArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion());
        File pomFile = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(pomArtifact));
        if (pomFile.isFile()) {
            this.copyArtifact(pomFile, pomArtifact, testRepository);
            this.copyParentPoms(pomFile, testRepository);
        }
    }

    private void copyParentPoms(File pomFile, ArtifactRepository testRepository) throws MojoExecutionException {
        Model model = PomUtils.loadPom(pomFile);
        Parent parent = model.getParent();
        if (parent != null) {
            this.copyParentPoms(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), testRepository);
        }
    }

    private void copyParentPoms(String groupId, String artifactId, String version, ArtifactRepository testRepository) throws MojoExecutionException {
        Artifact pomArtifact = this.artifactFactory.createProjectArtifact(groupId, artifactId, version);
        if (this.installedArtifacts.contains(pomArtifact.getId()) || this.copiedArtifacts.contains(pomArtifact.getId())) {
            this.getLog().debug((CharSequence)("Not re-installing " + pomArtifact));
            return;
        }
        File pomFile = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(pomArtifact));
        if (pomFile.isFile()) {
            this.copyArtifact(pomFile, pomArtifact, testRepository);
            this.copyParentPoms(pomFile, testRepository);
        }
    }

    private void installExtraArtifacts(ArtifactRepository testRepository, String[] extraArtifacts) throws MojoExecutionException {
        if (extraArtifacts == null) {
            return;
        }
        Artifact originatingArtifact = this.project.getArtifact();
        for (String extraArtifact : extraArtifacts) {
            String[] gav = extraArtifact.split(":");
            if (gav.length < 3 || gav.length > 5) {
                throw new MojoExecutionException("Invalid artifact " + extraArtifact);
            }
            String groupId = gav[0];
            String artifactId = gav[1];
            String version = gav[2];
            String type = "jar";
            if (gav.length > 3) {
                type = gav[3];
            }
            String classifier = null;
            if (gav.length == 5) {
                classifier = gav[4];
            }
            List<ArtifactRepository> remoteRepositories = "maven-plugin".equals(type) ? this.remotePluginRepositories : this.remoteArtifactRepositories;
            Artifact artifact = null;
            try {
                artifact = this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
                ArtifactResolutionResult arr = this.resolver.resolveTransitively(Collections.singleton(artifact), originatingArtifact, remoteRepositories, this.localRepository, this.artifactMetadataSource);
                if (!(groupId.equals(artifact.getGroupId()) && artifactId.equals(artifact.getArtifactId()) && version.equals(artifact.getVersion()))) {
                    artifact = this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
                    this.copyPoms(artifact, testRepository);
                }
                for (Artifact arrArtifact : arr.getArtifacts()) {
                    this.copyArtifact(arrArtifact, testRepository);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to resolve dependencies for: " + artifact, e);
            }
        }
    }
}

