/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jar;

import java.io.File;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public abstract class AbstractJarMojo
extends AbstractMojo {
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/package.html"};
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(alias="jarName", property="jar.finalName", defaultValue="${project.build.finalName}")
    private String finalName;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", required=true, readonly=true)
    private File defaultManifestFile;
    @Parameter(property="jar.useDefaultManifestFile", defaultValue="false")
    private boolean useDefaultManifestFile;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="jar.forceCreation", defaultValue="false")
    private boolean forceCreation;
    @Parameter(property="jar.skipIfEmpty", defaultValue="false")
    private boolean skipIfEmpty;

    protected abstract File getClassesDirectory();

    protected final MavenProject getProject() {
        return this.project;
    }

    protected abstract String getClassifier();

    protected abstract String getType();

    protected static File getJarFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".jar");
    }

    protected File getDefaultManifestFile() {
        return this.defaultManifestFile;
    }

    public File createArchive() throws MojoExecutionException {
        File jarFile = AbstractJarMojo.getJarFile(this.outputDirectory, this.finalName, this.getClassifier());
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        this.archive.setForced(this.forceCreation);
        try {
            File contentDirectory = this.getClassesDirectory();
            if (!contentDirectory.exists()) {
                this.getLog().warn((CharSequence)"JAR will be empty - no content was marked for inclusion!");
            } else {
                archiver.getArchiver().addDirectory(contentDirectory, this.getIncludes(), this.getExcludes());
            }
            File existingManifest = this.getDefaultManifestFile();
            if (this.useDefaultManifestFile && existingManifest.exists() && this.archive.getManifestFile() == null) {
                this.getLog().info((CharSequence)("Adding existing MANIFEST to archive. Found under: " + existingManifest.getPath()));
                this.archive.setManifestFile(existingManifest);
            }
            archiver.createArchive(this.session, this.project, this.archive);
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling JAR", e);
        }
    }

    public void execute() throws MojoExecutionException {
        if (this.skipIfEmpty && (!this.getClassesDirectory().exists() || this.getClassesDirectory().list().length < 1)) {
            this.getLog().info((CharSequence)("Skipping packaging of the " + this.getType()));
        } else {
            File jarFile = this.createArchive();
            String classifier = this.getClassifier();
            if (classifier != null) {
                this.projectHelper.attachArtifact(this.getProject(), this.getType(), classifier, jarFile);
            } else {
                this.getProject().getArtifact().setFile(jarFile);
            }
        }
    }

    private String[] getIncludes() {
        if (this.includes != null && this.includes.length > 0) {
            return this.includes;
        }
        return DEFAULT_INCLUDES;
    }

    private String[] getExcludes() {
        if (this.excludes != null && this.excludes.length > 0) {
            return this.excludes;
        }
        return DEFAULT_EXCLUDES;
    }
}

