/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jarsigner;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.jarsigner.JarSigner;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerUtil;
import org.apache.maven.shared.utils.ReaderFactory;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.javatool.JavaToolException;
import org.apache.maven.shared.utils.cli.javatool.JavaToolRequest;
import org.apache.maven.shared.utils.cli.javatool.JavaToolResult;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class AbstractJarsignerMojo
extends AbstractMojo {
    @Parameter(property="jarsigner.verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="jarsigner.keystore")
    private String keystore;
    @Parameter(property="jarsigner.storetype")
    private String storetype;
    @Parameter(property="jarsigner.storepass")
    private String storepass;
    @Parameter(property="jarsigner.providerName")
    private String providerName;
    @Parameter(property="jarsigner.providerClass")
    private String providerClass;
    @Parameter(property="jarsigner.providerArg")
    private String providerArg;
    @Parameter(property="jarsigner.alias")
    private String alias;
    @Parameter(property="jarsigner.maxMemory")
    private String maxMemory;
    @Parameter(property="jarsigner.archive")
    private File archive;
    @Parameter(property="jarsigner.archiveDirectory")
    private File archiveDirectory;
    @Parameter
    private String[] includes = new String[]{"**/*.?ar"};
    @Parameter
    private String[] excludes = new String[0];
    @Parameter(property="jarsigner.arguments")
    private String[] arguments;
    @Parameter(property="jarsigner.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="jarsigner.processMainArtifact", defaultValue="true")
    private boolean processMainArtifact;
    @Parameter(property="jarsigner.processAttachedArtifacts", defaultValue="true")
    private boolean processAttachedArtifacts;
    @Parameter(property="jarsigner.protectedAuthenticationPath", defaultValue="false")
    private boolean protectedAuthenticationPath;
    @Parameter
    private String[] includeClassifiers;
    @Parameter
    private String[] excludeClassifiers;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(defaultValue="${project.basedir}")
    private File workingDirectory;
    @Component
    private JarSigner jarSigner;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ToolchainManager toolchainManager;
    @Component(hint="mng-4384")
    private SecDispatcher securityDispatcher;

    public final void execute() throws MojoExecutionException {
        if (!this.skip) {
            Toolchain toolchain = this.getToolchain();
            if (toolchain != null) {
                this.getLog().info((CharSequence)("Toolchain in maven-jarsigner-plugin: " + toolchain));
                this.jarSigner.setToolchain((Object)toolchain);
            }
            int processed = 0;
            if (this.archive != null) {
                this.processArchive(this.archive);
                ++processed;
            } else {
                if (this.processMainArtifact) {
                    processed += this.processArtifact(this.project.getArtifact()) ? 1 : 0;
                }
                if (this.processAttachedArtifacts) {
                    HashSet<String> includes = new HashSet<String>();
                    if (this.includeClassifiers != null) {
                        includes.addAll(Arrays.asList(this.includeClassifiers));
                    }
                    HashSet<String> excludes = new HashSet<String>();
                    if (this.excludeClassifiers != null) {
                        excludes.addAll(Arrays.asList(this.excludeClassifiers));
                    }
                    for (Artifact artifact : this.project.getAttachedArtifacts()) {
                        if (!includes.isEmpty() && !includes.contains(artifact.getClassifier()) || excludes.contains(artifact.getClassifier())) continue;
                        processed += this.processArtifact(artifact) ? 1 : 0;
                    }
                } else if (this.verbose) {
                    this.getLog().info((CharSequence)this.getMessage("ignoringAttachments"));
                } else {
                    this.getLog().debug((CharSequence)this.getMessage("ignoringAttachments"));
                }
                if (this.archiveDirectory != null) {
                    List jarFiles;
                    String includeList = this.includes != null ? StringUtils.join((Object[])this.includes, (String)",") : null;
                    String excludeList = this.excludes != null ? StringUtils.join((Object[])this.excludes, (String)",") : null;
                    try {
                        jarFiles = FileUtils.getFiles((File)this.archiveDirectory, (String)includeList, (String)excludeList);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Failed to scan archive directory for JARs: " + e.getMessage(), (Exception)e);
                    }
                    for (File jarFile : jarFiles) {
                        this.processArchive(jarFile);
                        ++processed;
                    }
                }
            }
            this.getLog().info((CharSequence)this.getMessage("processed", processed));
        } else {
            this.getLog().info((CharSequence)this.getMessage("disabled", null));
        }
    }

    protected abstract JarSignerRequest createRequest(File var1) throws MojoExecutionException;

    protected String getCommandlineInfo(Commandline commandLine) {
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        String commandLineInfo = commandLine.toString();
        commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.storepass, (String)"'*****'");
        return commandLineInfo;
    }

    public String getStoretype() {
        return this.storetype;
    }

    public String getStorepass() {
        return this.storepass;
    }

    private boolean isZipFile(Artifact artifact) {
        return artifact != null && artifact.getFile() != null && JarSignerUtil.isZipFile((File)artifact.getFile());
    }

    private boolean processArtifact(Artifact artifact) throws MojoExecutionException {
        if (artifact == null) {
            throw new NullPointerException("artifact");
        }
        boolean processed = false;
        if (this.isZipFile(artifact)) {
            this.processArchive(artifact.getFile());
            processed = true;
        } else if (this.verbose) {
            this.getLog().info((CharSequence)this.getMessage("unsupported", artifact));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)this.getMessage("unsupported", artifact));
        }
        return processed;
    }

    protected void preProcessArchive(File archive) throws MojoExecutionException {
    }

    private void processArchive(File archive) throws MojoExecutionException {
        if (archive == null) {
            throw new NullPointerException("archive");
        }
        this.preProcessArchive(archive);
        if (this.verbose) {
            this.getLog().info((CharSequence)this.getMessage("processing", archive));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)this.getMessage("processing", archive));
        }
        JarSignerRequest request = this.createRequest(archive);
        request.setVerbose(this.verbose);
        request.setAlias(this.alias);
        request.setArchive(archive);
        request.setKeystore(this.keystore);
        request.setStoretype(this.storetype);
        request.setProviderArg(this.providerArg);
        request.setProviderClass(this.providerClass);
        request.setProviderName(this.providerName);
        request.setWorkingDirectory(this.workingDirectory);
        request.setMaxMemory(this.maxMemory);
        request.setProtectedAuthenticationPath(this.protectedAuthenticationPath);
        ArrayList<String> additionalArguments = new ArrayList<String>();
        boolean fileEncodingSeen = false;
        if (this.arguments != null) {
            for (String argument : this.arguments) {
                if (argument.trim().startsWith("-J-Dfile.encoding=")) {
                    fileEncodingSeen = true;
                }
                additionalArguments.add(argument);
            }
        }
        if (!fileEncodingSeen) {
            additionalArguments.add("-J-Dfile.encoding=" + ReaderFactory.FILE_ENCODING);
        }
        if (this.settings != null && this.settings.getActiveProxy() != null && StringUtils.isNotEmpty((String)this.settings.getActiveProxy().getHost())) {
            additionalArguments.add("-J-Dhttp.proxyHost=" + this.settings.getActiveProxy().getHost());
            additionalArguments.add("-J-Dhttps.proxyHost=" + this.settings.getActiveProxy().getHost());
            additionalArguments.add("-J-Dftp.proxyHost=" + this.settings.getActiveProxy().getHost());
            if (this.settings.getActiveProxy().getPort() > 0) {
                additionalArguments.add("-J-Dhttp.proxyPort=" + this.settings.getActiveProxy().getPort());
                additionalArguments.add("-J-Dhttps.proxyPort=" + this.settings.getActiveProxy().getPort());
                additionalArguments.add("-J-Dftp.proxyPort=" + this.settings.getActiveProxy().getPort());
            }
            if (StringUtils.isNotEmpty((String)this.settings.getActiveProxy().getNonProxyHosts())) {
                additionalArguments.add("-J-Dhttp.nonProxyHosts=\"" + this.settings.getActiveProxy().getNonProxyHosts() + "\"");
                additionalArguments.add("-J-Dftp.nonProxyHosts=\"" + this.settings.getActiveProxy().getNonProxyHosts() + "\"");
            }
        }
        request.setArguments(!additionalArguments.isEmpty() ? additionalArguments.toArray(new String[additionalArguments.size()]) : null);
        request.setStorepass(this.decrypt(this.storepass));
        try {
            JavaToolResult result = this.jarSigner.execute((JavaToolRequest)request);
            Commandline commandLine = result.getCommandline();
            int resultCode = result.getExitCode();
            if (resultCode != 0) {
                throw new MojoExecutionException(this.getMessage("failure", this.getCommandlineInfo(commandLine), resultCode));
            }
        }
        catch (JavaToolException e) {
            throw new MojoExecutionException(this.getMessage("commandLineException", e.getMessage()), (Exception)((Object)e));
        }
    }

    protected String decrypt(String encoded) throws MojoExecutionException {
        try {
            return this.securityDispatcher.decrypt(encoded);
        }
        catch (SecDispatcherException e) {
            this.getLog().error((CharSequence)("error using security dispatcher: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("error using security dispatcher: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private String getMessage(String key, Object[] args) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new MessageFormat(ResourceBundle.getBundle("jarsigner").getString(key)).format(args);
    }

    private String getMessage(String key) {
        return this.getMessage(key, null);
    }

    String getMessage(String key, Object arg) {
        return this.getMessage(key, new Object[]{arg});
    }

    private String getMessage(String key, Object arg1, Object arg2) {
        return this.getMessage(key, new Object[]{arg1, arg2});
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.toolchainManager != null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }
}

