/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.javadoc.JavadocJar;
import org.apache.maven.plugin.javadoc.JavadocUtil;
import org.apache.maven.plugin.javadoc.resolver.SourceResolverConfig;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class TestJavadocJar
extends JavadocJar {
    private File outputDirectory;
    private String testDoctitle;
    private File testOverview;
    private String testWindowtitle;
    private File testJavadocDirectory;

    protected String getClassifier() {
        return "test-javadoc";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsoluteFile().toString();
    }

    protected File getJavadocDirectory() {
        return this.testJavadocDirectory;
    }

    protected String getDoctitle() {
        return this.testDoctitle;
    }

    protected File getOverview() {
        return this.testOverview;
    }

    protected String getWindowtitle() {
        return this.testWindowtitle;
    }

    protected List getProjectBuildOutputDirs(MavenProject p) {
        ArrayList<String> dirs = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)p.getBuild().getOutputDirectory())) {
            dirs.add(p.getBuild().getOutputDirectory());
        }
        if (StringUtils.isNotEmpty((String)p.getBuild().getTestOutputDirectory())) {
            dirs.add(p.getBuild().getTestOutputDirectory());
        }
        return dirs;
    }

    protected List getProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getPackaging().toLowerCase())) {
            return Collections.EMPTY_LIST;
        }
        return p.getTestCompileSourceRoots();
    }

    protected List getExecutionProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getExecutionProject().getPackaging().toLowerCase())) {
            return Collections.EMPTY_LIST;
        }
        return p.getExecutionProject().getTestCompileSourceRoots();
    }

    protected List getProjectArtifacts(MavenProject p) {
        return p.getTestArtifacts();
    }

    protected List getCompileArtifacts(ArtifactResolutionResult result) {
        return JavadocUtil.getCompileArtifacts(result.getArtifacts(), true);
    }

    protected SourceResolverConfig configureDependencySourceResolution(SourceResolverConfig config) {
        return super.configureDependencySourceResolution(config).withoutCompileSources().withTestSources();
    }
}

