/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.javadoc.AbstractJavadocMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

@Mojo(name="resource-bundle", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class ResourcesBundleMojo
extends AbstractJavadocMojo {
    public static final String BUNDLE_OPTIONS_PATH = "META-INF/maven/javadoc-options.xml";
    public static final String RESOURCES_DIR_PATH = "resources";
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private ArchiverManager archiverManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Archiver archiver;
        try {
            this.buildJavadocOptions();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate javadoc-options file: " + e.getMessage(), (Exception)e);
        }
        try {
            archiver = this.archiverManager.getArchiver("jar");
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Failed to retrieve jar archiver component from manager.", (Exception)((Object)e));
        }
        File optionsFile = this.getJavadocOptionsFile();
        File bundleFile = new File(this.getProject().getBuild().getDirectory(), this.finalName + "-" + this.getAttachmentClassifier() + ".jar");
        try {
            archiver.addFile(optionsFile, BUNDLE_OPTIONS_PATH);
            File javadocDir = this.getJavadocDirectory();
            if (javadocDir.exists() && javadocDir.isDirectory()) {
                archiver.addDirectory(javadocDir, RESOURCES_DIR_PATH);
            }
            archiver.setDestFile(bundleFile);
            archiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Failed to assemble javadoc-resources bundle archive. Reason: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to assemble javadoc-resources bundle archive. Reason: " + e.getMessage(), (Exception)e);
        }
        this.projectHelper.attachArtifact(this.getProject(), bundleFile, this.getAttachmentClassifier());
    }
}

