/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ClassUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.javadoc.AdditionalDependency;
import org.apache.maven.plugins.javadoc.JavadocReport;
import org.apache.maven.plugins.javadoc.JavadocUtil;
import org.apache.maven.plugins.javadoc.SystemUtils;
import org.apache.maven.plugins.javadoc.TestJavadocReport;
import org.apache.maven.plugins.javadoc.options.BootclasspathArtifact;
import org.apache.maven.plugins.javadoc.options.DocletArtifact;
import org.apache.maven.plugins.javadoc.options.Group;
import org.apache.maven.plugins.javadoc.options.JavadocOptions;
import org.apache.maven.plugins.javadoc.options.JavadocPathArtifact;
import org.apache.maven.plugins.javadoc.options.OfflineLink;
import org.apache.maven.plugins.javadoc.options.ResourcesArtifact;
import org.apache.maven.plugins.javadoc.options.Tag;
import org.apache.maven.plugins.javadoc.options.Taglet;
import org.apache.maven.plugins.javadoc.options.TagletArtifact;
import org.apache.maven.plugins.javadoc.options.io.xpp3.JavadocOptionsXpp3Writer;
import org.apache.maven.plugins.javadoc.resolver.JavadocBundle;
import org.apache.maven.plugins.javadoc.resolver.ResourceResolver;
import org.apache.maven.plugins.javadoc.resolver.SourceResolverConfig;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.artifact.filter.resolve.AndFilter;
import org.apache.maven.shared.artifact.filter.resolve.PatternExclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.PatternInclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.wagon.PathUtils;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.codehaus.plexus.languages.java.jpms.ModuleNameSource;
import org.codehaus.plexus.languages.java.jpms.ResolvePathRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathResult;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.version.JavaVersion;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class AbstractJavadocMojo
extends AbstractMojo {
    public static final String JAVADOC_RESOURCES_ATTACHMENT_CLASSIFIER = "javadoc-resources";
    public static final String TEST_JAVADOC_RESOURCES_ATTACHMENT_CLASSIFIER = "test-javadoc-resources";
    protected static final String DEBUG_JAVADOC_SCRIPT_NAME = "javadoc." + (SystemUtils.IS_OS_WINDOWS ? "bat" : "sh");
    protected static final String OPTIONS_FILE_NAME = "options";
    protected static final String PACKAGES_FILE_NAME = "packages";
    protected static final String ARGFILE_FILE_NAME = "argfile";
    protected static final String FILES_FILE_NAME = "files";
    private static final String RESOURCE_DIR = ClassUtils.getPackageName(JavadocReport.class).replace('.', '/');
    private static final String DEFAULT_CSS_NAME = "stylesheet.css";
    private static final String RESOURCE_CSS_DIR = RESOURCE_DIR + "/css";
    private static final String PACKAGE_LIST = "package-list";
    private static final String ELEMENT_LIST = "element-list";
    private static final JavaVersion SINCE_JAVADOC_1_4 = JavaVersion.parse((String)"1.4");
    private static final JavaVersion SINCE_JAVADOC_1_4_2 = JavaVersion.parse((String)"1.4.2");
    private static final JavaVersion SINCE_JAVADOC_1_5 = JavaVersion.parse((String)"1.5");
    private static final JavaVersion SINCE_JAVADOC_1_6 = JavaVersion.parse((String)"1.6");
    private static final JavaVersion SINCE_JAVADOC_1_8 = JavaVersion.parse((String)"1.8");
    private static final JavaVersion JAVA_VERSION = JavaVersion.JAVA_SPECIFICATION_VERSION;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private ResourceResolver resourceResolver;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private DependencyResolver dependencyResolver;
    @Component
    private ProjectBuilder mavenProjectBuilder;
    @Component
    private ToolchainManager toolchainManager;
    final LocationManager locationManager = new LocationManager();
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojo;
    @Parameter(defaultValue="${settings.offline}", required=true, readonly=true)
    private boolean isOffline;
    @Parameter(defaultValue="${basedir}/src/main/javadoc")
    private File javadocDirectory;
    @Parameter
    private String[] additionalOptions;
    @Parameter(property="additionalJOption")
    private String additionalJOption;
    @Parameter
    private String[] additionalJOptions;
    @Parameter(property="resourcesArtifacts")
    private ResourcesArtifact[] resourcesArtifacts;
    @Parameter(property="localRepository")
    private ArtifactRepository localRepository;
    @Parameter(property="reactorProjects", readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="javadocExecutable")
    private String javadocExecutable;
    @Parameter(property="javadocVersion")
    private String javadocVersion;
    private JavaVersion javadocRuntimeVersion;
    @Parameter(property="maven.javadoc.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="maven.javadoc.failOnError", defaultValue="true")
    protected boolean failOnError;
    @Parameter(property="maven.javadoc.failOnWarnings", defaultValue="false")
    protected boolean failOnWarnings;
    @Parameter(property="useStandardDocletOptions", defaultValue="true")
    protected boolean useStandardDocletOptions;
    @Parameter(property="detectLinks", defaultValue="false")
    private boolean detectLinks;
    @Parameter(property="detectOfflineLinks", defaultValue="true")
    private boolean detectOfflineLinks;
    @Parameter(property="detectJavaApiLink", defaultValue="true")
    private boolean detectJavaApiLink;
    @Parameter(property="javaApiLinks")
    private Properties javaApiLinks;
    @Parameter(property="validateLinks", defaultValue="false")
    private boolean validateLinks;
    @Parameter(property="bootclasspath")
    private String bootclasspath;
    @Parameter(property="bootclasspathArtifacts")
    private BootclasspathArtifact[] bootclasspathArtifacts;
    @Parameter(property="breakiterator", defaultValue="false")
    private boolean breakiterator;
    @Parameter(property="doclet")
    private String doclet;
    @Parameter(property="docletArtifact")
    private DocletArtifact docletArtifact;
    @Parameter(property="docletArtifacts")
    private DocletArtifact[] docletArtifacts;
    @Parameter(property="docletPath")
    private String docletPath;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="excludePackageNames")
    private String excludePackageNames;
    @Parameter(property="extdirs")
    private String extdirs;
    @Parameter(property="locale")
    private String locale;
    @Parameter(property="maxmemory")
    private String maxmemory;
    @Parameter(property="minmemory")
    private String minmemory;
    @Parameter(property="old", defaultValue="false")
    private boolean old;
    @Parameter(property="overview", defaultValue="${basedir}/src/main/javadoc/overview.html")
    private File overview;
    @Parameter(property="quiet", defaultValue="false")
    private boolean quiet;
    @Parameter(property="show", defaultValue="protected")
    private String show;
    @Parameter(property="source")
    private String source;
    @Parameter(defaultValue="${maven.compiler.release}")
    private String release;
    @Parameter(property="sourcepath")
    private String sourcepath;
    @Parameter(property="subpackages")
    private String subpackages;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="author", defaultValue="true")
    private boolean author;
    @Parameter(property="bottom", defaultValue="Copyright &#169; {inceptionYear}&#x2013;{currentYear} {organizationName}. All rights reserved.")
    private String bottom;
    @Parameter(property="charset")
    private String charset;
    @Parameter(property="docencoding", defaultValue="${project.reporting.outputEncoding}")
    private String docencoding;
    @Parameter(property="docfilessubdirs", defaultValue="false")
    private boolean docfilessubdirs;
    @Parameter(property="doclint")
    private String doclint;
    @Parameter(property="doctitle", defaultValue="${project.name} ${project.version} API")
    private String doctitle;
    @Parameter(property="excludedocfilessubdir")
    private String excludedocfilessubdir;
    @Parameter(property="footer")
    private String footer;
    @Parameter
    private Group[] groups;
    @Parameter(property="header")
    private String header;
    @Parameter(property="helpfile")
    private String helpfile;
    @Parameter(property="keywords", defaultValue="false")
    private boolean keywords;
    @Parameter(property="links")
    protected ArrayList<String> links;
    @Parameter(property="linksource", defaultValue="false")
    private boolean linksource;
    @Parameter(property="nocomment", defaultValue="false")
    private boolean nocomment;
    @Parameter(property="nodeprecated", defaultValue="false")
    private boolean nodeprecated;
    @Parameter(property="nodeprecatedlist", defaultValue="false")
    private boolean nodeprecatedlist;
    @Parameter(property="nohelp", defaultValue="false")
    private boolean nohelp;
    @Parameter(property="noindex", defaultValue="false")
    private boolean noindex;
    @Parameter(property="nonavbar", defaultValue="false")
    private boolean nonavbar;
    @Parameter(property="nooverview", defaultValue="false")
    private boolean nooverview;
    @Parameter(property="noqualifier")
    private String noqualifier;
    @Parameter(property="nosince", defaultValue="false")
    private boolean nosince;
    @Parameter(property="notimestamp", defaultValue="false")
    private boolean notimestamp;
    @Parameter(property="notree", defaultValue="false")
    private boolean notree;
    @Parameter(property="offlineLinks")
    private OfflineLink[] offlineLinks;
    @Parameter(property="destDir", alias="destDir", defaultValue="${project.build.directory}/apidocs", required=true)
    protected File outputDirectory;
    @Parameter(property="packagesheader")
    private String packagesheader;
    @Parameter(property="serialwarn", defaultValue="false")
    private boolean serialwarn;
    @Parameter(property="sourcetab", alias="linksourcetab")
    private int sourcetab;
    @Parameter(property="splitindex", defaultValue="false")
    private boolean splitindex;
    @Parameter(property="stylesheet", defaultValue="java")
    private String stylesheet;
    @Parameter(property="stylesheetfile")
    private String stylesheetfile;
    @Parameter(property="taglet")
    private String taglet;
    @Parameter(property="tagletArtifact")
    private TagletArtifact tagletArtifact;
    @Parameter(property="tagletArtifacts")
    private TagletArtifact[] tagletArtifacts;
    @Parameter(property="tagletpath")
    private String tagletpath;
    @Parameter(property="taglets")
    private Taglet[] taglets;
    @Parameter(property="tags")
    private Tag[] tags;
    @Parameter(property="top")
    private String top;
    @Parameter(property="use", defaultValue="true")
    private boolean use;
    @Parameter(property="version", defaultValue="true")
    private boolean version;
    @Parameter(property="windowtitle", defaultValue="${project.name} ${project.version} API")
    private String windowtitle;
    @Parameter(defaultValue="false")
    private boolean includeDependencySources;
    @Parameter(defaultValue="${project.build.directory}/distro-javadoc-sources")
    private File sourceDependencyCacheDir;
    @Deprecated
    @Parameter(defaultValue="false")
    private boolean includeTransitiveDependencySources;
    @Parameter
    private List<String> dependencySourceIncludes;
    @Parameter
    private List<String> dependencySourceExcludes;
    @Parameter(defaultValue="${project.build.directory}/javadoc-bundle-options", readonly=true)
    private File javadocOptionsDir;
    private transient List<JavadocBundle> dependencyJavadocBundles;
    @Parameter
    private List<AdditionalDependency> additionalDependencies;
    @Parameter
    private List<String> sourceFileIncludes;
    @Parameter
    private List<String> sourceFileExcludes;
    @Parameter(defaultValue="true", property="maven.javadoc.applyJavadocSecurityFix")
    private boolean applyJavadocSecurityFix = true;
    @Parameter
    private Map<String, String> jdkToolchain;

    protected boolean isAggregator() {
        return false;
    }

    protected boolean isTest() {
        return false;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsoluteFile().toString();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected List<File> getProjectBuildOutputDirs(MavenProject p) {
        if (StringUtils.isEmpty((String)p.getBuild().getOutputDirectory())) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new File(p.getBuild().getOutputDirectory()));
    }

    protected File getArtifactFile(MavenProject project) {
        if (!this.isAggregator() && this.isTest()) {
            return null;
        }
        if (project.getArtifact() != null) {
            return project.getArtifact().getFile();
        }
        return null;
    }

    protected List<String> getProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getPackaging().toLowerCase())) {
            return Collections.emptyList();
        }
        return p.getCompileSourceRoots() == null ? Collections.emptyList() : new LinkedList(p.getCompileSourceRoots());
    }

    protected List<String> getExecutionProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getExecutionProject().getPackaging().toLowerCase())) {
            return Collections.emptyList();
        }
        return p.getExecutionProject().getCompileSourceRoots() == null ? Collections.emptyList() : new LinkedList(p.getExecutionProject().getCompileSourceRoots());
    }

    protected File getJavadocDirectory() {
        return this.javadocDirectory;
    }

    protected String getDoclint() {
        return this.doclint;
    }

    protected String getDoctitle() {
        return this.doctitle;
    }

    protected File getOverview() {
        return this.overview;
    }

    protected String getWindowtitle() {
        return this.windowtitle;
    }

    private String getCharset() {
        return StringUtils.isEmpty((String)this.charset) ? this.getDocencoding() : this.charset;
    }

    private String getDocencoding() {
        return StringUtils.isEmpty((String)this.docencoding) ? "UTF-8" : this.docencoding;
    }

    private String getEncoding() {
        return StringUtils.isEmpty((String)this.encoding) ? ReaderFactory.FILE_ENCODING : this.encoding;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.verifyRemovedParameter("aggregator");
        this.verifyRemovedParameter("proxyHost");
        this.verifyRemovedParameter("proxyPort");
        this.verifyReplacedParameter("additionalparam", "additionalOptions");
        this.doExecute();
    }

    abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected final void verifyRemovedParameter(String paramName) {
        Xpp3Dom configDom = this.mojo.getConfiguration();
        if (configDom != null && configDom.getChild(paramName) != null) {
            throw new IllegalArgumentException("parameter '" + paramName + "' has been removed from the plugin, please verify documentation.");
        }
    }

    private void verifyReplacedParameter(String oldParamName, String newParamNew) {
        Xpp3Dom configDom = this.mojo.getConfiguration();
        if (configDom != null && configDom.getChild(oldParamName) != null) {
            throw new IllegalArgumentException("parameter '" + oldParamName + "' has been replaced with " + newParamNew + ", please verify documentation.");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeReport(Locale unusedLocale) throws MavenReportException {
        boolean includesExcludesActive;
        void var10_15;
        String jExecutable;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping javadoc generation");
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.debug = true;
        }
        try {
            this.buildJavadocOptions();
        }
        catch (IOException e) {
            throw new MavenReportException("Failed to generate javadoc options file: " + e.getMessage(), (Exception)e);
        }
        Map<String, Collection<Path>> sourcePaths = this.getSourcePaths();
        Collection<Path> collectedSourcePaths = this.collect(sourcePaths.values());
        Map<Path, Collection<String>> files = this.getFiles(collectedSourcePaths);
        if (!this.canGenerateReport(files)) {
            return;
        }
        try {
            jExecutable = this.getJavadocExecutable();
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to find javadoc command: " + e.getMessage(), (Exception)e);
        }
        this.setFJavadocVersion(new File(jExecutable));
        List<String> packageNames = this.javadocRuntimeVersion.isAtLeast("9") ? this.getPackageNamesRespectingJavaModules(sourcePaths) : this.getPackageNames(files);
        File javadocOutputDirectory = new File(this.getOutputDirectory());
        if (javadocOutputDirectory.exists() && !javadocOutputDirectory.isDirectory()) {
            throw new MavenReportException("IOException: " + this.getOutputDirectory() + " is not a directory.");
        }
        if (javadocOutputDirectory.exists() && !javadocOutputDirectory.canWrite()) {
            throw new MavenReportException("IOException: " + this.getOutputDirectory() + " is not writable.");
        }
        javadocOutputDirectory.mkdirs();
        this.copyAllResources(javadocOutputDirectory);
        Commandline cmd = new Commandline();
        cmd.getShell().setQuotedArgumentsEnabled(false);
        cmd.setWorkingDirectory(javadocOutputDirectory.getAbsolutePath());
        cmd.setExecutable(jExecutable);
        this.addMemoryArg(cmd, "-Xmx", this.maxmemory);
        this.addMemoryArg(cmd, "-Xms", this.minmemory);
        this.addProxyArg(cmd);
        if (StringUtils.isNotEmpty((String)this.additionalJOption)) {
            cmd.createArg().setValue(this.additionalJOption);
        }
        if (this.additionalJOptions != null && this.additionalJOptions.length != 0) {
            for (String jo : this.additionalJOptions) {
                cmd.createArg().setValue(jo);
            }
        }
        ArrayList<String> standardDocletArguments = new ArrayList<String>();
        if (StringUtils.isEmpty((String)this.doclet) || this.useStandardDocletOptions) {
            Set<OfflineLink> set = this.getLinkofflines();
            this.addStandardDocletOptions(javadocOutputDirectory, standardDocletArguments, set);
        } else {
            Set set = Collections.emptySet();
        }
        ArrayList<String> javadocArguments = new ArrayList<String>();
        this.addJavadocOptions(javadocOutputDirectory, javadocArguments, sourcePaths, (Set<OfflineLink>)var10_15);
        ArrayList<String> arguments = new ArrayList<String>(javadocArguments.size() + standardDocletArguments.size());
        arguments.addAll(javadocArguments);
        arguments.addAll(standardDocletArguments);
        if (arguments.size() > 0) {
            this.addCommandLineOptions(cmd, arguments, javadocOutputDirectory);
        }
        boolean bl = includesExcludesActive = this.sourceFileIncludes != null && !this.sourceFileIncludes.isEmpty() || this.sourceFileExcludes != null && !this.sourceFileExcludes.isEmpty();
        if (includesExcludesActive && !StringUtils.isEmpty((String)this.subpackages)) {
            this.getLog().warn((CharSequence)"sourceFileIncludes and sourceFileExcludes have no effect when subpackages are specified!");
            includesExcludesActive = false;
        }
        if (!packageNames.isEmpty() && !includesExcludesActive) {
            this.addCommandLinePackages(cmd, javadocOutputDirectory, packageNames);
            List<String> specialFiles = this.getSpecialFiles(files);
            if (!specialFiles.isEmpty()) {
                this.addCommandLineArgFile(cmd, javadocOutputDirectory, specialFiles);
            }
        } else {
            ArrayList<String> allFiles = new ArrayList<String>();
            for (Map.Entry<Path, Collection<String>> filesEntry : files.entrySet()) {
                for (String file : filesEntry.getValue()) {
                    allFiles.add(filesEntry.getKey().resolve(file).toString());
                }
            }
            if (!files.isEmpty()) {
                this.addCommandLineArgFile(cmd, javadocOutputDirectory, allFiles);
            }
        }
        this.executeJavadocCommandLine(cmd, javadocOutputDirectory);
        if (!this.debug) {
            for (int i = 0; i < cmd.getArguments().length; ++i) {
                File argFile;
                String arg = cmd.getArguments()[i].trim();
                if (!arg.startsWith("@") || !(argFile = new File(javadocOutputDirectory, arg.substring(1))).exists()) continue;
                argFile.delete();
            }
            File scriptFile = new File(javadocOutputDirectory, DEBUG_JAVADOC_SCRIPT_NAME);
            if (scriptFile.exists()) {
                scriptFile.delete();
            }
        }
        if (this.applyJavadocSecurityFix) {
            try {
                int patched = this.fixFrameInjectionBug(javadocOutputDirectory, this.getDocencoding());
                if (patched <= 0) return;
                this.getLog().info((CharSequence)String.format("Fixed Javadoc frame injection vulnerability (CVE-2013-1571) in %d files.", patched));
                return;
            }
            catch (IOException e) {
                throw new MavenReportException("Failed to patch javadocs vulnerability: " + e.getMessage(), (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)"applying javadoc security fix has been disabled");
        }
    }

    protected final <T> Collection<T> collect(Collection<Collection<T>> sourcePaths) {
        LinkedHashSet<T> collectedSourcePaths = new LinkedHashSet<T>();
        for (Collection<T> sp : sourcePaths) {
            collectedSourcePaths.addAll(sp);
        }
        return collectedSourcePaths;
    }

    protected Map<Path, Collection<String>> getFiles(Collection<Path> sourcePaths) throws MavenReportException {
        LinkedHashMap<Path, Collection<String>> mappedFiles = new LinkedHashMap<Path, Collection<String>>(sourcePaths.size());
        if (StringUtils.isEmpty((String)this.subpackages)) {
            Collection<String> excludedPackages = this.getExcludedPackages();
            for (Path sourcePath : sourcePaths) {
                ArrayList<String> files = new ArrayList<String>();
                File sourceDirectory = sourcePath.toFile();
                files.addAll(JavadocUtil.getFilesFromSource(sourceDirectory, this.sourceFileIncludes, this.sourceFileExcludes, excludedPackages));
                if (this.source != null && JavaVersion.parse((String)this.source).isBefore("9") && files.remove("module-info.java")) {
                    this.getLog().debug((CharSequence)"Auto exclude module-info.java due to source value");
                }
                mappedFiles.put(sourcePath, files);
            }
        }
        return mappedFiles;
    }

    protected Map<String, Collection<Path>> getSourcePaths() throws MavenReportException {
        LinkedHashMap<String, Collection<Path>> mappedSourcePaths = new LinkedHashMap<String, Collection<Path>>();
        if (StringUtils.isEmpty((String)this.sourcepath)) {
            if (!"pom".equals(this.project.getPackaging())) {
                File javadocDir;
                LinkedHashSet<Path> sourcePaths = new LinkedHashSet<Path>(JavadocUtil.pruneDirs(this.project, this.getProjectSourceRoots(this.project)));
                if (this.project.getExecutionProject() != null) {
                    sourcePaths.addAll(JavadocUtil.pruneDirs(this.project, this.getExecutionProjectSourceRoots(this.project)));
                }
                if (this.getJavadocDirectory() != null && (javadocDir = this.getJavadocDirectory()).exists() && javadocDir.isDirectory()) {
                    Collection<Path> l = JavadocUtil.pruneDirs(this.project, Collections.singletonList(this.getJavadocDirectory().getAbsolutePath()));
                    sourcePaths.addAll(l);
                }
                if (!sourcePaths.isEmpty()) {
                    mappedSourcePaths.put(ArtifactUtils.versionlessKey((String)this.project.getGroupId(), (String)this.project.getArtifactId()), (Collection<Path>)sourcePaths);
                }
            }
            if (this.includeDependencySources) {
                mappedSourcePaths.putAll(this.getDependencySourcePaths());
            }
            if (this.isAggregator()) {
                for (MavenProject subProject : this.getAggregatedProjects()) {
                    ArtifactHandler artifactHandler;
                    if (subProject == this.project) continue;
                    ArrayList<Path> additionalSourcePaths = new ArrayList<Path>();
                    List<String> sourceRoots = this.getProjectSourceRoots(subProject);
                    if (subProject.getExecutionProject() != null) {
                        sourceRoots.addAll(this.getExecutionProjectSourceRoots(subProject));
                    }
                    if ("java".equals((artifactHandler = subProject.getArtifact().getArtifactHandler()).getLanguage())) {
                        additionalSourcePaths.addAll(JavadocUtil.pruneDirs(subProject, sourceRoots));
                    }
                    if (this.getJavadocDirectory() != null) {
                        String javadocDirRelative = PathUtils.toRelative((File)this.project.getBasedir(), (String)this.getJavadocDirectory().getAbsolutePath());
                        File javadocDir = new File(subProject.getBasedir(), javadocDirRelative);
                        if (javadocDir.exists() && javadocDir.isDirectory()) {
                            Collection<Path> l = JavadocUtil.pruneDirs(subProject, Collections.singletonList(javadocDir.getAbsolutePath()));
                            additionalSourcePaths.addAll(l);
                        }
                    }
                    mappedSourcePaths.put(ArtifactUtils.versionlessKey((String)subProject.getGroupId(), (String)subProject.getArtifactId()), additionalSourcePaths);
                }
            }
        } else {
            Collection<Path> sourcePaths = JavadocUtil.pruneDirs(this.project, new ArrayList<String>(Arrays.asList(JavadocUtil.splitPath(this.sourcepath))));
            if (this.getJavadocDirectory() != null) {
                Collection<Path> l = JavadocUtil.pruneDirs(this.project, Collections.singletonList(this.getJavadocDirectory().getAbsolutePath()));
                sourcePaths.addAll(l);
            }
            mappedSourcePaths.put(ArtifactUtils.versionlessKey((String)this.project.getGroupId(), (String)this.project.getArtifactId()), sourcePaths);
        }
        return mappedSourcePaths;
    }

    private Collection<MavenProject> getAggregatedProjects() {
        HashMap<Path, MavenProject> reactorProjectsMap = new HashMap<Path, MavenProject>();
        for (MavenProject reactorProject : this.reactorProjects) {
            reactorProjectsMap.put(reactorProject.getBasedir().toPath(), reactorProject);
        }
        return this.modulesForAggregatedProject(this.project, reactorProjectsMap);
    }

    private Set<MavenProject> modulesForAggregatedProject(MavenProject aggregatedProject, Map<Path, MavenProject> reactorProjectsMap) {
        if (aggregatedProject.getModules().isEmpty()) {
            return Collections.singleton(aggregatedProject);
        }
        LinkedList<Path> modulePaths = new LinkedList<Path>();
        for (String module : aggregatedProject.getModules()) {
            modulePaths.add(new File(aggregatedProject.getBasedir(), module).toPath());
        }
        LinkedHashSet<MavenProject> aggregatedModules = new LinkedHashSet<MavenProject>();
        for (Path modulePath : modulePaths) {
            MavenProject module = reactorProjectsMap.remove(modulePath);
            if (module == null) continue;
            aggregatedModules.addAll(this.modulesForAggregatedProject(module, reactorProjectsMap));
        }
        return aggregatedModules;
    }

    protected SourceResolverConfig configureDependencySourceResolution(SourceResolverConfig config) {
        return config.withCompileSources();
    }

    protected final Map<String, Collection<Path>> getDependencySourcePaths() throws MavenReportException {
        try {
            if (this.sourceDependencyCacheDir.exists()) {
                FileUtils.forceDelete((File)this.sourceDependencyCacheDir);
                this.sourceDependencyCacheDir.mkdirs();
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Failed to delete cache directory: " + this.sourceDependencyCacheDir + "\nReason: " + e.getMessage(), (Exception)e);
        }
        SourceResolverConfig config = this.getDependencySourceResolverConfig();
        try {
            return this.resourceResolver.resolveDependencySourcePaths(config);
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException e) {
            throw new MavenReportException("Failed to resolve one or more javadoc source/resource artifacts:\n\n" + e.getMessage(), (Exception)e);
        }
    }

    private TransformableFilter createDependencyArtifactFilter() {
        Set dependencyArtifacts = this.project.getDependencyArtifacts();
        ArrayList<String> artifactPatterns = new ArrayList<String>(dependencyArtifacts.size());
        for (Artifact artifact : dependencyArtifacts) {
            artifactPatterns.add(artifact.getGroupId() + ":" + artifact.getArtifactId());
        }
        return new PatternInclusionsFilter(artifactPatterns);
    }

    private SourceResolverConfig getDependencySourceResolverConfig() {
        ArrayList<Object> andFilters = new ArrayList<Object>();
        List<String> dependencyIncludes = this.dependencySourceIncludes;
        List<String> dependencyExcludes = this.dependencySourceExcludes;
        if (!this.includeTransitiveDependencySources || JavadocUtil.isNotEmpty(dependencyIncludes) || JavadocUtil.isNotEmpty(dependencyExcludes)) {
            if (!this.includeTransitiveDependencySources) {
                andFilters.add(this.createDependencyArtifactFilter());
            }
            if (JavadocUtil.isNotEmpty(dependencyIncludes)) {
                andFilters.add(new PatternInclusionsFilter(dependencyIncludes));
            }
            if (JavadocUtil.isNotEmpty(dependencyExcludes)) {
                andFilters.add(new PatternExclusionsFilter(dependencyExcludes));
            }
        }
        return this.configureDependencySourceResolution(new SourceResolverConfig(this.project, this.getProjectBuildingRequest(this.project), this.sourceDependencyCacheDir).withReactorProjects(this.reactorProjects)).withFilter(new AndFilter(andFilters));
    }

    private ProjectBuildingRequest getProjectBuildingRequest(MavenProject currentProject) {
        return new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest()).setRemoteRepositories(currentProject.getRemoteArtifactRepositories());
    }

    protected boolean canGenerateReport(Map<Path, Collection<String>> files) {
        for (Collection<String> filesValues : files.values()) {
            if (filesValues.isEmpty()) continue;
            return true;
        }
        return !StringUtils.isEmpty((String)this.subpackages);
    }

    private String getExcludedPackages(Collection<Path> sourcePaths) throws MavenReportException {
        List<String> excludedNames = null;
        if (StringUtils.isNotEmpty((String)this.sourcepath) && StringUtils.isNotEmpty((String)this.subpackages)) {
            Collection<String> excludedPackages = this.getExcludedPackages();
            excludedNames = JavadocUtil.getExcludedPackages(sourcePaths, excludedPackages);
        }
        String excludeArg = "";
        if (StringUtils.isNotEmpty((String)this.subpackages) && excludedNames != null) {
            excludeArg = StringUtils.join(excludedNames.iterator(), (String)":");
        }
        return excludeArg;
    }

    private String getSourcePath(Collection<Path> sourcePaths) {
        String sourcePath = null;
        if (StringUtils.isEmpty((String)this.subpackages) || StringUtils.isNotEmpty((String)this.sourcepath)) {
            sourcePath = StringUtils.join(sourcePaths.iterator(), (String)File.pathSeparator);
        }
        return sourcePath;
    }

    private Collection<String> getExcludedPackages() throws MavenReportException {
        LinkedHashSet<String> excluded = new LinkedHashSet<String>();
        if (this.includeDependencySources) {
            try {
                this.resolveDependencyBundles();
            }
            catch (IOException e) {
                throw new MavenReportException("Failed to resolve javadoc bundles from dependencies: " + e.getMessage(), (Exception)e);
            }
            if (JavadocUtil.isNotEmpty(this.dependencyJavadocBundles)) {
                for (JavadocBundle bundle : this.dependencyJavadocBundles) {
                    JavadocOptions options = bundle.getOptions();
                    if (options == null || !JavadocUtil.isNotEmpty(options.getExcludePackageNames())) continue;
                    excluded.addAll(options.getExcludePackageNames());
                }
            }
        }
        if (StringUtils.isNotEmpty((String)this.excludePackageNames)) {
            List<String> packageNames = Arrays.asList(this.excludePackageNames.split("[,:;]"));
            excluded.addAll(AbstractJavadocMojo.trimValues(packageNames));
        }
        return excluded;
    }

    private static List<String> trimValues(List<String> items) {
        ArrayList<String> result = new ArrayList<String>(items.size());
        for (String item : items) {
            String trimmed = item.trim();
            if (StringUtils.isEmpty((String)trimmed)) continue;
            result.add(trimmed);
        }
        return result;
    }

    private Collection<File> getPathElements() throws MavenReportException {
        LinkedHashSet<File> classpathElements = new LinkedHashSet<File>();
        LinkedHashMap<String, Artifact> compileArtifactMap = new LinkedHashMap<String, Artifact>();
        if (this.isTest()) {
            classpathElements.addAll(this.getProjectBuildOutputDirs(this.project));
        }
        this.populateCompileArtifactMap(compileArtifactMap, this.project.getArtifacts());
        if (this.isAggregator()) {
            Collection<MavenProject> aggregatorProjects = this.getAggregatedProjects();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MavenProject p : aggregatorProjects) {
                arrayList.add(p.getGroupId() + ':' + p.getArtifactId());
            }
            AndFilter dependencyFilter = new AndFilter(Arrays.asList(new PatternExclusionsFilter(arrayList), this.getDependencyScopeFilter()));
            for (MavenProject subProject : aggregatorProjects) {
                if (subProject == this.project) continue;
                File projectArtifactFile = this.getArtifactFile(subProject);
                if (projectArtifactFile != null) {
                    classpathElements.add(projectArtifactFile);
                } else {
                    classpathElements.addAll(this.getProjectBuildOutputDirs(subProject));
                }
                try {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Compiled artifacts for ");
                    sb.append(subProject.getGroupId()).append(":");
                    sb.append(subProject.getArtifactId()).append(":");
                    sb.append(subProject.getVersion()).append('\n');
                    ProjectBuildingRequest buildingRequest = this.getProjectBuildingRequest(subProject);
                    List managedDependencies = null;
                    if (subProject.getDependencyManagement() != null) {
                        managedDependencies = subProject.getDependencyManagement().getDependencies();
                    }
                    for (ArtifactResult artifactResult : this.dependencyResolver.resolveDependencies(buildingRequest, (Collection)subProject.getDependencies(), (Collection)managedDependencies, (TransformableFilter)dependencyFilter)) {
                        this.populateCompileArtifactMap(compileArtifactMap, Collections.singletonList(artifactResult.getArtifact()));
                        sb.append(artifactResult.getArtifact().getFile()).append('\n');
                    }
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)sb.toString());
                }
                catch (DependencyResolverException e) {
                    throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
                }
            }
        }
        for (Artifact artifact : compileArtifactMap.values()) {
            classpathElements.add(artifact.getFile());
        }
        if (this.additionalDependencies != null) {
            for (Dependency dependency : this.additionalDependencies) {
                Artifact artifact = this.resolveDependency(dependency);
                this.getLog().debug((CharSequence)("add additional artifact with path " + artifact.getFile()));
                classpathElements.add(artifact.getFile());
            }
        }
        return classpathElements;
    }

    protected ScopeFilter getDependencyScopeFilter() {
        return ScopeFilter.including((String[])new String[]{"compile", "provided", "system"});
    }

    public Artifact resolveDependency(Dependency dependency) throws MavenReportException {
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(dependency.getGroupId());
        coordinate.setArtifactId(dependency.getArtifactId());
        coordinate.setVersion(dependency.getVersion());
        coordinate.setClassifier(dependency.getClassifier());
        coordinate.setExtension(this.artifactHandlerManager.getArtifactHandler(dependency.getType()).getExtension());
        try {
            return this.artifactResolver.resolveArtifact(this.getProjectBuildingRequest(this.project), (ArtifactCoordinate)coordinate).getArtifact();
        }
        catch (ArtifactResolverException e) {
            throw new MavenReportException("artifact resolver problem - " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected final Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.jdkToolchain != null) {
            try {
                Method getToolchainsMethod = this.toolchainManager.getClass().getMethod("getToolchains", MavenSession.class, String.class, Map.class);
                List tcs = (List)getToolchainsMethod.invoke((Object)this.toolchainManager, this.session, "jdk", this.jdkToolchain);
                if (tcs != null && tcs.size() > 0) {
                    tc = (Toolchain)tcs.get(0);
                }
            }
            catch (ReflectiveOperationException | SecurityException exception) {
                // empty catch block
            }
        }
        if (tc == null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }

    private void populateCompileArtifactMap(Map<String, Artifact> compileArtifactMap, Collection<Artifact> artifactList) throws MavenReportException {
        if (artifactList == null) {
            return;
        }
        for (Artifact newArtifact : artifactList) {
            File file = newArtifact.getFile();
            if (file == null) {
                throw new MavenReportException("Error in plugin descriptor - dependency was not resolved for artifact: " + newArtifact.getGroupId() + ":" + newArtifact.getArtifactId() + ":" + newArtifact.getVersion());
            }
            if (compileArtifactMap.get(newArtifact.getDependencyConflictId()) != null) {
                Artifact oldArtifact = compileArtifactMap.get(newArtifact.getDependencyConflictId());
                DefaultArtifactVersion oldVersion = new DefaultArtifactVersion(oldArtifact.getVersion());
                DefaultArtifactVersion newVersion = new DefaultArtifactVersion(newArtifact.getVersion());
                if (newVersion.compareTo((Object)oldVersion) <= 0) continue;
                compileArtifactMap.put(newArtifact.getDependencyConflictId(), newArtifact);
                continue;
            }
            compileArtifactMap.put(newArtifact.getDependencyConflictId(), newArtifact);
        }
    }

    private String getBottomText() {
        int currentYear = Calendar.getInstance().get(1);
        String year = String.valueOf(currentYear);
        String inceptionYear = this.project.getInceptionYear();
        String theBottom = StringUtils.replace((String)this.bottom, (String)"{currentYear}", (String)year);
        theBottom = inceptionYear != null ? (inceptionYear.equals(year) ? StringUtils.replace((String)theBottom, (String)"{inceptionYear}&#x2013;", (String)"") : StringUtils.replace((String)theBottom, (String)"{inceptionYear}", (String)inceptionYear)) : StringUtils.replace((String)theBottom, (String)"{inceptionYear}&#x2013;", (String)"");
        theBottom = this.project.getOrganization() == null ? StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)"") : (StringUtils.isNotEmpty((String)this.project.getOrganization().getName()) ? (StringUtils.isNotEmpty((String)this.project.getOrganization().getUrl()) ? StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)("<a href=\"" + this.project.getOrganization().getUrl() + "\">" + this.project.getOrganization().getName() + "</a>")) : StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)this.project.getOrganization().getName())) : StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)""));
        return theBottom;
    }

    private String getStylesheetFile(File javadocOutputDirectory) {
        if (StringUtils.isEmpty((String)this.stylesheetfile)) {
            if ("java".equalsIgnoreCase(this.stylesheet)) {
                return null;
            }
            return new File(javadocOutputDirectory, DEFAULT_CSS_NAME).getAbsolutePath();
        }
        if (new File(this.stylesheetfile).exists()) {
            return new File(this.stylesheetfile).getAbsolutePath();
        }
        return this.getResource(new File(javadocOutputDirectory, DEFAULT_CSS_NAME), this.stylesheetfile);
    }

    private String getHelpFile(File javadocOutputDirectory) {
        if (StringUtils.isEmpty((String)this.helpfile)) {
            return null;
        }
        if (new File(this.helpfile).exists()) {
            return new File(this.helpfile).getAbsolutePath();
        }
        return this.getResource(new File(javadocOutputDirectory, "help-doc.html"), this.helpfile);
    }

    private String getAccessLevel() {
        String accessLevel;
        if ("public".equalsIgnoreCase(this.show) || "protected".equalsIgnoreCase(this.show) || "package".equalsIgnoreCase(this.show) || "private".equalsIgnoreCase(this.show)) {
            accessLevel = "-" + this.show;
        } else {
            if (this.getLog().isErrorEnabled()) {
                this.getLog().error((CharSequence)("Unrecognized access level to show '" + this.show + "'. Defaulting to protected."));
            }
            accessLevel = "-protected";
        }
        return accessLevel;
    }

    private String getBootclassPath() throws MavenReportException {
        Set<BootclasspathArtifact> bootclasspathArtifacts = this.collectBootClasspathArtifacts();
        List<String> bootclassPath = new ArrayList<String>();
        for (BootclasspathArtifact aBootclasspathArtifact : bootclasspathArtifacts) {
            if (!StringUtils.isNotEmpty((String)aBootclasspathArtifact.getGroupId()) || !StringUtils.isNotEmpty((String)aBootclasspathArtifact.getArtifactId()) || !StringUtils.isNotEmpty((String)aBootclasspathArtifact.getVersion())) continue;
            bootclassPath.addAll(this.getArtifactsAbsolutePath(aBootclasspathArtifact));
        }
        bootclassPath = JavadocUtil.pruneFiles(bootclassPath);
        StringBuilder path = new StringBuilder();
        path.append(StringUtils.join(bootclassPath.iterator(), (String)File.pathSeparator));
        if (StringUtils.isNotEmpty((String)this.bootclasspath)) {
            path.append(JavadocUtil.unifyPathSeparator(this.bootclasspath));
        }
        return path.toString();
    }

    private String getDocletPath() throws MavenReportException {
        String path;
        Set<DocletArtifact> docletArtifacts = this.collectDocletArtifacts();
        ArrayList<String> pathParts = new ArrayList<String>();
        for (DocletArtifact docletArtifact : docletArtifacts) {
            if (this.isDocletArtifactEmpty(docletArtifact)) continue;
            pathParts.addAll(this.getArtifactsAbsolutePath(docletArtifact));
        }
        if (!StringUtils.isEmpty((String)this.docletPath)) {
            pathParts.add(JavadocUtil.unifyPathSeparator(this.docletPath));
        }
        if (StringUtils.isEmpty((String)(path = StringUtils.join(pathParts.iterator(), (String)File.pathSeparator))) && this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)"No docletpath option was found. Please review <docletpath/> or <docletArtifact/> or <doclets/>.");
        }
        return path;
    }

    private boolean isDocletArtifactEmpty(DocletArtifact aDocletArtifact) {
        if (aDocletArtifact == null) {
            return true;
        }
        return StringUtils.isEmpty((String)aDocletArtifact.getGroupId()) && StringUtils.isEmpty((String)aDocletArtifact.getArtifactId()) && StringUtils.isEmpty((String)aDocletArtifact.getVersion());
    }

    private String getTagletPath() throws MavenReportException {
        Set<TagletArtifact> tArtifacts = this.collectTagletArtifacts();
        ArrayList<String> pathParts = new ArrayList<String>();
        for (TagletArtifact tagletArtifact : tArtifacts) {
            if (tagletArtifact == null || !StringUtils.isNotEmpty((String)tagletArtifact.getGroupId()) || !StringUtils.isNotEmpty((String)tagletArtifact.getArtifactId()) || !StringUtils.isNotEmpty((String)tagletArtifact.getVersion())) continue;
            pathParts.addAll(this.getArtifactsAbsolutePath(tagletArtifact));
        }
        Set<Taglet> taglets = this.collectTaglets();
        for (Taglet taglet : taglets) {
            if (taglet == null) continue;
            if (taglet.getTagletArtifact() != null && StringUtils.isNotEmpty((String)taglet.getTagletArtifact().getGroupId()) && StringUtils.isNotEmpty((String)taglet.getTagletArtifact().getArtifactId()) && StringUtils.isNotEmpty((String)taglet.getTagletArtifact().getVersion())) {
                pathParts.addAll(JavadocUtil.pruneFiles(this.getArtifactsAbsolutePath(taglet.getTagletArtifact())));
                continue;
            }
            if (!StringUtils.isNotEmpty((String)taglet.getTagletpath())) continue;
            for (Path dir : JavadocUtil.pruneDirs(this.project, Collections.singletonList(taglet.getTagletpath()))) {
                pathParts.add(dir.toString());
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.join(pathParts.iterator(), (String)File.pathSeparator));
        if (StringUtils.isNotEmpty((String)this.tagletpath)) {
            stringBuilder.append(JavadocUtil.unifyPathSeparator(this.tagletpath));
        }
        return stringBuilder.toString();
    }

    private Set<String> collectLinks() throws MavenReportException {
        LinkedHashSet<String> links = new LinkedHashSet<String>();
        if (this.includeDependencySources) {
            try {
                this.resolveDependencyBundles();
            }
            catch (IOException e) {
                throw new MavenReportException("Failed to resolve javadoc bundles from dependencies: " + e.getMessage(), (Exception)e);
            }
            if (JavadocUtil.isNotEmpty(this.dependencyJavadocBundles)) {
                for (JavadocBundle bundle : this.dependencyJavadocBundles) {
                    JavadocOptions options = bundle.getOptions();
                    if (options == null || !JavadocUtil.isNotEmpty(options.getLinks())) continue;
                    links.addAll(options.getLinks());
                }
            }
        }
        if (JavadocUtil.isNotEmpty(this.links)) {
            links.addAll(this.links);
        }
        links.addAll(this.getDependenciesLinks());
        return this.followLinks(links);
    }

    private Set<Group> collectGroups() throws MavenReportException {
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        if (this.includeDependencySources) {
            try {
                this.resolveDependencyBundles();
            }
            catch (IOException e) {
                throw new MavenReportException("Failed to resolve javadoc bundles from dependencies: " + e.getMessage(), (Exception)e);
            }
            if (JavadocUtil.isNotEmpty(this.dependencyJavadocBundles)) {
                for (JavadocBundle bundle : this.dependencyJavadocBundles) {
                    JavadocOptions options = bundle.getOptions();
                    if (options == null || !JavadocUtil.isNotEmpty(options.getGroups())) continue;
                    groups.addAll(options.getGroups());
                }
            }
        }
        if (this.groups != null && this.groups.length > 0) {
            groups.addAll(Arrays.asList(this.groups));
        }
        return groups;
    }

    private Set<ResourcesArtifact> collectResourcesArtifacts() throws MavenReportException {
        LinkedHashSet<ResourcesArtifact> result = new LinkedHashSet<ResourcesArtifact>();
        if (this.includeDependencySources) {
            try {
                this.resolveDependencyBundles();
            }
            catch (IOException e) {
                throw new MavenReportException("Failed to resolve javadoc bundles from dependencies: " + e.getMessage(), (Exception)e);
            }
            if (JavadocUtil.isNotEmpty(this.dependencyJavadocBundles)) {
                for (JavadocBundle bundle : this.dependencyJavadocBundles) {
                    JavadocOptions options = bundle.getOptions();
                    if (options == null || !JavadocUtil.isNotEmpty(options.getResourcesArtifacts())) continue;
                    result.addAll(options.getResourcesArtifacts());
                }
            }
        }
        if (this.resourcesArtifacts != null && this.resourcesArtifacts.length > 0) {
            result.addAll(Arrays.asList(this.resourcesArtifacts));
        }
        return result;
    }

    private Set<BootclasspathArtifact> collectBootClasspathArtifacts() throws MavenReportException {
        LinkedHashSet<BootclasspathArtifact> result = new LinkedHashSet<BootclasspathArtifact>();
        if (this.includeDependencySources) {
            try {
                this.resolveDependencyBundles();
            }
            catch (IOException e) {
                throw new MavenReportException("Failed to resolve javadoc bundles from dependencies: " + e.getMessage(), (Exception)e);
            }
            if (JavadocUtil.isNotEmpty(this.dependencyJavadocBundles)) {
                for (JavadocBundle bundle : this.dependencyJavadocBundles) {
                    JavadocOptions options = bundle.getOptions();
                    if (options == null || !JavadocUtil.isNotEmpty(options.getBootclasspathArtifacts())) continue;
                    result.addAll(options.getBootclasspathArtifacts());
                }
            }
        }
        if (this.bootclasspathArtifacts != null && this.bootclasspathArtifacts.length > 0) {
            result.addAll(Arrays.asList(this.bootclasspathArtifacts));
        }
        return result;
    }

    private Set<OfflineLink> collectOfflineLinks() throws MavenReportException {
        LinkedHashSet<OfflineLink> result = new LinkedHashSet<OfflineLink>();
        OfflineLink javaApiLink = this.getDefaultJavadocApiLink();
        if (javaApiLink != null) {
            result.add(javaApiLink);
        }
        if (this.includeDependencySources) {
            try {
                this.resolveDependencyBundles();
            }
            catch (IOException e) {
                throw new MavenReportException("Failed to resolve javadoc bundles from dependencies: " + e.getMessage(), (Exception)e);
            }
            if (JavadocUtil.isNotEmpty(this.dependencyJavadocBundles)) {
                for (JavadocBundle bundle : this.dependencyJavadocBundles) {
                    JavadocOptions options = bundle.getOptions();
                    if (options == null || !JavadocUtil.isNotEmpty(options.getOfflineLinks())) continue;
                    result.addAll(options.getOfflineLinks());
                }
            }
        }
        if (this.offlineLinks != null && this.offlineLinks.length > 0) {
            result.addAll(Arrays.asList(this.offlineLinks));
        }
        return result;
    }

    private Set<Tag> collectTags() throws MavenReportException {
        LinkedHashSet<Tag> tags = new LinkedHashSet<Tag>();
        if (this.includeDependencySources) {
            try {
                this.resolveDependencyBundles();
            }
            catch (IOException e) {
                throw new MavenReportException("Failed to resolve javadoc bundles from dependencies: " + e.getMessage(), (Exception)e);
            }
            if (JavadocUtil.isNotEmpty(this.dependencyJavadocBundles)) {
                for (JavadocBundle bundle : this.dependencyJavadocBundles) {
                    JavadocOptions options = bundle.getOptions();
                    if (options == null || !JavadocUtil.isNotEmpty(options.getTags())) continue;
                    tags.addAll(options.getTags());
                }
            }
        }
        if (this.tags != null && this.tags.length > 0) {
            tags.addAll(Arrays.asList(this.tags));
        }
        return tags;
    }

    private Set<TagletArtifact> collectTagletArtifacts() throws MavenReportException {
        LinkedHashSet<TagletArtifact> tArtifacts = new LinkedHashSet<TagletArtifact>();
        if (this.includeDependencySources) {
            try {
                this.resolveDependencyBundles();
            }
            catch (IOException e) {
                throw new MavenReportException("Failed to resolve javadoc bundles from dependencies: " + e.getMessage(), (Exception)e);
            }
            if (JavadocUtil.isNotEmpty(this.dependencyJavadocBundles)) {
                for (JavadocBundle bundle : this.dependencyJavadocBundles) {
                    JavadocOptions options = bundle.getOptions();
                    if (options == null || !JavadocUtil.isNotEmpty(options.getTagletArtifacts())) continue;
                    tArtifacts.addAll(options.getTagletArtifacts());
                }
            }
        }
        if (this.tagletArtifact != null) {
            tArtifacts.add(this.tagletArtifact);
        }
        if (this.tagletArtifacts != null && this.tagletArtifacts.length > 0) {
            tArtifacts.addAll(Arrays.asList(this.tagletArtifacts));
        }
        return tArtifacts;
    }

    private Set<DocletArtifact> collectDocletArtifacts() throws MavenReportException {
        LinkedHashSet<DocletArtifact> dArtifacts = new LinkedHashSet<DocletArtifact>();
        if (this.includeDependencySources) {
            try {
                this.resolveDependencyBundles();
            }
            catch (IOException e) {
                throw new MavenReportException("Failed to resolve javadoc bundles from dependencies: " + e.getMessage(), (Exception)e);
            }
            if (JavadocUtil.isNotEmpty(this.dependencyJavadocBundles)) {
                for (JavadocBundle bundle : this.dependencyJavadocBundles) {
                    JavadocOptions options = bundle.getOptions();
                    if (options == null || !JavadocUtil.isNotEmpty(options.getDocletArtifacts())) continue;
                    dArtifacts.addAll(options.getDocletArtifacts());
                }
            }
        }
        if (this.docletArtifact != null) {
            dArtifacts.add(this.docletArtifact);
        }
        if (this.docletArtifacts != null && this.docletArtifacts.length > 0) {
            dArtifacts.addAll(Arrays.asList(this.docletArtifacts));
        }
        return dArtifacts;
    }

    private Set<Taglet> collectTaglets() throws MavenReportException {
        LinkedHashSet<Taglet> result = new LinkedHashSet<Taglet>();
        if (this.includeDependencySources) {
            try {
                this.resolveDependencyBundles();
            }
            catch (IOException e) {
                throw new MavenReportException("Failed to resolve javadoc bundles from dependencies: " + e.getMessage(), (Exception)e);
            }
            if (JavadocUtil.isNotEmpty(this.dependencyJavadocBundles)) {
                for (JavadocBundle bundle : this.dependencyJavadocBundles) {
                    JavadocOptions options = bundle.getOptions();
                    if (options == null || !JavadocUtil.isNotEmpty(options.getTaglets())) continue;
                    result.addAll(options.getTaglets());
                }
            }
        }
        if (this.taglets != null && this.taglets.length > 0) {
            result.addAll(Arrays.asList(this.taglets));
        }
        return result;
    }

    private List<String> getArtifactsAbsolutePath(JavadocPathArtifact javadocArtifact) throws MavenReportException {
        if (StringUtils.isEmpty((String)javadocArtifact.getGroupId()) && StringUtils.isEmpty((String)javadocArtifact.getArtifactId()) && StringUtils.isEmpty((String)javadocArtifact.getVersion())) {
            return Collections.emptyList();
        }
        ArrayList<String> path = new ArrayList<String>();
        try {
            Artifact artifact = this.createAndResolveArtifact(javadocArtifact);
            path.add(artifact.getFile().getAbsolutePath());
            DefaultDependableCoordinate coordinate = new DefaultDependableCoordinate();
            coordinate.setGroupId(javadocArtifact.getGroupId());
            coordinate.setArtifactId(javadocArtifact.getArtifactId());
            coordinate.setVersion(javadocArtifact.getVersion());
            Iterable deps = this.dependencyResolver.resolveDependencies(this.getProjectBuildingRequest(this.project), (DependableCoordinate)coordinate, (TransformableFilter)ScopeFilter.including((String[])new String[]{"compile", "provided"}));
            for (ArtifactResult a : deps) {
                path.add(a.getArtifact().getFile().getAbsolutePath());
            }
            return path;
        }
        catch (ArtifactResolverException e) {
            throw new MavenReportException("Unable to resolve artifact:" + javadocArtifact, (Exception)((Object)e));
        }
        catch (DependencyResolverException e) {
            throw new MavenReportException("Unable to resolve dependencies for:" + javadocArtifact, (Exception)((Object)e));
        }
    }

    private Artifact createAndResolveArtifact(JavadocPathArtifact javadocArtifact) throws ArtifactResolverException {
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(javadocArtifact.getGroupId());
        coordinate.setArtifactId(javadocArtifact.getArtifactId());
        coordinate.setVersion(javadocArtifact.getVersion());
        return this.artifactResolver.resolveArtifact(this.getProjectBuildingRequest(this.project), (ArtifactCoordinate)coordinate).getArtifact();
    }

    private void addMemoryArg(Commandline cmd, String arg, String memory) {
        block3: {
            if (StringUtils.isNotEmpty((String)memory)) {
                try {
                    cmd.createArg().setValue("-J" + arg + JavadocUtil.parseJavadocMemory(memory));
                }
                catch (IllegalArgumentException e) {
                    if (!this.getLog().isErrorEnabled()) break block3;
                    this.getLog().error((CharSequence)("Malformed memory pattern for '" + arg + memory + "'. Ignore this option."));
                }
            }
        }
    }

    private void addProxyArg(Commandline cmd) {
        Proxy httpProxy;
        Proxy httpsProxy;
        if (this.settings == null || this.settings.getProxies().isEmpty()) {
            return;
        }
        HashMap<String, Proxy> activeProxies = new HashMap<String, Proxy>();
        for (Proxy proxy : this.settings.getProxies()) {
            String protocol;
            if (!proxy.isActive() || activeProxies.containsKey(protocol = proxy.getProtocol())) continue;
            activeProxies.put(protocol, proxy);
        }
        if (activeProxies.containsKey("https") && StringUtils.isNotEmpty((String)(httpsProxy = (Proxy)activeProxies.get("https")).getHost())) {
            cmd.createArg().setValue("-J-Dhttps.proxyHost=" + httpsProxy.getHost());
            cmd.createArg().setValue("-J-Dhttps.proxyPort=" + httpsProxy.getPort());
            if (StringUtils.isNotEmpty((String)httpsProxy.getNonProxyHosts()) && (!activeProxies.containsKey("http") || StringUtils.isEmpty((String)((Proxy)activeProxies.get("http")).getNonProxyHosts()))) {
                cmd.createArg().setValue("-J-Dhttp.nonProxyHosts=\"" + httpsProxy.getNonProxyHosts().replace("|", "^|") + "\"");
            }
        }
        if (activeProxies.containsKey("http") && StringUtils.isNotEmpty((String)(httpProxy = (Proxy)activeProxies.get("http")).getHost())) {
            cmd.createArg().setValue("-J-Dhttp.proxyHost=" + httpProxy.getHost());
            cmd.createArg().setValue("-J-Dhttp.proxyPort=" + httpProxy.getPort());
            if (!activeProxies.containsKey("https")) {
                cmd.createArg().setValue("-J-Dhttps.proxyHost=" + httpProxy.getHost());
                cmd.createArg().setValue("-J-Dhttps.proxyPort=" + httpProxy.getPort());
            }
            if (StringUtils.isNotEmpty((String)httpProxy.getNonProxyHosts())) {
                cmd.createArg().setValue("-J-Dhttp.nonProxyHosts=\"" + httpProxy.getNonProxyHosts().replace("|", "^|") + "\"");
            }
        }
    }

    private String getJavadocExecutable() throws IOException {
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in maven-javadoc-plugin: " + tc));
            if (this.javadocExecutable != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'javadocExecutable' parameter is set to " + this.javadocExecutable));
            } else {
                this.javadocExecutable = tc.findTool("javadoc");
            }
        }
        String javadocCommand = "javadoc" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        if (StringUtils.isNotEmpty((String)this.javadocExecutable)) {
            File javadocExe = new File(this.javadocExecutable);
            if (javadocExe.isDirectory()) {
                javadocExe = new File(javadocExe, javadocCommand);
            }
            if (SystemUtils.IS_OS_WINDOWS && javadocExe.getName().indexOf(46) < 0) {
                javadocExe = new File(javadocExe.getPath() + ".exe");
            }
            if (!javadocExe.isFile()) {
                throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. Verify the <javadocExecutable/> parameter.");
            }
            return javadocExe.getAbsolutePath();
        }
        File javadocExe = SystemUtils.IS_OS_AIX ? new File(SystemUtils.getJavaHome() + File.separator + ".." + File.separator + "sh", javadocCommand) : (SystemUtils.IS_OS_MAC_OSX && !JavaVersion.JAVA_SPECIFICATION_VERSION.isAtLeast("1.7") ? new File(SystemUtils.getJavaHome() + File.separator + "bin", javadocCommand) : new File(SystemUtils.getJavaHome() + File.separator + ".." + File.separator + "bin", javadocCommand));
        if (!javadocExe.exists() || !javadocExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            String javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).getCanonicalFile().exists() || new File(javaHome).getCanonicalFile().isFile()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javadocExe = new File(javaHome + File.separator + "bin", javadocCommand);
        }
        if (!javadocExe.getCanonicalFile().exists() || !javadocExe.getCanonicalFile().isFile()) {
            throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javadocExe.getAbsolutePath();
    }

    private void setFJavadocVersion(File jExecutable) throws MavenReportException {
        JavaVersion jVersion;
        try {
            jVersion = JavadocUtil.getJavadocVersion(jExecutable);
        }
        catch (IOException | IllegalArgumentException | CommandLineException e) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("Unable to find the javadoc version: " + e.getMessage()));
                this.getLog().warn((CharSequence)("Using the Java version instead of, i.e. " + JAVA_VERSION));
            }
            jVersion = JAVA_VERSION;
        }
        if (StringUtils.isNotEmpty((String)this.javadocVersion)) {
            try {
                this.javadocRuntimeVersion = JavaVersion.parse((String)this.javadocVersion);
            }
            catch (NumberFormatException e) {
                throw new MavenReportException("Unable to parse javadoc version: " + e.getMessage(), (Exception)e);
            }
            if (this.javadocRuntimeVersion.compareTo(jVersion) != 0 && this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("Are you sure about the <javadocVersion/> parameter? It seems to be " + jVersion));
            }
        } else {
            this.javadocRuntimeVersion = jVersion;
        }
    }

    private boolean isJavaDocVersionAtLeast(JavaVersion requiredVersion) {
        return JAVA_VERSION.compareTo(requiredVersion) >= 0;
    }

    private void addArgIf(List<String> arguments, boolean b, String value) {
        if (b) {
            arguments.add(value);
        }
    }

    private void addArgIf(List<String> arguments, boolean b, String value, JavaVersion requiredJavaVersion) {
        if (b) {
            if (this.isJavaDocVersionAtLeast(requiredJavaVersion)) {
                this.addArgIf(arguments, true, value);
            } else if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)(value + " option is not supported on Java version < " + requiredJavaVersion + ". Ignore this option."));
            }
        }
    }

    private void addArgIfNotEmpty(List<String> arguments, String key, String value) {
        this.addArgIfNotEmpty(arguments, key, value, false);
    }

    private void addArgIfNotEmpty(List<String> arguments, String key, String value, boolean repeatKey, boolean splitValue, JavaVersion requiredJavaVersion) {
        if (StringUtils.isNotEmpty((String)value)) {
            if (this.isJavaDocVersionAtLeast(requiredJavaVersion)) {
                this.addArgIfNotEmpty(arguments, key, value, repeatKey, splitValue);
            } else if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)(key + " option is not supported on Java version < " + requiredJavaVersion + ". Ignore this option."));
            }
        }
    }

    private void addArgIfNotEmpty(List<String> arguments, String key, String value, boolean repeatKey, boolean splitValue) {
        if (StringUtils.isNotEmpty((String)value)) {
            if (StringUtils.isNotEmpty((String)key)) {
                arguments.add(key);
            }
            if (splitValue) {
                StringTokenizer token = new StringTokenizer(value, ",");
                while (token.hasMoreTokens()) {
                    String current = token.nextToken().trim();
                    if (!StringUtils.isNotEmpty((String)current)) continue;
                    arguments.add(current);
                    if (!token.hasMoreTokens() || !repeatKey) continue;
                    arguments.add(key);
                }
            } else {
                arguments.add(value);
            }
        }
    }

    private void addArgIfNotEmpty(List<String> arguments, String key, String value, boolean repeatKey) {
        this.addArgIfNotEmpty(arguments, key, value, repeatKey, true);
    }

    private void addArgIfNotEmpty(List<String> arguments, String key, String value, JavaVersion requiredJavaVersion) {
        this.addArgIfNotEmpty(arguments, key, value, requiredJavaVersion, false);
    }

    private void addArgIfNotEmpty(List<String> arguments, String key, String value, JavaVersion requiredJavaVersion, boolean repeatKey) {
        if (StringUtils.isNotEmpty((String)value)) {
            if (this.isJavaDocVersionAtLeast(requiredJavaVersion)) {
                this.addArgIfNotEmpty(arguments, key, value, repeatKey);
            } else if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)(key + " option is not supported on Java version < " + requiredJavaVersion));
            }
        }
    }

    private void addLinkofflineArguments(List<String> arguments, Set<OfflineLink> offlineLinksList) throws MavenReportException {
        for (OfflineLink offlineLink : offlineLinksList) {
            String url = offlineLink.getUrl();
            if (StringUtils.isEmpty((String)url)) continue;
            url = AbstractJavadocMojo.cleanUrl(url);
            String location = offlineLink.getLocation();
            if (StringUtils.isEmpty((String)location) || !this.isValidJavadocLink(location, false)) continue;
            this.addArgIfNotEmpty(arguments, "-linkoffline", JavadocUtil.quotedPathArgument(url) + " " + JavadocUtil.quotedPathArgument(location), true);
        }
    }

    private Set<OfflineLink> getLinkofflines() throws MavenReportException {
        Set<OfflineLink> offlineLinksList = this.collectOfflineLinks();
        offlineLinksList.addAll(this.getModulesLinks());
        return offlineLinksList;
    }

    private void addLinkArguments(List<String> arguments) throws MavenReportException {
        Set<String> links = this.collectLinks();
        for (String link : links) {
            if (StringUtils.isEmpty((String)link) || this.isOffline && !link.startsWith("file:")) continue;
            while (link.endsWith("/")) {
                link = link.substring(0, link.lastIndexOf("/"));
            }
            this.addArgIfNotEmpty(arguments, "-link", JavadocUtil.quotedPathArgument(link), true, false);
        }
    }

    private void copyAllResources(File javadocOutputDirectory) throws MavenReportException {
        try {
            this.copyDefaultStylesheet(javadocOutputDirectory);
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy default stylesheet: " + e.getMessage(), (Exception)e);
        }
        if (this.docfilessubdirs) {
            try {
                this.copyJavadocResources(javadocOutputDirectory);
            }
            catch (IOException e) {
                throw new MavenReportException("Unable to copy javadoc resources: " + e.getMessage(), (Exception)e);
            }
        }
        this.copyAdditionalJavadocResources(javadocOutputDirectory);
    }

    private void copyDefaultStylesheet(File anOutputDirectory) throws IOException {
        if (StringUtils.isNotEmpty((String)this.stylesheetfile)) {
            return;
        }
        if (!this.stylesheet.equalsIgnoreCase("maven")) {
            return;
        }
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(RESOURCE_CSS_DIR + "/" + DEFAULT_CSS_NAME);
        File outFile = new File(anOutputDirectory, DEFAULT_CSS_NAME);
        JavadocUtil.copyResource(url, outFile);
    }

    private void copyJavadocResources(File anOutputDirectory) throws IOException {
        if (anOutputDirectory == null || !anOutputDirectory.exists()) {
            throw new IOException("The outputDirectory " + anOutputDirectory + " doesn't exists.");
        }
        if (this.includeDependencySources) {
            this.resolveDependencyBundles();
            if (JavadocUtil.isNotEmpty(this.dependencyJavadocBundles)) {
                for (JavadocBundle bundle : this.dependencyJavadocBundles) {
                    File dir = bundle.getResourcesDirectory();
                    JavadocOptions options = bundle.getOptions();
                    if (dir == null || !dir.isDirectory()) continue;
                    JavadocUtil.copyJavadocResources(anOutputDirectory, dir, options == null ? null : options.getExcludedDocfilesSubdirs());
                }
            }
        }
        if (this.getJavadocDirectory() != null) {
            JavadocUtil.copyJavadocResources(anOutputDirectory, this.getJavadocDirectory(), this.excludedocfilessubdir);
        }
        if (this.isAggregator()) {
            for (MavenProject subProject : this.getAggregatedProjects()) {
                if (subProject == this.project || this.getJavadocDirectory() == null) continue;
                String javadocDirRelative = PathUtils.toRelative((File)this.project.getBasedir(), (String)this.getJavadocDirectory().getAbsolutePath());
                File javadocDir = new File(subProject.getBasedir(), javadocDirRelative);
                JavadocUtil.copyJavadocResources(anOutputDirectory, javadocDir, this.excludedocfilessubdir);
            }
        }
    }

    private synchronized void resolveDependencyBundles() throws IOException {
        if (this.dependencyJavadocBundles == null) {
            this.dependencyJavadocBundles = this.resourceResolver.resolveDependencyJavadocBundles(this.getDependencySourceResolverConfig());
            if (this.dependencyJavadocBundles == null) {
                this.dependencyJavadocBundles = new ArrayList<JavadocBundle>();
            }
        }
    }

    private void copyAdditionalJavadocResources(File anOutputDirectory) throws MavenReportException {
        UnArchiver unArchiver;
        Set<ResourcesArtifact> resourcesArtifacts = this.collectResourcesArtifacts();
        if (JavadocUtil.isEmpty(resourcesArtifacts)) {
            return;
        }
        try {
            unArchiver = this.archiverManager.getUnArchiver("jar");
        }
        catch (NoSuchArchiverException e) {
            throw new MavenReportException("Unable to extract resources artifact. No archiver for 'jar' available.", (Exception)((Object)e));
        }
        for (ResourcesArtifact item : resourcesArtifacts) {
            Artifact artifact;
            try {
                artifact = this.createAndResolveArtifact(item);
            }
            catch (ArtifactResolverException e) {
                throw new MavenReportException("Unable to resolve artifact:" + item, (Exception)((Object)e));
            }
            unArchiver.setSourceFile(artifact.getFile());
            unArchiver.setDestDirectory(anOutputDirectory);
            IncludeExcludeFileSelector[] selectors = new IncludeExcludeFileSelector[]{new IncludeExcludeFileSelector()};
            selectors[0].setExcludes(new String[]{"META-INF/**"});
            unArchiver.setFileSelectors((FileSelector[])selectors);
            this.getLog().info((CharSequence)("Extracting contents of resources artifact: " + artifact.getArtifactId()));
            try {
                unArchiver.extract();
            }
            catch (ArchiverException e) {
                throw new MavenReportException("Extraction of resources failed. Artifact that failed was: " + artifact.getArtifactId(), (Exception)((Object)e));
            }
        }
    }

    private List<String> getPackageNames(Map<Path, Collection<String>> sourcePaths) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.sourcepath)) {
            return returnList;
        }
        for (Map.Entry<Path, Collection<String>> currentPathEntry : sourcePaths.entrySet()) {
            for (String currentFile : currentPathEntry.getValue()) {
                String packagename;
                int lastIndexOfSeparator;
                if (currentFile.contains("doc-files") || (lastIndexOfSeparator = currentFile.lastIndexOf("/")) == -1 || returnList.contains(packagename = currentFile.substring(0, lastIndexOfSeparator).replace('/', '.'))) continue;
                returnList.add(packagename);
            }
        }
        return returnList;
    }

    private List<String> getPackageNamesRespectingJavaModules(Map<String, Collection<Path>> allSourcePaths) throws MavenReportException {
        ArrayList<String> returnList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.sourcepath)) {
            return returnList;
        }
        for (Collection<Path> artifactSourcePaths : allSourcePaths.values()) {
            boolean exportAllPackages;
            HashSet<String> exportedPackages = new HashSet<String>();
            File mainDescriptor = this.findMainDescriptor(artifactSourcePaths);
            if (mainDescriptor != null && !this.isTest()) {
                ResolvePathsRequest request = ResolvePathsRequest.ofFiles(Collections.emptyList()).setMainModuleDescriptor((Object)mainDescriptor);
                try {
                    Set exports = this.locationManager.resolvePaths(request).getMainModuleDescriptor().exports();
                    if (exports.isEmpty()) continue;
                    for (JavaModuleDescriptor.JavaExports export : exports) {
                        exportedPackages.add(export.source());
                    }
                }
                catch (IOException e) {
                    throw new MavenReportException(e.getMessage(), (Exception)e);
                }
                exportAllPackages = false;
            } else {
                exportAllPackages = true;
            }
            for (Map.Entry<Path, Collection<String>> currentPathEntry : this.getFiles(artifactSourcePaths).entrySet()) {
                for (String currentFile : currentPathEntry.getValue()) {
                    int lastIndexOfSeparator;
                    if (currentFile.contains("doc-files") || (lastIndexOfSeparator = currentFile.lastIndexOf(File.separatorChar)) == -1) continue;
                    String packagename = currentFile.substring(0, lastIndexOfSeparator).replace(File.separatorChar, '.');
                    if (!exportAllPackages && !exportedPackages.contains(packagename)) continue;
                    returnList.add(packagename);
                }
            }
        }
        return returnList;
    }

    private List<String> getFilesWithUnnamedPackages(Map<Path, Collection<String>> sourcePaths) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.sourcepath)) {
            return returnList;
        }
        for (Map.Entry<Path, Collection<String>> currentPathEntry : sourcePaths.entrySet()) {
            Path currentSourcePath = currentPathEntry.getKey();
            for (String currentFile : currentPathEntry.getValue()) {
                if (currentFile.contains("doc-files") || currentFile.indexOf(File.separatorChar) != -1) continue;
                returnList.add(currentSourcePath.resolve(currentFile).toAbsolutePath().toString());
            }
        }
        return returnList;
    }

    private List<String> getSpecialFiles(Map<Path, Collection<String>> sourcePaths) {
        Collection<String> sourcepathFiles;
        if (!StringUtils.isEmpty((String)this.sourcepath)) {
            return new ArrayList<String>();
        }
        boolean containsModuleDescriptor = false;
        Iterator<Collection<String>> iterator = sourcePaths.values().iterator();
        while (iterator.hasNext() && !(containsModuleDescriptor = (sourcepathFiles = iterator.next()).contains("module-info.java"))) {
        }
        if (containsModuleDescriptor) {
            return this.getModuleSourcePathFiles(sourcePaths);
        }
        return this.getFilesWithUnnamedPackages(sourcePaths);
    }

    private List<String> getModuleSourcePathFiles(Map<Path, Collection<String>> sourcePaths) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (Map.Entry<Path, Collection<String>> currentPathEntry : sourcePaths.entrySet()) {
            Path currentSourcePath = currentPathEntry.getKey();
            if (currentPathEntry.getValue().contains("module-info.java")) {
                returnList.add(currentSourcePath.resolve("module-info.java").toAbsolutePath().toString());
                continue;
            }
            for (String currentFile : currentPathEntry.getValue()) {
                if (currentFile.contains("doc-files")) continue;
                returnList.add(currentSourcePath.resolve(currentFile).toAbsolutePath().toString());
            }
        }
        return returnList;
    }

    private void addCommandLineOptions(Commandline cmd, List<String> arguments, File javadocOutputDirectory) throws MavenReportException {
        File optionsFile = new File(javadocOutputDirectory, OPTIONS_FILE_NAME);
        StringBuilder options = new StringBuilder();
        options.append(StringUtils.join(arguments.iterator(), (String)SystemUtils.LINE_SEPARATOR));
        String outputFileEncoding = null;
        if (JAVA_VERSION.isAtLeast("9")) {
            outputFileEncoding = StandardCharsets.UTF_8.name();
        }
        try {
            FileUtils.fileWrite((String)optionsFile.getAbsolutePath(), (String)outputFileEncoding, (String)options.toString());
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to write '" + optionsFile.getName() + "' temporary file for command execution", (Exception)e);
        }
        cmd.createArg().setValue("@options");
    }

    private void addCommandLineArgFile(Commandline cmd, File javadocOutputDirectory, List<String> files) throws MavenReportException {
        File argfileFile;
        if (JAVA_VERSION.compareTo(SINCE_JAVADOC_1_4) >= 0) {
            argfileFile = new File(javadocOutputDirectory, ARGFILE_FILE_NAME);
            cmd.createArg().setValue("@argfile");
        } else {
            argfileFile = new File(javadocOutputDirectory, FILES_FILE_NAME);
            cmd.createArg().setValue("@files");
        }
        ArrayList<String> quotedFiles = new ArrayList<String>(files.size());
        for (String file : files) {
            quotedFiles.add(JavadocUtil.quotedPathArgument(file));
        }
        try {
            FileUtils.fileWrite((String)argfileFile.getAbsolutePath(), null, (String)StringUtils.join(quotedFiles.iterator(), (String)SystemUtils.LINE_SEPARATOR));
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to write '" + argfileFile.getName() + "' temporary file for command execution", (Exception)e);
        }
    }

    private void addCommandLinePackages(Commandline cmd, File javadocOutputDirectory, List<String> packageNames) throws MavenReportException {
        File packagesFile = new File(javadocOutputDirectory, PACKAGES_FILE_NAME);
        try {
            FileUtils.fileWrite((String)packagesFile.getAbsolutePath(), null, (String)StringUtils.join(packageNames.iterator(), (String)SystemUtils.LINE_SEPARATOR));
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to write '" + packagesFile.getName() + "' temporary file for command execution", (Exception)e);
        }
        cmd.createArg().setValue("@packages");
    }

    private void validateJavadocOptions() throws MavenReportException {
        if (StringUtils.isNotEmpty((String)this.getEncoding()) && !JavadocUtil.validateEncoding(this.getEncoding())) {
            throw new MavenReportException("Unsupported option <encoding/> '" + this.getEncoding() + "'");
        }
        if (StringUtils.isNotEmpty((String)this.locale)) {
            StringTokenizer tokenizer = new StringTokenizer(this.locale, "_");
            int maxTokens = 3;
            if (tokenizer.countTokens() > 3) {
                throw new MavenReportException("Unsupported option <locale/> '" + this.locale + "', should be language_country_variant.");
            }
            Locale localeObject = null;
            if (tokenizer.hasMoreTokens()) {
                String language = tokenizer.nextToken().toLowerCase(Locale.ENGLISH);
                if (!Arrays.asList(Locale.getISOLanguages()).contains(language)) {
                    throw new MavenReportException("Unsupported language '" + language + "' in option <locale/> '" + this.locale + "'");
                }
                localeObject = new Locale(language);
                if (tokenizer.hasMoreTokens()) {
                    String country = tokenizer.nextToken().toUpperCase(Locale.ENGLISH);
                    if (!Arrays.asList(Locale.getISOCountries()).contains(country)) {
                        throw new MavenReportException("Unsupported country '" + country + "' in option <locale/> '" + this.locale + "'");
                    }
                    localeObject = new Locale(language, country);
                    if (tokenizer.hasMoreTokens()) {
                        String variant = tokenizer.nextToken();
                        localeObject = new Locale(language, country, variant);
                    }
                }
            }
            if (localeObject == null) {
                throw new MavenReportException("Unsupported option <locale/> '" + this.locale + "', should be language_country_variant.");
            }
            this.locale = localeObject.toString();
            List<Locale> availableLocalesList = Arrays.asList(Locale.getAvailableLocales());
            if (StringUtils.isNotEmpty((String)localeObject.getVariant()) && !availableLocalesList.contains(localeObject)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Unsupported option <locale/> with variant '").append(this.locale);
                sb.append("'");
                localeObject = new Locale(localeObject.getLanguage(), localeObject.getCountry());
                this.locale = localeObject.toString();
                sb.append(", trying to use <locale/> without variant, i.e. '").append(this.locale).append("'");
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)sb.toString());
                }
            }
            if (!availableLocalesList.contains(localeObject)) {
                throw new MavenReportException("Unsupported option <locale/> '" + this.locale + "'");
            }
        }
    }

    private void validateStandardDocletOptions() throws MavenReportException {
        if (StringUtils.isNotEmpty((String)this.getDocencoding()) && !JavadocUtil.validateEncoding(this.getDocencoding())) {
            throw new MavenReportException("Unsupported option <docencoding/> '" + this.getDocencoding() + "'");
        }
        if (StringUtils.isNotEmpty((String)this.getCharset()) && !JavadocUtil.validateEncoding(this.getCharset())) {
            throw new MavenReportException("Unsupported option <charset/> '" + this.getCharset() + "'");
        }
        if (StringUtils.isNotEmpty((String)this.helpfile) && this.nohelp) {
            throw new MavenReportException("Option <nohelp/> conflicts with <helpfile/>");
        }
        if (this.getOverview() != null && this.nooverview) {
            throw new MavenReportException("Option <nooverview/> conflicts with <overview/>");
        }
        if (this.splitindex && this.noindex) {
            throw new MavenReportException("Option <noindex/> conflicts with <splitindex/>");
        }
        if (StringUtils.isNotEmpty((String)this.stylesheet) && !this.stylesheet.equalsIgnoreCase("maven") && !this.stylesheet.equalsIgnoreCase("java")) {
            throw new MavenReportException("Option <stylesheet/> supports only \"maven\" or \"java\" value.");
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void addJavadocOptions(File javadocOutputDirectory, List<String> arguments, Map<String, Collection<Path>> allSourcePaths, Set<OfflineLink> offlineLinks) throws MavenReportException {
        sourcePaths = this.collect(allSourcePaths.values());
        this.validateJavadocOptions();
        this.addArgIfNotEmpty(arguments, "-locale", JavadocUtil.quotedArgument(this.locale));
        if (this.old && this.isJavaDocVersionAtLeast(AbstractJavadocMojo.SINCE_JAVADOC_1_4)) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)"Javadoc 1.4+ doesn't support the -1.1 switch anymore. Ignore this option.");
            }
        } else {
            this.addArgIf(arguments, this.old, "-1.1");
        }
        this.addArgIfNotEmpty(arguments, "-bootclasspath", JavadocUtil.quotedPathArgument(this.getBootclassPath()));
        if (this.isJavaDocVersionAtLeast(AbstractJavadocMojo.SINCE_JAVADOC_1_5)) {
            this.addArgIf(arguments, this.breakiterator, "-breakiterator", AbstractJavadocMojo.SINCE_JAVADOC_1_5);
        }
        reactorKeys = new HashMap<String, MavenProject>(this.reactorProjects.size());
        for (MavenProject reactorProject : this.reactorProjects) {
            reactorKeys.put(ArtifactUtils.versionlessKey((String)reactorProject.getGroupId(), (String)reactorProject.getArtifactId()), reactorProject);
        }
        allModuleDescriptors = new HashMap<String, JavaModuleDescriptor>();
        v0 = supportModulePath = !(this.javadocRuntimeVersion.isAtLeast("9") == false || this.source != null && JavaVersion.parse((String)this.source).isAtLeast("9") == false || this.release != null && JavaVersion.parse((String)this.release).isAtLeast("9") == false);
        if (supportModulePath) {
            for (Map.Entry<String, Collection<Path>> entry : allSourcePaths.entrySet()) {
                entryProject = (MavenProject)reactorKeys.get(entry.getKey());
                artifactFile = entryProject != null ? this.getArtifactFile(entryProject) : ((Artifact)this.project.getArtifactMap().get(entry.getKey())).getFile();
                resolvePathResult = this.getResolvePathResult(artifactFile);
                if (resolvePathResult == null || resolvePathResult.getModuleNameSource() == ModuleNameSource.FILENAME) {
                    moduleDescriptor = this.findMainDescriptor(entry.getValue());
                    if (moduleDescriptor == null) continue;
                    try {
                        allModuleDescriptors.put(entry.getKey(), this.locationManager.parseModuleDescriptor(moduleDescriptor).getModuleDescriptor());
                        continue;
                    }
                    catch (IOException e) {
                        throw new MavenReportException(e.getMessage(), (Exception)e);
                    }
                }
                allModuleDescriptors.put(entry.getKey(), resolvePathResult.getModuleDescriptor());
            }
        }
        additionalModules = new ArrayList<String>();
        mainResolvePathResult = null;
        patchModules = new HashMap<String, V>();
        moduleSourceDir = null;
        if (supportModulePath && !allModuleDescriptors.isEmpty()) {
            unnamedProjects = new ArrayList<K>();
            for (Map.Entry projectSourcepaths : allSourcePaths.entrySet()) {
                aggregatedProject = (MavenProject)reactorKeys.get(projectSourcepaths.getKey());
                if (aggregatedProject != null && !"pom".equals(aggregatedProject.getPackaging())) {
                    result = null;
                    artifactFile = this.getArtifactFile(aggregatedProject);
                    if (artifactFile != null) {
                        request = ResolvePathRequest.ofFile((File)artifactFile);
                        try {
                            result = this.locationManager.resolvePath(request);
                        }
                        catch (RuntimeException e) {
                            if ("java.lang.module.FindException".equals(e.getClass().getName())) ** GOTO lbl64
                            throw e;
                        }
                        catch (IOException e) {
                            throw new MavenReportException(e.getMessage(), (Exception)e);
                        }
                    } else {
                        moduleDescriptor = this.findMainDescriptor((Collection)projectSourcepaths.getValue());
                        if (moduleDescriptor != null) {
                            try {
                                result = this.locationManager.parseModuleDescriptor(moduleDescriptor);
                            }
                            catch (IOException e) {
                                throw new MavenReportException(e.getMessage(), (Exception)e);
                            }
                        }
                    }
lbl64:
                    // 5 sources

                    if (result != null && result.getModuleDescriptor() != null) {
                        moduleSourceDir = javadocOutputDirectory.toPath().resolve("src");
                        try {
                            moduleSourceDir = Files.createDirectories(moduleSourceDir, new FileAttribute[0]);
                            additionalModules.add(result.getModuleDescriptor().name());
                            patchModules.put(result.getModuleDescriptor().name(), projectSourcepaths.getValue());
                            modulePath = moduleSourceDir.resolve(result.getModuleDescriptor().name());
                            if (Files.isDirectory(modulePath, new LinkOption[0])) ** GOTO lbl81
                            Files.createDirectory(modulePath, new FileAttribute[0]);
                        }
                        catch (IOException e) {
                            throw new MavenReportException(e.getMessage(), (Exception)e);
                        }
                    } else {
                        unnamedProjects.add(projectSourcepaths.getKey());
                    }
lbl81:
                    // 3 sources

                    if (!aggregatedProject.equals((Object)this.getProject())) continue;
                    mainResolvePathResult = result;
                    continue;
                }
                this.getLog().error((CharSequence)("no reactor project: " + (String)projectSourcepaths.getKey()));
            }
            if (!unnamedProjects.isEmpty()) {
                this.getLog().error((CharSequence)"Creating an aggregated report for both named and unnamed modules is not possible.");
                this.getLog().error((CharSequence)"Ensure that every module has a module descriptor or is a jar with a MANIFEST.MF containing an Automatic-Module-Name.");
                this.getLog().error((CharSequence)"Fix the following projects:");
                for (String unnamedProject : unnamedProjects) {
                    this.getLog().error((CharSequence)(" - " + unnamedProject));
                }
                throw new MavenReportException("Aggregator report contains named and unnamed modules");
            }
            if (mainResolvePathResult != null && ModuleNameSource.MANIFEST.equals((Object)mainResolvePathResult.getModuleNameSource())) {
                arguments.add("--add-modules");
                arguments.add("ALL-MODULE-PATH");
            }
        }
        moduleDescriptorSource = false;
        for (Path sourcepath : sourcePaths) {
            if (!Files.isRegularFile(sourcepath.resolve("module-info.java"), new LinkOption[0])) continue;
            moduleDescriptorSource = true;
            break;
        }
        mainModuleNameSource = mainResolvePathResult != null ? mainResolvePathResult.getModuleNameSource() : null;
        if (supportModulePath && !this.isTest() && (this.isAggregator() || ModuleNameSource.MODULEDESCRIPTOR.equals((Object)mainModuleNameSource) || ModuleNameSource.MANIFEST.equals((Object)mainModuleNameSource))) {
            pathElements = new ArrayList<File>(this.getPathElements());
            artifactFile = this.getArtifactFile(this.project);
            if (artifactFile != null) {
                pathElements.add(0, artifactFile);
            }
            request = ResolvePathsRequest.ofFiles(pathElements);
            mainModuleName = null;
            if (mainResolvePathResult != null) {
                request.setModuleDescriptor(mainResolvePathResult.getModuleDescriptor());
                mainModuleName = mainResolvePathResult.getModuleDescriptor().name();
            }
            request.setAdditionalModules(additionalModules);
            try {
                result = this.locationManager.resolvePaths(request);
                modulePathElements = new HashSet<K>(result.getModulepathElements().keySet());
                classPathElements = new ArrayList<File>(result.getClasspathElements().size());
                for (File file : result.getClasspathElements()) {
                    if (file.isDirectory() && new File(file, "module-info.class").exists()) {
                        modulePathElements.add(file);
                        continue;
                    }
                    if (ModuleNameSource.MANIFEST.equals((Object)mainModuleNameSource)) {
                        depModuleNameSource = this.locationManager.resolvePath(ResolvePathRequest.ofFile((File)file)).getModuleNameSource();
                        if (ModuleNameSource.MODULEDESCRIPTOR.equals((Object)depModuleNameSource) || ModuleNameSource.MANIFEST.equals((Object)depModuleNameSource)) {
                            modulePathElements.add(file);
                            continue;
                        }
                        ((Collection)patchModules.get(mainModuleName)).add(file.toPath());
                        continue;
                    }
                    classPathElements.add(file);
                }
                classpath = StringUtils.join(classPathElements.iterator(), (String)File.pathSeparator);
                this.addArgIfNotEmpty(arguments, "--class-path", JavadocUtil.quotedPathArgument(classpath), false, false);
                modulepath = StringUtils.join(modulePathElements.iterator(), (String)File.pathSeparator);
                this.addArgIfNotEmpty(arguments, "--module-path", JavadocUtil.quotedPathArgument(modulepath), false, false);
            }
            catch (IOException e) {
                throw new MavenReportException(e.getMessage(), (Exception)e);
            }
        } else if (supportModulePath && moduleDescriptorSource && !this.isTest()) {
            modulepath = StringUtils.join(this.getPathElements().iterator(), (String)File.pathSeparator);
            this.addArgIfNotEmpty(arguments, "--module-path", JavadocUtil.quotedPathArgument(modulepath), false, false);
        } else {
            classpath = StringUtils.join(this.getPathElements().iterator(), (String)File.pathSeparator);
            this.addArgIfNotEmpty(arguments, "-classpath", JavadocUtil.quotedPathArgument(classpath), false, false);
        }
        for (Map.Entry<K, V> entry : patchModules.entrySet()) {
            this.addArgIfNotEmpty(arguments, "--patch-module", (String)entry.getKey() + '=' + JavadocUtil.quotedPathArgument(this.getSourcePath((Collection)entry.getValue())), false, false);
        }
        if (StringUtils.isNotEmpty((String)this.doclet)) {
            this.addArgIfNotEmpty(arguments, "-doclet", JavadocUtil.quotedArgument(this.doclet));
            this.addArgIfNotEmpty(arguments, "-docletpath", JavadocUtil.quotedPathArgument(this.getDocletPath()));
        }
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.getLog().warn((CharSequence)("Source files encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
        }
        this.addArgIfNotEmpty(arguments, "-encoding", JavadocUtil.quotedArgument(this.getEncoding()));
        this.addArgIfNotEmpty(arguments, "-extdirs", JavadocUtil.quotedPathArgument(JavadocUtil.unifyPathSeparator(this.extdirs)));
        if (this.getOverview() != null && this.getOverview().exists()) {
            this.addArgIfNotEmpty(arguments, "-overview", JavadocUtil.quotedPathArgument(this.getOverview().getAbsolutePath()));
        }
        arguments.add(this.getAccessLevel());
        if (this.isJavaDocVersionAtLeast(AbstractJavadocMojo.SINCE_JAVADOC_1_5)) {
            this.addArgIf(arguments, this.quiet, "-quiet", AbstractJavadocMojo.SINCE_JAVADOC_1_5);
        }
        if (this.release != null) {
            arguments.add("--release");
            arguments.add(this.release);
        } else {
            this.addArgIfNotEmpty(arguments, "-source", JavadocUtil.quotedArgument(this.source), AbstractJavadocMojo.SINCE_JAVADOC_1_4);
        }
        if (StringUtils.isEmpty((String)this.sourcepath) && StringUtils.isNotEmpty((String)this.subpackages)) {
            this.sourcepath = StringUtils.join(sourcePaths.iterator(), (String)File.pathSeparator);
        }
        if (moduleSourceDir == null) {
            this.addArgIfNotEmpty(arguments, "-sourcepath", JavadocUtil.quotedPathArgument(this.getSourcePath(sourcePaths)), false, false);
        } else if (mainResolvePathResult == null || ModuleNameSource.MODULEDESCRIPTOR.equals((Object)mainResolvePathResult.getModuleNameSource())) {
            this.addArgIfNotEmpty(arguments, "--module-source-path", JavadocUtil.quotedPathArgument(moduleSourceDir.toString()));
        }
        if (StringUtils.isNotEmpty((String)this.sourcepath) && this.isJavaDocVersionAtLeast(AbstractJavadocMojo.SINCE_JAVADOC_1_5)) {
            this.addArgIfNotEmpty(arguments, "-subpackages", this.subpackages, AbstractJavadocMojo.SINCE_JAVADOC_1_5);
        }
        this.addArgIfNotEmpty(arguments, "-exclude", this.getExcludedPackages(sourcePaths), AbstractJavadocMojo.SINCE_JAVADOC_1_4);
        this.addArgIf(arguments, this.verbose, "-verbose");
        if (this.additionalOptions != null && this.additionalOptions.length > 0) {
            for (String additionalOption : this.additionalOptions) {
                arguments.add(additionalOption.replaceAll("(?<!\\\\)\\\\(?!\\\\|:)", "\\\\"));
            }
        }
    }

    private ResolvePathResult getResolvePathResult(File artifactFile) {
        if (artifactFile == null) {
            return null;
        }
        ResolvePathResult resolvePathResult = null;
        ResolvePathRequest resolvePathRequest = ResolvePathRequest.ofFile((File)artifactFile);
        try {
            resolvePathResult = this.locationManager.resolvePath(resolvePathRequest);
            if (resolvePathResult.getModuleDescriptor() == null) {
                return null;
            }
        }
        catch (IOException | RuntimeException e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            this.getLog().warn((CharSequence)e.getMessage());
        }
        return resolvePathResult;
    }

    private File findMainDescriptor(Collection<Path> roots) throws MavenReportException {
        for (Map.Entry<Path, Collection<String>> entry : this.getFiles(roots).entrySet()) {
            if (!entry.getValue().contains("module-info.java")) continue;
            return entry.getKey().resolve("module-info.java").toFile();
        }
        return null;
    }

    private void addStandardDocletOptions(File javadocOutputDirectory, List<String> arguments, Set<OfflineLink> offlineLinks) throws MavenReportException {
        this.validateStandardDocletOptions();
        this.addArgIf(arguments, this.author, "-author");
        this.addArgIfNotEmpty(arguments, "-bottom", JavadocUtil.quotedArgument(this.getBottomText()), false, false);
        if (!this.isJavaDocVersionAtLeast(SINCE_JAVADOC_1_5)) {
            this.addArgIf(arguments, this.breakiterator, "-breakiterator", SINCE_JAVADOC_1_4);
        }
        this.addArgIfNotEmpty(arguments, "-charset", JavadocUtil.quotedArgument(this.getCharset()));
        this.addArgIfNotEmpty(arguments, "-d", JavadocUtil.quotedPathArgument(javadocOutputDirectory.toString()));
        this.addArgIfNotEmpty(arguments, "-docencoding", JavadocUtil.quotedArgument(this.getDocencoding()));
        this.addArgIf(arguments, this.docfilessubdirs, "-docfilessubdirs", SINCE_JAVADOC_1_4);
        this.addArgIf(arguments, StringUtils.isNotEmpty((String)this.doclint), "-Xdoclint:" + this.getDoclint(), SINCE_JAVADOC_1_8);
        this.addArgIfNotEmpty(arguments, "-doctitle", JavadocUtil.quotedArgument(this.getDoctitle()), false, false);
        if (this.docfilessubdirs) {
            this.addArgIfNotEmpty(arguments, "-excludedocfilessubdir", JavadocUtil.quotedPathArgument(this.excludedocfilessubdir), SINCE_JAVADOC_1_4);
        }
        this.addArgIfNotEmpty(arguments, "-footer", JavadocUtil.quotedArgument(this.footer), false, false);
        this.addGroups(arguments);
        this.addArgIfNotEmpty(arguments, "-header", JavadocUtil.quotedArgument(this.header), false, false);
        this.addArgIfNotEmpty(arguments, "-helpfile", JavadocUtil.quotedPathArgument(this.getHelpFile(javadocOutputDirectory)));
        this.addArgIf(arguments, this.keywords, "-keywords", SINCE_JAVADOC_1_4_2);
        this.addLinkArguments(arguments);
        this.addLinkofflineArguments(arguments, offlineLinks);
        this.addArgIf(arguments, this.linksource, "-linksource", SINCE_JAVADOC_1_4);
        if (this.sourcetab > 0) {
            if (this.javadocRuntimeVersion == SINCE_JAVADOC_1_4_2) {
                this.addArgIfNotEmpty(arguments, "-linksourcetab", String.valueOf(this.sourcetab));
            }
            this.addArgIfNotEmpty(arguments, "-sourcetab", String.valueOf(this.sourcetab), SINCE_JAVADOC_1_5);
        }
        this.addArgIf(arguments, this.nocomment, "-nocomment", SINCE_JAVADOC_1_4);
        this.addArgIf(arguments, this.nodeprecated, "-nodeprecated");
        this.addArgIf(arguments, this.nodeprecatedlist, "-nodeprecatedlist");
        this.addArgIf(arguments, this.nohelp, "-nohelp");
        this.addArgIf(arguments, this.noindex, "-noindex");
        this.addArgIf(arguments, this.nonavbar, "-nonavbar");
        this.addArgIf(arguments, this.nooverview, "-nooverview");
        this.addArgIfNotEmpty(arguments, "-noqualifier", JavadocUtil.quotedArgument(this.noqualifier), SINCE_JAVADOC_1_4);
        this.addArgIf(arguments, this.nosince, "-nosince");
        this.addArgIf(arguments, this.notimestamp, "-notimestamp", SINCE_JAVADOC_1_5);
        this.addArgIf(arguments, this.notree, "-notree");
        this.addArgIfNotEmpty(arguments, "-packagesheader", JavadocUtil.quotedArgument(this.packagesheader), SINCE_JAVADOC_1_4_2);
        if (!this.isJavaDocVersionAtLeast(SINCE_JAVADOC_1_5)) {
            this.addArgIf(arguments, this.quiet, "-quiet", SINCE_JAVADOC_1_4);
        }
        this.addArgIf(arguments, this.serialwarn, "-serialwarn");
        this.addArgIf(arguments, this.splitindex, "-splitindex");
        this.addArgIfNotEmpty(arguments, "-stylesheetfile", JavadocUtil.quotedPathArgument(this.getStylesheetFile(javadocOutputDirectory)));
        if (StringUtils.isNotEmpty((String)this.sourcepath) && !this.isJavaDocVersionAtLeast(SINCE_JAVADOC_1_5)) {
            this.addArgIfNotEmpty(arguments, "-subpackages", this.subpackages, SINCE_JAVADOC_1_4);
        }
        this.addArgIfNotEmpty(arguments, "-taglet", JavadocUtil.quotedArgument(this.taglet), SINCE_JAVADOC_1_4);
        this.addTaglets(arguments);
        this.addTagletsFromTagletArtifacts(arguments);
        this.addArgIfNotEmpty(arguments, "-tagletpath", JavadocUtil.quotedPathArgument(this.getTagletPath()), SINCE_JAVADOC_1_4);
        this.addTags(arguments);
        this.addArgIfNotEmpty(arguments, "-top", JavadocUtil.quotedArgument(this.top), false, false, SINCE_JAVADOC_1_6);
        this.addArgIf(arguments, this.use, "-use");
        this.addArgIf(arguments, this.version, "-version");
        this.addArgIfNotEmpty(arguments, "-windowtitle", JavadocUtil.quotedArgument(this.getWindowtitle()), false, false);
    }

    private void addGroups(List<String> arguments) throws MavenReportException {
        Set<Group> groups = this.collectGroups();
        if (JavadocUtil.isEmpty(groups)) {
            return;
        }
        for (Group group : groups) {
            if (group == null || StringUtils.isEmpty((String)group.getTitle()) || StringUtils.isEmpty((String)group.getPackages())) {
                if (!this.getLog().isWarnEnabled()) continue;
                this.getLog().warn((CharSequence)"A group option is empty. Ignore this option.");
                continue;
            }
            String groupTitle = StringUtils.replace((String)group.getTitle(), (String)",", (String)"&#44;");
            this.addArgIfNotEmpty(arguments, "-group", JavadocUtil.quotedArgument(groupTitle) + " " + JavadocUtil.quotedArgument(group.getPackages()), true);
        }
    }

    private void addTags(List<String> arguments) throws MavenReportException {
        Set<Tag> tags = this.collectTags();
        if (JavadocUtil.isEmpty(tags)) {
            return;
        }
        for (Tag tag : tags) {
            if (StringUtils.isEmpty((String)tag.getName())) {
                if (!this.getLog().isWarnEnabled()) continue;
                this.getLog().warn((CharSequence)"A tag name is empty. Ignore this option.");
                continue;
            }
            String value = "\"" + tag.getName();
            if (StringUtils.isNotEmpty((String)tag.getPlacement())) {
                value = value + ":" + tag.getPlacement();
                if (StringUtils.isNotEmpty((String)tag.getHead())) {
                    value = value + ":" + tag.getHead();
                }
            }
            value = value + "\"";
            this.addArgIfNotEmpty(arguments, "-tag", value, SINCE_JAVADOC_1_4);
        }
    }

    private void addTaglets(List<String> arguments) {
        if (this.taglets == null) {
            return;
        }
        for (Taglet taglet1 : this.taglets) {
            if (taglet1 == null || StringUtils.isEmpty((String)taglet1.getTagletClass())) {
                if (!this.getLog().isWarnEnabled()) continue;
                this.getLog().warn((CharSequence)"A taglet option is empty. Ignore this option.");
                continue;
            }
            this.addArgIfNotEmpty(arguments, "-taglet", JavadocUtil.quotedArgument(taglet1.getTagletClass()), SINCE_JAVADOC_1_4);
        }
    }

    private void addTagletsFromTagletArtifacts(List<String> arguments) throws MavenReportException {
        LinkedHashSet<TagletArtifact> tArtifacts = new LinkedHashSet<TagletArtifact>();
        if (this.tagletArtifacts != null && this.tagletArtifacts.length > 0) {
            tArtifacts.addAll(Arrays.asList(this.tagletArtifacts));
        }
        if (this.includeDependencySources) {
            try {
                this.resolveDependencyBundles();
            }
            catch (IOException e) {
                throw new MavenReportException("Failed to resolve javadoc bundles from dependencies: " + e.getMessage(), (Exception)e);
            }
            if (JavadocUtil.isNotEmpty(this.dependencyJavadocBundles)) {
                for (JavadocBundle bundle : this.dependencyJavadocBundles) {
                    JavadocOptions options = bundle.getOptions();
                    if (options == null || !JavadocUtil.isNotEmpty(options.getTagletArtifacts())) continue;
                    tArtifacts.addAll(options.getTagletArtifacts());
                }
            }
        }
        if (JavadocUtil.isEmpty(tArtifacts)) {
            return;
        }
        List<String> tagletsPath = new ArrayList<String>();
        for (TagletArtifact aTagletArtifact : tArtifacts) {
            Artifact artifact;
            if (!StringUtils.isNotEmpty((String)aTagletArtifact.getGroupId()) || !StringUtils.isNotEmpty((String)aTagletArtifact.getArtifactId()) || !StringUtils.isNotEmpty((String)aTagletArtifact.getVersion())) continue;
            try {
                artifact = this.createAndResolveArtifact(aTagletArtifact);
            }
            catch (ArtifactResolverException e) {
                throw new MavenReportException("Unable to resolve artifact:" + aTagletArtifact, (Exception)((Object)e));
            }
            tagletsPath.add(artifact.getFile().getAbsolutePath());
        }
        tagletsPath = JavadocUtil.pruneFiles(tagletsPath);
        for (String tagletJar : tagletsPath) {
            List<String> tagletClasses;
            if (!tagletJar.toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
            try {
                tagletClasses = JavadocUtil.getTagletClassNames(new File(tagletJar));
            }
            catch (IOException e) {
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)("Unable to auto-detect Taglet class names from '" + tagletJar + "'. Try to specify them with <taglets/>."));
                }
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("IOException: " + e.getMessage()), (Throwable)e);
                continue;
            }
            catch (ClassNotFoundException e) {
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)("Unable to auto-detect Taglet class names from '" + tagletJar + "'. Try to specify them with <taglets/>."));
                }
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("ClassNotFoundException: " + e.getMessage()), (Throwable)e);
                continue;
            }
            catch (NoClassDefFoundError e) {
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)("Unable to auto-detect Taglet class names from '" + tagletJar + "'. Try to specify them with <taglets/>."));
                }
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("NoClassDefFoundError: " + e.getMessage()), (Throwable)e);
                continue;
            }
            if (tagletClasses == null || tagletClasses.isEmpty()) continue;
            for (String tagletClass : tagletClasses) {
                this.addArgIfNotEmpty(arguments, "-taglet", JavadocUtil.quotedArgument(tagletClass), SINCE_JAVADOC_1_4);
            }
        }
    }

    private void executeJavadocCommandLine(Commandline cmd, File javadocOutputDirectory) throws MavenReportException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)CommandLineUtils.toString((String[])cmd.getCommandline()).replaceAll("'", ""));
        }
        String cmdLine = null;
        if (this.debug) {
            cmdLine = CommandLineUtils.toString((String[])cmd.getCommandline()).replaceAll("'", "");
            this.writeDebugJavadocScript(cmdLine, javadocOutputDirectory);
        }
        JavadocUtil.JavadocOutputStreamConsumer err = new JavadocUtil.JavadocOutputStreamConsumer();
        JavadocUtil.JavadocOutputStreamConsumer out = new JavadocUtil.JavadocOutputStreamConsumer();
        try {
            String output;
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
            String string = output = StringUtils.isEmpty((String)out.getOutput()) ? null : '\n' + out.getOutput().trim();
            if (exitCode != 0) {
                if (cmdLine == null) {
                    cmdLine = CommandLineUtils.toString((String[])cmd.getCommandline()).replaceAll("'", "");
                }
                this.writeDebugJavadocScript(cmdLine, javadocOutputDirectory);
                if (StringUtils.isNotEmpty((String)output) && StringUtils.isEmpty((String)err.getOutput()) && this.isJavadocVMInitError(output)) {
                    throw new MavenReportException(output + '\n' + '\n' + "Error occurred during initialization of VM, try to reduce the Java heap size for the MAVEN_OPTS environment variable using -Xms:<size> and -Xmx:<size>." + '\n' + "Or, try to reduce the Java heap size for the Javadoc goal using -Dminmemory=<size> and -Dmaxmemory=<size>." + '\n' + '\n' + "Command line was: " + cmdLine + '\n' + '\n' + "Refer to the generated Javadoc files in '" + javadocOutputDirectory + "' dir.\n");
                }
                if (StringUtils.isNotEmpty((String)output)) {
                    this.getLog().info((CharSequence)output);
                }
                StringBuilder msg = new StringBuilder("\nExit code: ");
                msg.append(exitCode);
                if (StringUtils.isNotEmpty((String)err.getOutput())) {
                    msg.append(" - ").append(err.getOutput());
                }
                msg.append('\n');
                msg.append("Command line was: ").append(cmdLine).append('\n').append('\n');
                msg.append("Refer to the generated Javadoc files in '").append(javadocOutputDirectory).append("' dir.\n");
                throw new MavenReportException(msg.toString());
            }
            if (StringUtils.isNotEmpty(output)) {
                this.getLog().info((CharSequence)output);
            }
        }
        catch (CommandLineException e) {
            throw new MavenReportException("Unable to execute javadoc command: " + e.getMessage(), (Exception)((Object)e));
        }
        if (StringUtils.isNotEmpty((String)err.getOutput()) && this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)"Javadoc Warnings");
            StringTokenizer token = new StringTokenizer(err.getOutput(), "\n");
            while (token.hasMoreTokens()) {
                String current = token.nextToken().trim();
                this.getLog().warn((CharSequence)current);
            }
        }
        if (StringUtils.isNotEmpty((String)err.getOutput()) && this.failOnWarnings) {
            throw new MavenReportException("Project contains Javadoc Warnings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fixFrameInjectionBug(File javadocOutputDirectory, String outputEncoding) throws IOException {
        String fixData;
        InputStream in = null;
        try {
            in = ((Object)((Object)this)).getClass().getResourceAsStream("frame-injection-fix.txt");
            if (in == null) {
                throw new FileNotFoundException("Missing resource 'frame-injection-fix.txt' in classpath.");
            }
            fixData = StringUtils.unifyLineSeparators((String)IOUtil.toString((InputStream)in, (String)"US-ASCII")).trim();
            in.close();
            in = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(javadocOutputDirectory);
        ds.setCaseSensitive(false);
        ds.setIncludes(new String[]{"**/index.html", "**/index.htm", "**/toc.html", "**/toc.htm"});
        ds.addDefaultExcludes();
        ds.scan();
        int patched = 0;
        for (String f : ds.getIncludedFiles()) {
            String patchedFileContents;
            File file = new File(javadocOutputDirectory, f);
            String fileContents = FileUtils.fileRead((File)file, (String)outputEncoding);
            if (StringUtils.contains((String)fileContents, (String)"function validURL(url) {") || (patchedFileContents = StringUtils.replaceOnce((String)fileContents, (String)"function loadFrames() {", (String)fixData)).equals(fileContents)) continue;
            FileUtils.fileWrite((File)file, (String)outputEncoding, (String)patchedFileContents);
            ++patched;
        }
        return patched;
    }

    private String getResource(File outputFile, String inputResourceName) {
        if (inputResourceName.startsWith("/")) {
            inputResourceName = inputResourceName.replaceFirst("//*", "");
        }
        ArrayList<String> classPath = new ArrayList<String>();
        classPath.add(this.project.getBuild().getSourceDirectory());
        URL resourceURL = this.getResource(classPath, inputResourceName);
        if (resourceURL != null) {
            this.getLog().debug((CharSequence)(inputResourceName + " found in the main src directory of the project."));
            return FileUtils.toFile((URL)resourceURL).getAbsolutePath();
        }
        classPath.clear();
        List resources = this.project.getBuild().getResources();
        for (Resource resource : resources) {
            classPath.add(resource.getDirectory());
        }
        resourceURL = this.getResource(classPath, inputResourceName);
        if (resourceURL != null) {
            this.getLog().debug((CharSequence)(inputResourceName + " found in the main resources directories of the project."));
            return FileUtils.toFile((URL)resourceURL).getAbsolutePath();
        }
        if (this.javadocDirectory.exists()) {
            classPath.clear();
            classPath.add(this.javadocDirectory.getAbsolutePath());
            resourceURL = this.getResource(classPath, inputResourceName);
            if (resourceURL != null) {
                this.getLog().debug((CharSequence)(inputResourceName + " found in the main javadoc directory of the project."));
                return FileUtils.toFile((URL)resourceURL).getAbsolutePath();
            }
        }
        classPath.clear();
        String pluginId = "org.apache.maven.plugins:maven-javadoc-plugin";
        Plugin javadocPlugin = AbstractJavadocMojo.getPlugin(this.project, "org.apache.maven.plugins:maven-javadoc-plugin");
        if (javadocPlugin != null && javadocPlugin.getDependencies() != null) {
            List dependencies = javadocPlugin.getDependencies();
            for (Dependency dependency : dependencies) {
                JavadocPathArtifact javadocPathArtifact = new JavadocPathArtifact();
                javadocPathArtifact.setGroupId(dependency.getGroupId());
                javadocPathArtifact.setArtifactId(dependency.getArtifactId());
                javadocPathArtifact.setVersion(dependency.getVersion());
                Artifact artifact = null;
                try {
                    artifact = this.createAndResolveArtifact(javadocPathArtifact);
                }
                catch (Exception e) {
                    this.logError("Unable to retrieve the dependency: " + dependency + ". Ignored.", e);
                }
                if (artifact == null || !artifact.getFile().exists()) continue;
                classPath.add(artifact.getFile().getAbsolutePath());
            }
            resourceURL = this.getResource(classPath, inputResourceName);
            if (resourceURL != null) {
                this.getLog().debug((CharSequence)(inputResourceName + " found in javadoc plugin dependencies."));
                try {
                    JavadocUtil.copyResource(resourceURL, outputFile);
                    return outputFile.getAbsolutePath();
                }
                catch (IOException e) {
                    this.logError("IOException: " + e.getMessage(), e);
                }
            }
        }
        this.getLog().warn((CharSequence)("Unable to find the resource '" + inputResourceName + "'. Using default Javadoc resources."));
        return null;
    }

    private URL getResource(List<String> classPath, String resource) {
        ArrayList<URL> urls = new ArrayList<URL>(classPath.size());
        for (String filename : classPath) {
            try {
                urls.add(new File(filename).toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().error((CharSequence)("MalformedURLException: " + e.getMessage()));
            }
        }
        URLClassLoader javadocClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        return javadocClassLoader.getResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFullJavadocGoal() {
        InputStream resourceAsStream;
        String javadocPluginVersion;
        block6: {
            javadocPluginVersion = null;
            resourceAsStream = null;
            try {
                String resource = "META-INF/maven/org.apache.maven.plugins/maven-javadoc-plugin/pom.properties";
                resourceAsStream = AbstractJavadocMojo.class.getClassLoader().getResourceAsStream(resource);
                if (resourceAsStream == null) break block6;
                Properties properties = new Properties();
                properties.load(resourceAsStream);
                resourceAsStream.close();
                resourceAsStream = null;
                if (!StringUtils.isNotEmpty((String)properties.getProperty("version"))) break block6;
                javadocPluginVersion = properties.getProperty("version");
            }
            catch (IOException resource) {
                IOUtil.close(resourceAsStream);
            }
            catch (Throwable throwable) {
                IOUtil.close(resourceAsStream);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)resourceAsStream);
        StringBuilder sb = new StringBuilder();
        sb.append("org.apache.maven.plugins:maven-javadoc-plugin:");
        if (StringUtils.isNotEmpty(javadocPluginVersion)) {
            sb.append(javadocPluginVersion).append(":");
        }
        if (this instanceof TestJavadocReport) {
            sb.append("test-javadoc");
        } else {
            sb.append("javadoc");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OfflineLink> getModulesLinks() throws MavenReportException {
        if (!this.detectOfflineLinks || this.isAggregator() || this.reactorProjects == null) {
            return Collections.emptyList();
        }
        this.getLog().debug((CharSequence)"Trying to add links for modules...");
        HashSet<String> dependencyArtifactIds = new HashSet<String>();
        Set dependencyArtifacts = this.project.getDependencyArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            dependencyArtifactIds.add(artifact.getId());
        }
        ArrayList<OfflineLink> modulesLinks = new ArrayList<OfflineLink>();
        String javadocDirRelative = PathUtils.toRelative((File)this.project.getBasedir(), (String)this.getOutputDirectory());
        for (MavenProject p : this.reactorProjects) {
            if (!dependencyArtifactIds.contains(p.getArtifact().getId()) || p.getUrl() == null) continue;
            File location = new File(p.getBasedir(), javadocDirRelative);
            if (!location.exists()) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Javadoc directory not found: " + location));
                }
                String javadocGoal = this.getFullJavadocGoal();
                this.getLog().info((CharSequence)("The goal '" + javadocGoal + "' has not been previously called for the module: '" + p.getId() + "'. Trying to invoke it..."));
                File invokerDir = new File(this.project.getBuild().getDirectory(), "invoker");
                invokerDir.mkdirs();
                File invokerLogFile = FileUtils.createTempFile((String)"maven-javadoc-plugin", (String)".txt", (File)invokerDir);
                try {
                    JavadocUtil.invokeMaven(this.getLog(), new File(this.localRepository.getBasedir()), p.getFile(), Collections.singletonList(javadocGoal), null, invokerLogFile);
                }
                catch (MavenInvocationException e) {
                    this.logError("MavenInvocationException: " + e.getMessage(), e);
                    String invokerLogContent = JavadocUtil.readFile(invokerLogFile, null);
                    if (invokerLogContent != null && invokerLogContent.contains("Error occurred during initialization of VM, try to reduce the Java heap size for the MAVEN_OPTS environment variable using -Xms:<size> and -Xmx:<size>.")) {
                        throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
                    }
                }
                finally {
                    if (!location.exists()) {
                        this.getLog().warn((CharSequence)("Creating fake javadoc directory to prevent repeated invocations: " + location));
                        location.mkdirs();
                    }
                }
            }
            if (!location.exists()) continue;
            String url = AbstractJavadocMojo.getJavadocLink(p);
            OfflineLink ol = new OfflineLink();
            ol.setUrl(url);
            ol.setLocation(location.getAbsolutePath());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Added Javadoc offline link: " + url + " for the module: " + p.getId()));
            }
            modulesLinks.add(ol);
        }
        return modulesLinks;
    }

    private List<String> getDependenciesLinks() {
        if (!this.detectLinks) {
            return Collections.emptyList();
        }
        this.getLog().debug((CharSequence)"Trying to add links for dependencies...");
        ArrayList<String> dependenciesLinks = new ArrayList<String>();
        Set dependencies = this.project.getDependencyArtifacts();
        for (Artifact artifact : dependencies) {
            if (artifact.getFile() == null || !artifact.getFile().exists()) continue;
            try {
                String url;
                MavenProject artifactProject = this.mavenProjectBuilder.build(artifact, this.getProjectBuildingRequest(this.project)).getProject();
                if (!StringUtils.isNotEmpty((String)artifactProject.getUrl()) || !this.isValidJavadocLink(url = AbstractJavadocMojo.getJavadocLink(artifactProject), true)) continue;
                this.getLog().debug((CharSequence)("Added Javadoc link: " + url + " for " + artifactProject.getId()));
                dependenciesLinks.add(url);
            }
            catch (ProjectBuildingException e) {
                this.logError("ProjectBuildingException for " + artifact.toString() + ": " + e.getMessage(), e);
            }
        }
        return dependenciesLinks;
    }

    protected final OfflineLink getDefaultJavadocApiLink() {
        String resourceName;
        Path javaApiListFile;
        JavaVersion javaApiversion;
        if (!this.detectJavaApiLink) {
            return null;
        }
        if (this.release != null) {
            javaApiversion = JavaVersion.parse((String)this.release);
        } else {
            String pluginId = "org.apache.maven.plugins:maven-compiler-plugin";
            String sourceConfigured = AbstractJavadocMojo.getPluginParameter(this.project, "org.apache.maven.plugins:maven-compiler-plugin", "source");
            if (sourceConfigured != null) {
                javaApiversion = JavaVersion.parse((String)sourceConfigured);
            } else {
                this.getLog().debug((CharSequence)("No maven-compiler-plugin defined in ${build.plugins} or in ${project.build.pluginManagement} for the " + this.project.getId() + ". Added Javadoc API link according the javadoc executable version i.e.: " + this.javadocRuntimeVersion));
                javaApiversion = this.javadocRuntimeVersion;
            }
        }
        String javaApiKey = javaApiversion.asMajor().isAtLeast("9") ? "api_" + javaApiversion.asMajor() : "api_1." + javaApiversion.asMajor().toString().charAt(0);
        String javaApiLink = this.javaApiLinks != null && this.javaApiLinks.containsKey(javaApiKey) ? this.javaApiLinks.getProperty(javaApiKey) : (javaApiversion.isAtLeast("11") ? String.format("https://docs.oracle.com/en/java/javase/%s/docs/api/", javaApiversion.getValue(1)) : (javaApiversion.asMajor().isAtLeast("6") ? String.format("https://docs.oracle.com/javase/%s/docs/api/", javaApiversion.asMajor().getValue(1)) : (javaApiversion.isAtLeast("1.5") ? "https://docs.oracle.com/javase/1.5.0/docs/api/" : null)));
        if (this.getLog().isDebugEnabled()) {
            if (javaApiLink != null) {
                this.getLog().debug((CharSequence)("Found Java API link: " + javaApiLink));
            } else {
                this.getLog().debug((CharSequence)"No Java API link found.");
            }
        }
        if (javaApiLink == null) {
            return null;
        }
        if (javaApiversion.isAtLeast("10")) {
            javaApiListFile = this.getJavadocOptionsFile().getParentFile().toPath().resolve(ELEMENT_LIST);
            resourceName = "java-api-element-list-" + javaApiversion.toString().substring(0, 2);
        } else if (javaApiversion.asMajor().isAtLeast("9")) {
            javaApiListFile = this.getJavadocOptionsFile().getParentFile().toPath().resolve(PACKAGE_LIST);
            resourceName = "java-api-package-list-9";
        } else {
            javaApiListFile = this.getJavadocOptionsFile().getParentFile().toPath().resolve(PACKAGE_LIST);
            resourceName = "java-api-package-list-1." + javaApiversion.asMajor().toString().charAt(0);
        }
        OfflineLink link = new OfflineLink();
        link.setLocation(javaApiListFile.getParent().toAbsolutePath().toString());
        link.setUrl(javaApiLink);
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);
        if (in != null) {
            try (InputStream closableIS = in;){
                Files.copy(closableIS, javaApiListFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ioe) {
                this.logError("Can't get " + resourceName + ": " + ioe.getMessage(), ioe);
                return null;
            }
        }
        return link;
    }

    private Set<String> followLinks(Set<String> links) {
        LinkedHashSet<String> redirectLinks = new LinkedHashSet<String>(links.size());
        for (String link : links) {
            try {
                redirectLinks.add(JavadocUtil.getRedirectUrl(new URI(link).toURL(), this.settings).toString());
            }
            catch (Exception e) {
                this.getLog().debug((CharSequence)("Could not follow " + link + ". Reason: " + e.getMessage()));
            }
        }
        return redirectLinks;
    }

    protected boolean isValidJavadocLink(String link, boolean detecting) {
        try {
            URI elementListUri;
            URI packageListUri;
            if (link.trim().toLowerCase(Locale.ENGLISH).startsWith("http:") || link.trim().toLowerCase(Locale.ENGLISH).startsWith("https:") || link.trim().toLowerCase(Locale.ENGLISH).startsWith("ftp:") || link.trim().toLowerCase(Locale.ENGLISH).startsWith("file:")) {
                packageListUri = new URI(link + '/' + PACKAGE_LIST);
                elementListUri = new URI(link + '/' + ELEMENT_LIST);
            } else {
                File dir = new File(link);
                if (!dir.isAbsolute()) {
                    dir = new File(this.getOutputDirectory(), link);
                }
                if (!dir.isDirectory()) {
                    if (detecting) {
                        this.getLog().warn((CharSequence)("The given File link: " + dir + " is not a dir."));
                    } else {
                        this.getLog().error((CharSequence)("The given File link: " + dir + " is not a dir."));
                    }
                }
                packageListUri = new File(dir, PACKAGE_LIST).toURI();
                elementListUri = new File(dir, ELEMENT_LIST).toURI();
            }
            IOException elementListIOException = null;
            try {
                if (JavadocUtil.isValidElementList(elementListUri.toURL(), this.settings, this.validateLinks)) {
                    return true;
                }
            }
            catch (IOException e) {
                elementListIOException = e;
            }
            if (JavadocUtil.isValidPackageList(packageListUri.toURL(), this.settings, this.validateLinks)) {
                return true;
            }
            if (this.getLog().isErrorEnabled()) {
                if (detecting) {
                    this.getLog().warn((CharSequence)("Invalid links: " + link + " with /" + PACKAGE_LIST + " or / " + ELEMENT_LIST + ". Ignored it."));
                } else {
                    this.getLog().error((CharSequence)("Invalid links: " + link + " with /" + PACKAGE_LIST + " or / " + ELEMENT_LIST + ". Ignored it."));
                }
            }
            return false;
        }
        catch (URISyntaxException e) {
            if (this.getLog().isErrorEnabled()) {
                if (detecting) {
                    this.getLog().warn((CharSequence)("Malformed link: " + e.getInput() + ". Ignored it."));
                } else {
                    this.getLog().error((CharSequence)("Malformed link: " + e.getInput() + ". Ignored it."));
                }
            }
            return false;
        }
        catch (IOException e) {
            if (this.getLog().isErrorEnabled()) {
                if (detecting) {
                    this.getLog().warn((CharSequence)("Error fetching link: " + link + ". Ignored it."));
                } else {
                    this.getLog().error((CharSequence)("Error fetching link: " + link + ". Ignored it."));
                }
            }
            return false;
        }
    }

    private void writeDebugJavadocScript(String cmdLine, File javadocOutputDirectory) {
        File commandLineFile = new File(javadocOutputDirectory, DEBUG_JAVADOC_SCRIPT_NAME);
        commandLineFile.getParentFile().mkdirs();
        try {
            FileUtils.fileWrite((String)commandLineFile.getAbsolutePath(), null, (String)cmdLine);
            if (!SystemUtils.IS_OS_WINDOWS) {
                Runtime.getRuntime().exec(new String[]{"chmod", "a+x", commandLineFile.getAbsolutePath()});
            }
        }
        catch (IOException e) {
            this.logError("Unable to write '" + commandLineFile.getName() + "' debug script file", e);
        }
    }

    private boolean isJavadocVMInitError(String output) {
        return !output.contains("Javadoc") && !output.contains("javadoc");
    }

    private static String getJavadocLink(MavenProject p) {
        if (p.getUrl() == null) {
            return null;
        }
        String url = AbstractJavadocMojo.cleanUrl(p.getUrl());
        String destDir = "apidocs";
        String pluginId = "org.apache.maven.plugins:maven-javadoc-plugin";
        String destDirConfigured = AbstractJavadocMojo.getPluginParameter(p, "org.apache.maven.plugins:maven-javadoc-plugin", "destDir");
        if (destDirConfigured != null) {
            destDir = destDirConfigured;
        }
        return url + "/" + destDir;
    }

    private static String cleanUrl(String url) {
        if (url == null) {
            return "";
        }
        url = url.trim();
        while (url.endsWith("/")) {
            url = url.substring(0, url.lastIndexOf("/"));
        }
        return url;
    }

    private static Plugin getPlugin(MavenProject p, String pluginId) {
        if (p.getBuild() == null || p.getBuild().getPluginsAsMap() == null) {
            return null;
        }
        Plugin plugin = (Plugin)p.getBuild().getPluginsAsMap().get(pluginId);
        if (plugin == null && p.getBuild().getPluginManagement() != null && p.getBuild().getPluginManagement().getPluginsAsMap() != null) {
            plugin = (Plugin)p.getBuild().getPluginManagement().getPluginsAsMap().get(pluginId);
        }
        return plugin;
    }

    private static String getPluginParameter(MavenProject p, String pluginId, String param) {
        Xpp3Dom xpp3Dom;
        Plugin plugin = AbstractJavadocMojo.getPlugin(p, pluginId);
        if (plugin != null && (xpp3Dom = (Xpp3Dom)plugin.getConfiguration()) != null && xpp3Dom.getChild(param) != null && StringUtils.isNotEmpty((String)xpp3Dom.getChild(param).getValue())) {
            return xpp3Dom.getChild(param).getValue();
        }
        return null;
    }

    protected final File getJavadocOptionsFile() {
        if (this.javadocOptionsDir != null && !this.javadocOptionsDir.exists()) {
            this.javadocOptionsDir.mkdirs();
        }
        return new File(this.javadocOptionsDir, "javadoc-options-" + this.getAttachmentClassifier() + ".xml");
    }

    protected final JavadocOptions buildJavadocOptions() throws IOException {
        JavadocOptions options = new JavadocOptions();
        options.setBootclasspathArtifacts(JavadocUtil.toList(this.bootclasspathArtifacts));
        options.setDocfilesSubdirsUsed(this.docfilessubdirs);
        options.setDocletArtifacts(JavadocUtil.toList(this.docletArtifact, this.docletArtifacts));
        options.setExcludedDocfilesSubdirs(this.excludedocfilessubdir);
        options.setExcludePackageNames(JavadocUtil.toList(this.excludePackageNames));
        options.setGroups(JavadocUtil.toList(this.groups));
        options.setLinks(this.links);
        options.setOfflineLinks(JavadocUtil.toList(this.offlineLinks));
        options.setResourcesArtifacts(JavadocUtil.toList(this.resourcesArtifacts));
        options.setTagletArtifacts(JavadocUtil.toList(this.tagletArtifact, this.tagletArtifacts));
        options.setTaglets(JavadocUtil.toList(this.taglets));
        options.setTags(JavadocUtil.toList(this.tags));
        if (this.getProject() != null && this.getJavadocDirectory() != null) {
            options.setJavadocResourcesDirectory(JavadocUtil.toRelative(this.getProject().getBasedir(), this.getJavadocDirectory().getAbsolutePath()));
        }
        File optionsFile = this.getJavadocOptionsFile();
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)optionsFile);){
            new JavadocOptionsXpp3Writer().write((Writer)writer, options);
        }
        return options;
    }

    protected String getAttachmentClassifier() {
        return JAVADOC_RESOURCES_ATTACHMENT_CLASSIFIER;
    }

    protected void logError(String message, Throwable t) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().error((CharSequence)message, t);
        } else {
            this.getLog().error((CharSequence)message);
        }
    }

    protected void failOnError(String prefix, Exception e) throws MojoExecutionException {
        if (this.failOnError) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new MojoExecutionException(prefix + ": " + e.getMessage(), e);
        }
        this.getLog().error((CharSequence)(prefix + ": " + e.getMessage()), (Throwable)e);
    }
}

