// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 2.0.0,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.plugins.javadoc.options.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import org.apache.maven.plugins.javadoc.options.BootclasspathArtifact;
import org.apache.maven.plugins.javadoc.options.DocletArtifact;
import org.apache.maven.plugins.javadoc.options.Group;
import org.apache.maven.plugins.javadoc.options.JavadocOptions;
import org.apache.maven.plugins.javadoc.options.JavadocPathArtifact;
import org.apache.maven.plugins.javadoc.options.OfflineLink;
import org.apache.maven.plugins.javadoc.options.ResourcesArtifact;
import org.apache.maven.plugins.javadoc.options.Tag;
import org.apache.maven.plugins.javadoc.options.Taglet;
import org.apache.maven.plugins.javadoc.options.TagletArtifact;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/**
 * Class JavadocOptionsXpp3Reader.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class JavadocOptionsXpp3Reader
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * If set the parser will be loaded with all single characters
     * from the XHTML specification.
     * The entities used:
     * <ul>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent</li>
     * </ul>
     */
    private boolean addDefaultEntities = true;

    /**
     * Field contentTransformer.
     */
    public final ContentTransformer contentTransformer;


      //----------------/
     //- Constructors -/
    //----------------/

    public JavadocOptionsXpp3Reader()
    {
        this( new ContentTransformer()
        {
            public String transform( String source, String fieldName )
            {
                return source;
            }
        } );
    } //-- org.apache.maven.plugins.javadoc.options.io.xpp3.JavadocOptionsXpp3Reader()

    public JavadocOptionsXpp3Reader(ContentTransformer contentTransformer)
    {
        this.contentTransformer = contentTransformer;
    } //-- org.apache.maven.plugins.javadoc.options.io.xpp3.JavadocOptionsXpp3Reader(ContentTransformer)


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method checkFieldWithDuplicate.
     * 
     * @param parser a parser object.
     * @param parsed a parsed object.
     * @param alias a alias object.
     * @param tagName a tagName object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XmlPullParser parser, String tagName, String alias, java.util.Set parsed )
        throws XmlPullParserException
    {
        if ( !( parser.getName().equals( tagName ) || parser.getName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XmlPullParserException( "Duplicated tag: '" + tagName + "'", parser, null );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XmlPullParser, String, String, java.util.Set )

    /**
     * Method checkUnknownAttribute.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @param tagName a tagName object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownAttribute( XmlPullParser parser, String attribute, String tagName, boolean strict )
        throws XmlPullParserException, IOException
    {
        // strictXmlAttributes = true for model: if strict == true, not only elements are checked but attributes too
        if ( strict )
        {
            throw new XmlPullParserException( "Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null );
        }
    } //-- void checkUnknownAttribute( XmlPullParser, String, String, boolean )

    /**
     * Method checkUnknownElement.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownElement( XmlPullParser parser, boolean strict )
        throws XmlPullParserException, IOException
    {
        if ( strict )
        {
            throw new XmlPullParserException( "Unrecognised tag: '" + parser.getName() + "'", parser, null );
        }

        for ( int unrecognizedTagCount = 1; unrecognizedTagCount > 0; )
        {
            int eventType = parser.next();
            if ( eventType == XmlPullParser.START_TAG )
            {
                unrecognizedTagCount++;
            }
            else if ( eventType == XmlPullParser.END_TAG )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XmlPullParser, boolean )

    /**
     * Returns the state of the "add default entities" flag.
     * 
     * @return boolean
     */
    public boolean getAddDefaultEntities()
    {
        return addDefaultEntities;
    } //-- boolean getAddDefaultEntities()

    /**
     * Method getBooleanValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getBooleanValue( s, attribute, parser, null );
    } //-- boolean getBooleanValue( String, String, XmlPullParser )

    /**
     * Method getBooleanValue.
     * 
     * @param s a s object.
     * @param defaultValue a defaultValue object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser, String defaultValue )
        throws XmlPullParserException
    {
        if ( s != null && s.length() != 0 )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        if ( defaultValue != null )
        {
            return Boolean.valueOf( defaultValue ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XmlPullParser, String )

    /**
     * Method getByteValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a byte", parser, nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XmlPullParser, boolean )

    /**
     * Method getCharacterValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getDateValue( s, attribute, null, parser );
    } //-- java.util.Date getDateValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param dateFormat a dateFormat object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, String dateFormat, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, java.util.Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue( String, String, String, XmlPullParser )

    /**
     * Method getDoubleValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XmlPullParser, boolean )

    /**
     * Method getFloatValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return float
     */
    private float getFloatValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XmlPullParser, boolean )

    /**
     * Method getIntegerValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be an integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue( String, String, XmlPullParser, boolean )

    /**
     * Method getLongValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return long
     */
    private long getLongValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a long integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XmlPullParser, boolean )

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XmlPullParserException( "Missing required value for attribute '" + attribute + "'", parser, null );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XmlPullParser, boolean )

    /**
     * Method getShortValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return short
     */
    private short getShortValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a short integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XmlPullParser, boolean )

    /**
     * Method getTrimmedValue.
     * 
     * @param s a s object.
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method interpolatedTrimmed.
     * 
     * @param value a value object.
     * @param context a context object.
     * @return String
     */
    private String interpolatedTrimmed( String value, String context )
    {
        return getTrimmedValue( contentTransformer.transform( value, context ) );
    } //-- String interpolatedTrimmed( String, String )

    /**
     * Method nextTag.
     * 
     * @param parser a parser object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int nextTag( XmlPullParser parser )
        throws IOException, XmlPullParserException
    {
        int eventType = parser.next();
        if ( eventType == XmlPullParser.TEXT )
        {
            eventType = parser.next();
        }
        if ( eventType != XmlPullParser.START_TAG && eventType != XmlPullParser.END_TAG )
        {
            throw new XmlPullParserException( "expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null );
        }
        return eventType;
    } //-- int nextTag( XmlPullParser )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader a reader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return JavadocOptions
     */
    public JavadocOptions read( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser( );

        parser.setInput( reader );


        return read( parser, strict );
    } //-- JavadocOptions read( Reader, boolean )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader a reader object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return JavadocOptions
     */
    public JavadocOptions read( Reader reader )
        throws IOException, XmlPullParserException
    {
        return read( reader, true );
    } //-- JavadocOptions read( Reader )

    /**
     * Method read.
     * 
     * @param in a in object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return JavadocOptions
     */
    public JavadocOptions read( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ), strict );
    } //-- JavadocOptions read( InputStream, boolean )

    /**
     * Method read.
     * 
     * @param in a in object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return JavadocOptions
     */
    public JavadocOptions read( InputStream in )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ) );
    } //-- JavadocOptions read( InputStream )

    /**
     * Method parseBootclasspathArtifact.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return BootclasspathArtifact
     */
    private BootclasspathArtifact parseBootclasspathArtifact( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        BootclasspathArtifact bootclasspathArtifact = new BootclasspathArtifact();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "groupId", null, parsed ) )
            {
                bootclasspathArtifact.setGroupId( interpolatedTrimmed( parser.nextText(), "groupId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "artifactId", null, parsed ) )
            {
                bootclasspathArtifact.setArtifactId( interpolatedTrimmed( parser.nextText(), "artifactId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "version", null, parsed ) )
            {
                bootclasspathArtifact.setVersion( interpolatedTrimmed( parser.nextText(), "version" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "classifier", null, parsed ) )
            {
                bootclasspathArtifact.setClassifier( interpolatedTrimmed( parser.nextText(), "classifier" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return bootclasspathArtifact;
    } //-- BootclasspathArtifact parseBootclasspathArtifact( XmlPullParser, boolean )

    /**
     * Method parseDocletArtifact.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return DocletArtifact
     */
    private DocletArtifact parseDocletArtifact( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DocletArtifact docletArtifact = new DocletArtifact();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "groupId", null, parsed ) )
            {
                docletArtifact.setGroupId( interpolatedTrimmed( parser.nextText(), "groupId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "artifactId", null, parsed ) )
            {
                docletArtifact.setArtifactId( interpolatedTrimmed( parser.nextText(), "artifactId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "version", null, parsed ) )
            {
                docletArtifact.setVersion( interpolatedTrimmed( parser.nextText(), "version" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "classifier", null, parsed ) )
            {
                docletArtifact.setClassifier( interpolatedTrimmed( parser.nextText(), "classifier" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return docletArtifact;
    } //-- DocletArtifact parseDocletArtifact( XmlPullParser, boolean )

    /**
     * Method parseGroup.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Group
     */
    private Group parseGroup( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Group group = new Group();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "title", null, parsed ) )
            {
                group.setTitle( interpolatedTrimmed( parser.nextText(), "title" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "packages", null, parsed ) )
            {
                group.setPackages( interpolatedTrimmed( parser.nextText(), "packages" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return group;
    } //-- Group parseGroup( XmlPullParser, boolean )

    /**
     * Method parseJavadocOptions.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return JavadocOptions
     */
    private JavadocOptions parseJavadocOptions( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        JavadocOptions javadocOptions = new JavadocOptions();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "xmlns".equals( name ) )
            {
                // ignore xmlns attribute in root class, which is a reserved attribute name
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "groups", null, parsed ) )
            {
                java.util.List<Group> groups = new java.util.ArrayList<Group>();
                javadocOptions.setGroups( groups );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "group".equals( parser.getName() ) )
                    {
                        groups.add( parseGroup( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "tags", null, parsed ) )
            {
                java.util.List<Tag> tags = new java.util.ArrayList<Tag>();
                javadocOptions.setTags( tags );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "tag".equals( parser.getName() ) )
                    {
                        tags.add( parseTag( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "docletArtifacts", null, parsed ) )
            {
                java.util.List<DocletArtifact> docletArtifacts = new java.util.ArrayList<DocletArtifact>();
                javadocOptions.setDocletArtifacts( docletArtifacts );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "docletArtifact".equals( parser.getName() ) )
                    {
                        docletArtifacts.add( parseDocletArtifact( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "taglets", null, parsed ) )
            {
                java.util.List<Taglet> taglets = new java.util.ArrayList<Taglet>();
                javadocOptions.setTaglets( taglets );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "taglet".equals( parser.getName() ) )
                    {
                        taglets.add( parseTaglet( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "offlineLinks", null, parsed ) )
            {
                java.util.List<OfflineLink> offlineLinks = new java.util.ArrayList<OfflineLink>();
                javadocOptions.setOfflineLinks( offlineLinks );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "offlineLink".equals( parser.getName() ) )
                    {
                        offlineLinks.add( parseOfflineLink( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "tagletArtifacts", null, parsed ) )
            {
                java.util.List<TagletArtifact> tagletArtifacts = new java.util.ArrayList<TagletArtifact>();
                javadocOptions.setTagletArtifacts( tagletArtifacts );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "tagletArtifact".equals( parser.getName() ) )
                    {
                        tagletArtifacts.add( parseTagletArtifact( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "resourcesArtifacts", null, parsed ) )
            {
                java.util.List<ResourcesArtifact> resourcesArtifacts = new java.util.ArrayList<ResourcesArtifact>();
                javadocOptions.setResourcesArtifacts( resourcesArtifacts );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "resourcesArtifact".equals( parser.getName() ) )
                    {
                        resourcesArtifacts.add( parseResourcesArtifact( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "bootclasspathArtifacts", null, parsed ) )
            {
                java.util.List<BootclasspathArtifact> bootclasspathArtifacts = new java.util.ArrayList<BootclasspathArtifact>();
                javadocOptions.setBootclasspathArtifacts( bootclasspathArtifacts );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "bootclasspathArtifact".equals( parser.getName() ) )
                    {
                        bootclasspathArtifacts.add( parseBootclasspathArtifact( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "links", null, parsed ) )
            {
                java.util.List<String> links = new java.util.ArrayList<String>();
                javadocOptions.setLinks( links );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "link".equals( parser.getName() ) )
                    {
                        links.add( interpolatedTrimmed( parser.nextText(), "links" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludePackageNames", null, parsed ) )
            {
                java.util.List<String> excludePackageNames = new java.util.ArrayList<String>();
                javadocOptions.setExcludePackageNames( excludePackageNames );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "excludePackageName".equals( parser.getName() ) )
                    {
                        excludePackageNames.add( interpolatedTrimmed( parser.nextText(), "excludePackageNames" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "docfilesSubdirsUsed", null, parsed ) )
            {
                javadocOptions.setDocfilesSubdirsUsed( getBooleanValue( interpolatedTrimmed( parser.nextText(), "docfilesSubdirsUsed" ), "docfilesSubdirsUsed", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "excludedDocfilesSubdirs", null, parsed ) )
            {
                javadocOptions.setExcludedDocfilesSubdirs( interpolatedTrimmed( parser.nextText(), "excludedDocfilesSubdirs" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "javadocResourcesDirectory", null, parsed ) )
            {
                javadocOptions.setJavadocResourcesDirectory( interpolatedTrimmed( parser.nextText(), "javadocResourcesDirectory" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return javadocOptions;
    } //-- JavadocOptions parseJavadocOptions( XmlPullParser, boolean )

    /**
     * Method parseJavadocPathArtifact.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return JavadocPathArtifact
     */
    private JavadocPathArtifact parseJavadocPathArtifact( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        JavadocPathArtifact javadocPathArtifact = new JavadocPathArtifact();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "groupId", null, parsed ) )
            {
                javadocPathArtifact.setGroupId( interpolatedTrimmed( parser.nextText(), "groupId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "artifactId", null, parsed ) )
            {
                javadocPathArtifact.setArtifactId( interpolatedTrimmed( parser.nextText(), "artifactId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "version", null, parsed ) )
            {
                javadocPathArtifact.setVersion( interpolatedTrimmed( parser.nextText(), "version" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "classifier", null, parsed ) )
            {
                javadocPathArtifact.setClassifier( interpolatedTrimmed( parser.nextText(), "classifier" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return javadocPathArtifact;
    } //-- JavadocPathArtifact parseJavadocPathArtifact( XmlPullParser, boolean )

    /**
     * Method parseOfflineLink.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return OfflineLink
     */
    private OfflineLink parseOfflineLink( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        OfflineLink offlineLink = new OfflineLink();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "url", null, parsed ) )
            {
                offlineLink.setUrl( interpolatedTrimmed( parser.nextText(), "url" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "location", null, parsed ) )
            {
                offlineLink.setLocation( interpolatedTrimmed( parser.nextText(), "location" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return offlineLink;
    } //-- OfflineLink parseOfflineLink( XmlPullParser, boolean )

    /**
     * Method parseResourcesArtifact.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return ResourcesArtifact
     */
    private ResourcesArtifact parseResourcesArtifact( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ResourcesArtifact resourcesArtifact = new ResourcesArtifact();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "groupId", null, parsed ) )
            {
                resourcesArtifact.setGroupId( interpolatedTrimmed( parser.nextText(), "groupId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "artifactId", null, parsed ) )
            {
                resourcesArtifact.setArtifactId( interpolatedTrimmed( parser.nextText(), "artifactId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "version", null, parsed ) )
            {
                resourcesArtifact.setVersion( interpolatedTrimmed( parser.nextText(), "version" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "classifier", null, parsed ) )
            {
                resourcesArtifact.setClassifier( interpolatedTrimmed( parser.nextText(), "classifier" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return resourcesArtifact;
    } //-- ResourcesArtifact parseResourcesArtifact( XmlPullParser, boolean )

    /**
     * Method parseTag.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Tag
     */
    private Tag parseTag( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Tag tag = new Tag();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "name", null, parsed ) )
            {
                tag.setName( interpolatedTrimmed( parser.nextText(), "name" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "head", null, parsed ) )
            {
                tag.setHead( interpolatedTrimmed( parser.nextText(), "head" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "placement", null, parsed ) )
            {
                tag.setPlacement( interpolatedTrimmed( parser.nextText(), "placement" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return tag;
    } //-- Tag parseTag( XmlPullParser, boolean )

    /**
     * Method parseTaglet.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Taglet
     */
    private Taglet parseTaglet( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Taglet taglet = new Taglet();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "tagletClass", null, parsed ) )
            {
                taglet.setTagletClass( interpolatedTrimmed( parser.nextText(), "tagletClass" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "tagletpath", null, parsed ) )
            {
                taglet.setTagletpath( interpolatedTrimmed( parser.nextText(), "tagletpath" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "tagletArtifact", null, parsed ) )
            {
                taglet.setTagletArtifact( parseTagletArtifact( parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return taglet;
    } //-- Taglet parseTaglet( XmlPullParser, boolean )

    /**
     * Method parseTagletArtifact.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return TagletArtifact
     */
    private TagletArtifact parseTagletArtifact( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        TagletArtifact tagletArtifact = new TagletArtifact();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "groupId", null, parsed ) )
            {
                tagletArtifact.setGroupId( interpolatedTrimmed( parser.nextText(), "groupId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "artifactId", null, parsed ) )
            {
                tagletArtifact.setArtifactId( interpolatedTrimmed( parser.nextText(), "artifactId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "version", null, parsed ) )
            {
                tagletArtifact.setVersion( interpolatedTrimmed( parser.nextText(), "version" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "classifier", null, parsed ) )
            {
                tagletArtifact.setClassifier( interpolatedTrimmed( parser.nextText(), "classifier" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return tagletArtifact;
    } //-- TagletArtifact parseTagletArtifact( XmlPullParser, boolean )

    /**
     * Method read.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return JavadocOptions
     */
    private JavadocOptions read( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        JavadocOptions javadocOptions = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "javadocOptions".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'javadocOptions' but found '" + parser.getName() + "'", parser, null );
                }
                else if ( parsed )
                {
                    // fallback, already expected a XmlPullParserException due to invalid XML
                    throw new XmlPullParserException( "Duplicated tag: 'javadocOptions'", parser, null );
                }
                javadocOptions = parseJavadocOptions( parser, strict );
                javadocOptions.setModelEncoding( parser.getInputEncoding() );
                parsed = true;
            }
            eventType = parser.next();
        }
        if ( parsed )
        {
            return javadocOptions;
        }
        throw new XmlPullParserException( "Expected root element 'javadocOptions' but found no element at all: invalid XML document", parser, null );
    } //-- JavadocOptions read( XmlPullParser, boolean )

    /**
     * Sets the state of the "add default entities" flag.
     * 
     * @param addDefaultEntities a addDefaultEntities object.
     */
    public void setAddDefaultEntities( boolean addDefaultEntities )
    {
        this.addDefaultEntities = addDefaultEntities;
    } //-- void setAddDefaultEntities( boolean )

    public static interface ContentTransformer
{
    /**
     * Interpolate the value read from the xpp3 document
     * @param source The source value
     * @param fieldName A description of the field being interpolated. The implementation may use this to
     *                           log stuff.
     * @return The interpolated value.
     */
    String transform( String source, String fieldName );
}

}
