/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jxr;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.jxr.AbstractJxrReport;
import org.apache.maven.project.MavenProject;

public class JxrReport
extends AbstractJxrReport {
    private List sourceDirs;
    private String sourcePath;
    private String destDir;
    private File javadocDir;
    private boolean linkJavadoc;

    protected String getDestinationDirectory() {
        return this.destDir;
    }

    protected List getSourceRoots() {
        String[] sourcePathArray;
        if (this.sourcePath != null && (sourcePathArray = this.sourcePath.split(";")).length > 0) {
            return Arrays.asList(sourcePathArray);
        }
        return this.sourceDirs;
    }

    protected List getSourceRoots(MavenProject project) {
        return project.getCompileSourceRoots();
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.xref.main.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.xref.main.name");
    }

    public String getOutputName() {
        return "xref/index";
    }

    protected String getJavadocLocation() {
        String location = null;
        if (this.linkJavadoc) {
            if (this.javadocDir.exists()) {
                location = this.javadocDir.getAbsolutePath();
            } else {
                Iterator reports = this.getProject().getReportPlugins().iterator();
                while (reports.hasNext()) {
                    ReportPlugin report = (ReportPlugin)reports.next();
                    String artifactId = report.getArtifactId();
                    if (!"maven-javadoc-plugin".equals(artifactId)) continue;
                    location = this.javadocDir.getAbsolutePath();
                }
            }
            if (location == null) {
                this.getLog().warn((CharSequence)"Unable to locate Javadoc to link to - DISABLED");
            }
        }
        return location;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.destDir = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("xref") ? new File(reportOutputDirectory, "xref").getAbsolutePath() : reportOutputDirectory.getAbsolutePath();
    }
}

