/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.registry.MavenPluginRegistryBuilder;
import org.apache.maven.plugin.registry.Plugin;
import org.apache.maven.plugin.registry.PluginRegistry;
import org.apache.maven.plugin.registry.PluginRegistryUtils;
import org.apache.maven.plugin.registry.io.xpp3.PluginRegistryXpp3Writer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class UpdatePluginRegistryMojo
extends AbstractMojo {
    private boolean usePluginRegistry;
    private String groupId;
    private String artifactId;
    private String version;
    private MavenPluginRegistryBuilder pluginRegistryBuilder;
    private boolean skip;
    private boolean skipUpdatePluginRegistry;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.usePluginRegistry) {
            if (this.skip || this.skipUpdatePluginRegistry) {
                this.getLog().warn((CharSequence)"Execution skipped");
                return;
            }
            this.updatePluginVersionInRegistry(this.groupId, this.artifactId, this.version);
        }
    }

    private void updatePluginVersionInRegistry(String aGroupId, String anArtifactId, String aVersion) throws MojoExecutionException {
        PluginRegistry pluginRegistry;
        try {
            pluginRegistry = this.getPluginRegistry(aGroupId, anArtifactId);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read plugin registry.", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Failed to parse plugin registry.", (Exception)((Object)e));
        }
        String pluginKey = ArtifactUtils.versionlessKey((String)aGroupId, (String)anArtifactId);
        Plugin plugin = (Plugin)pluginRegistry.getPluginsByKey().get(pluginKey);
        if (plugin != null) {
            if ("global-level".equals(plugin.getSourceLevel())) {
                this.getLog().warn((CharSequence)("Cannot update registered version for plugin {" + aGroupId + ":" + anArtifactId + "}; it is specified in the global registry."));
            } else {
                plugin.setUseVersion(aVersion);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd.HH:mm:ss Z");
                plugin.setLastChecked(format.format(new Date()));
            }
        } else {
            plugin = new Plugin();
            plugin.setGroupId(aGroupId);
            plugin.setArtifactId(anArtifactId);
            plugin.setUseVersion(aVersion);
            pluginRegistry.addPlugin(plugin);
            pluginRegistry.flushPluginsByKey();
        }
        this.writeUserRegistry(aGroupId, anArtifactId, pluginRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUserRegistry(String aGroupId, String anArtifactId, PluginRegistry pluginRegistry) {
        File pluginRegistryFile = pluginRegistry.getRuntimeInfo().getFile();
        PluginRegistry extractedUserRegistry = PluginRegistryUtils.extractUserPluginRegistry((PluginRegistry)pluginRegistry);
        if (extractedUserRegistry != null) {
            XmlStreamWriter fWriter = null;
            try {
                pluginRegistryFile.getParentFile().mkdirs();
                fWriter = WriterFactory.newXmlWriter((File)pluginRegistryFile);
                PluginRegistryXpp3Writer writer = new PluginRegistryXpp3Writer();
                writer.write((Writer)fWriter, extractedUserRegistry);
            }
            catch (IOException e) {
                try {
                    this.getLog().warn((CharSequence)("Cannot rewrite user-level plugin-registry.xml with new plugin version of plugin: '" + aGroupId + ":" + anArtifactId + "'."), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(fWriter);
                    throw throwable;
                }
                IOUtil.close((Writer)fWriter);
            }
            IOUtil.close((Writer)fWriter);
        }
    }

    private PluginRegistry getPluginRegistry(String aGroupId, String anArtifactId) throws IOException, XmlPullParserException {
        PluginRegistry pluginRegistry = null;
        pluginRegistry = this.pluginRegistryBuilder.buildPluginRegistry();
        if (pluginRegistry == null) {
            pluginRegistry = this.pluginRegistryBuilder.createUserPluginRegistry();
        }
        return pluginRegistry;
    }
}

