/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin.metadata;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.plugin.metadata.GroupRepositoryMetadata;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="addPluginArtifactMetadata", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class AddPluginArtifactMetadataMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter
    private String goalPrefix;
    @Parameter(defaultValue="false", property="maven.plugin.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().warn((CharSequence)"Execution skipped");
            return;
        }
        Artifact projectArtifact = this.project.getArtifact();
        Versioning versioning = new Versioning();
        versioning.setLatest(projectArtifact.getVersion());
        versioning.updateTimestamp();
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(projectArtifact, versioning);
        projectArtifact.addMetadata((ArtifactMetadata)metadata);
        GroupRepositoryMetadata groupMetadata = new GroupRepositoryMetadata(this.project.getGroupId());
        groupMetadata.addPluginMapping(this.getGoalPrefix(), this.project.getArtifactId(), this.project.getName());
        projectArtifact.addMetadata((ArtifactMetadata)groupMetadata);
    }

    private String getGoalPrefix() {
        if (this.goalPrefix == null) {
            this.goalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)this.project.getArtifactId());
        }
        return this.goalPrefix;
    }
}

