/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.codehaus.plexus.util.ReaderFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Component
    protected MojoScanner mojoScanner;
    @Component
    protected BuildContext buildContext;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter
    protected String goalPrefix;
    @Parameter(property="maven.plugin.skipErrorNoDescriptorsFound", defaultValue="false")
    protected boolean skipErrorNoDescriptorsFound;
    @Parameter
    protected Set<String> extractors;
    @Parameter(defaultValue="false", property="maven.plugin.skip")
    protected boolean skip;
    @Parameter
    private List<String> mojoDependencies = null;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    protected List<ArtifactRepository> remoteRepos;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    protected ArtifactRepository local;
    @Parameter
    protected List<String> packagingTypes = Collections.singletonList("maven-plugin");
    @Parameter(defaultValue="true", property="maven.plugin.checkExpectedProvidedScope")
    private boolean checkExpectedProvidedScope = true;
    @Parameter
    private List<String> expectedProvidedScopeGroupIds = Collections.singletonList("org.apache.maven");
    @Parameter
    private List<String> expectedProvidedScopeExclusions = Arrays.asList("org.apache.maven:maven-archiver", "org.apache.maven:maven-jxr");
    private static final String LS = System.lineSeparator();

    protected abstract File getOutputDirectory();

    protected abstract Generator createGenerator();

    public void execute() throws MojoExecutionException {
        Set<Artifact> wrongScopedArtifacts;
        if (!this.packagingTypes.contains(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Unsupported packaging type " + this.project.getPackaging() + ", execution skipped"));
            return;
        }
        if (this.skip) {
            this.getLog().warn((CharSequence)"Execution skipped");
            return;
        }
        if (!"maven-plugin".equalsIgnoreCase(this.project.getArtifactId()) && this.project.getArtifactId().toLowerCase().startsWith("maven-") && this.project.getArtifactId().toLowerCase().endsWith("-plugin") && !"org.apache.maven.plugins".equals(this.project.getGroupId())) {
            this.getLog().error((CharSequence)(LS + LS + "Artifact Ids of the format maven-___-plugin are reserved for" + LS + "plugins in the Group Id org.apache.maven.plugins" + LS + "Please change your artifactId to the format ___-maven-plugin" + LS + "In the future this error will break the build." + LS + LS));
        }
        if (this.checkExpectedProvidedScope && !(wrongScopedArtifacts = this.dependenciesNotInProvidedScope()).isEmpty()) {
            StringBuilder errorMessage = new StringBuilder(LS + LS + "Some dependencies of Maven Plugins are expected to be in provided scope." + LS + "Please make sure that dependencies listed below declared in POM" + LS + "have set '<scope>provided</scope>' as well." + LS + LS + "The following dependencies are in wrong scope:" + LS);
            for (Artifact artifact : wrongScopedArtifacts) {
                errorMessage.append(" * ").append(artifact).append(LS);
            }
            errorMessage.append(LS).append(LS);
            this.getLog().error((CharSequence)errorMessage.toString());
        }
        String defaultGoalPrefix = AbstractGeneratorMojo.getDefaultGoalPrefix(this.project);
        if (this.goalPrefix == null) {
            this.goalPrefix = defaultGoalPrefix;
        } else if (!this.goalPrefix.equals(defaultGoalPrefix)) {
            this.getLog().warn((CharSequence)(LS + LS + "Goal prefix is specified as: '" + this.goalPrefix + "'. Maven currently expects it to be '" + defaultGoalPrefix + "'." + LS));
        }
        this.mojoScanner.setActiveExtractors(this.extractors);
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setGroupId(this.project.getGroupId());
        pluginDescriptor.setArtifactId(this.project.getArtifactId());
        pluginDescriptor.setVersion(this.project.getVersion());
        pluginDescriptor.setGoalPrefix(this.goalPrefix);
        pluginDescriptor.setName(this.project.getName());
        pluginDescriptor.setDescription(this.project.getDescription());
        if (this.encoding == null || this.encoding.length() < 1) {
            this.getLog().warn((CharSequence)("Using platform encoding (" + ReaderFactory.FILE_ENCODING + " actually) to read mojo source files, i.e. build is platform dependent!"));
        } else {
            this.getLog().info((CharSequence)("Using '" + this.encoding + "' encoding to read mojo source files."));
        }
        try {
            List deps = GeneratorUtils.toComponentDependencies((Collection)this.project.getArtifacts());
            pluginDescriptor.setDependencies(deps);
            DefaultPluginToolsRequest request = new DefaultPluginToolsRequest(this.project, pluginDescriptor);
            request.setEncoding(this.encoding);
            request.setSkipErrorNoDescriptorsFound(this.skipErrorNoDescriptorsFound);
            request.setDependencies(this.filterMojoDependencies());
            request.setLocal(this.local);
            request.setRemoteRepos(this.remoteRepos);
            this.mojoScanner.populatePluginDescriptor((PluginToolsRequest)request);
            File outputDirectory = this.getOutputDirectory();
            outputDirectory.mkdirs();
            this.createGenerator().execute(outputDirectory, (PluginToolsRequest)request);
            this.buildContext.refresh(outputDirectory);
        }
        catch (GeneratorException e) {
            throw new MojoExecutionException("Error writing plugin descriptor", (Exception)((Object)e));
        }
        catch (InvalidPluginDescriptorException | ExtractionException e) {
            throw new MojoExecutionException("Error extracting plugin descriptor: '" + e.getLocalizedMessage() + "'", (Exception)e);
        }
        catch (LinkageError e) {
            throw new MojoExecutionException("The API of the mojo scanner is not compatible with this plugin version. Please check the plugin dependencies configured in the POM and ensure the versions match.", (Throwable)e);
        }
    }

    static String getDefaultGoalPrefix(MavenProject project) {
        String defaultGoalPrefix = "maven-plugin".equalsIgnoreCase(project.getArtifactId()) ? project.getGroupId().substring(project.getGroupId().lastIndexOf(46) + 1) : PluginDescriptor.getGoalPrefixFromArtifactId((String)project.getArtifactId());
        return defaultGoalPrefix;
    }

    private Set<Artifact> dependenciesNotInProvidedScope() {
        LinkedHashSet<Artifact> wrongScopedDependencies = new LinkedHashSet<Artifact>();
        for (Artifact dependency : this.project.getArtifacts()) {
            String ga = dependency.getGroupId() + ":" + dependency.getArtifactId();
            if (!this.expectedProvidedScopeGroupIds.contains(dependency.getGroupId()) || this.expectedProvidedScopeExclusions.contains(ga) || "provided".equals(dependency.getScope())) continue;
            wrongScopedDependencies.add(dependency);
        }
        return wrongScopedDependencies;
    }

    private Set<Artifact> filterMojoDependencies() {
        LinkedHashSet<Artifact> filteredArtifacts;
        if (this.mojoDependencies == null) {
            filteredArtifacts = new LinkedHashSet<Artifact>(this.project.getArtifacts());
        } else if (this.mojoDependencies.size() == 0) {
            filteredArtifacts = null;
        } else {
            filteredArtifacts = new LinkedHashSet();
            IncludesArtifactFilter filter = new IncludesArtifactFilter(this.mojoDependencies);
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!filter.include(artifact)) continue;
                filteredArtifacts.add(artifact);
            }
        }
        return filteredArtifacts;
    }
}

