/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.release.AbstractReleaseMojo;
import org.apache.maven.plugins.release.helpers.ReleaseProgressTracker;
import org.apache.maven.plugins.release.helpers.ScmHelper;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerformReleaseMojo
extends AbstractReleaseMojo {
    private String basedir;
    private String goals = "deploy";
    protected String workingDirectory;
    private ReleaseProgressTracker releaseProgress;

    protected void executeTask() throws MojoExecutionException {
        this.checkout();
        this.runGoals();
    }

    private void checkout() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Checking out the project to perform the release ...");
        try {
            ScmHelper scm = this.getScm(this.workingDirectory);
            scm.checkout();
        }
        catch (Exception e) {
            throw new MojoExecutionException("An error is occurred in the checkout process.", e);
        }
    }

    private void runGoals() throws MojoExecutionException {
        Commandline cl = new Commandline();
        cl.setExecutable("m2");
        cl.setWorkingDirectory(this.workingDirectory);
        cl.createArgument().setLine(this.goals);
        cl.createArgument().setLine("-DperformRelease=true");
        cl.createArgument().setLine("--no-plugin-updates");
        cl.createArgument().setLine("--batch-mode");
        DefaultConsumer consumer = new DefaultConsumer();
        try {
            CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)consumer);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Can't run goal " + this.goals, (Exception)((Object)e));
        }
    }

    protected ReleaseProgressTracker getReleaseProgress() throws MojoExecutionException {
        if (this.releaseProgress == null) {
            try {
                this.releaseProgress = ReleaseProgressTracker.load(this.basedir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to load release information from file: " + ReleaseProgressTracker.getReleaseProgressFilename(), (Exception)e);
            }
        }
        return this.releaseProgress;
    }
}

