/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.release.AbstractReleaseMojo;
import org.apache.maven.plugins.release.helpers.ProjectScmRewriter;
import org.apache.maven.plugins.release.helpers.ProjectVersionResolver;
import org.apache.maven.plugins.release.helpers.ReleaseProgressTracker;
import org.apache.maven.plugins.release.helpers.ScmHelper;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.codehaus.plexus.components.inputhandler.InputHandler;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class PrepareReleaseMojo
extends AbstractReleaseMojo {
    private static final String RELEASE_POM = "release-pom.xml";
    private static final String POM = "pom.xml";
    private String basedir;
    private boolean interactive;
    private ArtifactMetadataSource artifactMetadataSource;
    private InputHandler inputHandler;
    private ArtifactRepository localRepository;
    private List reactorProjects;
    private String urlScm;
    private String username;
    private String password;
    private String tag;
    private String tagBase;
    private boolean resume;
    private String userTag;
    private ReleaseProgressTracker releaseProgress;
    private ProjectVersionResolver versionResolver;
    private ProjectScmRewriter scmRewriter;

    protected void executeTask() throws MojoExecutionException {
        try {
            this.getReleaseProgress().checkpoint(this.basedir, "initialized");
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Error writing checkpoint.", (Throwable)e);
        }
        if (!this.getReleaseProgress().verifyCheckpoint("prepared-release")) {
            MavenProject project;
            Iterator it;
            this.checkForLocalModifications();
            if (!this.getReleaseProgress().verifyCheckpoint("transformed-pom-for-release")) {
                it = this.reactorProjects.iterator();
                while (it.hasNext()) {
                    project = (MavenProject)it.next();
                    this.getVersionResolver().resolveVersion(project);
                    this.getScmRewriter().rewriteScmInfo(project, this.getTagLabel());
                }
                it = this.reactorProjects.iterator();
                while (it.hasNext()) {
                    project = (MavenProject)it.next();
                    this.checkForPresenceOfSnapshots(project);
                    this.transformPomToReleaseVersionPom(project);
                }
                try {
                    this.getReleaseProgress().checkpoint(this.basedir, "transformed-pom-for-release");
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)"Error writing checkpoint.", (Throwable)e);
                }
            }
            this.generateReleasePoms();
            this.checkInRelease();
            this.tagRelease();
            if (!this.getReleaseProgress().verifyCheckpoint("transform-pom-for-development")) {
                it = this.reactorProjects.iterator();
                while (it.hasNext()) {
                    project = (MavenProject)it.next();
                    this.getVersionResolver().incrementVersion(project);
                    this.getScmRewriter().restoreScmInfo(project);
                }
                it = this.reactorProjects.iterator();
                while (it.hasNext()) {
                    project = (MavenProject)it.next();
                    this.transformPomToSnapshotVersionPom(project);
                }
                try {
                    this.getReleaseProgress().checkpoint(this.basedir, "transform-pom-for-development");
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)"Error writing checkpoint.", (Throwable)e);
                }
            }
            this.removeReleasePoms();
            this.checkInNextSnapshot();
            try {
                this.getReleaseProgress().checkpoint(this.basedir, "prepared-release");
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Error writing checkpoint.", (Throwable)e);
            }
        }
    }

    private void transformPomToSnapshotVersionPom(MavenProject project) throws MojoExecutionException {
        List reports;
        Reporting reporting;
        String version;
        Iterator i;
        Build build;
        List dependencies;
        String incrementedVersion;
        Model model = project.getOriginalModel();
        ProjectVersionResolver versionResolver = this.getVersionResolver();
        Parent parent = model.getParent();
        if (parent != null && (incrementedVersion = versionResolver.getResolvedVersion(parent.getGroupId(), parent.getArtifactId())) != null) {
            parent.setVersion(incrementedVersion);
        }
        if ((dependencies = model.getDependencies()) != null) {
            Iterator i2 = dependencies.iterator();
            while (i2.hasNext()) {
                Dependency dep = (Dependency)i2.next();
                String version2 = versionResolver.getResolvedVersion(dep.getGroupId(), dep.getArtifactId());
                if (version2 == null) continue;
                dep.setVersion(version2);
            }
        }
        if ((build = model.getBuild()) != null) {
            List plugins = build.getPlugins();
            if (plugins != null) {
                Iterator i3 = plugins.iterator();
                while (i3.hasNext()) {
                    Plugin plugin = (Plugin)i3.next();
                    String version3 = versionResolver.getResolvedVersion(plugin.getGroupId(), plugin.getArtifactId());
                    if (version3 == null) continue;
                    plugin.setVersion(version3);
                }
            }
            List extensions = build.getExtensions();
            i = extensions.iterator();
            while (i.hasNext()) {
                Extension ext = (Extension)i.next();
                version = versionResolver.getResolvedVersion(ext.getGroupId(), ext.getArtifactId());
                if (version == null) continue;
                ext.setVersion(version);
            }
        }
        if ((reporting = model.getReporting()) != null && (reports = reporting.getPlugins()) != null) {
            i = reports.iterator();
            while (i.hasNext()) {
                ReportPlugin plugin = (ReportPlugin)i.next();
                version = versionResolver.getResolvedVersion(plugin.getGroupId(), plugin.getArtifactId());
                if (version == null) continue;
                plugin.setVersion(version);
            }
        }
        FileWriter writer = null;
        File file = new File(project.getFile().getParentFile(), POM);
        try {
            writer = new FileWriter(file);
            project.writeOriginalModel((Writer)writer);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Cannot write development version of pom to: " + file, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    protected ReleaseProgressTracker getReleaseProgress() throws MojoExecutionException {
        if (this.releaseProgress == null) {
            try {
                this.releaseProgress = ReleaseProgressTracker.loadOrCreate(this.basedir);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Cannot read existing release progress file from directory: " + this.basedir + "."));
                this.getLog().debug((CharSequence)"Cause", (Throwable)e);
                this.releaseProgress = ReleaseProgressTracker.create();
            }
            if (this.resume) {
                this.releaseProgress.setResumeAtCheckpoint(true);
            }
            if (this.releaseProgress.getUsername() == null) {
                if (this.username == null) {
                    this.username = System.getProperty("user.name");
                }
                this.releaseProgress.setUsername(this.username);
            }
            if (this.releaseProgress.getPassword() == null && this.password != null) {
                this.releaseProgress.setPassword(this.password);
            }
            if (this.releaseProgress.getScmTag() == null) {
                this.releaseProgress.setScmTag(this.getTagLabel());
            }
            if (this.releaseProgress.getScmTagBase() == null) {
                this.releaseProgress.setScmTagBase(this.tagBase);
            }
            if (this.releaseProgress.getScmUrl() == null) {
                this.releaseProgress.setScmUrl(this.urlScm);
            }
            if (this.releaseProgress.getUsername() == null || this.releaseProgress.getScmTag() == null || this.releaseProgress.getScmTagBase() == null || this.releaseProgress.getScmUrl() == null) {
                throw new MojoExecutionException("Missing release preparation information.");
            }
        }
        return this.releaseProgress;
    }

    protected ProjectVersionResolver getVersionResolver() {
        if (this.versionResolver == null) {
            this.versionResolver = new ProjectVersionResolver(this.getLog(), this.inputHandler, this.interactive);
        }
        return this.versionResolver;
    }

    protected ProjectScmRewriter getScmRewriter() throws MojoExecutionException {
        if (this.scmRewriter == null) {
            this.scmRewriter = new ProjectScmRewriter(this.getReleaseProgress());
        }
        return this.scmRewriter;
    }

    private void checkForLocalModifications() throws MojoExecutionException {
        if (!this.getReleaseProgress().verifyCheckpoint("local-modifications-checked")) {
            List changedFiles;
            this.getLog().info((CharSequence)"Verifying there are no local modifications ...");
            try {
                ScmHelper scm = this.getScm(this.basedir);
                changedFiles = scm.getStatus();
            }
            catch (ScmException e) {
                throw new MojoExecutionException("An error is occurred in the status process.", (Exception)((Object)e));
            }
            String releaseProgressFilename = ReleaseProgressTracker.getReleaseProgressFilename();
            Iterator i = changedFiles.iterator();
            while (i.hasNext()) {
                ScmFile f = (ScmFile)i.next();
                if (!"pom.xml.backup".equals(f.getPath()) && !f.getPath().equals(releaseProgressFilename)) continue;
                i.remove();
            }
            if (!changedFiles.isEmpty()) {
                StringBuffer message = new StringBuffer();
                Iterator i2 = changedFiles.iterator();
                while (i2.hasNext()) {
                    ScmFile file = (ScmFile)i2.next();
                    message.append(file.toString());
                    message.append("\n");
                }
                throw new MojoExecutionException("Cannot prepare the release because you have local modifications : \n" + message.toString());
            }
            try {
                this.getReleaseProgress().checkpoint(this.basedir, "local-modifications-checked");
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Error writing checkpoint.", (Throwable)e);
            }
        }
    }

    private void checkForPresenceOfSnapshots(MavenProject project) throws MojoExecutionException {
        String artifactVersion;
        Artifact artifact;
        this.getLog().info((CharSequence)"Checking lineage for snapshots ...");
        MavenProject currentProject = project;
        while (currentProject.hasParent()) {
            MavenProject parentProject = currentProject.getParent();
            String parentVersion = null;
            if (ArtifactUtils.isSnapshot((String)parentProject.getVersion())) {
                parentVersion = this.getVersionResolver().getResolvedVersion(parentProject.getGroupId(), parentProject.getArtifactId());
                if (parentVersion == null) {
                    parentVersion = parentProject.getVersion();
                }
                if (ArtifactUtils.isSnapshot((String)parentVersion)) {
                    throw new MojoExecutionException("Can't release project due to non released parent (" + parentProject.getGroupId() + ":" + parentProject.getArtifactId() + parentVersion + ".");
                }
            }
            currentProject = parentProject;
        }
        this.getLog().info((CharSequence)"Checking dependencies for snapshots ...");
        HashSet<Artifact> snapshotDependencies = new HashSet<Artifact>();
        Iterator i = project.getArtifacts().iterator();
        while (i.hasNext()) {
            artifact = (Artifact)i.next();
            artifactVersion = this.getVersionResolver().getResolvedVersion(artifact.getGroupId(), artifact.getArtifactId());
            if (artifactVersion == null) {
                artifactVersion = artifact.getVersion();
            }
            if (!ArtifactUtils.isSnapshot((String)artifactVersion)) continue;
            snapshotDependencies.add(artifact);
        }
        this.getLog().info((CharSequence)"Checking plugins for snapshots ...");
        i = project.getPluginArtifacts().iterator();
        while (i.hasNext()) {
            artifact = (Artifact)i.next();
            artifactVersion = this.getVersionResolver().getResolvedVersion(artifact.getGroupId(), artifact.getArtifactId());
            if (artifactVersion == null) {
                artifactVersion = artifact.getVersion();
            }
            if (!ArtifactUtils.isSnapshot((String)artifactVersion)) continue;
            snapshotDependencies.add(artifact);
        }
        if (!snapshotDependencies.isEmpty()) {
            ArrayList snapshotsList = new ArrayList(snapshotDependencies);
            Collections.sort(snapshotsList);
            StringBuffer message = new StringBuffer();
            Iterator i2 = snapshotsList.iterator();
            while (i2.hasNext()) {
                Artifact artifact2 = (Artifact)i2.next();
                message.append("    ");
                message.append(artifact2.getId());
                message.append("\n");
            }
            throw new MojoExecutionException("Can't release project due to non released dependencies :\n" + message.toString());
        }
    }

    private void transformPomToReleaseVersionPom(MavenProject project) throws MojoExecutionException {
        Reporting reporting;
        String resolvedVersion;
        ReportPlugin plugin;
        Iterator i;
        Build build;
        DependencyManagement dependencyManagement;
        List dependencies;
        Artifact parentArtifact;
        if (!ArtifactUtils.isSnapshot((String)project.getVersion())) {
            throw new MojoExecutionException("The project " + project.getGroupId() + ":" + project.getArtifactId() + " isn't a snapshot (" + project.getVersion() + ").");
        }
        Model model = project.getOriginalModel();
        if (model.getParent() != null && ArtifactUtils.isSnapshot((String)(parentArtifact = project.getParentArtifact()).getBaseVersion())) {
            String version = this.resolveVersion(parentArtifact, "parent", project);
            model.getParent().setVersion(version);
        }
        if ((dependencies = model.getDependencies()) != null) {
            Iterator i2 = dependencies.iterator();
            while (i2.hasNext()) {
                String resolvedVersion2;
                Dependency dep = (Dependency)i2.next();
                if (dep.getVersion() == null || (resolvedVersion2 = this.getVersionResolver().getResolvedVersion(dep.getGroupId(), dep.getArtifactId())) == null) continue;
                dep.setVersion(resolvedVersion2);
            }
        }
        List list = dependencies = (dependencyManagement = model.getDependencyManagement()) != null ? dependencyManagement.getDependencies() : null;
        if (dependencies != null) {
            Iterator i3 = dependencies.iterator();
            while (i3.hasNext()) {
                String resolvedVersion3;
                Dependency dep = (Dependency)i3.next();
                if (dep.getVersion() == null || (resolvedVersion3 = this.getVersionResolver().getResolvedVersion(dep.getGroupId(), dep.getArtifactId())) == null) continue;
                dep.setVersion(resolvedVersion3);
            }
        }
        if ((build = model.getBuild()) != null) {
            PluginManagement pluginManagement;
            List plugins = build.getPlugins();
            if (plugins != null) {
                Iterator i4 = plugins.iterator();
                while (i4.hasNext()) {
                    String resolvedVersion4;
                    Plugin plugin2 = (Plugin)i4.next();
                    if (plugin2.getVersion() == null || (resolvedVersion4 = this.getVersionResolver().getResolvedVersion(plugin2.getGroupId(), plugin2.getArtifactId())) == null) continue;
                    plugin2.setVersion(resolvedVersion4);
                }
            }
            List list2 = plugins = (pluginManagement = build.getPluginManagement()) != null ? pluginManagement.getPlugins() : null;
            if (plugins != null) {
                i = plugins.iterator();
                while (i.hasNext()) {
                    plugin = (Plugin)i.next();
                    if (plugin.getVersion() == null || (resolvedVersion = this.getVersionResolver().getResolvedVersion(plugin.getGroupId(), plugin.getArtifactId())) == null) continue;
                    plugin.setVersion(resolvedVersion);
                }
            }
            List extensions = build.getExtensions();
            Iterator i5 = extensions.iterator();
            while (i5.hasNext()) {
                Extension ext = (Extension)i5.next();
                String resolvedVersion5 = this.getVersionResolver().getResolvedVersion(ext.getGroupId(), ext.getArtifactId());
                if (resolvedVersion5 == null) continue;
                ext.setVersion(resolvedVersion5);
            }
        }
        if ((reporting = model.getReporting()) != null) {
            List reports = reporting.getPlugins();
            i = reports.iterator();
            while (i.hasNext()) {
                plugin = (ReportPlugin)i.next();
                resolvedVersion = this.getVersionResolver().getResolvedVersion(plugin.getGroupId(), plugin.getArtifactId());
                if (resolvedVersion == null) continue;
                plugin.setVersion(resolvedVersion);
            }
        }
        FileWriter writer = null;
        File file = new File(project.getFile().getParentFile(), POM);
        try {
            writer = new FileWriter(file);
            project.writeOriginalModel((Writer)writer);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Cannot write released version of pom to: " + file, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    private void generateReleasePoms() throws MojoExecutionException {
        block20: {
            String canonicalBasedir;
            if (this.getReleaseProgress().verifyCheckpoint("generated-release-pom")) break block20;
            try {
                canonicalBasedir = this.trimPathForScmCalculation(new File(this.basedir));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot canonicalize basedir: " + this.basedir, (Exception)e);
            }
            Iterator it = this.reactorProjects.iterator();
            while (it.hasNext()) {
                List extensions;
                List reports;
                Build originalModel;
                List plugins;
                MavenProject project = (MavenProject)it.next();
                MavenProject releaseProject = new MavenProject(project);
                Model releaseModel = releaseProject.getOriginalModel();
                this.fixNullValueInModel(releaseModel, project.getOriginalModel());
                Set artifacts = releaseProject.getArtifacts();
                if (artifacts != null) {
                    ArrayList<Dependency> newdeps = new ArrayList<Dependency>();
                    Iterator i = releaseProject.getArtifacts().iterator();
                    while (i.hasNext()) {
                        Artifact artifact = (Artifact)i.next();
                        Dependency newdep = new Dependency();
                        newdep.setArtifactId(artifact.getArtifactId());
                        newdep.setGroupId(artifact.getGroupId());
                        newdep.setVersion(artifact.getVersion());
                        newdep.setType(artifact.getType());
                        newdep.setScope(artifact.getScope());
                        newdep.setClassifier(artifact.getClassifier());
                        newdeps.add(newdep);
                    }
                    releaseModel.setDependencies(newdeps);
                }
                List list = plugins = (originalModel = releaseProject.getOriginalModel().getBuild()) != null ? originalModel.getPlugins() : null;
                if (plugins != null) {
                    Map pluginArtifacts = releaseProject.getPluginArtifactMap();
                    Iterator i = plugins.iterator();
                    while (i.hasNext()) {
                        Plugin plugin = (Plugin)i.next();
                        Artifact artifact = (Artifact)pluginArtifacts.get(plugin.getKey());
                        String version = this.resolveVersion(artifact, "plugin", releaseProject);
                        plugin.setVersion(version);
                    }
                }
                if ((reports = releaseProject.getReportPlugins()) != null) {
                    Map reportArtifacts = releaseProject.getReportArtifactMap();
                    this.getLog().info((CharSequence)("Using report-artifact map with " + reportArtifacts.size() + " entries."));
                    Iterator i = reports.iterator();
                    while (i.hasNext()) {
                        ReportPlugin plugin = (ReportPlugin)i.next();
                        String pluginKey = plugin.getKey();
                        this.getLog().info((CharSequence)("Looking up report artifact for: '" + pluginKey + "'"));
                        Artifact artifact = (Artifact)reportArtifacts.get(pluginKey);
                        String version = this.resolveVersion(artifact, "report", releaseProject);
                        plugin.setVersion(version);
                    }
                }
                if ((extensions = releaseProject.getBuildExtensions()) != null) {
                    Map extensionArtifacts = releaseProject.getExtensionArtifactMap();
                    Iterator i = extensions.iterator();
                    while (i.hasNext()) {
                        Extension ext = (Extension)i.next();
                        String extensionId = ArtifactUtils.versionlessKey((String)ext.getGroupId(), (String)ext.getArtifactId());
                        Artifact artifact = (Artifact)extensionArtifacts.get(extensionId);
                        String version = this.resolveVersion(artifact, "extension", releaseProject);
                        ext.setVersion(version);
                    }
                }
                File releasePomFile = new File(releaseProject.getFile().getParentFile(), RELEASE_POM);
                FileWriter writer = null;
                try {
                    writer = new FileWriter(releasePomFile);
                    releaseProject.writeOriginalModel((Writer)writer);
                }
                catch (IOException e) {
                    try {
                        throw new MojoExecutionException("Cannot write release-pom to: " + releasePomFile, (Exception)e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(writer);
                        throw throwable;
                    }
                }
                IOUtil.close((Writer)writer);
                try {
                    String releasePomPath = this.trimPathForScmCalculation(releasePomFile);
                    releasePomPath = releasePomPath.substring(canonicalBasedir.length() + 1);
                    ScmHelper scm = this.getScm(this.basedir);
                    scm.add(releasePomPath);
                }
                catch (ScmException e) {
                    throw new MojoExecutionException("Error adding the release-pom.xml: " + releasePomFile, (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error adding the release-pom.xml: " + releasePomFile, (Exception)e);
                }
                try {
                    this.getReleaseProgress().checkpoint(this.basedir, "generated-release-pom");
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)"Error writing checkpoint.", (Throwable)e);
                }
            }
        }
    }

    private void fixNullValueInModel(Model modelToFix, Model correctModel) {
        if (modelToFix.getModelVersion() != null) {
            modelToFix.setModelVersion(correctModel.getModelVersion());
        }
        if (modelToFix.getName() != null) {
            modelToFix.setName(correctModel.getName());
        }
        if (modelToFix.getParent() != null) {
            modelToFix.setParent(PrepareReleaseMojo.cloneParent(correctModel.getParent()));
        }
        if (modelToFix.getVersion() != null) {
            modelToFix.setVersion(correctModel.getVersion());
        }
        if (modelToFix.getArtifactId() != null) {
            modelToFix.setArtifactId(correctModel.getArtifactId());
        }
        if (modelToFix.getProperties() != null && ((Hashtable)modelToFix.getProperties()).isEmpty()) {
            modelToFix.setProperties(new Properties(correctModel.getProperties()));
        }
        if (modelToFix.getGroupId() != null) {
            modelToFix.setGroupId(correctModel.getGroupId());
        }
        if (modelToFix.getPackaging() != null) {
            modelToFix.setPackaging(correctModel.getPackaging());
        }
        if (modelToFix.getModules() != null && !modelToFix.getModules().isEmpty()) {
            modelToFix.setModules(PrepareReleaseMojo.cloneModules(correctModel.getModules()));
        }
        if (modelToFix.getDistributionManagement() != null) {
            modelToFix.setDistributionManagement(correctModel.getDistributionManagement());
        }
    }

    private static List cloneModules(List modules) {
        if (modules == null) {
            return modules;
        }
        return new ArrayList(modules);
    }

    private static Parent cloneParent(Parent parent) {
        if (parent == null) {
            return parent;
        }
        Parent newParent = new Parent();
        newParent.setArtifactId(parent.getArtifactId());
        newParent.setGroupId(parent.getGroupId());
        newParent.setRelativePath(parent.getRelativePath());
        newParent.setVersion(parent.getVersion());
        return newParent;
    }

    private String resolveVersion(Artifact artifact, String artifactUsage, MavenProject project) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Resolving version for: " + artifact));
        String resolvedVersion = this.getVersionResolver().getResolvedVersion(artifact.getGroupId(), artifact.getArtifactId());
        if (resolvedVersion == null) {
            if (artifact.getFile() == null) {
                try {
                    this.artifactMetadataSource.retrieve(artifact, this.localRepository, project.getPluginArtifactRepositories());
                }
                catch (ArtifactMetadataRetrievalException e) {
                    throw new MojoExecutionException("Cannot resolve " + artifactUsage + ": " + artifact.getId(), (Exception)((Object)e));
                }
            }
            resolvedVersion = artifact.getVersion();
        }
        return resolvedVersion;
    }

    private void checkInRelease() throws MojoExecutionException {
        if (!this.getReleaseProgress().verifyCheckpoint("checked-in-release-version")) {
            this.checkIn("[maven-release-plugin] prepare release " + this.getTagLabel());
            try {
                this.getReleaseProgress().checkpoint(this.basedir, "checked-in-release-version");
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Error writing checkpoint.", (Throwable)e);
            }
        }
    }

    private void removeReleasePoms() throws MojoExecutionException {
        if (!this.getReleaseProgress().verifyCheckpoint("removed-release-pom")) {
            File currentReleasePomFile = null;
            try {
                String canonicalBasedir = this.trimPathForScmCalculation(new File(this.basedir));
                Iterator it = this.reactorProjects.iterator();
                while (it.hasNext()) {
                    MavenProject project = (MavenProject)it.next();
                    currentReleasePomFile = new File(project.getFile().getParentFile(), RELEASE_POM);
                    String releasePomPath = this.trimPathForScmCalculation(currentReleasePomFile);
                    releasePomPath = releasePomPath.substring(canonicalBasedir.length() + 1);
                    ScmHelper scm = this.getScm(this.basedir);
                    scm.remove("Removing for next development iteration.", releasePomPath);
                    currentReleasePomFile.delete();
                }
            }
            catch (ScmException e) {
                throw new MojoExecutionException("Cannot remove " + currentReleasePomFile + " from development HEAD.", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot remove " + currentReleasePomFile + " from development HEAD.", (Exception)e);
            }
            try {
                this.getReleaseProgress().checkpoint(this.basedir, "removed-release-pom");
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Error writing checkpoint.", (Throwable)e);
            }
        }
    }

    private String trimPathForScmCalculation(File file) throws IOException {
        String path = file.getCanonicalPath();
        if ((path = path.replace(File.separatorChar, '/')).endsWith("/")) {
            path = path.substring(path.length() - 1);
        }
        return path;
    }

    private void checkInNextSnapshot() throws MojoExecutionException {
        if (!this.getReleaseProgress().verifyCheckpoint("check-in-development-version")) {
            this.checkIn("[maven-release-plugin] prepare for next development iteration");
            try {
                this.getReleaseProgress().checkpoint(this.basedir, "check-in-development-version");
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Error writing checkpoint.", (Throwable)e);
            }
        }
    }

    private void checkIn(String message) throws MojoExecutionException {
        try {
            ScmHelper scm = this.getScm(this.basedir);
            String tag = scm.getTag();
            scm.setTag(null);
            scm.checkin(message);
            scm.setTag(tag);
        }
        catch (Exception e) {
            throw new MojoExecutionException("An error is occurred in the checkin process.", e);
        }
    }

    private String getTagLabel() throws MojoExecutionException {
        if (this.userTag == null) {
            try {
                if (this.tag == null && this.interactive) {
                    this.getLog().info((CharSequence)"What tag name should be used? ");
                    String inputTag = this.inputHandler.readLine();
                    if (!StringUtils.isEmpty((String)inputTag)) {
                        this.userTag = inputTag;
                    }
                } else {
                    this.userTag = this.tag;
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("An error is occurred in the tag process.", e);
            }
        }
        if (this.userTag == null) {
            this.userTag = this.releaseProgress.getScmTag();
        }
        if (this.userTag == null) {
            throw new MojoExecutionException("A tag must be specified");
        }
        return this.userTag;
    }

    private void tagRelease() throws MojoExecutionException {
        if (!this.getReleaseProgress().verifyCheckpoint("tagged-release")) {
            String tag = this.getTagLabel();
            try {
                ScmHelper scm = this.getScm(this.basedir);
                scm.setTag(tag);
                this.getLog().info((CharSequence)("Tagging release with the label " + tag + "."));
                scm.tag();
            }
            catch (Exception e) {
                throw new MojoExecutionException("An error is occurred in the tag process.", e);
            }
            try {
                this.getReleaseProgress().checkpoint(this.basedir, "tagged-release");
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Error writing checkpoint.", (Throwable)e);
            }
        }
    }
}

