/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.helpers;

import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.release.helpers.ReleaseProgressTracker;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class ProjectScmRewriter {
    private ReleaseProgressTracker releaseProgress;

    public ProjectScmRewriter(ReleaseProgressTracker releaseProgress) {
        this.releaseProgress = releaseProgress;
    }

    public void rewriteScmInfo(MavenProject project, String tagLabel) throws MojoExecutionException {
        String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
        if (project.getScm() == null) {
            throw new MojoExecutionException("Project: " + projectId + " does not have a SCM section! Cannot proceed with release.");
        }
        Model model = project.getOriginalModel();
        Scm scm = model.getScm();
        if (scm != null) {
            this.releaseProgress.addOriginalScmInfo(projectId, scm);
            this.rewriteScmConnection(scm, tagLabel);
        }
    }

    public void restoreScmInfo(MavenProject project) {
        Scm scm = project.getOriginalModel().getScm();
        if (scm != null) {
            String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            this.releaseProgress.restoreScmInfo(projectId, scm);
        }
    }

    private void rewriteScmConnection(Scm scm, String tag) {
        String scmConnection;
        if (scm != null && (scmConnection = scm.getConnection()) != null && scmConnection.startsWith("scm:svn")) {
            scm.setConnection(this.convertSvnConnectionString(scmConnection, tag));
            scm.setDeveloperConnection(this.convertSvnConnectionString(scm.getDeveloperConnection(), tag));
            scm.setUrl(this.convertSvnConnectionString(scm.getUrl(), tag));
        }
    }

    private String convertSvnConnectionString(String scmConnection, String tag) {
        if (scmConnection.indexOf("/trunk") >= 0) {
            scmConnection = StringUtils.replace((String)scmConnection, (String)"/trunk", (String)("/tags/" + tag));
        } else {
            int begin = scmConnection.indexOf("/branches/");
            if (begin >= 0) {
                int end = scmConnection.indexOf(47, begin + "/branches/".length());
                scmConnection = scmConnection.substring(0, begin) + "/tags/" + tag;
                if (end >= 0 && end < scmConnection.length() - 1) {
                    scmConnection = scmConnection + scmConnection.substring(end);
                }
            }
        }
        return scmConnection;
    }
}

