/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.helpers;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.FileUtils;

public class ScmHelper {
    private String username;
    private String password;
    private String url;
    private String tag;
    private String workingDirectory;
    private File checkoutDirectory;
    private String tagBase;
    private ScmManager scmManager;

    private ScmManager getScmManager() throws ScmException {
        if (this.scmManager == null) {
            throw new ScmException("scmManager isn't define.");
        }
        return this.scmManager;
    }

    private ScmRepository getScmRepository() throws ScmException {
        ScmRepository repository;
        try {
            repository = this.getScmManager().makeScmRepository(this.url);
            if (repository.getProvider().equals("svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
                if (this.username != null && this.username.length() > 0) {
                    svnRepo.setUser(this.username);
                }
                if (this.password != null && this.password.length() > 0) {
                    svnRepo.setPassword(this.password);
                }
                if (this.tagBase != null && this.tagBase.length() > 0) {
                    svnRepo.setTagBase(this.tagBase);
                }
            }
        }
        catch (Exception e) {
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        return repository;
    }

    private void checkResult(ScmResult result) throws ScmException {
        if (!result.isSuccess()) {
            System.err.println("Provider message:");
            System.err.println(result.getProviderMessage());
            System.err.println("Command output:");
            System.err.println(result.getCommandOutput());
            throw new ScmException("Error!");
        }
    }

    public void checkout() throws ScmException, IOException {
        ScmRepository repository = this.getScmRepository();
        this.checkoutDirectory = new File(this.workingDirectory);
        if (FileUtils.fileExists((String)this.workingDirectory)) {
            FileUtils.deleteDirectory((String)this.workingDirectory);
            FileUtils.mkdir((String)this.workingDirectory);
        }
        CheckOutScmResult result = this.getScmManager().getProviderByRepository(repository).checkOut(repository, new ScmFileSet(this.checkoutDirectory), this.tag);
        this.checkResult((ScmResult)result);
    }

    public void update() throws ScmException {
        ScmRepository repository = this.getScmRepository();
        this.checkoutDirectory = new File(this.workingDirectory);
        UpdateScmResult result = this.getScmManager().getProviderByRepository(repository).update(repository, new ScmFileSet(new File(this.workingDirectory)), this.tag);
        this.checkResult((ScmResult)result);
    }

    public List getStatus() throws ScmException {
        ScmRepository repository = this.getScmRepository();
        StatusScmResult result = this.getScmManager().getProviderByRepository(repository).status(repository, new ScmFileSet(new File(this.workingDirectory)));
        this.checkResult((ScmResult)result);
        List changedFiles = result.getChangedFiles();
        return changedFiles;
    }

    public void add(String file) throws ScmException, IOException {
        ScmRepository repository = this.getScmRepository();
        ScmFileSet fs = new ScmFileSet(new File(this.workingDirectory), new File(file));
        AddScmResult result = this.getScmManager().getProviderByRepository(repository).add(repository, fs);
        this.checkResult((ScmResult)result);
    }

    public void remove(String message, String file) throws ScmException, IOException {
        ScmRepository repository = this.getScmRepository();
        ScmFileSet fs = new ScmFileSet(new File(this.workingDirectory), new File(file));
        RemoveScmResult result = this.getScmManager().getProviderByRepository(repository).remove(repository, fs, message);
        this.checkResult((ScmResult)result);
    }

    public void checkin(String message) throws Exception {
        ScmRepository repository = this.getScmRepository();
        CheckInScmResult result = this.getScmManager().getProviderByRepository(repository).checkIn(repository, new ScmFileSet(new File(this.workingDirectory)), this.tag, message);
        this.checkResult((ScmResult)result);
    }

    public void tag() throws ScmException {
        ScmRepository repository = this.getScmRepository();
        TagScmResult result = this.getScmManager().getProviderByRepository(repository).tag(repository, new ScmFileSet(new File(this.workingDirectory)), this.tag);
        this.checkResult((ScmResult)result);
    }

    public void setScmManager(ScmManager scmManager) {
        this.scmManager = scmManager;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public void setWorkingDirectory(String workingDirectory) {
        FileUtils.mkdir((String)workingDirectory);
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public File getCheckoutDirectory() {
        return this.checkoutDirectory;
    }

    public String getTagBase() {
        return this.tagBase;
    }

    public void setTagBase(String tagBase) {
        this.tagBase = tagBase;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

