/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.helpers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.components.inputhandler.InputHandler;
import org.codehaus.plexus.util.StringUtils;

public class ProjectVersionResolver {
    private static final String SNAPSHOT_CLASSIFIER = "-SNAPSHOT";
    private Map resolvedVersions = new HashMap();
    private final Log log;
    private final InputHandler inputHandler;
    private final boolean interactive;

    public ProjectVersionResolver(Log log, InputHandler inputHandler, boolean interactive) {
        this.log = log;
        this.inputHandler = inputHandler;
        this.interactive = interactive;
    }

    public void resolveVersion(Model model, String projectId) throws MojoExecutionException {
        if (this.resolvedVersions.containsKey(projectId)) {
            throw new IllegalArgumentException("Project: " + projectId + " is already resolved. Each project should only be resolved once.");
        }
        String projectVersion = model.getVersion();
        projectVersion = projectVersion.substring(0, projectVersion.length() - SNAPSHOT_CLASSIFIER.length());
        if (this.interactive) {
            try {
                this.log.info((CharSequence)("What is the release version for '" + projectId + "'? [" + projectVersion + "]"));
                String inputVersion = this.inputHandler.readLine();
                if (!StringUtils.isEmpty((String)inputVersion)) {
                    projectVersion = inputVersion;
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Can't read release version from user input.", e);
            }
        }
        model.setVersion(projectVersion);
        this.resolvedVersions.put(projectId, projectVersion);
    }

    public String getResolvedVersion(String groupId, String artifactId) {
        String projectId = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
        return (String)this.resolvedVersions.get(projectId);
    }

    /*
     * Unable to fully structure code
     */
    public void incrementVersion(Model model, String projectId) throws MojoExecutionException {
        projectVersion = model.getVersion();
        if (ArtifactUtils.isSnapshot((String)projectVersion)) {
            throw new MojoExecutionException("The project " + projectId + " is a snapshot (" + projectVersion + "). It appears that the release version has not been committed.");
        }
        staticVersionPart = null;
        nextVersionString = null;
        dashIdx = projectVersion.lastIndexOf("-");
        dotIdx = projectVersion.lastIndexOf(".");
        if (dashIdx > 0) {
            staticVersionPart = projectVersion.substring(0, dashIdx + 1);
            nextVersionString = projectVersion.substring(dashIdx + 1);
        } else if (dotIdx > 0) {
            staticVersionPart = projectVersion.substring(0, dotIdx + 1);
            nextVersionString = projectVersion.substring(dotIdx + 1);
        } else {
            staticVersionPart = "";
            nextVersionString = projectVersion;
        }
        try {
            nextVersionString = Integer.toString(Integer.parseInt(nextVersionString) + 1);
            projectVersion = staticVersionPart + nextVersionString + "-SNAPSHOT";
        }
        catch (NumberFormatException e) {
            projectVersion = "";
        }
        if (this.interactive) {
            try {
                this.log.info((CharSequence)("What is the new development version for '" + projectId + "'? [" + projectVersion + "]"));
                inputVersion = this.inputHandler.readLine();
                if (StringUtils.isEmpty((String)inputVersion)) ** GOTO lbl35
                projectVersion = inputVersion;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Can't read next development version from user input.", (Exception)e);
            }
        } else if ("".equals(projectVersion)) {
            throw new MojoExecutionException("Cannot determine incremented development version for: " + projectId);
        }
lbl35:
        // 4 sources

        model.setVersion(projectVersion);
        this.resolvedVersions.put(projectId, projectVersion);
    }
}

