/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import org.apache.maven.model.Scm;
import org.codehaus.plexus.util.IOUtil;

public class ReleaseProgressTracker {
    private static final String RELEASE_PROPERTIES = "release.properties";
    private static final String USERNAME = "maven.username";
    private static final String SCM_TAG = "scm.tag";
    private static final String SCM_URL = "scm.url";
    private static final String SCM_TAG_BASE = "scm.tag-base";
    private static final String SCM_PASSWORD = "scm.password";
    private static final String CHECKPOINT_PREFIX = "checkpoint.";
    private static final String SCM_INFO_PREFIX = "scm-info.";
    public static final String CP_INITIALIZED = "initialized";
    public static final String CP_LOCAL_MODIFICATIONS_CHECKED = "local-modifications-checked";
    public static final String CP_POM_TRANSFORMED_FOR_RELEASE = "transformed-pom-for-release";
    public static final String CP_GENERATED_RELEASE_POM = "generated-release-pom";
    public static final String CP_CHECKED_IN_RELEASE_VERSION = "checked-in-release-version";
    public static final String CP_TAGGED_RELEASE = "tagged-release";
    public static final String CP_POM_TRANSORMED_FOR_DEVELOPMENT = "transform-pom-for-development";
    public static final String CP_REMOVED_RELEASE_POM = "removed-release-pom";
    public static final String CP_CHECKED_IN_DEVELOPMENT_VERSION = "check-in-development-version";
    public static final String CP_PREPARED_RELEASE = "prepared-release";
    private Properties releaseProperties;
    private boolean resumeAtCheckpoint = false;

    private ReleaseProgressTracker(Properties properties) {
        this.releaseProperties = properties;
    }

    public static ReleaseProgressTracker loadOrCreate(String basedir) throws IOException {
        ReleaseProgressTracker tracker = new File(basedir, RELEASE_PROPERTIES).exists() ? ReleaseProgressTracker.load(basedir) : ReleaseProgressTracker.create();
        return tracker;
    }

    public static ReleaseProgressTracker create() {
        return new ReleaseProgressTracker(new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReleaseProgressTracker load(String basedir) throws IOException {
        Properties rp;
        File releasePropertiesFile = new File(basedir, RELEASE_PROPERTIES);
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(releasePropertiesFile);
            rp = new Properties();
            rp.load(inStream);
        }
        catch (Throwable throwable) {
            IOUtil.close(inStream);
            throw throwable;
        }
        IOUtil.close((InputStream)inStream);
        return new ReleaseProgressTracker(rp);
    }

    public static String getReleaseProgressFilename() {
        return RELEASE_PROPERTIES;
    }

    public void setUsername(String username) {
        this.releaseProperties.setProperty(USERNAME, username);
    }

    public String getUsername() {
        return this.releaseProperties.getProperty(USERNAME);
    }

    public void setScmTag(String scmTag) {
        this.releaseProperties.setProperty(SCM_TAG, scmTag);
    }

    public String getScmTag() {
        return this.releaseProperties.getProperty(SCM_TAG);
    }

    public void setScmUrl(String scmUrl) {
        this.releaseProperties.setProperty(SCM_URL, scmUrl);
    }

    public String getScmUrl() {
        return this.releaseProperties.getProperty(SCM_URL);
    }

    public void setScmTagBase(String tagBase) {
        this.releaseProperties.setProperty(SCM_TAG_BASE, tagBase);
    }

    public String getScmTagBase() {
        return this.releaseProperties.getProperty(SCM_TAG_BASE);
    }

    public void setPassword(String password) {
        this.releaseProperties.setProperty(SCM_PASSWORD, password);
    }

    public String getPassword() {
        return this.releaseProperties.getProperty(SCM_PASSWORD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint(String basedir, String pointName) throws IOException {
        this.setCheckpoint(pointName);
        File releasePropertiesFile = new File(basedir, RELEASE_PROPERTIES);
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(releasePropertiesFile);
            this.releaseProperties.store(outStream, "Generated by Release Plugin on: " + new Date());
        }
        catch (Throwable throwable) {
            IOUtil.close(outStream);
            throw throwable;
        }
        IOUtil.close((OutputStream)outStream);
    }

    private void setCheckpoint(String pointName) {
        this.releaseProperties.setProperty(CHECKPOINT_PREFIX + pointName, "OK");
    }

    public boolean verifyCheckpoint(String pointName) {
        return this.resumeAtCheckpoint && "OK".equals(this.releaseProperties.getProperty(CHECKPOINT_PREFIX + pointName));
    }

    public void setResumeAtCheckpoint(boolean resumeAtCheckpoint) {
        this.resumeAtCheckpoint = resumeAtCheckpoint;
    }

    public void addOriginalScmInfo(String projectId, Scm scm) {
        String tag;
        String url;
        String devConnection;
        String connection = scm.getConnection();
        if (connection != null) {
            this.releaseProperties.setProperty(SCM_INFO_PREFIX + projectId + ".connection", connection);
        }
        if ((devConnection = scm.getDeveloperConnection()) != null) {
            this.releaseProperties.setProperty(SCM_INFO_PREFIX + projectId + ".developerConnection", devConnection);
        }
        if ((url = scm.getUrl()) != null) {
            this.releaseProperties.setProperty(SCM_INFO_PREFIX + projectId + ".url", url);
        }
        if ((tag = scm.getTag()) != null) {
            this.releaseProperties.setProperty(SCM_INFO_PREFIX + projectId + ".tag", tag);
        }
    }

    public void restoreScmInfo(String projectId, Scm scm) {
        String tag;
        String url;
        String devConnection;
        String connection = this.releaseProperties.getProperty(SCM_INFO_PREFIX + projectId + ".connection");
        if (connection != null) {
            scm.setConnection(connection);
        }
        if ((devConnection = this.releaseProperties.getProperty(SCM_INFO_PREFIX + projectId + ".connection")) != null) {
            scm.setDeveloperConnection(devConnection);
        }
        if ((url = this.releaseProperties.getProperty(SCM_INFO_PREFIX + projectId + ".url")) != null) {
            scm.setUrl(url);
        }
        if ((tag = this.releaseProperties.getProperty(SCM_INFO_PREFIX + projectId + ".tag")) != null) {
            scm.setTag(tag);
        }
    }
}

