/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.helpers;

import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.release.helpers.ReleaseProgressTracker;

public class ProjectScmRewriter {
    private ReleaseProgressTracker releaseProgress;

    public ProjectScmRewriter(ReleaseProgressTracker releaseProgress) {
        this.releaseProgress = releaseProgress;
    }

    public void rewriteScmInfo(Model model, String projectId, String tagLabel) throws MojoExecutionException {
        Scm scm = model.getScm();
        if (scm != null) {
            this.releaseProgress.addOriginalScmInfo(projectId, scm);
            this.rewriteScmConnection(scm, tagLabel);
        }
    }

    public void restoreScmInfo(Model model) {
        Scm scm = model.getScm();
        if (scm != null) {
            String projectId = ArtifactUtils.versionlessKey((String)model.getGroupId(), (String)model.getArtifactId());
            this.releaseProgress.restoreScmInfo(projectId, scm);
        }
    }

    private void rewriteScmConnection(Scm scm, String tag) {
        String scmConnection;
        if (scm != null && (scmConnection = scm.getConnection()) != null && scmConnection.startsWith("scm:svn")) {
            String url;
            scm.setConnection(this.convertSvnConnectionString(scmConnection, tag));
            String devConnection = scm.getDeveloperConnection();
            if (devConnection != null) {
                scm.setDeveloperConnection(this.convertSvnConnectionString(devConnection, tag));
            }
            if ((url = scm.getUrl()) != null) {
                scm.setUrl(this.convertSvnConnectionString(url, tag));
            }
        }
    }

    private String convertSvnConnectionString(String scmConnection, String tag) {
        int trunkBegin = scmConnection.indexOf("/trunk");
        if (trunkBegin >= 0) {
            String tail = "";
            if (scmConnection.length() > trunkBegin + "/trunk".length() && !(tail = scmConnection.substring(trunkBegin + "/trunk".length())).startsWith("/")) {
                tail = tail + "/";
            }
            scmConnection = scmConnection.substring(0, trunkBegin) + "/tags/" + tag + tail;
        } else {
            int begin = scmConnection.indexOf("/branches/");
            if (begin >= 0) {
                int end = scmConnection.indexOf(47, begin + "/branches/".length());
                scmConnection = scmConnection.substring(0, begin) + "/tags/" + tag;
                if (end >= 0 && end < scmConnection.length() - 1) {
                    scmConnection = scmConnection + scmConnection.substring(end);
                }
            }
        }
        return scmConnection;
    }
}

