package org.apache.maven.plugins.release;

/*
 * Copyright 2005-2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;

import java.util.List;

/**
 * Clean up after a release preparation.
 *
 * @author <a href="mailto:brett@apache.org">Brett Porter</a>
 * @version $Id: CleanReleaseMojo.java 399171 2006-05-03 06:41:11Z brett $
 * @aggregator
 * @goal clean
 */
public class CleanReleaseMojo
    extends AbstractReleaseMojo
{
    /**
     * @parameter expression="${reactorProjects}"
     * @required
     * @readonly
     */
    private List reactorProjects;

    public void execute()
        throws MojoExecutionException, MojoFailureException
    {
        ReleaseConfiguration releaseConfiguration = new ReleaseConfiguration();
        releaseConfiguration.setReactorProjects( reactorProjects );
        releaseManager.clean( releaseConfiguration );
    }

    List getReactorProjects()
    {
        return reactorProjects;
    }
}
