/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.release.ReleaseManager;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractReleaseMojo
extends AbstractMojo {
    private String username;
    private String password;
    private String tag;
    private String tagBase;
    private File basedir;
    private Settings settings;
    protected MavenProject project;
    protected ReleaseManager releaseManager;
    private String arguments;
    private String pomFileName;

    protected ReleaseConfiguration createReleaseConfiguration() {
        ReleaseConfiguration config = new ReleaseConfiguration();
        config.setInteractive(this.settings.isInteractiveMode());
        config.setPassword(this.password);
        config.setReleaseLabel(this.tag);
        config.setSettings(this.settings);
        config.setTagBase(this.tagBase);
        config.setUsername(this.username);
        config.setWorkingDirectory(this.basedir);
        config.setPomFileName(this.pomFileName);
        List profiles = this.project.getActiveProfiles();
        String arguments = this.arguments;
        if (profiles != null && !profiles.isEmpty()) {
            arguments = !StringUtils.isEmpty((String)arguments) ? arguments + " -P " : "-P ";
            Iterator it = profiles.iterator();
            while (it.hasNext()) {
                Profile profile = (Profile)it.next();
                arguments = arguments + profile.getId();
                if (!it.hasNext()) continue;
                arguments = arguments + ",";
            }
        }
        config.setAdditionalArguments(arguments);
        return config;
    }

    void setReleaseManager(ReleaseManager releaseManager) {
        this.releaseManager = releaseManager;
    }

    Settings getSettings() {
        return this.settings;
    }
}

