/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Scm;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;
import org.apache.maven.plugins.release.config.ReleaseConfigurationStore;
import org.apache.maven.plugins.release.config.ReleaseConfigurationStoreException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;

public class PropertiesReleaseConfigurationStore
extends AbstractLogEnabled
implements ReleaseConfigurationStore {
    public ReleaseConfiguration read(ReleaseConfiguration mergeConfiguration) throws ReleaseConfigurationStoreException {
        return this.read(mergeConfiguration, PropertiesReleaseConfigurationStore.getDefaultReleasePropertiesFile(mergeConfiguration));
    }

    public ReleaseConfiguration read(File file) throws ReleaseConfigurationStoreException {
        return this.read(null, file);
    }

    /*
     * Loose catch block
     */
    public ReleaseConfiguration read(ReleaseConfiguration mergeConfiguration, File file) throws ReleaseConfigurationStoreException {
        Properties properties = new Properties();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            properties.load(inStream);
        }
        catch (FileNotFoundException e) {
            this.getLogger().debug(file.getName() + " not found - using empty properties");
            IOUtil.close((InputStream)inStream);
        }
        catch (IOException e2) {
            throw new ReleaseConfigurationStoreException("Error reading properties file '" + file.getName() + "': " + e2.getMessage(), e2);
            {
                catch (Throwable throwable) {
                    IOUtil.close(inStream);
                    throw throwable;
                }
            }
        }
        IOUtil.close((InputStream)inStream);
        ReleaseConfiguration releaseConfiguration = new ReleaseConfiguration();
        releaseConfiguration.setCompletedPhase(properties.getProperty("completedPhase"));
        releaseConfiguration.setUrl(properties.getProperty("scm.url"));
        releaseConfiguration.setUsername(properties.getProperty("scm.username"));
        releaseConfiguration.setPassword(properties.getProperty("scm.password"));
        releaseConfiguration.setPrivateKey(properties.getProperty("scm.privateKey"));
        releaseConfiguration.setPassphrase(properties.getProperty("scm.passphrase"));
        releaseConfiguration.setTagBase(properties.getProperty("scm.tagBase"));
        releaseConfiguration.setReleaseLabel(properties.getProperty("scm.tag"));
        releaseConfiguration.setAdditionalArguments(properties.getProperty("exec.additionalArguments"));
        releaseConfiguration.setPomFileName(properties.getProperty("exec.pomFileName"));
        releaseConfiguration.setPreparationGoals(properties.getProperty("preparationGoals"));
        Iterator<Object> i = properties.keySet().iterator();
        while (i.hasNext()) {
            int index;
            String property = (String)i.next();
            if (property.startsWith("project.rel.")) {
                releaseConfiguration.mapReleaseVersion(property.substring("project.rel.".length()), properties.getProperty(property));
                continue;
            }
            if (property.startsWith("project.dev.")) {
                releaseConfiguration.mapDevelopmentVersion(property.substring("project.dev.".length()), properties.getProperty(property));
                continue;
            }
            if (!property.startsWith("project.scm.") || (index = property.lastIndexOf(46)) <= "project.scm.".length()) continue;
            String key = property.substring("project.scm.".length(), index);
            if (releaseConfiguration.getOriginalScmInfo().containsKey(key)) continue;
            if (properties.getProperty("project.scm." + key + ".empty") != null) {
                releaseConfiguration.mapOriginalScmInfo(key, null);
                continue;
            }
            Scm scm = new Scm();
            scm.setConnection(properties.getProperty("project.scm." + key + ".connection"));
            scm.setDeveloperConnection(properties.getProperty("project.scm." + key + ".developerConnection"));
            scm.setUrl(properties.getProperty("project.scm." + key + ".url"));
            scm.setTag(properties.getProperty("project.scm." + key + ".tag"));
            releaseConfiguration.mapOriginalScmInfo(key, scm);
        }
        if (mergeConfiguration != null) {
            releaseConfiguration.merge(mergeConfiguration);
        }
        return releaseConfiguration;
    }

    public void write(ReleaseConfiguration config) throws ReleaseConfigurationStoreException {
        this.write(config, PropertiesReleaseConfigurationStore.getDefaultReleasePropertiesFile(config));
    }

    public void delete(ReleaseConfiguration config) {
        File file = PropertiesReleaseConfigurationStore.getDefaultReleasePropertiesFile(config);
        if (file.exists()) {
            file.delete();
        }
    }

    public void write(ReleaseConfiguration config, File file) throws ReleaseConfigurationStoreException {
        Map.Entry entry;
        Properties properties = new Properties();
        properties.setProperty("completedPhase", config.getCompletedPhase());
        properties.setProperty("scm.url", config.getUrl());
        if (config.getUsername() != null) {
            properties.setProperty("scm.username", config.getUsername());
        }
        if (config.getPassword() != null) {
            properties.setProperty("scm.password", config.getPassword());
        }
        if (config.getPrivateKey() != null) {
            properties.setProperty("scm.privateKey", config.getPrivateKey());
        }
        if (config.getPassphrase() != null) {
            properties.setProperty("scm.passphrase", config.getPassphrase());
        }
        if (config.getTagBase() != null) {
            properties.setProperty("scm.tagBase", config.getTagBase());
        }
        if (config.getReleaseLabel() != null) {
            properties.setProperty("scm.tag", config.getReleaseLabel());
        }
        if (config.getAdditionalArguments() != null) {
            properties.setProperty("exec.additionalArguments", config.getAdditionalArguments());
        }
        if (config.getPomFileName() != null) {
            properties.setProperty("exec.pomFileName", config.getPomFileName());
        }
        if (config.getPreparationGoals() != null) {
            properties.setProperty("preparationGoals", config.getPreparationGoals());
        }
        Iterator i = config.getReleaseVersions().entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            properties.setProperty("project.rel." + entry.getKey(), (String)entry.getValue());
        }
        i = config.getDevelopmentVersions().entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            properties.setProperty("project.dev." + entry.getKey(), (String)entry.getValue());
        }
        i = config.getOriginalScmInfo().entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            Scm scm = (Scm)entry.getValue();
            String prefix = "project.scm." + entry.getKey();
            if (scm != null) {
                properties.setProperty(prefix + ".connection", scm.getConnection());
                if (scm.getDeveloperConnection() != null) {
                    properties.setProperty(prefix + ".developerConnection", scm.getDeveloperConnection());
                }
                if (scm.getUrl() != null) {
                    properties.setProperty(prefix + ".url", scm.getUrl());
                }
                if (scm.getTag() == null) continue;
                properties.setProperty(prefix + ".tag", scm.getTag());
                continue;
            }
            properties.setProperty(prefix + ".empty", "true");
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(file);
            properties.store(outStream, "release configuration");
        }
        catch (IOException e) {
            try {
                throw new ReleaseConfigurationStoreException("Error writing properties file '" + file.getName() + "': " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(outStream);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)outStream);
    }

    private static File getDefaultReleasePropertiesFile(ReleaseConfiguration mergeConfiguration) {
        return new File(mergeConfiguration.getWorkingDirectory(), "release.properties");
    }
}

