/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.phase;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugins.release.ReleaseExecutionException;
import org.apache.maven.plugins.release.ReleaseFailureException;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;
import org.apache.maven.plugins.release.phase.AbstractReleasePhase;
import org.apache.maven.plugins.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.plugins.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;

public class CheckPomPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;

    public void execute(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException, ReleaseFailureException {
        if (StringUtils.isEmpty((String)releaseConfiguration.getUrl())) {
            MavenProject rootProject = (MavenProject)releaseConfiguration.getReactorProjects().get(0);
            if (rootProject != null && rootProject.getScm() != null) {
                if (rootProject.getScm().getDeveloperConnection() != null) {
                    releaseConfiguration.setUrl(rootProject.getScm().getDeveloperConnection());
                } else if (rootProject.getScm().getConnection() != null) {
                    releaseConfiguration.setUrl(rootProject.getScm().getConnection());
                }
            }
            if (StringUtils.isEmpty((String)releaseConfiguration.getUrl())) {
                throw new ReleaseFailureException("Missing required setting: scm connection or developerConnection must be specified.");
            }
            try {
                this.scmRepositoryConfigurator.getConfiguredRepository(releaseConfiguration);
            }
            catch (ScmRepositoryException e) {
                throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
            }
            catch (NoSuchScmProviderException e) {
                throw new ReleaseFailureException("The provider given in the SCM URL could not be found: " + e.getMessage());
            }
        }
        List reactorProjects = releaseConfiguration.getReactorProjects();
        Iterator it = reactorProjects.iterator();
        while (it.hasNext()) {
            MavenProject project = (MavenProject)it.next();
            String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            if (ArtifactUtils.isSnapshot((String)project.getVersion())) continue;
            throw new ReleaseFailureException("The project " + projectId + " isn't a snapshot (" + project.getVersion() + ").");
        }
    }

    public void simulate(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException, ReleaseFailureException {
        this.execute(releaseConfiguration);
    }
}

