/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.phase;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugins.release.ReleaseExecutionException;
import org.apache.maven.plugins.release.ReleaseFailureException;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;
import org.apache.maven.plugins.release.phase.AbstractReleasePhase;
import org.apache.maven.plugins.release.scm.ReleaseScmCommandException;
import org.apache.maven.plugins.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.plugins.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;

public class ScmCheckModificationsPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;
    private Set excludedFiles = new HashSet<String>(Arrays.asList("pom.xml", "pom.xml.backup", "pom.xml.tag", "pom.xml.next", "release.properties"));

    public void execute(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException, ReleaseFailureException {
        StatusScmResult result;
        ScmProvider provider;
        ScmRepository repository;
        this.getLogger().info("Verifying that there are no local modifications...");
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseConfiguration);
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage() + " for URL: " + releaseConfiguration.getUrl(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
        try {
            result = provider.status(repository, new ScmFileSet(releaseConfiguration.getWorkingDirectory()));
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error occurred during the status check process: " + e.getMessage(), e);
        }
        if (!result.isSuccess()) {
            throw new ReleaseScmCommandException("Unable to check for local modifications", (ScmResult)result);
        }
        List changedFiles = result.getChangedFiles();
        Iterator i = changedFiles.iterator();
        while (i.hasNext()) {
            ScmFile f = (ScmFile)i.next();
            String fileName = f.getPath().replace('\\', '/');
            if (!this.excludedFiles.contains(fileName = fileName.substring(fileName.lastIndexOf(47) + 1, fileName.length()))) continue;
            i.remove();
        }
        if (!changedFiles.isEmpty()) {
            StringBuffer message = new StringBuffer();
            Iterator i2 = changedFiles.iterator();
            while (i2.hasNext()) {
                ScmFile file = (ScmFile)i2.next();
                message.append(file.toString());
                message.append("\n");
            }
            throw new ReleaseFailureException("Cannot prepare the release because you have local modifications : \n" + message);
        }
    }

    public void simulate(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException, ReleaseFailureException {
        this.execute(releaseConfiguration);
    }
}

