/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.phase;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugins.release.ReleaseExecutionException;
import org.apache.maven.plugins.release.ReleaseFailureException;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;
import org.apache.maven.plugins.release.phase.AbstractReleasePhase;
import org.apache.maven.plugins.release.scm.ReleaseScmCommandException;
import org.apache.maven.plugins.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.plugins.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;

public class ScmCommitPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;
    private String messageFormat;

    public void execute(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException, ReleaseFailureException {
        CheckInScmResult result;
        ScmProvider provider;
        ScmRepository repository;
        ScmCommitPhase.validateConfiguration(releaseConfiguration);
        this.getLogger().info("Checking in modified POMs...");
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseConfiguration);
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
        Collection pomFiles = ScmCommitPhase.createPomFiles(releaseConfiguration.getReactorProjects());
        File[] files = pomFiles.toArray(new File[pomFiles.size()]);
        try {
            ScmFileSet fileSet = new ScmFileSet(releaseConfiguration.getWorkingDirectory(), files);
            result = provider.checkIn(repository, fileSet, null, this.createMessage(releaseConfiguration));
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error is occurred in the checkin process: " + e.getMessage(), e);
        }
        if (!result.isSuccess()) {
            throw new ReleaseScmCommandException("Unable to commit files", (ScmResult)result);
        }
    }

    public void simulate(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException, ReleaseFailureException {
        ScmCommitPhase.validateConfiguration(releaseConfiguration);
        Collection pomFiles = ScmCommitPhase.createPomFiles(releaseConfiguration.getReactorProjects());
        this.getLogger().info("Full run would be checking in " + pomFiles.size() + " files with message: '" + this.createMessage(releaseConfiguration) + "'");
    }

    private static void validateConfiguration(ReleaseConfiguration releaseConfiguration) throws ReleaseFailureException {
        if (releaseConfiguration.getReleaseLabel() == null) {
            throw new ReleaseFailureException("A release label is required for committing");
        }
    }

    private String createMessage(ReleaseConfiguration releaseConfiguration) {
        return MessageFormat.format(this.messageFormat, releaseConfiguration.getReleaseLabel());
    }

    private static Collection createPomFiles(List reactorProjects) {
        ArrayList<File> pomFiles = new ArrayList<File>(reactorProjects.size());
        Iterator i = reactorProjects.iterator();
        while (i.hasNext()) {
            MavenProject project = (MavenProject)i.next();
            pomFiles.add(project.getFile());
        }
        return pomFiles;
    }
}

