/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.phase;

import org.apache.maven.plugins.release.ReleaseExecutionException;
import org.apache.maven.plugins.release.ReleaseFailureException;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;
import org.apache.maven.plugins.release.phase.AbstractReleasePhase;
import org.apache.maven.plugins.release.scm.ReleaseScmCommandException;
import org.apache.maven.plugins.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.plugins.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;

public class ScmTagPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;

    public void execute(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException, ReleaseFailureException {
        TagScmResult result;
        ScmProvider provider;
        ScmRepository repository;
        ScmTagPhase.validateConfiguration(releaseConfiguration);
        this.getLogger().info("Tagging release with the label " + releaseConfiguration.getReleaseLabel() + "...");
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseConfiguration);
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
        try {
            ScmFileSet fileSet = new ScmFileSet(releaseConfiguration.getWorkingDirectory());
            result = provider.tag(repository, fileSet, releaseConfiguration.getReleaseLabel());
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error is occurred in the tag process: " + e.getMessage(), e);
        }
        if (!result.isSuccess()) {
            throw new ReleaseScmCommandException("Unable to tag SCM", (ScmResult)result);
        }
    }

    public void simulate(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException, ReleaseFailureException {
        ScmTagPhase.validateConfiguration(releaseConfiguration);
        this.getLogger().info("Full run would be tagging " + releaseConfiguration.getWorkingDirectory() + " with label: '" + releaseConfiguration.getReleaseLabel());
    }

    private static void validateConfiguration(ReleaseConfiguration releaseConfiguration) throws ReleaseFailureException {
        if (releaseConfiguration.getReleaseLabel() == null) {
            throw new ReleaseFailureException("A release label is required for committing");
        }
    }
}

