/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.release.AbstractReleaseMojo;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseUtils;

public class PrepareReleaseMojo
extends AbstractReleaseMojo {
    private boolean resume;
    private boolean generateReleasePoms;
    private boolean useEditMode;
    private boolean updateDependencies;
    private boolean autoVersionSubmodules;
    private boolean dryRun;
    private boolean addSchema;
    private String preparationGoals;
    private boolean commitByProject;
    private boolean allowTimestampedSnapshots;
    private String releaseVersion;
    private String developmentVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        ReleaseDescriptor config = this.createReleaseDescriptor();
        config.setAddSchema(this.addSchema);
        config.setGenerateReleasePoms(this.generateReleasePoms);
        config.setScmUseEditMode(this.useEditMode);
        config.setPreparationGoals(this.preparationGoals);
        config.setCommitByProject(this.commitByProject);
        config.setUpdateDependencies(this.updateDependencies);
        config.setAutoVersionSubmodules(this.autoVersionSubmodules);
        config.setAllowTimestampedSnapshots(this.allowTimestampedSnapshots);
        config.setDefaultReleaseVersion(this.releaseVersion);
        config.setDefaultDevelopmentVersion(this.developmentVersion);
        ReleaseDescriptor sysPropertiesConfig = ReleaseUtils.copyPropertiesToReleaseDescriptor((Properties)System.getProperties());
        this.mergeCommandLineConfig(config, sysPropertiesConfig);
        try {
            this.releaseManager.prepare(config, this.getReleaseEnvironment(), this.reactorProjects, this.resume, this.dryRun);
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ReleaseFailureException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    private void mergeCommandLineConfig(ReleaseDescriptor config, ReleaseDescriptor sysPropertiesConfig) {
        if (sysPropertiesConfig.getReleaseVersions() != null) {
            config.getReleaseVersions().putAll(sysPropertiesConfig.getReleaseVersions());
        }
        if (sysPropertiesConfig.getDevelopmentVersions() != null) {
            config.getDevelopmentVersions().putAll(sysPropertiesConfig.getDevelopmentVersions());
        }
    }
}

