package org.apache.maven.plugins.release;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-release-plugin.<br/> Call <pre>  mvn release:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Mon Jun 27 09:55:55 IST 2011
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.6)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-release-plugin:2.2", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Release Plugin", 0 );
        append( sb, "This plugin is used to release a project with Maven, saving a lot of repetitive, manual work.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 9 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "branch".equals( goal ) )
        {
            append( sb, "release:branch", 0 );
            append( sb, "Branch a project in SCM, using the same steps as the release:prepare goal, creating a branch instead of a tag. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/branch.html.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addSchema (Default: true)", 2 );
                append( sb, "Whether to add a schema to the POM if it was previously missing on release.", 3 );
                append( sb, "", 0 );

                append( sb, "arguments", 2 );
                append( sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3 );
                append( sb, "", 0 );

                append( sb, "autoVersionSubmodules (Default: false)", 2 );
                append( sb, "Whether to automatically assign submodules the parent version. If set to false, the user will be prompted for the version of each submodules.", 3 );
                append( sb, "", 0 );

                append( sb, "branchBase", 2 );
                append( sb, "The branch base directory in SVN, you must define it if you don\'t use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/branches. The URL is an SVN URL and does not include the SCM provider and protocol.", 3 );
                append( sb, "", 0 );

                append( sb, "branchName", 2 );
                append( sb, "The branch name to use.", 3 );
                append( sb, "", 0 );

                append( sb, "checkModificationExcludeList", 2 );
                append( sb, "Command-line version of checkModificationExcludes", 3 );
                append( sb, "", 0 );

                append( sb, "checkModificationExcludes", 2 );
                append( sb, "Additional files that will skipped when checking for modifications on the working copy. Is ignored, when checkModificationExcludes is set.", 3 );
                append( sb, "", 0 );

                append( sb, "developmentVersion", 2 );
                append( sb, "Default version to use for new local working copy.", 3 );
                append( sb, "", 0 );

                append( sb, "dryRun (Default: false)", 2 );
                append( sb, "Dry run: don\'t checkin or tag anything in the scm repository, or modify the checkout. Running mvn -DdryRun=true release:prepare is useful in order to check that modifications to poms and scm operations (only listed on the console) are working as expected. Modified POMs are written alongside the originals without modifying them.", 3 );
                append( sb, "", 0 );

                append( sb, "javaHome (Default: ${java.home})", 2 );
                append( sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "localCheckout (Default: false)", 2 );
                append( sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3 );
                append( sb, "", 0 );

                append( sb, "localRepoDirectory (Default: ${maven.repo.local})", 2 );
                append( sb, "The command-line local repository directory in use for this build (if specified).", 3 );
                append( sb, "", 0 );

                append( sb, "mavenExecutorId (Default: invoker)", 2 );
                append( sb, "Role hint of the MavenExecutor implementation to use.", 3 );
                append( sb, "", 0 );

                append( sb, "mavenHome (Default: ${maven.home})", 2 );
                append( sb, "The M2_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The SCM password to use.", 3 );
                append( sb, "", 0 );

                append( sb, "pomFileName", 2 );
                append( sb, "The file name of the POM to execute any goals against.", 3 );
                append( sb, "", 0 );

                append( sb, "providerImplementations", 2 );
                append( sb, "List of provider implementations.", 3 );
                append( sb, "", 0 );

                append( sb, "pushChanges (Default: true)", 2 );
                append( sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3 );
                append( sb, "", 0 );

                append( sb, "releaseVersion", 2 );
                append( sb, "Default version to use when preparing a release or a branch.", 3 );
                append( sb, "", 0 );

                append( sb, "remoteTagging (Default: true)", 2 );
                append( sb, "currently only implemented with svn scm. Enable a workaround to prevent issue due to svn client > 1.5.0 (http://jira.codehaus.org/browse/SCM-406)", 3 );
                append( sb, "", 0 );

                append( sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2 );
                append( sb, "The message prefix to use for all SCM changes.", 3 );
                append( sb, "", 0 );

                append( sb, "suppressCommitBeforeBranch (Default: false)", 2 );
                append( sb, "Whether to suppress a commit of changes to the working copy before the tag is created.\n\nThis requires remoteTagging to be set to false.\n\nsuppressCommitBeforeBranch is useful when you want to avoid poms with released versions in all revisions of your trunk or development branch.", 3 );
                append( sb, "", 0 );

                append( sb, "tag", 2 );
                append( sb, "The SCM tag to use.", 3 );
                append( sb, "", 0 );

                append( sb, "tagBase", 2 );
                append( sb, "The tag base directory in SVN, you must define it if you don\'t use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3 );
                append( sb, "", 0 );

                append( sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2 );
                append( sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3 );
                append( sb, "", 0 );

                append( sb, "updateBranchVersions (Default: false)", 2 );
                append( sb, "Whether to update versions in the branch.", 3 );
                append( sb, "", 0 );

                append( sb, "updateDependencies (Default: true)", 2 );
                append( sb, "Whether to update dependencies version to the next development version.", 3 );
                append( sb, "", 0 );

                append( sb, "updateVersionsToSnapshot (Default: true)", 2 );
                append( sb, "Whether to update versions to SNAPSHOT in the branch.", 3 );
                append( sb, "", 0 );

                append( sb, "updateWorkingCopyVersions (Default: true)", 2 );
                append( sb, "Whether to update versions in the working copy.", 3 );
                append( sb, "", 0 );

                append( sb, "useEditMode (Default: false)", 2 );
                append( sb, "Whether to use \'edit\' mode on the SCM, to lock the file for editing during SCM operations.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The SCM username to use.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "clean".equals( goal ) )
        {
            append( sb, "release:clean", 0 );
            append( sb, "Clean up after a release preparation. This is done automatically after a successful release:perform, so is best served for cleaning up a failed or abandoned release, or a dry run. Note that only the working copy is cleaned up, no previous steps are rolled back. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/clean-release.html.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "arguments", 2 );
                append( sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3 );
                append( sb, "", 0 );

                append( sb, "javaHome (Default: ${java.home})", 2 );
                append( sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "localCheckout (Default: false)", 2 );
                append( sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3 );
                append( sb, "", 0 );

                append( sb, "localRepoDirectory (Default: ${maven.repo.local})", 2 );
                append( sb, "The command-line local repository directory in use for this build (if specified).", 3 );
                append( sb, "", 0 );

                append( sb, "mavenExecutorId (Default: invoker)", 2 );
                append( sb, "Role hint of the MavenExecutor implementation to use.", 3 );
                append( sb, "", 0 );

                append( sb, "mavenHome (Default: ${maven.home})", 2 );
                append( sb, "The M2_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The SCM password to use.", 3 );
                append( sb, "", 0 );

                append( sb, "pomFileName", 2 );
                append( sb, "The file name of the POM to execute any goals against.", 3 );
                append( sb, "", 0 );

                append( sb, "providerImplementations", 2 );
                append( sb, "List of provider implementations.", 3 );
                append( sb, "", 0 );

                append( sb, "pushChanges (Default: true)", 2 );
                append( sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3 );
                append( sb, "", 0 );

                append( sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2 );
                append( sb, "The message prefix to use for all SCM changes.", 3 );
                append( sb, "", 0 );

                append( sb, "tag", 2 );
                append( sb, "The SCM tag to use.", 3 );
                append( sb, "", 0 );

                append( sb, "tagBase", 2 );
                append( sb, "The tag base directory in SVN, you must define it if you don\'t use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3 );
                append( sb, "", 0 );

                append( sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2 );
                append( sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The SCM username to use.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "release:help", 0 );
            append( sb, "Display help information on maven-release-plugin.\nCall\n\u00a0\u00a0mvn\u00a0release:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "perform".equals( goal ) )
        {
            append( sb, "release:perform", 0 );
            append( sb, "Perform a release from SCM, either from a specified tag, or the tag representing the previous release in the working copy created by release:prepare. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/perform-release.html.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "arguments", 2 );
                append( sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3 );
                append( sb, "", 0 );

                append( sb, "connectionUrl", 2 );
                append( sb, "The SCM URL to checkout from. If omitted, the one from the release.properties file is used, followed by the URL from the current POM.", 3 );
                append( sb, "", 0 );

                append( sb, "goals", 2 );
                append( sb, "A space separated list of goals to execute on deployment. Default value is either deploy or deploy site-deploy, if the project has a <distributionManagement>/<site> element.", 3 );
                append( sb, "", 0 );

                append( sb, "javaHome (Default: ${java.home})", 2 );
                append( sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "localCheckout (Default: false)", 2 );
                append( sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3 );
                append( sb, "", 0 );

                append( sb, "localRepoDirectory (Default: ${maven.repo.local})", 2 );
                append( sb, "The command-line local repository directory in use for this build (if specified).", 3 );
                append( sb, "", 0 );

                append( sb, "mavenExecutorId (Default: invoker)", 2 );
                append( sb, "Role hint of the MavenExecutor implementation to use.", 3 );
                append( sb, "", 0 );

                append( sb, "mavenHome (Default: ${maven.home})", 2 );
                append( sb, "The M2_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The SCM password to use.", 3 );
                append( sb, "", 0 );

                append( sb, "pomFileName", 2 );
                append( sb, "The file name of the POM to execute any goals against.", 3 );
                append( sb, "", 0 );

                append( sb, "providerImplementations", 2 );
                append( sb, "List of provider implementations.", 3 );
                append( sb, "", 0 );

                append( sb, "pushChanges (Default: true)", 2 );
                append( sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3 );
                append( sb, "", 0 );

                append( sb, "releaseProfiles", 2 );
                append( sb, "Comma separated profiles to enable on deployment, in addition to active profiles for project execution.", 3 );
                append( sb, "", 0 );

                append( sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2 );
                append( sb, "The message prefix to use for all SCM changes.", 3 );
                append( sb, "", 0 );

                append( sb, "tag", 2 );
                append( sb, "The SCM tag to use.", 3 );
                append( sb, "", 0 );

                append( sb, "tagBase", 2 );
                append( sb, "The tag base directory in SVN, you must define it if you don\'t use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3 );
                append( sb, "", 0 );

                append( sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2 );
                append( sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useReleaseProfile (Default: true)", 2 );
                append( sb, "Whether to use the release profile that adds sources and javadocs to the released artifact, if appropriate.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The SCM username to use.", 3 );
                append( sb, "", 0 );

                append( sb, "workingDirectory (Default: ${project.build.directory}/checkout)", 2 );
                append( sb, "The checkout directory.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "prepare".equals( goal ) )
        {
            append( sb, "release:prepare", 0 );
            append( sb, "Prepare for a release in SCM. Steps through several phases to ensure the POM is ready to be released and then prepares SCM to eventually contain a tagged version of the release and a record in the local copy of the parameters used. This can be followed by a call to release:perform. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/prepare-release.html.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addSchema (Default: true)", 2 );
                append( sb, "Whether to add a schema to the POM if it was previously missing on release.", 3 );
                append( sb, "", 0 );

                append( sb, "allowTimestampedSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow timestamped SNAPSHOT dependencies. Default is to fail when finding any SNAPSHOT.", 3 );
                append( sb, "", 0 );

                append( sb, "arguments", 2 );
                append( sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3 );
                append( sb, "", 0 );

                append( sb, "autoVersionSubmodules (Default: false)", 2 );
                append( sb, "Whether to automatically assign submodules the parent version. If set to false, the user will be prompted for the version of each submodules.", 3 );
                append( sb, "", 0 );

                append( sb, "checkModificationExcludeList", 2 );
                append( sb, "Command-line version of checkModificationExcludes", 3 );
                append( sb, "", 0 );

                append( sb, "checkModificationExcludes", 2 );
                append( sb, "Additional files that will skipped when checking for modifications on the working copy. Is ignored, when checkModificationExcludes is set.", 3 );
                append( sb, "", 0 );

                append( sb, "commitByProject (Default: false)", 2 );
                append( sb, "Commits to do are atomic or by project.", 3 );
                append( sb, "", 0 );

                append( sb, "completionGoals", 2 );
                append( sb, "Goals to run on completion of the preparation step, after transformation back to the next development version but before committing. Space delimited.", 3 );
                append( sb, "", 0 );

                append( sb, "developmentVersion", 2 );
                append( sb, "Default version to use for new local working copy.", 3 );
                append( sb, "", 0 );

                append( sb, "dryRun (Default: false)", 2 );
                append( sb, "Dry run: don\'t checkin or tag anything in the scm repository, or modify the checkout. Running mvn -DdryRun=true release:prepare is useful in order to check that modifications to poms and scm operations (only listed on the console) are working as expected. Modified POMs are written alongside the originals without modifying them.", 3 );
                append( sb, "", 0 );

                append( sb, "generateReleasePoms (Default: false)", 2 );
                append( sb, "Deprecated. Please use release:prepare-with-pom instead.", 3 );
                append( sb, "", 0 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "javaHome (Default: ${java.home})", 2 );
                append( sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "localCheckout (Default: false)", 2 );
                append( sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3 );
                append( sb, "", 0 );

                append( sb, "localRepoDirectory (Default: ${maven.repo.local})", 2 );
                append( sb, "The command-line local repository directory in use for this build (if specified).", 3 );
                append( sb, "", 0 );

                append( sb, "mavenExecutorId (Default: invoker)", 2 );
                append( sb, "Role hint of the MavenExecutor implementation to use.", 3 );
                append( sb, "", 0 );

                append( sb, "mavenHome (Default: ${maven.home})", 2 );
                append( sb, "The M2_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The SCM password to use.", 3 );
                append( sb, "", 0 );

                append( sb, "pomFileName", 2 );
                append( sb, "The file name of the POM to execute any goals against.", 3 );
                append( sb, "", 0 );

                append( sb, "preparationGoals (Default: clean verify)", 2 );
                append( sb, "Goals to run as part of the preparation step, after transformation but before committing. Space delimited.", 3 );
                append( sb, "", 0 );

                append( sb, "providerImplementations", 2 );
                append( sb, "List of provider implementations.", 3 );
                append( sb, "", 0 );

                append( sb, "pushChanges (Default: true)", 2 );
                append( sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3 );
                append( sb, "", 0 );

                append( sb, "releaseVersion", 2 );
                append( sb, "Default version to use when preparing a release or a branch.", 3 );
                append( sb, "", 0 );

                append( sb, "remoteTagging (Default: true)", 2 );
                append( sb, "Currently only implemented with svn scm.\n-\tEnables a workaround to prevent issue due to svn client > 1.5.0 (fixed in 1.6.5) (http://jira.codehaus.org/browse/SCM-406)\n-\tYou may not want to use this in conjunction with suppressCommitBeforeTag, such that no poms with released versions are committed to the working copy ever.\n", 3 );
                append( sb, "", 0 );

                append( sb, "resume (Default: true)", 2 );
                append( sb, "Resume a previous release attempt from the point where it was stopped.", 3 );
                append( sb, "", 0 );

                append( sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2 );
                append( sb, "The message prefix to use for all SCM changes.", 3 );
                append( sb, "", 0 );

                append( sb, "suppressCommitBeforeTag (Default: false)", 2 );
                append( sb, "Whether to suppress a commit of changes to the working copy before the tag is created.\n\nThis requires remoteTagging to be set to false.\n\nsuppressCommitBeforeTag is useful when you want to avoid poms with released versions in all revisions of your trunk or development branch.", 3 );
                append( sb, "", 0 );

                append( sb, "tag", 2 );
                append( sb, "The SCM tag to use.", 3 );
                append( sb, "", 0 );

                append( sb, "tagBase", 2 );
                append( sb, "The tag base directory in SVN, you must define it if you don\'t use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3 );
                append( sb, "", 0 );

                append( sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2 );
                append( sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3 );
                append( sb, "", 0 );

                append( sb, "updateDependencies (Default: true)", 2 );
                append( sb, "Whether to update dependencies version to the next development version.", 3 );
                append( sb, "", 0 );

                append( sb, "updateWorkingCopyVersions (Default: true)", 2 );
                append( sb, "Whether to bump the working copy versions to developmentVersion.", 3 );
                append( sb, "", 0 );

                append( sb, "useEditMode (Default: false)", 2 );
                append( sb, "Whether to use \'edit\' mode on the SCM, to lock the file for editing during SCM operations.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The SCM username to use.", 3 );
                append( sb, "", 0 );

                append( sb, "waitBeforeTagging (Default: 0)", 2 );
                append( sb, "Wait the specified number of second before creating the tag.\nwaitBeforeTagging is useful when your source repository is synced between several instances and access to it is determined by geographical location, like the SVN repository at the Apache Software Foundation.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "prepare-with-pom".equals( goal ) )
        {
            append( sb, "release:prepare-with-pom", 0 );
            append( sb, "Prepare for a release in SCM, fully resolving dependencies for the purpose of producing a \'release POM\'.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addSchema (Default: true)", 2 );
                append( sb, "Whether to add a schema to the POM if it was previously missing on release.", 3 );
                append( sb, "", 0 );

                append( sb, "allowTimestampedSnapshots (Default: false)", 2 );
                append( sb, "Whether to allow timestamped SNAPSHOT dependencies. Default is to fail when finding any SNAPSHOT.", 3 );
                append( sb, "", 0 );

                append( sb, "arguments", 2 );
                append( sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3 );
                append( sb, "", 0 );

                append( sb, "autoVersionSubmodules (Default: false)", 2 );
                append( sb, "Whether to automatically assign submodules the parent version. If set to false, the user will be prompted for the version of each submodules.", 3 );
                append( sb, "", 0 );

                append( sb, "checkModificationExcludeList", 2 );
                append( sb, "Command-line version of checkModificationExcludes", 3 );
                append( sb, "", 0 );

                append( sb, "checkModificationExcludes", 2 );
                append( sb, "Additional files that will skipped when checking for modifications on the working copy. Is ignored, when checkModificationExcludes is set.", 3 );
                append( sb, "", 0 );

                append( sb, "commitByProject (Default: false)", 2 );
                append( sb, "Commits to do are atomic or by project.", 3 );
                append( sb, "", 0 );

                append( sb, "completionGoals", 2 );
                append( sb, "Goals to run on completion of the preparation step, after transformation back to the next development version but before committing. Space delimited.", 3 );
                append( sb, "", 0 );

                append( sb, "developmentVersion", 2 );
                append( sb, "Default version to use for new local working copy.", 3 );
                append( sb, "", 0 );

                append( sb, "dryRun (Default: false)", 2 );
                append( sb, "Dry run: don\'t checkin or tag anything in the scm repository, or modify the checkout. Running mvn -DdryRun=true release:prepare is useful in order to check that modifications to poms and scm operations (only listed on the console) are working as expected. Modified POMs are written alongside the originals without modifying them.", 3 );
                append( sb, "", 0 );

                append( sb, "generateReleasePoms (Default: true)", 2 );
                append( sb, "Whether to generate release-pom.xml files that contain resolved information about the project.", 3 );
                append( sb, "", 0 );

                append( sb, "javaHome (Default: ${java.home})", 2 );
                append( sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "localCheckout (Default: false)", 2 );
                append( sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3 );
                append( sb, "", 0 );

                append( sb, "localRepoDirectory (Default: ${maven.repo.local})", 2 );
                append( sb, "The command-line local repository directory in use for this build (if specified).", 3 );
                append( sb, "", 0 );

                append( sb, "mavenExecutorId (Default: invoker)", 2 );
                append( sb, "Role hint of the MavenExecutor implementation to use.", 3 );
                append( sb, "", 0 );

                append( sb, "mavenHome (Default: ${maven.home})", 2 );
                append( sb, "The M2_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The SCM password to use.", 3 );
                append( sb, "", 0 );

                append( sb, "pomFileName", 2 );
                append( sb, "The file name of the POM to execute any goals against.", 3 );
                append( sb, "", 0 );

                append( sb, "preparationGoals (Default: clean verify)", 2 );
                append( sb, "Goals to run as part of the preparation step, after transformation but before committing. Space delimited.", 3 );
                append( sb, "", 0 );

                append( sb, "providerImplementations", 2 );
                append( sb, "List of provider implementations.", 3 );
                append( sb, "", 0 );

                append( sb, "pushChanges (Default: true)", 2 );
                append( sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3 );
                append( sb, "", 0 );

                append( sb, "releaseVersion", 2 );
                append( sb, "Default version to use when preparing a release or a branch.", 3 );
                append( sb, "", 0 );

                append( sb, "remoteTagging (Default: true)", 2 );
                append( sb, "Currently only implemented with svn scm.\n-\tEnables a workaround to prevent issue due to svn client > 1.5.0 (fixed in 1.6.5) (http://jira.codehaus.org/browse/SCM-406)\n-\tYou may not want to use this in conjunction with suppressCommitBeforeTag, such that no poms with released versions are committed to the working copy ever.\n", 3 );
                append( sb, "", 0 );

                append( sb, "resume (Default: true)", 2 );
                append( sb, "Resume a previous release attempt from the point where it was stopped.", 3 );
                append( sb, "", 0 );

                append( sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2 );
                append( sb, "The message prefix to use for all SCM changes.", 3 );
                append( sb, "", 0 );

                append( sb, "suppressCommitBeforeTag (Default: false)", 2 );
                append( sb, "Whether to suppress a commit of changes to the working copy before the tag is created.\n\nThis requires remoteTagging to be set to false.\n\nsuppressCommitBeforeTag is useful when you want to avoid poms with released versions in all revisions of your trunk or development branch.", 3 );
                append( sb, "", 0 );

                append( sb, "tag", 2 );
                append( sb, "The SCM tag to use.", 3 );
                append( sb, "", 0 );

                append( sb, "tagBase", 2 );
                append( sb, "The tag base directory in SVN, you must define it if you don\'t use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3 );
                append( sb, "", 0 );

                append( sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2 );
                append( sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3 );
                append( sb, "", 0 );

                append( sb, "updateDependencies (Default: true)", 2 );
                append( sb, "Whether to update dependencies version to the next development version.", 3 );
                append( sb, "", 0 );

                append( sb, "updateWorkingCopyVersions (Default: true)", 2 );
                append( sb, "Whether to bump the working copy versions to developmentVersion.", 3 );
                append( sb, "", 0 );

                append( sb, "useEditMode (Default: false)", 2 );
                append( sb, "Whether to use \'edit\' mode on the SCM, to lock the file for editing during SCM operations.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The SCM username to use.", 3 );
                append( sb, "", 0 );

                append( sb, "waitBeforeTagging (Default: 0)", 2 );
                append( sb, "Wait the specified number of second before creating the tag.\nwaitBeforeTagging is useful when your source repository is synced between several instances and access to it is determined by geographical location, like the SVN repository at the Apache Software Foundation.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "rollback".equals( goal ) )
        {
            append( sb, "release:rollback", 0 );
            append( sb, "Rollback changes made by a previous release. This requires that the previous release descriptor release.properties is still available in the local working copy. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/rollback-release.html.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "arguments", 2 );
                append( sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3 );
                append( sb, "", 0 );

                append( sb, "javaHome (Default: ${java.home})", 2 );
                append( sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "localCheckout (Default: false)", 2 );
                append( sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3 );
                append( sb, "", 0 );

                append( sb, "localRepoDirectory (Default: ${maven.repo.local})", 2 );
                append( sb, "The command-line local repository directory in use for this build (if specified).", 3 );
                append( sb, "", 0 );

                append( sb, "mavenExecutorId (Default: invoker)", 2 );
                append( sb, "Role hint of the MavenExecutor implementation to use.", 3 );
                append( sb, "", 0 );

                append( sb, "mavenHome (Default: ${maven.home})", 2 );
                append( sb, "The M2_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The SCM password to use.", 3 );
                append( sb, "", 0 );

                append( sb, "pomFileName", 2 );
                append( sb, "The file name of the POM to execute any goals against.", 3 );
                append( sb, "", 0 );

                append( sb, "providerImplementations", 2 );
                append( sb, "List of provider implementations.", 3 );
                append( sb, "", 0 );

                append( sb, "pushChanges (Default: true)", 2 );
                append( sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3 );
                append( sb, "", 0 );

                append( sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2 );
                append( sb, "The message prefix to use for all SCM changes.", 3 );
                append( sb, "", 0 );

                append( sb, "tag", 2 );
                append( sb, "The SCM tag to use.", 3 );
                append( sb, "", 0 );

                append( sb, "tagBase", 2 );
                append( sb, "The tag base directory in SVN, you must define it if you don\'t use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3 );
                append( sb, "", 0 );

                append( sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2 );
                append( sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The SCM username to use.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "stage".equals( goal ) )
        {
            append( sb, "release:stage", 0 );
            append( sb, "Perform a release from SCM to a staging repository.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "arguments", 2 );
                append( sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3 );
                append( sb, "", 0 );

                append( sb, "connectionUrl", 2 );
                append( sb, "The SCM URL to checkout from. If omitted, the one from the release.properties file is used, followed by the URL from the current POM.", 3 );
                append( sb, "", 0 );

                append( sb, "goals", 2 );
                append( sb, "A comma or space separated list of goals to execute on deployment. Default value is either deploy or deploy site-deploy, if the project has a <distributionManagement>/<site> element.", 3 );
                append( sb, "", 0 );

                append( sb, "javaHome (Default: ${java.home})", 2 );
                append( sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "localCheckout (Default: false)", 2 );
                append( sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3 );
                append( sb, "", 0 );

                append( sb, "localRepoDirectory (Default: ${maven.repo.local})", 2 );
                append( sb, "The command-line local repository directory in use for this build (if specified).", 3 );
                append( sb, "", 0 );

                append( sb, "mavenExecutorId (Default: invoker)", 2 );
                append( sb, "Role hint of the MavenExecutor implementation to use.", 3 );
                append( sb, "", 0 );

                append( sb, "mavenHome (Default: ${maven.home})", 2 );
                append( sb, "The M2_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The SCM password to use.", 3 );
                append( sb, "", 0 );

                append( sb, "pomFileName", 2 );
                append( sb, "The file name of the POM to execute any goals against.", 3 );
                append( sb, "", 0 );

                append( sb, "providerImplementations", 2 );
                append( sb, "List of provider implementations.", 3 );
                append( sb, "", 0 );

                append( sb, "pushChanges (Default: true)", 2 );
                append( sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3 );
                append( sb, "", 0 );

                append( sb, "releaseProfiles", 2 );
                append( sb, "Comma separated profiles to enable on deployment, in addition to active profiles for project execution.", 3 );
                append( sb, "", 0 );

                append( sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2 );
                append( sb, "The message prefix to use for all SCM changes.", 3 );
                append( sb, "", 0 );

                append( sb, "stagingRepository", 2 );
                append( sb, "URL of the staging repository to use.", 3 );
                append( sb, "", 0 );

                append( sb, "tag", 2 );
                append( sb, "The SCM tag to use.", 3 );
                append( sb, "", 0 );

                append( sb, "tagBase", 2 );
                append( sb, "The tag base directory in SVN, you must define it if you don\'t use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3 );
                append( sb, "", 0 );

                append( sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2 );
                append( sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useReleaseProfile (Default: true)", 2 );
                append( sb, "Whether to use the release profile that adds sources and javadocs to the released artifact, if appropriate.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The SCM username to use.", 3 );
                append( sb, "", 0 );

                append( sb, "workingDirectory (Default: ${project.build.directory}/checkout)", 2 );
                append( sb, "The checkout directory.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "update-versions".equals( goal ) )
        {
            append( sb, "release:update-versions", 0 );
            append( sb, "Update the POM versions for a project. This performs the normal version updates of the release:prepare goal without making other modifications to the SCM such as tagging. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/update-versions.html.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addSchema (Default: true)", 2 );
                append( sb, "Whether to add a schema to the POM if it was previously missing on release.", 3 );
                append( sb, "", 0 );

                append( sb, "arguments", 2 );
                append( sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3 );
                append( sb, "", 0 );

                append( sb, "autoVersionSubmodules (Default: false)", 2 );
                append( sb, "Whether to automatically assign submodules the parent version. If set to false, the user will be prompted for the version of each submodules.", 3 );
                append( sb, "", 0 );

                append( sb, "developmentVersion", 2 );
                append( sb, "Default version to use for new local working copy.", 3 );
                append( sb, "", 0 );

                append( sb, "javaHome (Default: ${java.home})", 2 );
                append( sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "localCheckout (Default: false)", 2 );
                append( sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3 );
                append( sb, "", 0 );

                append( sb, "localRepoDirectory (Default: ${maven.repo.local})", 2 );
                append( sb, "The command-line local repository directory in use for this build (if specified).", 3 );
                append( sb, "", 0 );

                append( sb, "mavenExecutorId (Default: invoker)", 2 );
                append( sb, "Role hint of the MavenExecutor implementation to use.", 3 );
                append( sb, "", 0 );

                append( sb, "mavenHome (Default: ${maven.home})", 2 );
                append( sb, "The M2_HOME parameter to use for forked Maven invocations.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The SCM password to use.", 3 );
                append( sb, "", 0 );

                append( sb, "pomFileName", 2 );
                append( sb, "The file name of the POM to execute any goals against.", 3 );
                append( sb, "", 0 );

                append( sb, "providerImplementations", 2 );
                append( sb, "List of provider implementations.", 3 );
                append( sb, "", 0 );

                append( sb, "pushChanges (Default: true)", 2 );
                append( sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3 );
                append( sb, "", 0 );

                append( sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2 );
                append( sb, "The message prefix to use for all SCM changes.", 3 );
                append( sb, "", 0 );

                append( sb, "tag", 2 );
                append( sb, "The SCM tag to use.", 3 );
                append( sb, "", 0 );

                append( sb, "tagBase", 2 );
                append( sb, "The tag base directory in SVN, you must define it if you don\'t use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3 );
                append( sb, "", 0 );

                append( sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2 );
                append( sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The SCM username to use.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
