/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.release.AbstractScmReleaseMojo;
import org.apache.maven.shared.release.DefaultReleaseManagerListener;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseManagerListener;
import org.apache.maven.shared.release.ReleasePrepareRequest;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;

@Mojo(name="prepare", aggregator=true, requiresDependencyCollection=ResolutionScope.TEST)
public class PrepareReleaseMojo
extends AbstractScmReleaseMojo {
    @Parameter(defaultValue="true", property="resume")
    private boolean resume;
    @Deprecated
    @Parameter(defaultValue="false", property="generateReleasePoms")
    private boolean generateReleasePoms;
    @Parameter(defaultValue="false", property="useEditMode")
    private boolean useEditMode;
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies;
    @Parameter(defaultValue="false", property="autoVersionSubmodules")
    private boolean autoVersionSubmodules;
    @Parameter(defaultValue="false", property="dryRun")
    private boolean dryRun;
    @Parameter(defaultValue="true", property="addSchema")
    private boolean addSchema;
    @Parameter(defaultValue="clean verify", property="preparationGoals")
    private String preparationGoals;
    @Parameter(defaultValue="", property="completionGoals")
    private String completionGoals;
    @Parameter(defaultValue="false", property="commitByProject")
    private boolean commitByProject;
    @Parameter(defaultValue="false", property="ignoreSnapshots")
    private boolean allowTimestampedSnapshots;
    @Parameter(defaultValue="false", property="allowReleasePluginSnapshot", readonly=true)
    private boolean allowReleasePluginSnapshot;
    @Parameter
    private String[] checkModificationExcludes;
    @Parameter(property="checkModificationExcludeList")
    private String checkModificationExcludeList;
    @Parameter(property="releaseVersion")
    private String releaseVersion;
    @Parameter(property="developmentVersion")
    private String developmentVersion;
    @Parameter(defaultValue="true", property="remoteTagging")
    private boolean remoteTagging;
    @Parameter(property="signTag")
    private boolean signTag = false;
    @Parameter(defaultValue="true", property="updateWorkingCopyVersions")
    private boolean updateWorkingCopyVersions;
    @Parameter(defaultValue="false", property="suppressCommitBeforeTag")
    private boolean suppressCommitBeforeTag;
    @Parameter(defaultValue="0", property="waitBeforeTagging")
    private int waitBeforeTagging;
    @Parameter(defaultValue="default", property="projectVersionPolicyId")
    private String projectVersionPolicyId;
    @Parameter(property="projectNamingPolicyId")
    private String projectTagNamingPolicyId;
    @Parameter(defaultValue="@{prefix} prepare release @{releaseLabel}", property="scmReleaseCommitComment")
    private String scmReleaseCommitComment = "@{prefix} prepare release @{releaseLabel}";
    @Parameter(defaultValue="@{prefix} prepare for next development iteration", property="scmDevelopmentCommitComment")
    private String scmDevelopmentCommitComment = "@{prefix} prepare for next development iteration";
    @Parameter(property="autoResolveSnapshots")
    private String autoResolveSnapshots;
    @Parameter(defaultValue="false", property="pinExternals")
    private boolean pinExternals;
    @Parameter(defaultValue="source", property="lineSeparator")
    private String lineSeparator;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.generateReleasePoms) {
            throw new MojoFailureException("Generating release POMs is no longer supported in release:prepare. Please run release:prepare-with-pom instead.");
        }
        this.prepareRelease(this.generateReleasePoms);
    }

    protected void prepareRelease(boolean generateReleasePoms) throws MojoExecutionException, MojoFailureException {
        super.execute();
        ReleaseDescriptorBuilder config = this.createReleaseDescriptor();
        config.setAddSchema(this.addSchema);
        config.setGenerateReleasePoms(generateReleasePoms);
        config.setScmUseEditMode(this.useEditMode);
        config.setPreparationGoals(this.preparationGoals);
        config.setCompletionGoals(this.completionGoals);
        config.setCommitByProject(this.commitByProject);
        config.setUpdateDependencies(this.updateDependencies);
        config.setAutoVersionSubmodules(this.autoVersionSubmodules);
        config.setAllowTimestampedSnapshots(this.allowTimestampedSnapshots);
        config.setSnapshotReleasePluginAllowed(this.allowReleasePluginSnapshot);
        config.setDefaultReleaseVersion(this.releaseVersion);
        config.setDefaultDevelopmentVersion(this.developmentVersion);
        config.setRemoteTagging(this.remoteTagging);
        config.setScmSignTags(this.signTag);
        config.setUpdateWorkingCopyVersions(this.updateWorkingCopyVersions);
        config.setSuppressCommitBeforeTagOrBranch(this.suppressCommitBeforeTag);
        config.setWaitBeforeTagging(this.waitBeforeTagging);
        config.setProjectVersionPolicyId(this.projectVersionPolicyId);
        config.setProjectNamingPolicyId(this.projectTagNamingPolicyId);
        config.setScmDevelopmentCommitComment(this.scmDevelopmentCommitComment);
        config.setScmReleaseCommitComment(this.scmReleaseCommitComment);
        config.setAutoResolveSnapshots(this.autoResolveSnapshots);
        config.setPinExternals(this.pinExternals);
        if (generateReleasePoms) {
            config.setLineSeparator(this.resolveLineSeparator());
        }
        if (this.checkModificationExcludeList != null) {
            this.checkModificationExcludes = this.checkModificationExcludeList.replaceAll("\\s", "").split(",");
        }
        if (this.checkModificationExcludes != null) {
            config.setCheckModificationExcludes(Arrays.asList(this.checkModificationExcludes));
        }
        ReleasePrepareRequest prepareRequest = new ReleasePrepareRequest();
        prepareRequest.setReleaseDescriptorBuilder(config);
        prepareRequest.setReleaseEnvironment(this.getReleaseEnvironment());
        prepareRequest.setReactorProjects(this.getReactorProjects());
        prepareRequest.setReleaseManagerListener((ReleaseManagerListener)new DefaultReleaseManagerListener(this.getLog(), this.dryRun));
        prepareRequest.setResume(Boolean.valueOf(this.resume));
        prepareRequest.setDryRun(Boolean.valueOf(this.dryRun));
        prepareRequest.setUserProperties(this.session.getUserProperties());
        try {
            this.releaseManager.prepare(prepareRequest);
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ReleaseFailureException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private String resolveLineSeparator() throws MojoExecutionException {
        if (this.lineSeparator == null) {
            return this.getLineSeparatorFromPom();
        }
        switch (this.lineSeparator) {
            case "lf": {
                return "\n";
            }
            case "cr": {
                return "\r";
            }
            case "crlf": {
                return "\r\n";
            }
            case "system": {
                return System.lineSeparator();
            }
            case "source": {
                return this.getLineSeparatorFromPom();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown property lineSeparator: '%s'. Use one of the following: 'source', 'system', 'lf', 'cr', 'crlf'.", this.lineSeparator));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLineSeparatorFromPom() throws MojoExecutionException {
        String lineSeparator = "";
        try (FileInputStream is = new FileInputStream(this.project.getFile());){
            char next;
            char current;
            do {
                if (((InputStream)is).available() <= 0) return lineSeparator;
            } while ((current = (char)((InputStream)is).read()) != '\n' && current != '\r');
            lineSeparator = lineSeparator + current;
            if (((InputStream)is).available() > 0 && (next = (char)((InputStream)is).read()) != current && (next == '\r' || next == '\n')) {
                lineSeparator = lineSeparator + next;
            }
            String string = lineSeparator;
            return string;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to detect line separator of " + this.project.getFile(), (Exception)e);
        }
    }
}

