/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.release.AbstractScmReleaseMojo;
import org.apache.maven.shared.release.DefaultReleaseManagerListener;
import org.apache.maven.shared.release.ReleaseBranchRequest;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseManagerListener;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;

@Mojo(name="branch", aggregator=true)
public class BranchReleaseMojo
extends AbstractScmReleaseMojo {
    @Parameter(property="branchName")
    private String branchName;
    @Parameter(property="branchBase")
    private String branchBase;
    @Parameter(defaultValue="false", property="updateBranchVersions")
    private boolean updateBranchVersions;
    @Parameter(defaultValue="true", property="updateWorkingCopyVersions")
    private boolean updateWorkingCopyVersions;
    @Parameter(defaultValue="false", property="suppressCommitBeforeBranch")
    private boolean suppressCommitBeforeBranch;
    @Parameter(defaultValue="true", property="updateVersionsToSnapshot")
    private boolean updateVersionsToSnapshot;
    @Parameter(defaultValue="false", property="useEditMode")
    private boolean useEditMode;
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies;
    @Parameter(defaultValue="false", property="autoVersionSubmodules")
    private boolean autoVersionSubmodules;
    @Parameter(defaultValue="false", property="dryRun")
    private boolean dryRun;
    @Parameter(defaultValue="true", property="addSchema")
    private boolean addSchema;
    @Parameter(defaultValue="true", property="remoteTagging")
    private boolean remoteTagging;
    @Parameter
    private String[] checkModificationExcludes;
    @Parameter(property="checkModificationExcludeList")
    private String checkModificationExcludeList;
    @Parameter(property="releaseVersion")
    private String releaseVersion;
    @Parameter(property="developmentVersion")
    private String developmentVersion;
    @Parameter(defaultValue="default", property="projectVersionPolicyId")
    private String projectVersionPolicyId;
    @Parameter(property="projectVersionPolicyConfig")
    private XmlPlexusConfiguration projectVersionPolicyConfig;
    @Parameter(property="projectNamingPolicyId")
    private String projectBranchNamingPolicyId;
    @Parameter(defaultValue="@{prefix} prepare branch @{releaseLabel}", property="scmBranchCommitComment")
    private String scmBranchCommitComment = "@{prefix} prepare branch @{releaseLabel}";
    @Parameter(defaultValue="false", property="pinExternals")
    private boolean pinExternals;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        ReleaseDescriptorBuilder config = this.createReleaseDescriptor();
        config.setAddSchema(this.addSchema);
        config.setScmUseEditMode(this.useEditMode);
        config.setUpdateDependencies(this.updateDependencies);
        config.setAutoVersionSubmodules(this.autoVersionSubmodules);
        config.setScmReleaseLabel(this.branchName);
        config.setScmBranchBase(this.branchBase);
        config.setBranchCreation(true);
        config.setUpdateBranchVersions(this.updateBranchVersions);
        config.setUpdateWorkingCopyVersions(this.updateWorkingCopyVersions);
        config.setUpdateVersionsToSnapshot(this.updateVersionsToSnapshot);
        config.setRemoteTagging(this.remoteTagging);
        config.setDefaultReleaseVersion(this.releaseVersion);
        config.setDefaultDevelopmentVersion(this.developmentVersion);
        config.setSuppressCommitBeforeTagOrBranch(this.suppressCommitBeforeBranch);
        config.setProjectVersionPolicyId(this.projectVersionPolicyId);
        if (this.projectVersionPolicyConfig != null) {
            config.setProjectVersionPolicyConfig(this.projectVersionPolicyConfig.toString());
        }
        config.setProjectNamingPolicyId(this.projectBranchNamingPolicyId);
        config.setScmBranchCommitComment(this.scmBranchCommitComment);
        config.setPinExternals(this.pinExternals);
        if (this.checkModificationExcludeList != null) {
            this.checkModificationExcludes = this.checkModificationExcludeList.replaceAll("\\s", "").split(",");
        }
        if (this.checkModificationExcludes != null) {
            config.setCheckModificationExcludes(Arrays.asList(this.checkModificationExcludes));
        }
        try {
            ReleaseBranchRequest branchRequest = new ReleaseBranchRequest();
            branchRequest.setReleaseDescriptorBuilder(config);
            branchRequest.setReleaseEnvironment(this.getReleaseEnvironment());
            branchRequest.setReactorProjects(this.getReactorProjects());
            branchRequest.setReleaseManagerListener((ReleaseManagerListener)new DefaultReleaseManagerListener(this.getLog(), this.dryRun));
            branchRequest.setDryRun(Boolean.valueOf(this.dryRun));
            branchRequest.setUserProperties(this.session.getUserProperties());
            this.releaseManager.branch(branchRequest);
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ReleaseFailureException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

