/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="changelog", aggregator=true)
public class ChangeLogMojo
extends AbstractScmMojo {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    @Parameter(property="startDate")
    private String startDate;
    @Parameter(property="endDate")
    private String endDate;
    @Parameter(property="startScmVersion")
    private String startScmVersion;
    @Parameter(property="endScmVersion")
    private String endScmVersion;
    @Parameter(property="startScmVersionType")
    private String startScmVersionType;
    @Parameter(property="endScmVersionType")
    private String endScmVersionType;
    @Parameter(property="dateFormat")
    private String dateFormat;
    @Parameter(property="userDateFormat", defaultValue="yyyy-MM-dd")
    private String userDateFormat = "yyyy-MM-dd";
    @Parameter(property="scmVersionType")
    private String scmVersionType;
    @Parameter(property="scmVersion")
    private String scmVersion;

    public void execute() throws MojoExecutionException {
        super.execute();
        SimpleDateFormat localFormat = new SimpleDateFormat(this.userDateFormat);
        try {
            ScmRepository repository = this.getScmRepository();
            ScmProvider provider = this.getScmManager().getProviderByRepository(repository);
            ScmVersion startRev = this.getScmVersion(StringUtils.isEmpty((String)this.startScmVersionType) ? "revision" : this.startScmVersionType, this.startScmVersion);
            ScmVersion endRev = this.getScmVersion(StringUtils.isEmpty((String)this.endScmVersionType) ? "revision" : this.endScmVersionType, this.endScmVersion);
            ChangeLogScmResult result = startRev != null || endRev != null ? provider.changeLog(repository, this.getFileSet(), startRev, endRev, this.dateFormat) : provider.changeLog(repository, this.getFileSet(), this.parseDate(localFormat, this.startDate), this.parseDate(localFormat, this.endDate), 0, (ScmBranch)this.getScmVersion(this.scmVersionType, this.scmVersion), this.dateFormat);
            this.checkResult((ScmResult)result);
            ChangeLogSet changeLogSet = result.getChangeLog();
            for (ChangeSet changeSet : changeLogSet.getChangeSets()) {
                this.getLog().info((CharSequence)changeSet.toString());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot run changelog command : ", (Exception)e);
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run changelog command : ", (Exception)((Object)e));
        }
    }

    private Date parseDate(SimpleDateFormat format, String date) throws MojoExecutionException {
        if (date == null || date.trim().length() == 0) {
            return null;
        }
        try {
            return format.parse(date.toString());
        }
        catch (ParseException e) {
            throw new MojoExecutionException("Please use this date pattern: " + format.toLocalizedPattern().toString(), (Exception)e);
        }
    }
}

